@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-body">
            <h2>Upazila List</h2>
            <div class="float-right mb-2">
                <a href="{{ route('location.index') }}" class="btn btn-primary btn-sm">District</a>
                <a href="{{ route('thanaList') }}" class="ml-1btn btn-primary btn-sm">Thana</a>
            </div>
            <div class="table-responsive">
                <table id="dataTable" class="display">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="text-center">#</th>
                            <th scope="col" class="text-center">District</th>
                            <th scope="col" class="text-center">Upazila Name</th>
                            <th scope="col" class="text-center">Upazila Name(Bengali)</th>
                            <th scope="col" class="text-center"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($upazilas as $r)
                            <tr>
                                <td class="text-center">{{ $r->id }}</td>
                                <td class="text-center">{{ $r->district->name ?? '' }}</td>
                                <td class="text-center">{{ $r->name }}</td>
                                <td class="text-center">{{ $r->bn_name }}</td>
                                <td class="d-flex">
                                    <a href="{{ route('upazilaEdit', $r->id) }}" class="btn btn-primary btn-sm">Edit</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
