<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bulk QR Code Payment</title>

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: white;
            margin: 0;
            padding: 20px;
        }

        .qr-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 12px;
            margin-bottom: 20px;
            max-width: 21cm;
            margin: 0 auto;
        }

        .container {
            width: 100%;
            max-width: 14cm;
            height: 19cm;
            position: relative;
            background: white;
            border-radius: 10px;
            text-align: center;
            padding: 20px 15px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            color: #333;
            overflow: hidden;
            page-break-inside: avoid;
            margin: 0 auto;
            border: 1px solid #f1c40f;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .logo-circle {
            width: 80px;
            height: 80px;
            background-color: white;
            border-radius: 50%;
            margin: 0 auto 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            flex-shrink: 0;
        }

        .logo-circle img {
            width: 65px;
            height: 65px;
            border-radius: 50%;
            object-fit: cover;
        }

        .network-title {
            font-size: 20px;
            font-weight: bold;
            color: #333;
            margin: 10px 0 15px 0;
            text-shadow: none;
            flex-shrink: 0;
        }

        .client-info {
            text-align: left;
            margin: 15px 0;
            background: linear-gradient(to bottom, #004aad, #cb6ce6);
            padding: 12px;
            border-radius: 8px;
            border: 1px solid #eee;
            flex-shrink: 0;
        }

        .client-info p {
            margin: 4px 0;
            font-size: 18px;
            color: #ffffff;
            font-weight: 500;
        }

        .scan-text {
            font-size: 16px;
            font-weight: bold;
            color: #333;
            margin: 12px 0 10px 0;
            text-shadow: none;
            flex-shrink: 0;
        }

        .qr-code-container {
            width: 160px;
            height: 160px;
            background-color: white;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 12px auto;
            padding: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            flex: 1;
            min-height: 160px;
        }

        .qr-code svg {
            width: 150px;
            height: 150px;
        }

        .thank-you {
            font-size: 16px;
            color: #ffffff;
            margin: 12px 0;
            font-weight: bold;
            background: linear-gradient(to top, #004aad, #cb6ce6);
            padding: 10px;
            border-radius: 8px;
            border: 1px solid #eee;
            text-shadow: none;
            flex-shrink: 0;
        }

        .contact-info {
            margin-top: 10px;
            font-size: 12px;
            color: #333;
            line-height: 1.3;
            text-align: left;
            flex-shrink: 0;
        }

        .footer {
            font-size: 11px;
            color: #666;
            margin-top: 8px;
            opacity: 0.9;
            flex-shrink: 0;
        }

        .print-controls {
            position: fixed;
            top: 20px;
            right: 20px;
            background: white;
            padding: 15px;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            z-index: 1000;
        }

        .printbtn {
            background-color: #0bc8d6;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
            margin-right: 10px;
        }

        .back-btn {
            background-color: #6c757d;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }

        .back-btn:hover {
            background-color: #5a6268;
        }

        .page-break {
            page-break-before: always;
        }

        .qr-page {
            page-break-inside: avoid;
            page-break-after: always;
        }

        .qr-page:last-child {
            page-break-after: auto;
        }

        /* Print Styles */
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                margin: 0;
                padding: 5mm;
            }

            .print-controls {
                display: none;
            }

            .header {
                display: none;
            }

            .qr-grid {
                grid-template-columns: repeat(2, 1fr);
                gap: 8mm;
                max-width: 21cm;
                margin: 0 auto;
            }

            .container {
                width: 100%;
                max-width: 14cm;
                height: 19cm;
                border-radius: 8px;
                text-align: center;
                padding: 15px 12px;
                color: #333;
                box-shadow: none;
                border: 1px solid #ccc;
            }

            .qr-code-container {
                padding: 5px;
            }
        }

        @media print and (max-width: 800px) {
            .qr-grid {
                grid-template-columns: 1fr;
            }
        }

        /* Header Styles */
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding: 20px;
            background: rgba(113, 86, 217, 0.1);
            border-radius: 10px;
        }

        .header-logo {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            margin: 0 auto 10px;
            display: block;
        }

        .header-title {
            font-size: 24px;
            font-weight: bold;
            color: #7156d9;
            margin: 10px 0;
        }

        @media print {
            .header {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="print-controls">
        <button class="printbtn" onclick="window.print()">Print</button>
    </div>

    <div class="header">
        <img class="header-logo" src="{{ asset('storage/company/' . siteinfo()->img_url) }}" alt="Company Logo">
        <h1 class="header-title">{{ siteinfo()->name ?? 'Company Name' }}</h1>
        <p>Bulk QR Code Generation - Total Clients: {{ count($clients) }}</p>
        <p>Generated on: {{ now()->format('d M Y, h:i A') }}</p>
    </div>

    @php
        $clientChunks = array_chunk($clients, 2);
    @endphp

    @foreach($clientChunks as $pageIndex => $pageClients)
        <div class="qr-page">
            <div class="qr-grid">
                @foreach($pageClients as $index => $clientData)
                    @php
                        $client = $clientData['client'];
                        $qrCode = $clientData['qrCode'];
                    @endphp

                    <div class="container">
                        <!-- Circular Logo -->
                        <div class="logo-circle">
                            <img src="{{ asset('storage/company/' . siteinfo()->img_url) }}" alt="Logo">
                        </div>

                        <!-- Network Title -->
                        <div class="network-title">{{ siteinfo()->name ?? 'Sabuj WiFi Network' }}</div>

                        <!-- Client Information -->
                        <div class="client-info">
                            <p>Username: {{ $client->userid ?? 'razib2_s01' }}</p>
                            <p>CID: {{ $client->id ?? '3' }}</p>
                            <p>Name: {{ $client->clientsinfo->clients_name ?? '' }}</p>
                            <p>Number: {{ $client->clientsinfo->contact_no ?? '' }}</p>
                            @if($client->customer_code)
                                <p>Customer Code: {{ $client->customer_code ?? '' }}</p>
                            @endif
                        </div>

                        <!-- Scan Text -->
                        <div class="scan-text">QR কোড স্ক্যান করে পেমেন্ট করুন</div>

                        <!-- QR Code -->
                        <div class="qr-code-container">
                            <div class="qr-code">{!! $qrCode !!}</div>
                        </div>

                        <!-- Thank You -->
                        <div class="thank-you">ধন্যবাদ</div>

                        <!-- Contact Information -->
                        <div class="contact-info">
                            <div>Address: {!! siteinfo()->address ?? 'Fulbaria, Kaliakoir, Gazipur' !!}</div>
                            <div>Contact: {{ siteinfo()->mobile ?? '01713580889' }}</div>
                        </div>

                        <!-- Footer -->
                        <div class="footer">Powered by YetFix Limited</div>
                    </div>
                @endforeach
            </div>
        </div>
    @endforeach
</body>

</html>
