@extends('layout.app')


@section('content')


    <form action="{{ route('item-category.update', $list->id) }}" method="POST">
        @method('PUT')
        @csrf
        <div class="card">
            <div class="card-body">
            <div class="row">
                <div class="form-group col-md-4">
                    <label for="name" class="">
                        Name*
                    </label>

                    <input type="text" name="name" id="name" value="{{ $list->name }}" class="form-control"
                        placeholder=" Name" autocomplete="off">
                    @error('name')
                        <div class="text-red-500 mt-2 text-sm">
                            {{ $message }}
                        </div>
                    @enderror
                </div>


                <div class="form-group col-md-4">
                    <label for="bn_name" class="">
                        Name (Bangla)
                    </label>

                    <input type="text" name="bn_name" id="bn_name" value="{{ $list->bn_name }}" class="form-control"
                        placeholder=" bn_name" autocomplete="off">
                    @error('bn_name')
                        <div class="text-red-500 mt-2 text-sm">
                            {{ $message }}
                        </div>
                    @enderror
                </div>



                <div class="form-group col-md-4">
                    <label for="short_name" class="">
                        Short Name
                    </label>

                    <input type="text" name="short_name" id="short_name" value="{{ $list->short_name }}"
                        class="form-control" placeholder=" short_name" autocomplete="off">
                    @error('short_name')
                        <div class="text-red-500 mt-2 text-sm">
                            {{ $message }}
                        </div>
                    @enderror
                </div>



                <div class="form-group col-md-12">
                    <label for="remarks" class="">
                        Remarks
                    </label>

                    <input type="text" name="remarks" id="remarks" value="{{ $list->remarks }}" class="form-control"
                        placeholder=" remarks" autocomplete="off">
                    @error('remarks')
                        <div class="text-red-500 mt-2 text-sm">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
            </div>
                <div class="form-group">
                    <div class="row float-right">
                        <a class="btn btn-primary" href="{{ url()->previous() }}">Back</a>

                        @can('inventory-group_edit')
                            <button type="submit" class="ml-2 btn btn-success">
                                Update
                            </button>
                        @endcan
                    </div>
                </div>
            </div>
    </form>

    <div class="p-5"></div>
@endsection
