@extends('layout.app')

@section('content')
    <div class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-header">
                    <p class="page-header">Billing Fix Invoices</p>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <div id="error-message"></div>
                        <input type="hidden" id="link" value="{{ $url }}">
                        <input type="hidden" id="pay_url" value="{{ $pay_url }}">
                        <input type="hidden" id="print_url" value="{{ url('/admin/portal-invoice-print') }}">

                        {{-- <input type="hidden" id="inv_exp_date" value="{{ license_check()['exp_date']->exp_date ?? '' }}"> --}}

                        <table class="table table-borderd" id="invoices-table">
                            <thead>
                                <tr>
                                    <th>Invoice ID</th>
                                    <th>Invoice Type</th>
                                    <th>Invoice Status</th>
                                    <th>Amount</th>
                                    <th>Exp Date</th>
                                    <th>Transaction Id</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="client-invoice-table">
                            </tbody>
                        </table>

                    </div>
                </div>
                <div class="card-footer">


                </div>
            </div>
        </div>
    </div>
@endsection

@section('ajax')
    <script>
        var link = $("#link").val();
        var pay_url = $("#pay_url").val();
        var print_url = $("#print_url").val();
        var txnID='';
        var date='';

        window.onload = function() {

            fetch('https://' + link)
                .then(response => response.json())
                .then(data => {
                    const invoices = data.data.invoices;
                    let tableRows = '';
                    invoices.forEach(invoice => {
                        tableRows += `
                    <tr>
                        <td>${invoice.id}</td>
                        <td>${invoice.invoice_type}</td>
                        <td>${invoice.invoice_status}</td>
                        <td>${invoice.amount}</td>
                        <td>${invoice.exp_date}</td>
                        ${invoice.invoice_status === 'Paid' ? `
                            <td>
                                ${invoice.payment.map((item)=>{
                                    txnID = item.trx_id;
                                    date = item.created_at;
                                    return item.trx_id;
                                })}

                            </td>
                        ` : `<td></td>`}
                        <td>
                            ${invoice.invoice_status === 'Due' ? `
                                <div class="row">
                                    <a href="https://${pay_url}" class="form-group btn btn-danger">Pay</a>
                                </div>
                            ` :
                            `<div class="row">
                                <button data-id="${invoice.id}" data-txn="${txnID}" data-date="${date}" data-amount="${invoice.amount}" data-exp="${invoice.exp_date}" data-type="${invoice.invoice_type}"
                                    class="btn btn-primary btn-sm text-nowrap billInvoice">Invoice</button>
                            </div>`
                            }
                        </td>
                    </tr>
                `;
                    });

                    // Insert table rows into table body
                    const tableBody = document.querySelector('#invoices-table tbody');
                    tableBody.innerHTML = tableRows;
                })
                .catch(error => {
                    console.error(error);
                    // Show error message
                    const errorContainer = document.querySelector('#error-message');
                    errorContainer.textContent = 'Failed to load invoice data. Please try again later.';
                });

        };


        $(document).on('click', '.billInvoice', function() {
            $('#processing').show();
            $('.portalInvoiceModal').show();
            var id = $(this).data('id');
            var txnId = $(this).data('txn');
            var date = $(this).data('date');
            var amount = $(this).data('amount');
            var exp = $(this).data('exp');
            var type = $(this).data('type');
            $.ajax({
                type: 'get',
                url: '/admin/portal-invoice-print/' + id + '/' + txnId + '/' + date + '/' + amount + '/' + exp + '/' + type,
                data: {
                    id: id,
                    txnId: txnId,
                    date: date,
                    amount: amount,
                    exp: exp,
                    type: type
                },
                success: function(result) {
                    $('#processing').hide();
                    $('.portalInvoiceModal').html('<div class="portalmodal">' + result + '</div>');
                }
            });

        });

        $(document).on('click', '.billInvoiceClose', function() {
            $('.portalmodal').remove();
            $('.portalInvoiceModal').hide();
        });

    </script>
@endsection
