<?php

use App\Http\Controllers\CRMClientController;
use App\Http\Controllers\CrmItemController;
use App\Http\Controllers\CrmItemReturnController;
use App\Http\Controllers\CrmItemUnitController;
use App\Http\Controllers\CRMLogController;
use App\Http\Controllers\ReportController;
use App\Models\CrmItem;
use App\Models\CrmItemUnit;
use Illuminate\Support\Facades\Route;

// Route::group(['middleware' => ['can:due-amount-check-by-month']], function () {
//     Route::get('due-amount-check-by-month', [ReportController::class, 'dueAmountCheckByMonth'])->name('due-amount-check-by-month');
// });

Route::get('crm-clients', [CRMClientController::class, 'crmcClients'])->name('crm-clients');
Route::get('crm-list/{type}', [CRMClientController::class, 'crmcClientsByTpye'])->name('crm-list');
Route::get('crm_customer_search', [CRMClientController::class, 'crmCustomerSearch'])->name('crm_customer_search');
Route::get('getCrmStatusLog', [CRMLogController::class, 'getCrmStatusLog'])->name('getCrmStatusLog');
Route::post('changeCrmStatus', [CRMLogController::class, 'changeCrmStatus'])->name('changeCrmStatus');

Route::resource('crm-item', CrmItemController::class);
Route::resource('crm-item-unit', CrmItemUnitController::class);

Route::get('crm-item-return/{id}', [CrmItemReturnController::class, 'crmItemReturn'])->name('crm-item-return');
Route::post('crm-item-return-save', [CrmItemReturnController::class, 'crmItemReturnSave'])->name('crm-item-return-save');

Route::get('crm-change-history/{id}', [CRMLogController::class, 'crmChangeHistory'])->name('crm-change-history');
Route::get('crm-return-report', [CrmItemReturnController::class, 'crmReturnReport'])->name('crm-return-report');
Route::get('crmReturnReportSearch',[CrmItemReturnController::class,'crmReturnReportSearch'])->name('crmReturnReportSearch');

Route::get('crm-item-return-show/{id}',[CrmItemReturnController::class,'crmItemReturnShow'])->name('crm-item-return-show');
Route::post('crm-item-return-approve', [CrmItemReturnController::class, 'crmItemReturnApprove'])->name('crm-item-return-approve');
Route::get('crm-client-list-csv', [CRMClientController::class, 'crmClientListCsv'])->name('crmClientListCsv');




