<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class NoBangla implements Rule
{
    public function passes($attribute, $value)
    {
        // Loop through each character and ensure it's in allowed ASCII ranges
        for ($i = 0; $i < strlen($value); $i++) {
            $ascii = ord($value[$i]);

            if ($ascii < 32 || $ascii > 126 || $ascii == 63) {
                return false;
            }
        }

        return true;
    }

    public function message()
    {
        return 'The :attribute field must not contain Bangla characters.';
    }
}
