@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table id="dataTable" class="display">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="text-center">ID</th>
                            <th scope="col" class="text-center">Name</th>
                            <th scope="col" class="text-center">Phone</th>
                            <th scope="col" class="text-center">Address</th>
                            <th scope="col" class="text-center">Package</th>
                            <th scope="col" class="text-center">Message</th>
                            <th scope="col" class="text-center">Create Date</th>
                            <th scope="col" class="text-center">Status</th>
                            <th scope="col" class="text-center">Remarks</th>
                            <th scope="col" class="text-center">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($list as $r)
                            <tr>
                                <td class="text-center">{{ $r->id }}</td>
                                <td class="text-center">{{ $r->name }}</td>
                                <td class="text-center">{{ $r->phone }}</td>
                                <td class="text-center">{{ $r->address }}</td>
                                <td class="text-center">{{ $r->package }}</td>
                                <td class="text-center">{{ $r->message }}</td>
                                <td class="text-center">{{ date('d-M-Y H:i:s A', strtotime($r->created_at)) }}</td>
                                <td class="text-center">{{ $r->status }}</td>
                                <td class="text-center">{{ $r->remarks }}</td>
                                <td class="d-flex">
                                    <a href="{{ route('clientRegisterEdit', $r->id) }}"
                                        class="btn btn-primary btn-sm">Edit</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
