@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="" id="search">
                <div class="row">
                    <div class="col-md-3 col-sm-3 col-xs-6 pop" >
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2">
                                Select Month
                            </label>
                            <select name="month" id="month" class="select2 form-control form-control-sm">
                                <option value="all"> ALL Month</option>
                                @foreach ($yearMonth as $month)
                                    <option value="{{ $month->year }}">{{ $month->year }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-6 manager" >
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2">
                                Manager Name
                            </label>
                            <select name="reseller" id="reseller" class="form-control select2 form-control-sm" required>
                                <option value="all">ALL Manager</option>
                                @foreach ($resellers as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-6 pop" >
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2">
                                POP Name
                            </label>
                            <select name="pop" id="pop" class="select2 form-control form-control-sm">
                                <option value="all"> ALL POP</option>

                            </select>
                        </div>
                    </div>
                    {{-- <div class="col-md-3 col-sm-3 col-xs-6 area" >
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2">
                                Select Area
                            </label>
                            <select name="area[]" id="area" class="select2 form-control form-control-sm" multiple>
                                <option value="all" selected>ALL Area</option>

                            </select>

                        </div>
                    </div> --}}
                    <div class="col-md-3 col-sm-3 col-xs-6 bill" >
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2">
                                Billing Cycle
                            </label>
                            <select name="billing_cycle" id="billing_cycle" class="select2 form-control form-control-sm">
                                <option value="all">ALL Billing Cycle</option>
                                @foreach (explode(',', $confday) as $conf)
                                    <option value="{{ $conf }}">{{ $conf }}</option>
                                @endforeach

                            </select>

                        </div>
                    </div>

                    <div class="col-md-3 col-sm-3 col-xs-6 status" >
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2">
                                Select Close Status
                            </label>
                            <select name="close_status" id="close_status" class="select2 form-control form-control-sm">
                                <option value="closed" selected>With Closed</option>
                                <option value="notClosed">With Out Closed</option>

                            </select>

                        </div>
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-6 from" >
                        <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                            From Date
                        </label>
                        <div class="input-group date" id="searchFrom" data-target-input="nearest">
                            <input type="text" name="from_date"
                                class="form-control datetimepicker-input input-group-append" data-toggle="datetimepicker"
                                data-target="#searchFrom" autocomplete="off">

                        </div>
                    </div>

                    <div class="col-md-3 col-sm-3 col-xs-6 to" >
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>


                </div>
                <div class="form-group float-right">
                    <button class="btn btn-primary" type="submit" id="searchBtnDue"><i class="fa fa-search"></i>
                        Search</button>
                    <a class="btn " href="{{ route('due-customer') }}" style="background: #f87171; color:#FFFFFF;">Reset</a>
                </div>

            </form>

            <button id="downloadExcel" class="btn btn-success">Download Excel</button>

            <div id="result" class="table-responsive">
                <table class="table table-striped table-bordered table-condensed" id="result_table">
                    <thead style="background:#78716c;color:#FFFFFF;">
                        <tr class="text-center">

                            <th>ID</th>
                            <th style="padding-left: 2px;padding-right: 2px;">User name</th>
                            <th class="status">Status</th>
                            <th class="status">Expire</th>
                            <th>Name</th>
                            <th>Mobile</th>
                            <th>Billing Cycle</th>
                            <th>Package</th>
                            <th>POP</th>
                            <th>User Info</th>
                            <th class="text-center">Due Amount</th>

                            {{-- <th style="padding-left: 2px;padding-right: 2px;max-width:100px">Date</th> --}}

                        </tr>
                    </thead>
                    <tbody class="text-center">

                    </tbody>

                </table>
            </div>

        </div>
    </div>





@endsection




@section('ajax')
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $("#result_table  tbody").empty();
                $('#pop').html('<option value="all">ALL POP</option>');
                $('#area').html('<option value="all"> All Area </option>');
                $("#reseller").val('all').change();
                $("#billing_cycle").val('all').change();

            });
            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="loading">Loading.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerAreaPop') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {

                        $('#pop').empty();
                        $('#pop').append('<option value="all"> All Pop </option>');
                        result.pops.forEach(element => {
                            $('#pop').append('<option value="' + element.id + '">' +
                                element.popname + '</option>');
                        });

                        $('#area').empty();
                        $('#area').append('<option value="all" selected> ALL Area </option>');
                        result.areas.forEach(element => {

                            if (element != "") {
                                $('#area').append('<option value="' + element + '">' +
                                    element + '</option>');
                            }

                        });

                        $('#loading').remove();

                    }
                });
            });




            $('#searchBtnDue').on('click', function(e) {
                e.preventDefault();

                // Prevent multiple loading indicators
                if (!$('#loading').length) {
                    $('body').prepend('<div id="loading">Loading...</div>');
                }

                // AJAX request
                $.ajax({
                    type: 'GET',
                    url: '{{ route('due-customer-search-for-invoice-wise-payment') }}', // Ensure this route exists in your Laravel backend
                    data: $('#search').serialize(),
                    success: function(result) {
                        // Update the result container
                        $('#result').html(result);
                    },
                    error: function(xhr, status, error) {
                        // Handle error and notify the user
                        console.error('Error:', error);

                    },
                    complete: function() {
                        // Remove the loading indicator when request completes
                        $('#loading').remove();
                    }
                });
            });




        });



        $('#downloadExcel').on('click', function () {
            console.log('comes');

            // Get the table element
            let table = document.querySelector('#result table');

            // Convert the table to a worksheet
            let worksheet = XLSX.utils.table_to_sheet(table);

            // Create a workbook and append the worksheet
            let workbook = XLSX.utils.book_new();
            XLSX.utils.book_append_sheet(workbook, worksheet, 'Bill Data');

            // Export the workbook as an Excel file
            XLSX.writeFile(workbook, 'bill_data.xlsx');
        });
    </script>


@endsection



