@extends('layout.app')

@section('content')
    <div class="card">

        <style type="text/css">
            .itemTable tr td:nth-child(2) {
                width: 15%;
                padding: 5px 0;
                vertical-align: top;
            }

            .itemTable tr td:nth-child(3) {
                width: 15%;
                padding: 5px 0;
                vertical-align: top;
            }

            .itemTable tr td:nth-child(4) {
                width: 15%;
                padding: 5px 0;
                vertical-align: top;
            }

            .itemTable tr td:nth-child(5) {
                width: 20%;
                padding: 5px 0;
                vertical-align: top;
            }

            .itemTable tr td:first-child {
                width: 35%;
                padding: 5px 0;
                vertical-align: top;
            }

            .invoice-box {
                max-width: 800px;
                margin: auto;
                font-size: 14px;
                line-height: 24px;
                color: black;
            }

            .invoice-box table {
                width: 100%;
                line-height: inherit;
                text-align: left;
            }

            .invoice-box table td {
                vertical-align: top;
            }

            .invoice-box table tr td:nth-child(2) {
                text-align: right;
            }

            .invoice-box table tr.top table td.title {
                font-size: 45px;
                line-height: 45px;
                color: black;
            }

            .invoice-box table tr.heading td {
                background: gray;
                border-bottom: 1px solid #21415B;
                font-weight: bold;
                color: black;
                padding: 2px 0;
            }

            .invoice-box table tr.headingPayment td {
                background: #f3f3f3;
                border-bottom: 1px solid #f3f3f3;
                font-weight: bold;
                color: black;
                padding: 2px 0;
            }

            .invoice-box table tr.item td {
                border-bottom: 1px solid #eee;
            }

            .invoice-box table tr.item.last td {
                border-bottom: none;
            }

            .invoice-box table tr.total td:nth-child(2) {
                border-top: 2px solid #eee;
                font-weight: bold;
            }

            .table.dataTable tfoot th,
            table.dataTable tfoot td {
                border-top: none;
            }

            .table-list tbody .table-list,
            .table-list tbody td:last-child {
                display: flex;
                padding-top: 14px !important;
            }

            .table-list tfoot td {
                /*display: inherit !important;*/
                font-weight: bold;
            }

            .table thead:after {
                margin-top: -10px;
            }
        </style>

        <div class="card-header">
            <button onclick="window.print()">Print</button>
        </div>
        <div class="card-body">

            <div class="invoice-box">
                <table cellspacing="0" cellpadding="0">
                </table>
                <table>
                    <tbody>
                        <tr>
                            @if (!empty(siteinfo()))
                                <td class="title">
                                    <img src="{{ asset('storage/company/' . siteinfo()->img_url ?? '') }}"
                                        alt="vendor-logo-Yetfix Limited" title="Yetfix Limited-logo(vendor)"
                                        style="width:200px;height:120px;">
                                </td>
                            @endif
                            <td>
                                <strong>BILL</strong><br>{{ $invoice->provider->company_name ?? '' }}<br>{{ $invoice->provider->address ?? '' }}<br>Mobile
                                No:{{ $invoice->provider->phone_no ?? '' }}
                                <br>Email: {{ $invoice->provider->email ?? '' }}<br>
                            </td>

                        </tr>
                    </tbody>
                </table>

                <hr>

                <table>
                    <tbody>
                        <tr>
                            <td width="60%">
                                @if (!empty(siteinfo()))
                                    BILL TO<br><strong>{{ siteinfo()->name }}</strong><br>Mobile Number:
                                    {{ siteinfo()->mobile }}<br>Email:
                                    {{ siteinfo()->email }}<br>Address: {{ siteinfo()->address }}
                                @endif
                            </td>
                            <td style="text-align:right" width="40%">
                                <table>
                                    <tbody>
                                        <tr>
                                            <td style="text-align:left"><strong>Invoice No</strong></td>
                                            <td style="text-align:center"><strong>:</strong></td>
                                            <td style="text-align:right">{{ $invoice->invoice_no }}</td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:left"><strong>Bill No</strong></td>
                                            <td style="text-align:center"><strong>:</strong></td>
                                            <td style="text-align:right">{{ $invoice->bill_no }}</td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:left"><strong>Billing Date</strong></td>
                                            <td style="text-align:center"><strong>:</strong></td>
                                            <td style="text-align:right">{{ $invoice->billing_date }}</td>
                                        </tr>
                                        <tr>
                                            <td style="text-align:left"><strong>Amount Due(BDT)</strong></td>
                                            <td style="text-align:center"><strong>:</strong></td>
                                            <td style="text-align:right"><strong>{{ $invoice->total }}</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <div style="padding-top:25px;"></div>
                <table class="itemTable" style="vertical-align:top">
                    <tbody>
                        <tr class="heading">
                            <td style="text-align:left;padding-left:10px">Item</td>
                            <td style="text-align:center!important">Quantity</td>
                            <td style="text-align:right;padding-right:10px">Price</td>
                            <td style="text-align:right;padding-right:10px">VAT(%)</td>
                            <td style="text-align:right;padding-right:10px">Amount</td>
                        </tr>
                        @foreach ($invoice->purchaseItem as $item)
                            <tr style="text-align:left!important;border-bottom:solid 1px #cccccc">
                                <td style="text-align:left;padding-left:10px">
                                    <strong>{{ $item->service->name ?? '' }}</strong> <br><span
                                        style="font-size:12px;line-height:15px;">
                                    </span>
                                </td>
                                <td style="text-align:center!important">{{ $item->quantity ?? '' }}</td>
                                <td style="text-align:right;padding-right:10px">{{ $item->rate ?? '' }}</td>
                                <td style="text-align:right;padding-right:10px">{{ $item->vat ?? '' }}</td>
                                @php
                                    $value = 0;
                                    $price = $item->rate * $item->vat;
                                    $price_vat = $price / 100;
                                    $price_with_vat = $price_vat + $item->rate;
                                    $value = $price_with_vat * $item->quantity;
                                @endphp
                                <td style="text-align:right;padding-right:10px">{{ $value ?? '' }}</td>
                            </tr>
                        @endforeach

                        <tr style="text-align:center!important">
                            <td></td>
                            <td></td>
                            <td colspan="2" style="text-align:left!important;padding-left:30px">Total Amount</td>
                            <td style="text-align:right;padding-right:10px">{{ $invoice->subTotal }}</td>
                        </tr>
                        <tr style="text-align:center!important">
                            <td></td>
                            <td></td>
                            <td colspan="2" style="text-align:left!important;padding-left:30px">Paid Amount</td>
                            <td style="text-align:right;padding-right:10px;border-bottom:solid 1px">
                                {{ $invoice->marketing_total }}</td>
                        </tr>
                        @php
                            $total = $invoice->subTotal - $invoice->marketing_total;
                        @endphp
                        <tr style="text-align:center!important;padding:0">
                            <td></td>
                            <td></td>
                            <td colspan="2" style="text-align:left!important;padding-left:30px"><strong>Amount
                                    Due(BDT)</strong></td>
                            <td style="text-align:right;padding-right:10px"><strong>{{ $total }}</strong></td>
                        </tr>
                    </tbody>
                </table>
                <br>
                <hr style="border-top:1px dashed #000;padding-top:20px;">
            </div>
        </div>
    </div>
@endsection

@section('ajax')
    <style>
        table {
            width: 100%;
            padding: 2px;
        }

        td {
            padding: 2px;
        }

        @media print {
            .card-header {
                display: none;
            }

            .main-footer {
                display: none;
            }

            td {
                padding: 2px;
            }

            td {
                font-size: 16px !important;
            }

            .cname {
                font-size: 50px;
            }
        }
    </style>
@endsection
