@extends('layout.app')


@section('content')


    <form action="{{ route('item.store') }}" method="POST">

        @csrf
        <div class="card">
            <div class="card-body">
            <div class="row">
                <div class="form-group col-md-4">
                    <label for="nas_id">
                        Category
                    </label>

                    <select name="category_id" id="category_id" class="form-control select2">
                        <option value="">Select Category</option>
                        @foreach ($categories as $list)
                            <option class="p-5" value="{{ $list->id }}">{{ $list->name }} (
                                {{ $list->bn_name }})
                            </option>
                        @endforeach
                    </select>
                    @error('category_id')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="form-group col-md-4">
                    <label for="name">
                        Name*
                    </label>

                    <input type="text" name="name" id="name" value="{{ old('name') }}"
                        class="form-control" placeholder=" Name" autocomplete="off" >
                    @error('name')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>


                <div class="form-group col-md-4">
                    <label for="bn_name">
                        Name(Bangla)
                    </label>

                    <input type="text" name="bn_name" id="bn_name" value="{{ old('bn_name') }}"
                        class="form-control" placeholder=" bn_name" autocomplete="off" >
                    @error('bn_name')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>


                <div class="form-group col-md-4">
                    <label for="nas_id">
                        Unit
                    </label>

                    <select name="unit_id" id="unit_id" class="form-control select2">
                        <option value="">Select Unit</option>
                        @foreach ($units as $unit)
                            <option class="p-5" value="{{ $unit->id }}">{{ $unit->name }}</option>
                        @endforeach
                    </select>
                    @error('unit_id')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="form-group col-md-4">
                    <label for="short_name">
                        Short Name*
                    </label>

                    <input type="text" name="short_name" id="short_name" value="{{ old('short_name') }}"
                        class="form-control" placeholder=" short_name" autocomplete="off" >
                    @error('short_name')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>

                <div class="form-group col-md-4">
                    <label for="nas_id">
                        Serial No
                    </label>

                    <select name="serial_number" id="serial_number" class="form-control select2">
                        <option value="enable" selected >Enable</option>
                        <option value="disable">Disable</option>

                    </select>

                </div>
                <div class="form-group col-md-4">
                    <label for="short_name">
                        Alert quantity*
                    </label>

                    <input type="number"  name="alert_quantity" id="alert_quantity" value="0" class="form-control" placeholder="alert_quantity" autocomplete="off" >
                    @error('alert_quantity')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>


                <div class="form-group col-md-12">
                    <label for="remarks">
                        Remarks
                    </label>

                    <input type="text" name="remarks" id="remarks" value="{{ old('remarks') }}"
                        class="form-control" placeholder=" remarks" autocomplete="off" autofocus>
                    @error('remarks')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>


            </div>

                <div class="form-group">
                    @can('inventory_store')
                        <button type="submit" class="btn btn-success float-right">
                            Save
                        </button>
                    @endcan
                </div>
            </div>
        </div>
    </form>

    <div class="p-5"></div>

@endsection
