import { toast } from 'react-hot-toast';
import axiosInstance from '../../util/axiosInstance';
import { setCurrentCluster } from '../reducers/currentClusterReducer';

export const fetchClusterData = (clusterId) => async (dispatch) => {
    try {
        const { data } = await axiosInstance.get(`/clusters/${clusterId}`);
        dispatch(setCurrentCluster(data));
    } catch (error) {
        console.log(error);
    }
};
