<?php


use App\Models\Token;

use App\Models\Client;
use Maatwebsite\Excel\Row;
use App\Classes\LicenseCheck;
use App\Jobs\LicenseCheckJob;
use App\Classes\SnmpOlt\SnmpOlt;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Dashboard;
use App\Http\Controllers\TableDump;
use App\Models\ResellerBillGenerate;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BoxController;
use App\Http\Controllers\DevController;
use App\Http\Controllers\NasController;
use App\Http\Controllers\OltController;
use App\Http\Controllers\PopController;
use App\Http\Controllers\SmsController;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\AreaController;

use App\Http\Controllers\UserController;

use App\Http\Middleware\VerifyCsrfToken;
use App\Classes\MikrotikService\Mikrotik;

use App\Classes\TelnetServices\TelnetOlt;

use App\Http\Controllers\RolesController;

use App\Http\Controllers\BWSaleController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\YFsmsController;;
use App\Http\Controllers\MailLogController;
use App\Http\Controllers\OltInfoController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\SupportController;
use App\Http\Controllers\DeleteCustomerInfo;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\MikrotikController;
use App\Http\Controllers\PackagesController;
use App\Http\Controllers\ResellerController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\TokenCatController;
use App\Http\Controllers\DueClientController;
use App\Http\Controllers\LineShiftController;
use App\Http\Controllers\RadiusLogController;
use App\Http\Controllers\TokenCodeController;
use App\Http\Controllers\BillDeleteController;
use App\Http\Controllers\DeviceTypeController;
use App\Http\Controllers\FileExportController;
use App\Http\Controllers\LeftClientController;
use App\Http\Controllers\PayBillLogController;
use App\Http\Controllers\SubPackageController;
use App\Http\Controllers\BandServiceController;
use App\Http\Controllers\Clients\OtcController;
use App\Http\Controllers\CompanyInfoController;
use App\Http\Controllers\ExpireCheckController;
use App\Http\Controllers\PermissionsController;
use App\Http\Controllers\RadiusTableController;
use App\Http\Controllers\SupportHomeController;
use App\Http\Controllers\UserBalanceController;
use App\Http\Controllers\BandProviderController;
use App\Http\Controllers\BandPurchaseController;
use App\Http\Controllers\BillGenerateController;
use App\Http\Controllers\BkashWebhookController;
use App\Http\Controllers\EmailSettingController;
use App\Http\Controllers\RadcheckUserController;
use App\Http\Controllers\RecentClientController;
use App\Http\Controllers\ResellerAreaController;
use App\Classes\MikrotikService\MikrotikStaticIP;
use App\Console\Commands\CheckPaymentIntegration;
use App\Http\Controllers\MarketingUserController;
use App\Http\Controllers\PackageChangeController;
use App\Http\Controllers\PaymentMethodController;
use App\Http\Controllers\PaymentReportController;
use App\Http\Controllers\SupportTicketController;
use App\Http\Controllers\BillCollectionController;
use App\Http\Controllers\ClientRegisterController;
use App\Http\Controllers\Customer\TokenController;
use App\Http\Controllers\FixCommonIssueController;
use App\Http\Controllers\GlobalSettingsController;
use App\Http\Controllers\PgwResponseLogController;
use App\Http\Controllers\ResellerSmsLogController;
use App\Http\Controllers\SessionRefreshController;
use App\Http\Controllers\UserSystemInfoController;
use App\Http\Controllers\Api\PayToYetFixController;
use App\Http\Controllers\CustomerInvoiceController;
use App\Http\Controllers\ExpiredCustomerController;
use App\Http\Controllers\AccountingServerController;
use App\Http\Controllers\AccountStatementController;
use App\Http\Controllers\BillDateExtendedController;
use App\Http\Controllers\BwBillCollectionController;
use App\Http\Controllers\CustomerRechargeController;
use App\Http\Controllers\DeleteClientInfoController;
use App\Http\Controllers\OtcPaymentReportController;
use App\Http\Controllers\Accounting\IncomeController;
use App\Http\Controllers\ResellerSmsGetwayController;
use App\Http\Controllers\SslCommerzPaymentController;
use App\Http\Controllers\Accounting\ExpenseController;
use App\Http\Controllers\RsellerCommissioneController;
use App\Http\Controllers\ResellerBillPaymentController;
use App\Http\Controllers\Clients\CustomerListController;
use App\Http\Controllers\Pop\PopEnableDisableController;
use App\Http\Controllers\ResellerBillGenerateController;
use App\Http\Controllers\SupportTicketSummaryController;
use App\Http\Controllers\Accounting\CashInHandController;
use App\Http\Controllers\Accounting\IncomeHeadController;
use App\Http\Controllers\Clients\PendingClientController;
use App\Http\Controllers\DivisionDistrictThanaController;
use App\Http\Controllers\SubRsellerCommissioneController;
use App\Http\Controllers\Accounting\ExpenseHeadController;
use App\Http\Controllers\Clients\ClientsSearchConntroller;
use App\Http\Controllers\Clients\OflineCustomerController;
use App\Http\Controllers\Clients\OnlineCustomerController;
use App\Http\Controllers\ResellerRechargeReportController;
use App\Http\Controllers\Accounting\FundTransferController;
use App\Http\Controllers\CheckPaymentIntegrationController;
use App\Http\Controllers\Clients\IdEnableDisableController;
use App\Http\Controllers\MultipleCustomerPaymentController;
use App\Http\Controllers\PaymentGetwayCredentialController;
use App\Http\Controllers\ReselleBalanceLogReportController;
use App\Http\Controllers\AdvencedBalencedCustomerController;
use App\Http\Controllers\BandwidthSale\BwCustomerController;
use App\Http\Controllers\OnlinePayment\SSLResellerController;
use App\Http\Controllers\Reseller\ResellerRechargeController;
use App\Http\Controllers\SubResellerRechargeReportController;
use App\Http\Controllers\BkashPaymentResellerReportController;
use App\Http\Controllers\OnlinePayment\BkashResellerController;
use App\Http\Controllers\OnlinePayment\NagadResellerController;
use App\Http\Controllers\privacyPolicy\PrivacyPolicyController;
use App\Http\Controllers\SubResellerBalanceLogReportController;
use App\Http\Controllers\MultipleCustomerStatusChangeController;
use App\Http\Controllers\Billing\ClientBillingCycleChangeController;
use App\Http\Controllers\OnlinePopRecharge\UpayPopRechargeController;
use App\Http\Controllers\OnlinePopRecharge\BkashPopRechargeController;
use App\Http\Controllers\OnlinePopRecharge\NagadPoprechargeController;
use App\Http\Controllers\Accounting\ResellerCommissionInHandController;
use App\Http\Controllers\ResellerClientPaymentController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


require __DIR__ . '/customer.php';

require __DIR__ . '/surjopay.php';

Route::get('down/{key?}', function () {
    echo 'processing...';
    if (request()->key == 'yetfix') {
        Artisan::call('down --secret=yetfix');
    }
    echo '<br>';
    echo 'Down Done';
});

Route::get('up/{key?}', function () {
    echo 'processing..';
    if (request()->key == 'yetfix2041') {
        Artisan::call('up');
    }
    echo '<br>' . 'Server is UP';
    return redirect('admin');
});

Route::get('licenseCheck', function () {
    echo 'processing...';
    Artisan::call('license:check');
    echo '<br>';
    echo 'Done';
});

Route::resource('client-register', ClientRegisterController::class);


Route::get('license-reset', [CompanyInfoController::class, 'licenseReset'])->name('licenseReset');

Route::get('sample-page', function () {
    return view('samplePage');
});


Route::middleware(['auth'])->prefix('admin')->group(function () {

    require __DIR__ . '/store.php';
    require __DIR__ . '/artisan.php';
    require __DIR__ . '/banking.php';
    require __DIR__ . '/payroll.php';
    require __DIR__ . '/report.php';
    require __DIR__ . '/crm.php';
    require __DIR__ . '/package.php';
    require __DIR__ . '/bandwidth.php';
    require __DIR__ . '/client.php';
    require __DIR__ . '/resellerAccount.php';

    Route::get('client-qr-code/{id}', [ClientRegisterController::class, 'qrCodeGenerate'])->name('clientQrcode');

    Route::get('client-register-list', [ClientRegisterController::class, 'index'])->name('clientRegisterList');
    Route::get('client-register-edit/{id}', [ClientRegisterController::class, 'clientEdit'])->name('clientRegisterEdit');
    Route::post('client-register-update/{id}', [ClientRegisterController::class, 'clientUpdate'])->name('clientRegisterUpdate');

    Route::view("map", "map.map")->name("map")->middleware('check.map.permission');

    Route::get('duplicateRadiusUserPass', [NasController::class, 'duplicateRadiusUserPass'])->name('duplicateRadiusUserPass');

    Route::resource('sms-gateway', SmsController::class);
    Route::group(['middleware' => ['can:sms_balance']], function () {
        Route::get('sms-balance', [SmsController::class, 'balance'])->name('smsBalance');
    });
    Route::group(['middleware' => ['can:bkash-recharge']], function () {

        Route::get('sms-recharge', [SmsController::class, 'recharge'])->name('smsRecharge');
    });
    //There is no pemissions for smsSetting,sms-log route
    Route::get('sms-settings', [SmsController::class, 'setting'])->name('smsSetting');
    Route::post('sms-tempalte-save', [SmsController::class, 'smsTempalteSave'])->name('sms-tempalte-save')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::post('payment-button-save', [CompanyInfoController::class, 'paumentBtnSave'])->name('paumentBtnSave')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);

    Route::get('bkashPaymentResellerReport', [BkashPaymentResellerReportController::class, 'bkashPaymentResellerReport'])->name('bkashPaymentResellerReport');

    Route::group(['middleware' => ['can:sms-log']], function () {
        Route::get('sms-log', [SmsController::class, 'smsLog'])->name('smsLog');
    });
    Route::group(['middleware' => ['can:email-setting']], function () {
        Route::get('emailLog', [MailLogController::class, 'index'])->name('emailLog');

        Route::get('email-reminder', [EmailSettingController::class, 'emailReminder'])->name('emailReminder');

        Route::post('billReminder', [EmailSettingController::class, 'billReminder'])->name('billReminder');

        Route::post('billReminderGroup', [EmailSettingController::class, 'billReminderGroup'])->name('billReminderGroup');
    });

    // Clinet ip'
    Route::get('getPackageIpRange', [ClientController::class, 'getPackageIpRange'])->name('getPackageIpRange');
    Route::get('getStaticIp', [ClientController::class, 'getStaticIp'])->name('getStaticIp');
    Route::get('getStaticIpRange', [ClientController::class, 'getStaticIpRange'])->name('getStaticIpRange');

    Route::get('getBox', [ClientController::class, 'getBox'])->name('getBox');


    Route::resource('mail-log', MailLogController::class);

    Route::get('/clientId-search-result', [ClientController::class, 'clientSearchResult'])->name('clientSearchResult');
    Route::group(['middleware' => ['can:send-batch-sms']], function () {

        Route::get('send-sms', [SmsController::class, 'sendSms'])->name('sendSms');
    });
    Route::group(['middleware' => ['can:send-sms-from-header-search']], function () {
        Route::get('send-sms-single/{id}', [SmsController::class, 'sendSmsSingle'])->name('send-sms-single');
    });
    Route::get('/sms-log-search-result', [SmsController::class, 'smsLogSearchResult'])->name('smsLogSearchResult');
    Route::post('sendSmsToSelectedPop', [SmsController::class, 'sendSmsToSelectedPop'])->name('sendSmsToSelectedPop')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::post('sendSmsToSelectedUser', [SmsController::class, 'sendSmsToSelectedUser'])->name('sendSmsToSelectedUser')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);

    Route::resource('company-settings', CompanyInfoController::class);

    Route::get('closeTokenList', [SupportController::class, 'closeIndex'])->name('closeTokenList');
    Route::get('file-export', [FileExportController::class, 'exportList'])->name('exportList');
    Route::post('file-export-down', [FileExportController::class, 'exportListDown'])->name('exportListDown')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);

    Route::group(['middleware' => ['can:assign-token']], function () {
        Route::get('assignTokenList', [SupportController::class, 'assignIndex'])->name('assignTokenList');
    });
    Route::get('printToken', [SupportController::class, 'indexPrint'])->name('printToken');
    Route::get('printTokenList', [SupportController::class, 'indexListPrint'])->name('printTokenList');
    Route::group(['middleware' => ['can:token-search']], function () {

        Route::get('searchToken', [SupportController::class, 'searchToken'])->name('searchToken');
    });
    Route::get('tokenExport', [SupportController::class, 'tokenExport'])->name('tokenExport');
    Route::get('searchTokenResult', [SupportController::class, 'searchTokenResult'])->name('searchTokenResult');
    Route::get('getTokenById', [SupportController::class, 'getTokenById'])->name('getTokenById');

    Route::post('closeTokenStore/{id}', [SupportController::class, 'closeTokenStore'])->name('closeTokenStore');
    Route::get('closeToken/{id}', [SupportController::class, 'closeToken'])->name('closeToken');

    Route::post('assignStore/{id}', [SupportController::class, 'assignStore'])->name('assignStore');


    Route::get('assignToken/{id}', [SupportController::class, 'assignToken'])->name('assignToken');

    Route::post('tokenStore', [SupportController::class, 'tokenStore'])->name('tokenStore');
    Route::get('tokenCreate/{id}', [SupportController::class, 'tokenCreate'])->name('tokenCreate');

    Route::get('assign-token-search', [SupportController::class, 'assignSearch'])->name('assignSearch');
    Route::get('close-token-search', [SupportController::class, 'closeTokenSearch'])->name('closeTokenSearch');
    Route::get('print-token-search', [SupportController::class, 'printTokenSearch'])->name('printTokenSearch');
    Route::get('print-token-search-result', [SupportController::class, 'indexSearchPrint'])->name('indexSearchPrint');

    Route::get('commission_history/{id}', [RsellerCommissioneController::class, 'edit'])->name('view-reseller-commission');

    Route::post('commission_history/{id}', [RsellerCommissioneController::class, 'commission_history_search'])->name('commission_history_search');

    Route::get('sub-reseller-commission/{id}', [SubRsellerCommissioneController::class, 'edit'])->name('view-sub-reseller-commission');
    Route::post('sub-reseller-commission/{id}', [SubRsellerCommissioneController::class, 'update'])->name('sub-reseller-commission');

    Route::resource('token', SupportController::class);

    Route::resource('tokenCode', TokenCodeController::class);


    Route::get('getTokenCodeList', [SupportController::class, 'getTokenCodeList'])->name('getTokenCodeList');

    Route::resource('tokenCat', TokenCatController::class);
    Route::group(['middleware' => ['can:monthly-paid-customer-list']], function () {

        Route::get('monthlyPaidCustomer', [BillGenerateController::class, 'monthlyPaidCustomer'])->name('monthlyPaidCustomer');
    });

    Route::get('paymentGetwayCredential/{id}', [PaymentGetwayCredentialController::class, 'index'])->name('paymentGetwayCredential');
    Route::post('paymentGetwayStore', [PaymentGetwayCredentialController::class, 'store'])->name('paymentGetwayStore');
    Route::get('paymentGetwayEdit/{id}', [PaymentGetwayCredentialController::class, 'edit'])->name('paymentGetwayEdit');
    Route::post('paymentGetwayUpdate/{id}', [PaymentGetwayCredentialController::class, 'update'])->name('paymentGetwayUpdate');
    Route::get('paymentGetwayDelete/{id}', [PaymentGetwayCredentialController::class, 'delete'])->name('paymentGetwayDelete');


    Route::get('printMonthlyPaid', [BillGenerateController::class, 'printMonthlyPaid'])->name('printMonthlyPaid');

    Route::get('bkashWebhookReport', [BkashWebhookController::class, 'bkashWebhookReport'])->name('bkashWebhookReport');


    Route::group(['middleware' => ['permission:customer-support']], function () {
        Route::get('support-home', [SupportHomeController::class, 'supportHome'])->name('support-home');
        Route::get("freeradius-logs", [SupportHomeController::class, 'showLastLogLines'])->name('freeradius-logs');
    });

    Route::get('get-client-info', [SupportHomeController::class, 'getClientDetails'])->name('getClientInfo');
    Route::get('getClientById', [SupportHomeController::class, 'getClientById'])->name('getClientById');


    Route::get('managerBalance', [ResellerController::class, 'managerBalance'])->name('managerBalance');


    Route::get('printExpiredClients', [ClientController::class, 'printExpiredClients'])->name('printExpiredClients');

    Route::get('severalPrint/{id}', [BillGenerateController::class, 'severalPrint'])->name('severalPrint');

    Route::get('tabledump', [TableDump::class, 'dump'])->name('tabledump');

    Route::get('client-export-import-list', [FileExportController::class, 'clientExportImportList'])->name('clientExportImportList');
    Route::post('client-list-download', [FileExportController::class, 'clientExportImportDown'])->name('clientExportImportDown');
    Route::get('user-recharge/{id}', [UserBalanceController::class, 'recharge'])->name('user-recharge');
    Route::post('user-recharge-update/{id}', [UserBalanceController::class, 'rechargeUpdate'])->name('user-recharge-update');


    Route::get('view_user_account_history/{id}', [UserController::class, 'view_user_account_history'])->name('view_user_account_history');

    Route::post('view_user_account_history/{id}', [UserController::class, 'view_user_account_history_search'])->name('view_user_account_history_search');
    Route::resource('user', UserController::class);
    // Route::resource('roles',RoleController::class);

    Route::resource('roles', RolesController::class);
    Route::get('assignPermission/{id}', [RolesController::class, 'assignPermission'])->name('assignPermission');
    Route::put('permissionUpdate', [RolesController::class, 'permissionUpdate'])->name('permissionUpdate');
    // Route::resource('permissions', PermissionsController::class);
    Route::group(['middleware' => ['can:assign-role']], function () {

        Route::get('userRole/{email}', [RolesController::class, 'userRole'])->name('userRole');
    });
    Route::put('userRoleUpdate/{id}', [RolesController::class, 'userRoleUpdate'])->name('userRoleUpdate');

    Route::resource('income', IncomeController::class);
    Route::resource('income-head', IncomeHeadController::class);
    Route::group(['middleware' => ['can:income-report']], function () {

        Route::get('/income-report', [IncomeController::class, 'incomeReport'])->name('incomeReport');
    });
    Route::get('/income-search-result', [IncomeController::class, 'incomeSearchResult'])->name('incomeSearchResult');

    Route::post('expense-approve/{id}', [ExpenseController::class, 'expenseApprove'])->name('expense-approve');
    Route::resource('expense', ExpenseController::class);
    Route::resource('expense-head', ExpenseHeadController::class);
    Route::group(['middleware' => ['can:expense-report']], function () {
        Route::get('/expense-report', [ExpenseController::class, 'expenseReport'])->name('expenseReport');
    });
    Route::get('/expense-search-result', [ExpenseController::class, 'expenseSearchResult'])->name('expenseSearchResult');
    Route::group(['middleware' => ['can:admin-password-reset']], function () {

        Route::get('/passwordReset/{email}', [UserController::class, 'passwordReset'])->name('passwordReset');
    });
    Route::put('/passwordReset/{email}', [UserController::class, 'passwordUpdate']);

    Route::get('/user-customer-summary/{id}', [UserController::class, 'userCustomerSummary'])->name('userCustomerSummary');

    Route::get('/', [Dashboard::class, 'dashboard']);
    Route::get('dashboard', [Dashboard::class, 'dashboard'])->name('dashboard');
    Route::get('dashboardNew', [Dashboard::class, 'dashboardNew'])->name('dashboardNew');

    Route::get('dashboardBill', [Dashboard::class, 'dashboardBill'])->name('dashboardBill');

    Route::post('dashboard', [Dashboard::class, 'sendmail']);

    Route::view("/dashboard/new", "dashboard.index2");

    Route::get('getPaymentReport', [Dashboard::class, 'getPaymentReport'])->name('getPaymentReport');

    Route::group(['middleware' => ['can:portal-invoice']], function () {
        Route::get('portal-invoice', [Dashboard::class, 'portalInvoice'])->name('portal-invoice');
        Route::get('portal-invoice-print/{id}/{txnID}/{date}/{amount}/{exp}/{type}', [Dashboard::class, 'portalInvoicePrint'])->name('portalInvoicePrint');
    });
    Route::group(['middleware' => ['can:disable-customer']], function () {

        Route::get('disable-customer', [ExpiredCustomerController::class, 'disableCustomer'])->name('disableCustomer');
        Route::get('disable-customer-search', [ExpiredCustomerController::class, 'disableCustomerSearch'])->name('disableCustomerSearch');
    });


    Route::group(['middleware' => ['can:newjoin']], function () {
        Route::get('newJoin', [ClientController::class, 'newJoin'])->name('newJoin');
        Route::get('newClientSearchReport', [ClientController::class, 'newClientSearchReport'])->name('newClientSearchReport');
        Route::get('newConnectionReport', [ClientController::class, 'newConnectionReport'])->name('newConnectionReport');
    });


    Route::group(['middleware' => ['can:active-customer']], function () {
        Route::get('active-customer', [ClientController::class, 'activeCustomer'])->name('activeCustomer');
        Route::get('active-customer-search', [ClientController::class, 'activeCustomerSearch'])->name('activeCustomerSearch');
    });

    Route::group(['middleware' => ['can:expire-customer']], function () {
        Route::get('expired-Clients', [ExpiredCustomerController::class, 'expiredCustomer'])->name('expiredClients');
        Route::get('expire-customer-search', [ExpiredCustomerController::class, 'expiredCustomerSearch'])->name('expiredCustomerSearch');
    });
    Route::get('expire-client-export', [ExpiredCustomerController::class, 'expireClientExport'])->name('expireClientExport');
    Route::get('pending-customer', [PendingClientController::class, 'pendingCustomer'])->name('pendingCustomer');
    Route::get('pending-customer-search', [PendingClientController::class, 'pendingCustomerSearch'])->name('pendingCustomerSearch');
    Route::get('accounts-pending-customer', [PendingClientController::class, 'accountsPendingCustomer'])->name('accountsPendingCustomer');
    Route::get('print-client-copy/{id}', [PendingClientController::class, 'printClientCopy'])->name('printClientCopy');
    // Route::get('adsfj', [LeftClient::class, 'leftClient'])->name('leftClient');
    Route::get('free-client', [ClientController::class, 'freeClient'])->name('freeClient');
    Route::get('freeClientSearch', [ClientController::class, 'freeClientSearch'])->name('freeClientSearch');

    Route::get('leftClient', [LeftClientController::class, 'leftClient'])->name('leftClient');
    Route::get('leftClientSearch', [LeftClientController::class, 'leftClientSearch'])->name('leftClientSearch');

    // close-list close customer list
    Route::get('list/{type}', [CustomerListController::class, 'index'])->name('list');
    Route::get('close-search-list', [CustomerListController::class, 'closeSearch'])->name('closeSearch');
    Route::get('close-client-export', [CustomerListController::class, 'closeClientExport'])->name('closeClientExport');

    Route::group(['middleware' => ['can:onlineUser']], function () {
        Route::get('online-customer', [OnlineCustomerController::class, 'onlineCustomer'])->name('onlineCustomer');
    });
    Route::get('fetch-online-customer', [OnlineCustomerController::class, 'fetchOnlineCustomer'])->name('fetch-online-customer');
    Route::get('online-customer-search', [OnlineCustomerController::class, 'onlineCustomerSearch'])->name('onlineCustomerSearch');
    Route::get('onlineUserDisconnect', [OnlineCustomerController::class, 'onlineUserDisconnect'])->name('onlineUserDisconnect');
    Route::get('disconnectAll', [OnlineCustomerController::class, 'disconnectAll'])->name('disconnectAll');
    Route::get('getTokenReport', [Dashboard::class, 'getTokenReport'])->name('getTokenReport');
    Route::get('show-sms-balance', [SmsController::class, 'showSmsBalance'])->name('showSmsBalance');
    Route::get('getOnlineUser', function () {

        $online =  totalOnlineCustomer();
        $clients = client_counter();
        $active = $clients->where('clients_status', 'active')->count() > 0 ? $clients->where('clients_status', 'active')->first()->total : 0;
        $expired = $clients->where('clients_status', 'expired')->count() > 0 ? $clients->where('clients_status', 'expired')->first()->total : 0;
        $disable = $clients->where('clients_status', 'disable')->count() > 0 ? $clients->where('clients_status', 'disable')->first()->total : 0;
        $deactive = $clients->where('clients_status', 'deactive')->count() > 0 ? $clients->where('clients_status', 'deactive')->first()->total : 0;
        $total = $active + $expired + $disable + $deactive;
        $data = [
            'online' => $online,
            'total' => $total,
        ];
        return $data;
    })->name('getOnlineUser');
    Route::get('close-client-list-export', [FileExportController::class, 'closeClientListExport'])->name('closeClientListExport');
    Route::group(['middleware' => ['can:deactivated-customer_index']], function () {
        Route::get('deactive-customer', [ExpiredCustomerController::class, 'deactiveCustomer'])->name('deactivatedClients');
    });
    Route::get('deactive-customer-search', [ExpiredCustomerController::class, 'deactiveCustomerSearch'])->name('deactiveCustomerSearch');
    Route::get('deactive-all-expired-customer', [ExpiredCustomerController::class, 'deactiveAllExpiredCustomer'])->name('deactiveAllExpiredCustomer');
    Route::get('deactive-client-export', [FileExportController::class, 'deactiveClientExport'])->name('deactiveClientExport');
    Route::get('refresh_session', [SessionRefreshController::class, 'refresh_session'])->name('refresh_session');
    Route::get('refreshSession/{userid}', [SessionRefreshController::class, 'refreshSession'])->name('refreshSession');

    Route::get('delete-radius-online-customer', [SessionRefreshController::class, 'deleteOnlineCustomer'])->name('delete-radius-online-customer');
    Route::get('stock-return/{id}', [ExpiredCustomerController::class, 'stockReturn'])->name('stockReturn');
    Route::resource('area', AreaController::class);
    Route::resource('box', BoxController::class);
    Route::resource('device-type', DeviceTypeController::class);
    Route::post('stock-return-store', [ExpiredCustomerController::class, 'returnStore'])->name('stock-return-store');
    Route::get('get-edit-log-history/{id}/{type}', [MikrotikController::class, 'editLogHistory'])->name('editLog-history');

    Route::resource('reseller-area', ResellerAreaController::class);
    Route::resource('mikrotiks', MikrotikController::class); //security ok
    Route::get("mikrotiks/{id}/secrets", [MikrotikController::class, "getMikrotikSecret"])->name("mikrotiks.secrets");
    // Route::resource('macusers', MacController::class);
    Route::resource('pop', PopController::class);
    Route::post('syncPopWithMikrotik', [PopController::class, "syncPopWithMikrotik"])->name("syncPopWithMikrotik");
    Route::post('syncPopForRadius', [PopController::class, "syncPopForRadius"])->name("syncPopForRadius");

    //OLT related route
    Route::resource('oltinfo', OltInfoController::class);
    Route::get('oltinfo/run/{id}', [OltController::class, 'run'])->name('oltinfo.run');
    Route::get('oltOnuInformationTruncate', [OltController::class, 'oltOnuInformationTruncate'])->name('oltOnuInformationTruncate');


    Route::post('pop_disable', [PopEnableDisableController::class, 'pop_disable'])->name('pop_disable')->withoutMiddleware([VerifyCsrfToken::class]);
    Route::post('pop_enable', [PopEnableDisableController::class, 'pop_enable'])->name('pop_enable')->withoutMiddleware([VerifyCsrfToken::class]);

    Route::group(['middleware' => ['can:pop_exception']], function () {
        Route::get('/pop-exception', [PopController::class, 'popException'])->name('pop.exception');
    });
    Route::get('/status-exception', [PopController::class, 'statusException'])->name('status.exception');
    Route::post('/status-change', [PopController::class, 'statusChange'])->name('status.change');
    Route::post('/experity-change', [PopController::class, 'experityCheckChange'])->name('experity.change');

    Route::get('subResellerRecharge/{id}', [PopController::class, 'subResellerRecharge'])->name('subResellerRecharge');
    Route::post('subRsellerRechargeUpdate', [PopController::class, 'subRsellerRechargeUpdate'])->name('subRsellerRechargeUpdate');

    Route::get('user-wise-token', [TokenController::class, 'userWiseToken'])->name('userWiseToken');
    Route::get('user-wise-token-report', [TokenController::class, 'userWiseTokenReport'])->name('userWiseTokenReport');

    Route::resource('employees', EmployeeController::class);

    Route::resource('resellers', ResellerController::class); //security ok
    Route::group(['middleware' => ['permission:package-permission|specific_management_services']], function () {

        Route::get('/reseller/{id}/permission', [ResellerController::class, 'permission'])->name('reseller.permission'); // security ok
    });

    Route::group(['middleware' => ['can:reseller-recharge']], function () {

        Route::get('resellerRecharge/{id}', [ResellerController::class, 'resellerRecharge'])->name('reseller.recharge'); //security ok
        Route::post('resellerRechargeUpdate', [ResellerController::class, 'resellerRechargeUpdate'])->middleware('custom_rate_limit')->name('rechargeUpdate'); //security ok
    });

    Route::get('onlineManagerRecharge/{id}', [ResellerRechargeController::class, 'onlineManagerRecharge'])->name('onlineManagerRecharge');
    Route::post('onlineManagerRechargeExecute', [ResellerRechargeController::class, 'onlineManagerRechargeExecute'])->name('onlineManagerRechargeExecute')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::get('upayResellerCallback', [ResellerRechargeController::class, 'upayResellerCallback'])->name('upayResellerCallback');
    Route::get('bkashResellerCallback', [BkashResellerController::class, 'bkashResellerCallback'])->name('bkashResellerCallback');
    Route::post('invWisePayToYetFixExecute', [PayToYetFixController::class, 'invWisePayToYetFixExecute'])->name('invWisePayToYetFixExecute')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::get('bkash-yetFix-callback', [PayToYetFixController::class, 'bkashYetFixCallback'])->name('bkashYetFixCallback');

    Route::post('/make-payment', [BandPurchaseController::class, 'makePayment'])->name('makePayment');
    Route::get('/purchase-invoice/{id}', [BandPurchaseController::class, 'invoice'])->name('bPurchaseInvoice');
    Route::post('reseller-pay-via-ajax', [SSLResellerController::class, 'payViaAjax'])->name('resellerPayViaAjax')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::post('reseller-success', [SSLResellerController::class, 'success'])->name('reseller-success')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::post('reseller-fail', [SSLResellerController::class, 'fail'])->name('reseller-fail')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::post('reseller-cancel', [SSLResellerController::class, 'cancel'])->name('reseller-cancel')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);

    Route::get('marketing-customer', [ClientController::class, 'marketingCustomer'])->name('marketingCustomer');
    Route::get('marketing-customer-search', [ClientController::class, 'marketingCustomerSearch'])->name('marketingCustomerSearch');

    Route::get('productinfo', [BandPurchaseController::class, 'productinfo'])->name('productinfo');
    Route::get('productDetails', [BandPurchaseController::class, 'productDetails'])->name('productDetails');


    // Route::post('recharge',[ResellerController::class,'recharge'])->name('resellerRecharge');

    Route::resource('resellerRecharge', ResellerRechargeController::class);


    Route::resource('resellerRechargeReport', ResellerRechargeReportController::class);
    Route::get('resellerRechargeSearch', [ResellerRechargeReportController::class, 'resellerRechargeSearch'])->name('resellerRechargeSearch');

    Route::resource('subResellerRechargeReport', SubResellerRechargeReportController::class);
    Route::get('subResellerRechargeSearch', [SubResellerRechargeReportController::class, 'subResellerRechargeSearch'])->name('subResellerRechargeSearch');

    Route::resource('subResellerBalanceLog', SubResellerBalanceLogReportController::class);
    Route::get('subResellerBalanceLogReport', [SubResellerBalanceLogReportController::class, 'subResellerBalanceLogReport'])->name('subResellerBalanceLogReport');


    Route::resource('ReselleBalanceLog', ReselleBalanceLogReportController::class);
    Route::get('resellerBalanceLogReport', [ReselleBalanceLogReportController::class, 'resellerBalanceLogReport'])->name('resellerBalanceLogReport');
    Route::get('resellerBalanceLogCheck', [ReselleBalanceLogReportController::class, 'resellerBalanceLogCheck'])->name('resellerBalanceLogCheck');


    // Route::get('/resellerRechargeReport',[ResellerRechargeReportController::class,'resellerRechargeReport'])->name('resellerRechargeReport');
    Route::group(['middleware' => ['can:package-permission']], function () {
        Route::put('/reseller/{id}/permissionUpdate', [ResellerController::class, 'permissionUpdate'])->name('reseller.permissionUpdate');
    });
    Route::group(['middleware' => ['can:sub-package-permission']], function () {

        Route::put('/subpackage/{id}/permissionUpdate', [PackagesController::class, 'permissionUpdate'])->name('subpackage.permissionUpdate'); //secure ok
    });

    Route::group(['middleware' => ['permission:sub-package-permission-form|specific_management_services']], function () {

        Route::get('/packages/{id}/sub_package_permission', [PackagesController::class, 'subPackagePermission'])->name('sub_package_permission'); //secure ok
    });


    // Route::resource('nas',NasController::class);

    // Route::post('nas', [NasController::class, 'store'])->name('nas');
    // Route::put('nas/{id}', [NasController::class, 'update']);
    Route::resource('packages', PackagesController::class); //secure ok
    Route::resource('sub-packages', SubPackageController::class); //secure ok
    Route::get('fetch-package-by-reseller-id/{id}', [SubPackageController::class, 'fetchPackage']);

    Route::get('form-settings', [GlobalSettingsController::class, 'formSetting'])->name('formSetting');
    Route::post('form-settings-store', [GlobalSettingsController::class, 'formSettingStore'])->name('formSetting.store');

    Route::get('csrf', function () {
        return csrf_token();
    })->name('csrf');

    Route::get('customer_search', [ClientsSearchConntroller::class, 'search'])->name('customer_search');

    Route::get('clientSearch', [ClientsSearchConntroller::class, 'clientSearch'])->name('clientSearch');

    Route::get('clientSearchReport', [ClientsSearchConntroller::class, 'clientSearchReport'])->name('clientSearchReport');

    Route::get('clientSearchReportPrint', [ClientsSearchConntroller::class, 'clientSearchReportPrint'])->name('clientSearchReportPrint');
    Route::post('allClientDownloadExcel', [ClientsSearchConntroller::class, 'allClientDownloadExcel'])->name('allClientDownloadExcel');

    Route::get('getResellerArea', [ClientController::class, 'getResellerArea'])->name('getResellerArea');

    Route::get('recent-client-export', [ClientsSearchConntroller::class, 'recentClientExport'])->name('recentClientExport');
    Route::get('clientOnlineStatus/{clientUserId}', [ClientsSearchConntroller::class, 'getCustomerOnLineStatus'])->name('clientOnlineStatus');

    Route::resource('clients', ClientController::class);
    Route::get("onu-information",  [ClientController::class, 'onuInformationShow'])->name("onu-information");
    Route::post('expire-date-extend', [ClientController::class, 'expireDateExtend'])->name('expireDateExtend');
    Route::get('close/{id}', [ClientController::class, 'close'])->name('close'); //secure ok
    Route::get('open/{id}', [ClientController::class, 'open'])->name('open'); // secure ok
    Route::group(['middleware' => ['can:login-attempts-all']], function () {
        Route::get('login-attempts-all', [ClientController::class, 'loginAttemptsAll'])->name('login-attempts-all');
    });

    Route::post('delete/{id}', [ClientController::class, 'delete'])->name('clinetDelete');
    Route::get('deactive/{id}', [ClientController::class, 'deactive'])->name('deactive');
    // MKapi route
    Route::post('re-sync-single-client', [ClientController::class, 'reSyncSingleClient'])->name("reSyncSingleClient");
    Route::get('fetch-district', [DivisionDistrictThanaController::class, 'fetchDistrict'])->name('fetchDistrict');
    Route::get('fetch-upazila', [DivisionDistrictThanaController::class, 'fetchUpazila'])->name('fetchUpazila');
    Route::get('fetch-thana', [DivisionDistrictThanaController::class, 'fetchThana'])->name('fetchThana');
    Route::post('never-disconnect-single-client', [ClientController::class, 'neverDisconnectClient'])->name("neverDisconnectClient");
    Route::post('reactivate/{id}', [ClientController::class, 'reactivate'])->name('reactivate');

    Route::get('getPackageForPop', [ClientController::class, 'getPackageForPop'])->name('getPackageForPop');

    Route::get('checkUsername', [ClientController::class, 'checkUsername'])->name('checkUsername');
    Route::get('checkCustomerCode', [ClientController::class, 'checkCustomerCode'])->name('checkCustomerCode');

    Route::post('changeExpireDate', [ClientController::class, 'changeExpireDate'])->name('changeExpireDate')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);

    Route::get('expireCheck', [ClientController::class, 'expireCheck'])->name('expireCheck');
    Route::post('recharge', [ClientCOntroller::class, 'recharge'])->name('recharge');

    Route::get('getClientDetails', [ClientController::class, 'getClientDetails'])->name('getClientDetails');
    Route::get('get-pop-wise-pack-list', [PackageChangeController::class, 'getPopWisePackList'])->name('getPopWisePackList');


    Route::get('getResellerPopList', [ClientController::class, 'getResellerPopList'])->name('getResellerPopList');
    Route::get('getPopWiseAreaList', [PopController::class, 'getPopWiseAreaList'])->name('getPopWiseAreaList');
    Route::get('getSubPopOfReseller', [PopController::class, 'getSubPopOfReseller'])->name('getSubPopOfReseller');
    Route::get('getResellPopList', [ClientController::class, 'getResellPopList'])->name('getResellPopList');

    Route::group(['middleware' => ['can:customer-list-for-BTRC']], function () {
        Route::get('customer-list-for-BTRC', [ClientController::class, 'clientSearchBTRC'])->name('clientSearchBTRC');
        Route::post('users/export', [ClientController::class, 'export'])->name('users.export')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);

        Route::get('customer-new-list-for-BTRC', [ClientController::class, 'clientNewSearchBTRC'])->name('clientNewSearchBTRC');
        Route::post('new-users/new-export', [ClientController::class, 'newExport'])->name('newusers.newexport')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    });


    // Route::get('onlineCustomer', [ClientController::class, 'onlineCustomer'])->name('onlineCustomer');

    Route::group(['middleware' => ['can:oflineUser']], function () {

        Route::get('oflineCustomer', [OflineCustomerController::class, 'oflineCustomer'])->name('oflineCustomer');
    });
    Route::get('oflineCustomerResult', [OflineCustomerController::class, 'oflineCustomerResult'])->name('oflineCustomerResult');

    Route::group(['middleware' => ['can:deletedUser']], function () {

        Route::get('deleted-Customer', [OflineCustomerController::class, 'deletedCustomer'])->name('deletedCustomer');
    });

    // Route::get('oflineCustomer', [ClientController::class, 'oflineCustomer'])->name('oflineCustomer');
    // Route::get('oflineCustomerResult', [ClientController::class, 'oflineCustomerResult'])->name('oflineCustomerResult');



    Route::get('userDisconnect/{id}', [ClientController::class, 'userDisconnect'])->name('userDisconnect');
    Route::get('getCustomerLogHistory/{id}', [RadiusLogController::class, 'getCustomerLogHistory'])->name('getCustomerLogHistory');

    Route::get('/log-search-result', [RadiusLogController::class, 'logeSearchResult'])->name('logSearchResult');


    Route::post('approve/{id}', [ClientController::class, 'approve'])->name('clinetApprove');

    Route::resource('marketing-user', MarketingUserController::class);

    Route::post('addMarketer', [ClientController::class, 'addMarketer'])->name('addMarketer')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);;
    Route::post('add-thana', [ClientController::class, 'addThana'])->name('addThana')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);;
    Route::post('add-upazila', [ClientController::class, 'addUpazila'])->name('addUpazila')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);;

    Route::post('approveAllPending', [PendingClientController::class, 'approveAllPending'])->name('approveAllPending');
    Route::post('firstApproveAllPending', [PendingClientController::class, 'firstApproveAllPending'])->name('firstApproveAllPending');

    Route::get('local-pending-customer', [PendingClientController::class, 'localPendingCustomer'])->name('localPendingCustomer');
    Route::get('local-pending-customer-search', [PendingClientController::class, 'localPendingCustomerSearch'])->name('localPendingCustomerSearch');
    Route::resource('location', LocationController::class);
    Route::get('location-upazila', [LocationController::class, 'upazilaList'])->name('upazilaList');
    Route::get('location-thana', [LocationController::class, 'thanaList'])->name('thanaList');
    Route::get('location-upazila-edit/{id}', [LocationController::class, 'upazilaEdit'])->name('upazilaEdit');
    Route::post('location-upazila-update', [LocationController::class, 'upazilaUpdate'])->name('upazilaUpdate');
    Route::get('location-thana-edit/{id}', [LocationController::class, 'thanaEdit'])->name('thanaEdit');
    Route::post('location-thana-update', [LocationController::class, 'thanaUpdate'])->name('thanaUpdate');

    //
    Route::post('CustomerRecharge', [CustomerRechargeController::class, 'CustomerRecharge'])->name('CustomerRecharge');

    Route::group(['middleware' => ['can:changeBillCycle']], function () {

        Route::get('billingCycleChange', [ClientBillingCycleChangeController::class, 'billingCycleChange'])->name('billingCycleChange');
    });
    Route::post('userBillingCycleChange', [ClientBillingCycleChangeController::class, 'userBillingCycleChange'])->name('userBillingCycleChange');
    Route::post('batchUserBillingCycleChange', [ClientBillingCycleChangeController::class, 'batchUserBillingCycleChange'])->name('batchUserBillingCycleChange');

    Route::post('autoDeactiveDateStore', [ClientBillingCycleChangeController::class, 'autoDeactiveDateStore'])->name('autoDeactiveDateStore');
    // Route::get('billingCycleChange', [ClientController::class, 'billingCycleChange'])->name('billingCycleChange');


    Route::get('idEnaleDisableReport', [IdEnableDisableController::class, 'idEnaleDisableReport'])->name('idEnaleDisableReport');
    Route::get('idEnaleDisableResult', [IdEnableDisableController::class, 'idEnaleDisableResult'])->name('idEnaleDisableResult');


    Route::get('monthlyBillFix/{id}', [BillGenerateController::class, 'monthlyBillFix'])->name('billDelete');
    Route::get('billDeleteBillByBillPayment/{id}', [BillDeleteController::class, 'billDeleteBillByBillPayment'])->name('billDeleteBillByBillPayment');


    Route::group(['middleware' => ['can:changePackage']], function () {

        Route::get('packageChange', [PackageChangeController::class, 'packageChange'])->name('packageChange');
    });
    Route::post('userPackageChange', [PackageChangeController::class, 'userPackageChange'])->name('userPackageChange');

    Route::post('packageChangeWithoutCost', [PackageChangeController::class, 'packageChangeWithoutCost'])->name('packageChangeWithoutCost');

    Route::post('batchUserPackageChange', [PackageChangeController::class, 'batchUserPackageChange'])->name('batchUserPackageChange');




    Route::group(['middleware' => ['can:money-receipt-entry']], function () {

        Route::get('billCollection', [BillGenerateController::class, 'billCollection'])->name('billCollection');
    });

    Route::group(['middleware' => ['can:bill-sheet']], function () {

        Route::get('billSheet', [BillGenerateController::class, 'billSheet'])->name('billSheet');
    });

    Route::get('clientPrint', [ClientController::class, 'clientPrint'])->name('clientPrint');
    Route::get('billsheetPrint', [BillGenerateController::class, 'billsheetPrint'])->name('billsheetPrint');
    Route::get('billCollectionPrint', [BillGenerateController::class, 'billCollectionPrint'])->name('billCollectionPrint');

    Route::get('generateMonthlyBill', [BillGenerateController::class, 'generateMonthlyBill'])->name('generateMonthlyBill');

    Route::post('billgenerate', [BillGenerateController::class, 'billgenerate'])->name('billgenerate')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::post('addBill', [BillGenerateController::class, 'addBill'])->name('addBill');

    Route::get('due-history-in-payment/{id}', [PaymentController::class, 'dueHistoryInPayment']);

    // Customer Payment related Route

    Route::post('singlePayment', [PaymentController::class, 'singlePaymentProcess'])->name('singlePayment');
    Route::post('payment/{id}', [PaymentController::class, 'paymentprocess'])->name('paymentprocess')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::post('paymentDelete/{id}', [PaymentController::class, 'paymentDelete'])->name('paymentDelete');
    Route::get('payment/{id}', [PaymentController::class, 'payment'])->name('payment');
    Route::get('getPaymentHistory/{id}', [PaymentController::class, 'getPaymentHistory'])->name('getPaymentHistory');

    Route::get('paymentLog/{id}', [PaymentController::class, 'paymentLog'])->name('paymentLog');
    Route::get('clientAccount/{id}', [PaymentController::class, 'clientAccount'])->name('clientAccount');
    Route::post('balanceAdjustment', [PaymentController::class, 'balanceAdjustment'])->name('balanceAdjustment');
    Route::get('getPopForManager', [PaymentReportController::class, 'getPopForManager'])->name('getPopForManager');


    Route::group(['middleware' => ['can:payment-report']], function () {
        Route::get('paymentReport', [PaymentReportController::class, 'paymentReport'])->name('paymentReport');
        Route::get('bill-payment-report', [PaymentReportController::class, 'billPaymentReport'])->name('billPaymentReport');
    });
    Route::get('paymentReportSearch', [PaymentReportController::class, 'paymentReportSearch'])->name('paymentReportSearch');
    Route::get('bill-payment-report-search', [PaymentReportController::class, 'billPaymentReportSearch'])->name('billPaymentReportSearch');

    Route::group(['middleware' => ['can:payment-report']], function () {
        Route::get('otcPaymentReport', [PaymentReportController::class, 'otcPaymentReport'])->name('otcPaymentReport');
    });

    Route::group(['middleware' => ['can:payment-report']], function () {
        Route::get('newOtcPaymentReport', [OtcPaymentReportController::class, 'newOtcPaymentReport'])->name('newOtcPaymentReport');
    });
    Route::get('newOtcPaymentReportSearch', [OtcPaymentReportController::class, 'newOtcPaymentReportSearch'])->name('newOtcPaymentReportSearch');

    Route::get('print-payment-invoice/{id}', [PaymentReportController::class, 'invoicePrint'])->name('printPaymentInvoice');
    Route::group(['middleware' => ['can:money-receipt-search']], function () {
        Route::get('moneyReceiptSearch', [PaymentReportController::class, 'moneyReceiptSearch'])->name('moneyReceiptSearch');
    });
    Route::get('payment-invoice-print', [PaymentReportController::class, 'paymentInvoicePrint'])->name('paymentInvoicePrint');
    Route::get('payment-invoice-search', [PaymentReportController::class, 'paymentInvoiceSearch'])->name('paymentInvoiceSearch');
    Route::get('moneyReceiptSearchReport', [PaymentReportController::class, 'moneyReceiptSearchReport'])->name('moneyReceiptSearchReport');

    Route::get('getPopForManager', [PaymentReportController::class, 'getPopForManager'])->name('getPopForManager');

    Route::post('CustomerPaymentDadeline', [ClientsSearchConntroller::class, 'CustomerPaymentDadeline'])->name('CustomerPaymentDadeline');
    Route::post('delete-from-sync-list', [MikrotikController::class, 'deleteFromSyncList'])->name('delete-from-sync-list')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);

    Route::resource('payment-method', PaymentMethodController::class);
    Route::get('invoice-print/{id}', [PaymentController::class, 'invoicePrint'])->name('invoice-print');

    Route::post('paymentDadeline', [ClientController::class, 'paymentDadeline'])->name('paymentDadeline');



    // Id Enable Disable Controller

    Route::get('idDIsable/{id}', [IdEnableDisableController::class, 'idDisable'])->name('idDisable');
    Route::get('idEnable/{id}', [IdEnableDisableController::class, 'idEnable'])->name('idEnable');
    Route::get('idDeactive/{id}', [IdEnableDisableController::class, 'idDeactive'])->name('idDeactive');


    Route::get('statusChange/{type}/{id}', [IdEnableDisableController::class, 'statusChange'])->name('statusChange');

    Route::post('enableDisable', [IdEnableDisableController::class, 'enableDisable'])->name('enableDisable');





    // Route::post('clientDisconnect',[ClientController::class,'clientDisconnect'])->name('clientDisconnect');
    Route::get('clientExpire', [ClientController::class, 'clientExpire'])->name('clientExpire');

    Route::post('addOtc', [OtcController::class, 'addOtc'])->name('addOtc');
    Route::group(['middleware' => ['can:assign-user-reseller']], function () {
        Route::get('assignReseller/{id}', [UserController::class, 'assignReseller'])->name('assignReseller');
    });
    Route::put('assignResellerUpdate/{id}', [UserController::class, 'assignResellerUpdate'])->name('assignResellerUpdate');
    Route::group(['middleware' => ['can:assign-user-pop']], function () {
        Route::get('assignPop/{id}', [UserController::class, 'assignPop'])->name('assignPop');
    });
    Route::put('assignPopUpdate/{id}', [UserController::class, 'assignPopUpdate'])->name('assignPopUpdate');

    Route::resource('sms', YFsmsController::class);
    Route::get('/usersysteminfo', [UserSystemInfoController::class, 'getusersysteminfo']);
    Route::get('/userLogInfo/{id}', [UserSystemInfoController::class, 'userLogInfo'])->name('userLogInfo');

    // Route::get('fund-transfer',[FundTransferController::class,'fundTransfer'])->name('fund-transfer');
    // Route::post('fund-transfer',[FundTransferController::class,'fundTransferProcess'])->name('fund-transfer-process');

    Route::resource('fund-transfer', FundTransferController::class);


    Route::group(['middleware' => ['can:cash-in-hand']], function () {

        Route::get('cash-in-hand/{id}', [CashInHandController::class, 'cashInHand'])->name('cash-in-hand');
    });
    Route::get('cash_in_hand_api', [CashInHandController::class, 'cash_in_hand_api'])->name('cash_in_hand_api');

    Route::group(['middleware' => ['can:commission-in-hand']], function () {
        Route::get('commission-search-result', [ResellerCommissionInHandController::class, 'commissionSearch'])->name('commission-search-result');
        Route::get('commission-in-hand/{type}', [ResellerCommissionInHandController::class, 'commissionInHand'])->name('commission-in-hand');
    });
    Route::post('commission-transfer', [ResellerCommissionInHandController::class, 'commissionTransfer'])->name('commission-transfer');


    Route::get('/settings', [SettingsController::class, 'create'])->name('settings.create');
    Route::get('/show-settings', [SettingsController::class, 'index'])->name('settings.index');
    Route::post('/add-settings', [SettingsController::class, 'store'])->name('settings.store');
    Route::get('/edit-settings', [SettingsController::class, 'edit'])->name('settings.edit');
    Route::post('/update-settings', [SettingsController::class, 'update'])->name('settings.update');


    Route::group(['middleware' => ['can:due-otc-report']], function () {
        Route::get('/dueOtc-report', [ClientController::class, 'dueOtcReport'])->name('dueOtcReport');
    });
    Route::get('/otc-report', [ClientController::class, 'totalOtcReport'])->name('totalOtcReport');

    Route::group(['middleware' => ['can:paid-otc-report']], function () {
        Route::get('/paid-otc', [ClientController::class, 'otcReport'])->name('otcReport');
    });
    Route::get('/otc-search-result', [ClientController::class, 'otcSearchResult'])->name('otcSearchResult');
    Route::get('sync-list-down', [FileExportController::class, 'synclistDownload'])->name('nasSyncListExport');

    Route::resource('global-settings', GlobalSettingsController::class);
    Route::get('getSpeed', [ClientController::class, 'getSpeed'])->name('getSpeed');
    Route::get('mikrotiks-sync', [MikrotikController::class, 'mikrotiksSync'])->name('mikrotiks-sync');
    Route::get('mikrotiks-sync-client', [ClientController::class, 'mikrotiksSyncClient'])->name('mikrotiks-sync-client');
    Route::get('sync-client-list', [MikrotikController::class, 'syncClientList'])->name('sync-client-list');
    Route::get('sync-profile-list', [MikrotikController::class, 'mikrotiksProfileSync'])->name('sync-profile-list');
    Route::get('mikrotiks-sync-profile', [MikrotikController::class, 'mikrotiksSyncProfile'])->name('mikrotiks-sync-profile');
    Route::post("deleteAllProfileFromSyncList", [MikrotikController::class, "deleteAllProfileFromSyncList"])->name("deleteAllProfileFromSyncList")->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::post('save-package-from-profil-sync', [MikrotikController::class, 'savePackageFromSyncList'])->name('save-package-from-profil-sync')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);

    Route::group(['middleware' => ['can:test-mikrotik']], function () {

        Route::get('test-mikrotik-connection/{id}', [MikrotikController::class, 'testMikrotikConnection'])->name('test-mikrotik-connection');
    });
    Route::get('reseller-pop', [ResellerController::class, 'resellerPop'])->name('reseller-pop');
    Route::post('save-from-sync-list', [ClientController::class, 'saveFromSyncList'])->name('save-from-sync-list')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);

    Route::get('/download/{id}', [CustomerInvoiceController::class, 'download'])->name('invoice.download');
    Route::get('sendInvoice/{id}', [CustomerInvoiceController::class, 'sendInvoice'])->name('sendInvoice');
    Route::get('/invoice/{id}', [CustomerInvoiceController::class, 'index'])->name('invoice');
    Route::get('/invoice-pdf/{id}', [CustomerInvoiceController::class, 'generate_pdf'])->name('invoice-pdf');
    Route::group(['middleware' => ['can:bill-sheet']], function () {

        Route::get('/all-invoice-pdf', [CustomerInvoiceController::class, 'allInvoicePdf'])->name('all-invoice-pdf');
        Route::post('/setMonthForInvoicePrint', [CustomerInvoiceController::class, 'allInvoicePdf'])->name('setMonthForInvoicePrint')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    });
    Route::group(['middleware' => ['can:account-statement']], function () {
        Route::get('/account-statement', [AccountStatementController::class, 'accountStatementReport'])->name('account-statement');
    });
    Route::get('/account-statement-search', [AccountStatementController::class, 'accountStatementSearch'])->name('accountStatementSearch');
    Route::get('package-profile', [PackagesController::class, 'packageProfile'])->name('package-profile');
    Route::post('client-excele-import', [ClientController::class, 'clientExceleImport'])->name('client-excele-import');
    Route::get('client-import', [ClientController::class, 'clientImport'])->name('client-import');

    Route::get('clientImportSampleDownload', [ClientController::class, 'clientImportSampleDownload'])->name('clientImportSampleDownload');
    Route::get('clientDueImportSampleDownload', [ClientController::class, 'clientDueImportSampleDownload'])->name('clientDueImportSampleDownload');
    Route::get('client-import-to-customer', [ClientController::class, 'clientImportToCustomer'])->name('client-import-to-customer');
    Route::post('client-import-to-customer', [ClientController::class, 'storeClientImportToCustomer'])->name('store-client-import-to-customer');
    Route::post('ClientDueImportToCustomer', [ClientController::class, 'storeClientDueImportToCustomer'])->name('storeClientDueImportToCustomer');
    Route::get('importClinetDue', [ClientController::class, 'importClinetDue'])->name('importClinetDue');
    Route::get('importClientsDueAmount', [ClientController::class, 'importClientsDueAmount'])->name('importClientsDueAmount');

    Route::get('all-customer-bill-generate', [BillGenerateController::class, 'allcustomerbill'])->name('all-customer-bill-generate');
    Route::get('clients-with-userName/{userName}', [ClientController::class, 'clientsWithUserName'])->name('clients-with-userName');
    Route::group(['middleware' => ['can:bulk-date-extended']], function () {
        Route::get('bulk-expariy-date-extended', [ClientsSearchConntroller::class, 'bulkExpariyDateExtended'])->name('bulk-expariy-date-extended');
    });
    Route::get('bulk-expariy-date-extended-search', [ClientsSearchConntroller::class, 'bulkExpariyDateExtendedSearch'])->name('bulk-expariy-date-extended-search');

    Route::get('cuostomer-inport-from-json', [ClientController::class, 'clientImportJson'])->name('cuostomer-inport-from-json');
    Route::post('client-json-import', [ClientController::class, 'clientJsonImportSave'])->name('client-json-import');
    Route::get('all-customer-to-mikrotik', [MikrotikController::class, 'allCustomerToMikrotik'])->name('all-customer-to-mikrotik');
    Route::group(['middleware' => ['can:due-customer-list']], function () {
        Route::get('due-customer', [DueClientController::class, 'dueCustomer'])->name('due-customer');
    });
    Route::get('getResellerAreaPop', [AreaController::class, 'getResellerAreaPop'])->name('getResellerAreaPop');
    Route::get('due-customer-search', [DueClientController::class, 'dueCustomerSearch'])->name('due-customer-search');
    Route::get('bill-extended-customers', [BillDateExtendedController::class, 'billExtendedCustomers'])->name('bill-extended-customers');
    Route::get('get-bill-extends-customers', [BillDateExtendedController::class, 'getBillExtendsCustomers'])->name('get-bill-extends-customers');
    Route::post('sendSmsToDueCustomer', [SmsController::class, 'sendSmsToDueCustomer'])->name('sendSmsToDueCustomer')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::get('pop-deactive/{id}', [PopController::class, 'deactiveAllCustomer'])->name('pop-deactive');
    Route::get('pop-close/{id}', [PopController::class, 'popClose'])->name('pop-close');
    Route::group(['middleware' => ['can:bill-generate-report']], function () {
        Route::get('bill-generate', [BillGenerateController::class, 'billGenerateReport'])->name('bill-generate');
        Route::get('generateMonthlyBill', [BillGenerateController::class, 'generateMonthlyBill'])->name('generateMonthlyBill');
        Route::post('generateMonthlyBill', [BillGenerateController::class, 'generateMonthlyBill']);
    });
    Route::get('bill-generate-search', [BillGenerateController::class, 'billGenerateSearch'])->name('bill-generate-search');
    Route::get('all-local-customer-number', [FileExportController::class, 'allLocalCustomerNumber'])->name('all-local-customer-number');
    Route::get('close-customer-details/{id}', [ClientController::class, 'closeShow'])->name('close-customer-details');
    Route::get('add-token', [TokenController::class, 'addToken'])->name('add-token');
    Route::get('get-token-code', [TokenController::class, 'getTokenCode'])->name('get-token-code');
    Route::get('get-customer', [TokenController::class, 'getCustomer'])->name('get-customer');
    Route::post('assignTokenFromModal', [TokenController::class, 'assignToken'])->name('assignTokenFromModal');
    Route::post('closeTokenModal', [TokenController::class, 'closeTokenModal'])->name('closeTokenModal');
    Route::post('token-save-new', [TokenController::class, 'tokenSaveNew'])->name('token-save-new');
    Route::get('customer_account_check', [TokenController::class, 'customerAccountCheck'])->name('customer_account_check');
    Route::get('getPopAreaList', [AreaController::class, 'getPopAreaList'])->name('getPopAreaList');
    Route::post('add-note-token', [TokenController::class, 'addNoteToken'])->name('add-note-token');
    Route::get('get-token-note', [TokenController::class, 'getTokenNote'])->name('get-token-note');
    Route::post('delete-token-note', [TokenController::class, 'deleteTokenNote'])->name('delete-token-note')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::get('email-setting', [EmailSettingController::class, 'index'])->name('email-setting');
    Route::post('email-tempalte-save', [EmailSettingController::class, 'store'])->name('email-tempalte-save')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::get('advanced-balanced-customer', [AdvencedBalencedCustomerController::class, 'advancedBalancedCustomer'])->name('advanced-balanced-customer');
    Route::get('advanced-balanced-customer-search', [AdvencedBalencedCustomerController::class, 'advancedBalancedCustomerSearch'])->name('advanced-balanced-customer-search');
    Route::get('change-all-blling-to-current-mounth', [AdvencedBalencedCustomerController::class, 'changeBillingCurrentMounth'])->name('change-all-blling-to-current-mounth');
    Route::get('change-all-blling-to-current-mounth-with-out-status', [AdvencedBalencedCustomerController::class, 'changeBillingCurrentMounthWithOutStatus'])->name('change-all-blling-to-current-mounth-with-out-status');
    Route::get('delete-all-account', [AdvencedBalencedCustomerController::class, 'deleteAllAccount'])->name('delete-all-account');
    Route::get('get-pop', [PopController::class, 'getPop'])->name('get-pop');
    Route::get('delete-all-customer-info-and-account-by-pop-id', [DeleteClientInfoController::class, 'deleteAllCustomerInfoAndAccountByPopId'])->name('delete-all-customer-info-and-account-by-pop-id');
    Route::post('delete-customer-account', [DeleteClientInfoController::class, 'deleteCustomerAccount'])->name('delete-customer-account');
    Route::get('recent-customer-report', [RecentClientController::class, 'recentCustomerAccount'])->name('recent-customer-report');
    Route::get('recent-customer-account-search', [RecentClientController::class, 'recentCustomerAccountSearch'])->name('recent-customer-account-search');
    Route::get('getClientDetailsForPackageChange', [PackageChangeController::class, 'getClientDetailsForPackageChange'])->name('getClientDetailsForPackageChange');
    Route::get('get-current-month-customer-info', [DeleteClientInfoController::class, 'currentMonthCustomerInfo'])->name('get-current-month-customer-info');
    Route::get('set-paid-amount-to-bill-generate', [BillCollectionController::class, 'setPaidAmountToBillGenerate'])->name('set-paid-amount-to-bill-generate');
    Route::resource('line-shift', LineShiftController::class);
    Route::get('get-all-edit-log-history/{id}', [SupportHomeController::class, 'getAllEditLogHistory'])->name('get-all-edit-log-history');
    Route::get('get-line-shift-customer', [LineShiftController::class, 'getCustomerList'])->name('getLineShiftcustomer');

    Route::get('change-expense-date', [ExpenseController::class, 'changeExpenseDate'])->name('change-expense-date');
    Route::post('reAssignTokenFromModal', [TokenController::class, 'reAssignTokenFromModal'])->name('reAssignTokenFromModal');

    Route::post("client-online-ip-add-to-static-ip", [ClientController::class, "clientOnlineIpAddToStaticIp"])->name("client-online-ip-add-to-static-ip")->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::post("sync-client-ip-to-software", [ClientController::class, "syncClientIpToSoftware"])->name("sync-client-ip-to-software")->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::post("sync-client-mac-to-software", [ClientController::class, "syncClientMacToSoftware"])->name("sync-client-mac-to-software")->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::post("sync-online-client-mac-to-software", [ClientController::class, "syncOnlineClientMacToSoftware"])->name("sync-online-client-mac-to-software")->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::post("delete-all-from-sync-list", [MikrotikController::class, "deleteAllFromSyncList"])->name("delete-all-from-sync-list")->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::get("fixed_due_zero_customer_account", [BillCollectionController::class, "fixedDueZeroCustomerAccount"])->name("fixed_due_zero_customer_account");
    Route::get("client-info-data/{id}", [CustomerRechargeController::class, "clientInfoData"])->name("client-info-data");
    Route::get("delete-all-bill-not-paid", [DeleteClientInfoController::class, "deleteAllBillNotPaid"])->name("delete-all-bill-not-paid");
    Route::get('customerAccountFix', [BillCollectionController::class, 'customerAccountFix'])->name('customer-account-fix');
    Route::get('fixed-expires-date', [DeleteClientInfoController::class, 'fixedExpiresDate'])->name('fixed-expires-date');
    Route::get('reseller-sms-gateway/{id}', [ResellerSmsGetwayController::class, 'smsGateway'])->name('reseller-sms-gateway');
    Route::post('reseller-sms-gateway-save', [ResellerSmsGetwayController::class, 'resellerSmsGatewaySave'])->name('reseller-sms-gateway-save');
    Route::get('resellers-sms-log', [ResellerSmsLogController::class, 'resellersSmsLog'])->name('resellers-sms-log');
    Route::get('reseller-sms-log-search', [ResellerSmsLogController::class, 'resellerSmsLogSearch'])->name('reseller-sms-log-search');
    Route::get('fixed-all-customer-billing-cycle', [DeleteClientInfoController::class, 'fixedAllCustomerBillingCycle'])->name('fixed-all-customer-billing-cycle');
    Route::get('missing-bill-generate', [BillGenerateController::class, 'missingBillGenerate'])->name('missing-bill-generate');
    Route::get('missing-bill-generate-search', [BillGenerateController::class, 'reseultMissingBillGenerate'])->name('missing-bill-generate-search');
    Route::get('check-in-redcheck', [RadiusTableController::class, 'checkInRedcheck'])->name('check-in-redcheck');
    Route::get('search-in-redcheck', [RadiusTableController::class, 'searchInRedcheck'])->name('search-in-redcheck');
    Route::get('editredcheck/{id}', [RadiusTableController::class, 'editRedcheck'])->name('editredcheck');
    Route::get('editredusergroup/{id}', [RadiusTableController::class, 'editRedUserGroup'])->name('editredusergroup');
    Route::put('updateRedcheck/{id}', [RadiusTableController::class, 'updateRedcheck'])->name('updateRedcheck');
    Route::put('updateRedUserGroup/{id}', [RadiusTableController::class, 'updateRedUserGroup'])->name('updateRedUserGroup');
    Route::post('addredcheck', [RadiusTableController::class, 'addredcheck'])->name('addredcheck')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::delete('destroyReduserGroup/{id}', [RadiusTableController::class, 'destroyReduserGroup'])->name('destroyReduserGroup');
    Route::delete('destroyRedcheck/{id}', [RadiusTableController::class, 'destroyRedcheck'])->name('destroyRedcheck');
    Route::get('onlinePopRecharge/{id}', [PopController::class, 'onlinePopRecharge'])->name('onlinePopRecharge');
    Route::post('onlinePopRechargeExecute', [PopController::class, 'onlinePopRechargeExecute'])->name('onlinePopRechargeExecute')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::get('upayPopRechargeCallback', [PopController::class, 'upayPopRechargeCallback'])->name('upayPopRechargeCallback');
    Route::get('bkashPopRechargeCallback', [BkashPopRechargeController::class, 'bkashPopRechargeCallback'])->name('bkashPopRechargeCallback');
    Route::get('nagad-reseller-recharge-callback', [NagadResellerController::class, 'nagadResellerRechargeCallback'])->name('nagad-reseller-recharge-callback');
    Route::get('nagad-pop-recharge-callback', [NagadPoprechargeController::class, 'nagadPopRechargeCallback'])->name('nagad-pop-recharge-callback');
    Route::get('onlinePopRechargeRedirect/{id}', [NagadPoprechargeController::class, 'onlinePopRechargeRedirect'])->name('onlinePopRechargeRedirect');
    Route::get('token-report-summary', [SupportTicketSummaryController::class, 'tokenReportSummary'])->name('token-report-summary');
    Route::get('token-report-download', [SupportTicketSummaryController::class, 'tokenReportDownload'])->name('tokenReportDownload');


    Route::delete("remove-buinding-static/{id}", [ClientController::class, "removeStaticIpBind"])->name("remove-buinding-static");
    Route::resource('payBiilLog', PayBillLogController::class);
    // Route::get('checl',[PayBillLogController::class,'check']);
    Route::get('singleId_deleteFrom_radacctTable', [SessionRefreshController::class, 'singleIdDeleteFromRadacctTable'])->name('singleId_deleteFrom_radacctTable');

    Route::get('test', [CheckPaymentIntegrationController::class, 'store'])->name('test');
    Route::get('get', [CheckPaymentIntegrationController::class, 'get'])->name('get');
    Route::get('rad-user-update', [RadcheckUserController::class, 'index'])->name('radUserUpdateList');
    Route::get('pop-wise-rad-user-update', [RadcheckUserController::class, 'radUserUpdate'])->name('popWiseRadClientUpdate');

    Route::get('userUpdate', [RadiusLogController::class, 'userUpdate'])->name('userUpdate');
    Route::group(['middleware' => ['can:pgw_response_log']], function () {
        Route::get('pgw_response_log', [PgwResponseLogController::class, 'index'])->name('pgw_response_log');
    });
    Route::post('pgw-response-log-search', [PgwResponseLogController::class, 'pgwResponseLogSearch'])->name('pgw-response-log-search');

    Route::get('deletemonthlybill-2023', [BillGenerateController::class, 'deleteMonthlyBill'])->name('deletemonthlybill');

    Route::get('expire-but-online', [ReportController::class, 'expireButOnline'])->name('expire-but-online');
    Route::get('expireButnotDisconectProciede', [ReportController::class, 'expireButnotDisconectProciede'])->name('expireButnotDisconectProciede');

    Route::get('package-upload-download', [ReportController::class, 'packageUploadDownload'])->name('package-upload-download');
    Route::get('get_all_customer_by_package', [ReportController::class, 'searchWithPackageUploadDownLoad'])->name('get_all_customer_by_package');
    Route::resource('accoutningServer', AccountingServerController::class);
    Route::post('multipleCustomerPayment', [MultipleCustomerPaymentController::class, 'multipleCustomerPayment'])->name('multipleCustomerPayment')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);


    Route::get('fixed-payment-not-deduct-issue', [FixCommonIssueController::class, 'fixedPaymentNotDeductIssue'])->name('fixed-payment-not-deduct-issue');
    Route::post('payment-issue-fixed', [FixCommonIssueController::class, 'paymentIssueFixed'])->name('payment-issue-fixed');
    Route::get('online-payment-but-not-recharge-in-manager', [FixCommonIssueController::class, 'onlinePaymentButNotRechargeInManager'])->name('online-payment-but-not-recharge-in-manager');
    Route::post('payment-not-recharge-reseller-update', [FixCommonIssueController::class, 'paymentNotRechargeResellerUpdate'])->name('payment-not-recharge-reseller-update');
    Route::get('due-customer-search-for-invoice-wise-payment', [DueClientController::class, 'dueCustomerSearchForInvoiceWisePayment'])->name('due-customer-search-for-invoice-wise-payment');
    Route::get('reseller-sms-balance/{id}', [ResellerSmsGetwayController::class, 'resellerSmsBalance'])->name('reseller-sms-balance');
    Route::get('disconnectAllExpireOnlineClient', [ReportController::class, 'disconnectAllExpireOnlineClient'])->name('disconnectAllExpireOnlineClient');

    Route::post('multiple-customer-status-change', [MultipleCustomerStatusChangeController::class, 'multipleCustomerStatusChange'])->name('multiple-customer-status-change')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
    Route::get("devShimuL", [DevController::class, "index"])->name("dev");
    Route::get('delete-client-manager-all-info', [FixCommonIssueController::class, 'deleteClientManagerAllInfo'])->name('delete-client-manager-all-info');
    Route::post('delete-client-manager-all-info-update', [FixCommonIssueController::class, 'deleteClientManagerAllInfoUpdate'])->name('delete-client-manager-all-info-update');

    // Reseller Client Payment Routes
    Route::delete('/reseller/client/payment/{id}/delete', [ResellerClientPaymentController::class, 'deletePayment'])
        ->name('reseller.client.payment.delete')
        ->middleware(['auth', 'can:reseller-client-payment-delete']);

    Route::delete('/reseller/client/bill/{id}/delete', [ResellerClientPaymentController::class, 'deleteBill'])
        ->name('reseller.client.bill.delete')
        ->middleware(['auth', 'can:reseller-client-bill-delete']);


});


Route::get('incomeFix', [ClientController::class, 'incomeFix']);




Route::get('/privacy-policy', [PrivacyPolicyController::class, 'index'])->name('privacyPolicy');
require __DIR__ . '/auth.php';




Route::get('add-divisition', function () {

    $districts = DB::table('districts')->get();
    $divisions = DB::table('divisions')->get();

    $clientsWithNonEmptyDistrict = DB::table('clientsinfo')
        ->whereNotNull('district')
        ->whereRaw("TRIM(district) <> ''")
        ->get();

    $count = 0;
    foreach ($clientsWithNonEmptyDistrict as $client) {
        foreach ($districts as $district) {
            if (strtolower($client->district) == strtolower($district->name)) {
                $division = $divisions->where('id', $district->division_id)->first();
                // dd($division->name);
                DB::table('clientsinfo')
                    ->where('id', $client->id)
                    ->update([
                        'division' => $division->name
                    ]);
                $count++;
            }
        }
    }
    echo $count;
});

Route::get('add-district', function () {

    $districts = DB::table('districts')->get();
    $thanas = DB::table('upazilas')->get();
    // dd($thanas);

    $clientsWithNonEmptyThana = DB::table('clientsinfo')
        ->whereNotNull('thana')
        ->whereRaw("TRIM(thana) <> ''")
        ->get();
    // dd($clientsWithNonEmptyThana);
    $count = 0;
    foreach ($clientsWithNonEmptyThana as $client) {
        foreach ($thanas as $thana) {
            if (strtolower($client->thana) == strtolower($thana->name)) {
                $district = $districts->where('id', $thana->district_id)->first();
                // dd($division->name);
                DB::table('clientsinfo')
                    ->where('id', $client->id)
                    ->update([
                        'division' => $district->name
                    ]);
                $count++;
            }
        }
    }
    echo $count;
});


Route::get('/add-customer-form', function () {
    return view("add-customer-form");
});


