<!DOCTYPE HTML>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Receipt</title>

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <style type="text/css">
        table {
            page-break-inside: auto
        }

        tr {
            page-break-inside: avoid;
            page-break-after: auto
        }

        thead {
            display: table-header-group
        }

        tfoot {
            display: table-footer-group
        }
    </style>
</head>

<body>

    <div style="margin: 10px 0;" class="fontSize">
        <label for="printFontSize">Print Font Size (px): </label>
        <input type="number" id="printFontSize" value="10" min="10" max="150" step="5"
            oninput="setPrintFontSize(this.value)">
    </div>

    <button onclick="handlePrint()" style="font-size: 14px; padding: 10px 20px;">🖨️ Print</button>

    <style id="dynamicPrintStyle">
        @media print {

            .verysmallfont,
            .smallfont,
            .midiumfont,
            .bigfont {
                font-size: 10px !important;
            }
        }
    </style>

    <style>
        @media print {
            thead th {
                font-size: 75px !important;
                border: 5px solid #ddd;
            }

            button {
                visibility: hidden;
            }

            .fontSize {
                visibility: hidden;
            }

            table,
            tr,
            thead th,
            td {
                font-size: 10px !important;
                padding: 5px !important;
                border: none;
                border-collapse: collapse;
            }

            .center {
                text-align: center;
                vertical-align: middle;
            }

            .bold {
                font-weight: bold;
            }

            hr {
                display: block;
                height: 5px;
                background: transparent;
                width: 100%;
                border: none;
                border-top: solid 1px #aaa;
            }
        }
    </style>
    <div>
        <div>
            <div>
                <div>
                    <div>
                        <table style="">
                            <tbody>
                                <tr>
                                    <td colspan="" class="center bold" style="font-size: 50px">
                                        <img src="{{ asset('storage/company/' . $company_info->img_url ?? '') }}"
                                            alt="" style="width: 50px; height: 50px;">
                                    </td>
                                </tr>
                                <tr>
                                    <td class="center verysmallfont" style="font-size: 50px">
                                        {{ $company_info->name }}
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" class="center verysmallfont">{{ $company_info->address }}</td>
                                </tr>
                                <tr>
                                    <td colspan="2" class="center verysmallfont">{{ $company_info->mobile ?? '' }}
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="1" class="center smallfont">MR ID :
                                        {{ $billpayment->money_receipt_number ?? '' }}</td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <hr>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="smallfont">CID : {{ $billpayment->clients->id ?? '' }} / Date :
                                        {{ $billpayment->created_at->format('d-m-Y') }}</td>
                                </tr>
                                <tr>
                                    <td colspan="1" class="smallfont">Name :
                                        {{ $billpayment->clientsinfo->clients_name ?? '' }}</td>
                                </tr>
                                <tr>
                                    <td colspan="1" class="smallfont">Userid :
                                        {{ $billpayment->clients->userid ?? '' }}</td>
                                </tr>
                                <tr>
                                    <td colspan="1" class="smallfont ">Contact :
                                        {{ $billpayment->clientsinfo->contact_no ?? '' }}</td>
                                </tr>
                                <tr>
                                    <td class="smallfont ">Description : {{ $billpayment->description }}</td>
                                </tr>
                                <tr>
                                    <td colspan="1" class="smallfont ">Paid Amount : {{ $billpayment->paid_amount }}
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="1" class="smallfont ">Due Amount :
                                        {{ $billpayment->clients->customerAccount->dueAmount ?? '' }}</td>
                                </tr>
                                @if ($billpayment->discount_amount > 0)
                                    <tr>
                                        <td colspan="1" class="smallfont ">Discount Amount :
                                            {{ $billpayment->discount_amount }}</td>
                                    </tr>
                                @endif
                                <tr>
                                    <td colspan="1" class="smallfont">Collect By :
                                        {{ $billpayment->employee->name ?? '' }}</td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <hr>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" class="smallfont bold center">
                                        Powerd By : https://yetfix.com/
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        function isMobileDevice() {
            return /Mobi|Android|iPhone/i.test(navigator.userAgent);
        }

        function handlePrint() {
            window.print();
        }

        // Automatically open print dialog on desktop
        window.onload = function() {
            if (!isMobileDevice()) {
                window.print();
            }
        };

        // Do NOT auto-close — mobile/browser behavior varies
    </script>

    <script>
        function setPrintFontSize(size) {
            const style = document.getElementById("dynamicPrintStyle");
            style.innerHTML = `
            @media print {
                .verysmallfont,
                .smallfont,
                .midiumfont,
                .bigfont {
                    font-size: ${size}px !important;
                }

                thead th {
                    font-size: ${size * 1.5}px !important;
                }

                td {
                    font-size: ${size}px !important;
                }
            }
        `;
        }
    </script>
</body>

</html>
