<?php

namespace App\Http\Controllers;

use App\Models\Employee;
use App\Models\Payroll;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Mpdf\Tag\Em;

class PayrollController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('payroll.salarysheet.index', [
            'employees' => Employee::where('salary_generate', 1)->get(),
        ]);
    }

    public function salaryGenerateResult(Request $request)
    {
        $fromDate = Carbon::now()->startOfMonth();
        $toDate = Carbon::now()->endOfMonth();
        if ($request->from_date) {
            $fromDate = Carbon::createFromFormat('Y-m-d', $request->from_date)->startOfMonth();
        }
        if ($request->to_date) {
            $toDate = Carbon::createFromFormat('Y-m-d', $request->to_date)->endOfMonth();
        }

        if ($request->employee_id) {
            $generateSalary = Payroll::with('employee')
                ->where('employee_id', $request->employee_id)
                ->whereBetween('created_at', [$fromDate, $toDate])
                ->get();
        } else {
            $generateSalary = Payroll::with('employee')
                ->whereBetween('created_at', [$fromDate, $toDate])
                ->get();
        }

        return view('payroll.salarysheet.result', [
            'generateSalary' => $generateSalary,
        ]);


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Payroll  $payroll
     * @return \Illuminate\Http\Response
     */
    public function show(Payroll $payroll)
    {
        dd('payroll');
        $salarySheet = Payroll::with('employee')->findOrFail($id);
        return response()->json($salarySheet);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Payroll  $payroll
     * @return \Illuminate\Http\Response
     */
    public function edit(Payroll $payroll)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Payroll  $payroll
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Payroll $payroll)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Payroll  $payroll
     * @return \Illuminate\Http\Response
     */
    public function destroy(Payroll $payroll)
    {
        //
    }

    public function salaryGenerate()
    {
        // dd('salaryGenerate');
        $employees = Employee::where('salary_generate', 1)->get();

        foreach ($employees as $employee) {
            $generatedSalaryEmployee = Payroll::where('employee_id', $employee->id)->whereMonth('created_at', Carbon::now()->month)->first();


            $previousMonthInfo = Payroll::where('employee_id', $employee->id)->whereMonth('created_at', Carbon::now()->subMonth())->first();


            if ($previousMonthInfo) {
                $previousMonth = $previousMonthInfo->salary_amount;
            } else {
                $previousMonth = 0;
            }

            $salary = $employee->current_salary ?? 0 + $employee->house_allowance ?? 0 + $employee->transport_allowance ?? 0 + $employee->other_allowance ?? 0 + $employee->bonous ?? 0;


            // dd($net_salary);

            if ($generatedSalaryEmployee) {
                $generatedSalaryEmployee->employee_id = $employee->id;
                $generatedSalaryEmployee->salary = $employee->current_salary ?? 0;
                $generatedSalaryEmployee->home_allowance = $employee->house_allowance ?? 0;
                $generatedSalaryEmployee->transport_allowance = $employee->transport_allowance ?? 0;
                $generatedSalaryEmployee->other_allowance = $employee->other_allowance ?? 0;
                $generatedSalaryEmployee->bonous = $employee->bonous ?? 0;
                $generatedSalaryEmployee->deduction = $employee->advance_salary ?? 0;
                $generatedSalaryEmployee->net_salary = $salary;
                $generatedSalaryEmployee->salary_amount = $previousMonth + $salary;
                $generatedSalaryEmployee->save();
            } else {
                $payroll = new Payroll();

                $payroll->employee_id = $employee->id;
                $payroll->salary = $employee->current_salary ?? 0;
                $payroll->home_allowance = $employee->house_allowance ?? 0;
                $payroll->transport_allowance = $employee->transport_allowance ?? 0;
                $payroll->other_allowance = $employee->other_allowance ?? 0;
                $payroll->bonous = $employee->bonous ?? 0;
                $payroll->deduction = $employee->advance_salary ?? 0;
                $payroll->net_salary = $salary;
                $payroll->salary_amount = $previousMonth + $salary;
                $payroll->save();
            }
        }


        return back();
    }

    public function salarySheet($id)
    {
        // dd('salarySheet');
        $salaryInfo = Payroll::with('employee')->where('employee_id', $id)->whereMonth('created_at', Carbon::now()->month)->first();

        if (!$salaryInfo) {
            $payroll = new Payroll();

            $payroll->employee_id = $id;
            $payroll->salary = 0;
            $payroll->home_allowance = 0;
            $payroll->transport_allowance = 0;
            $payroll->other_allowance = 0;
            $payroll->bonous = 0;
            $payroll->deduction = 0;
            $payroll->net_salary = 0;
            $payroll->salary_amount = 0;
            $payroll->save();
        }

        $employeeInfo = Employee::withSum('payroll', 'net_salary')
        ->withSum('employeePayment', 'amount')
        ->where('id', $id)
        ->first();
        return $employeeInfo;
    }
}
