<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeInSaleTableForNewRequirement extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('band_sales', function (Blueprint $table) {
            if (Schema::hasColumn('band_sales', 'subTotal')) {
                $table->renameColumn('subTotal', 'paid');
            }

            if (Schema::hasColumn('band_sales', 'marketing_total')) {
                $table->renameColumn('marketing_total', 'discount');
            }

           
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('band_sales', function (Blueprint $table) {
            if (Schema::hasColumn('band_sales', 'paid')) {
                $table->renameColumn('paid', 'subTotal');
            }

            if (Schema::hasColumn('band_sales', 'discount')) {
                $table->renameColumn('discount', 'marketing_total');
            }


        });
    }
}
