import React from 'react';
import { MdOutlineDeviceHub, MdImportExport } from 'react-icons/md';
import _ from 'lodash';
import { Badge, Button, Container, Table } from 'react-bootstrap';
import { getColor } from '../../../../../../util/colorModule';

const ConnectedComponent = ({ connected_component }) => {
  switch (connected_component?.type) {
    case 'splitter_out':
      return (
        <Badge className='bg-warning text-dark'>
          <MdOutlineDeviceHub />{' '}
          <span className='fw-bold'>
            {_.capitalize(connected_component.splitter.type)}:-
          </span>
          {connected_component.splitter.name} ({connected_component.out_number}:
          {_.capitalize(getColor(connected_component.out_number))})
        </Badge>
      );
    case 'port':
      return (
        <Badge pill className='m-0 bg-warning text-dark'>
          <MdImportExport />
          <span className='fw-bold'>
            {_.capitalize(connected_component.device.type)}
          </span>
          :- {connected_component.device.name}:{connected_component.port_number}
        </Badge>
      );

    default:
      return <Badge className='bg-dark'>Nothing connected</Badge>;
  }
};

function ClientInfo({ clientInfo }) {
  return (
    <tr>
      <td>{clientInfo.client.id}</td>
      <td>
        {clientInfo.clients_name} {clientInfo.status === 'online' ? '🟢' : '🔴'}
      </td>
      <td>{clientInfo.client.userid}</td>
      <td>{clientInfo.client.password}</td>
      <td>{clientInfo.contact_no}</td>
      <td>{clientInfo.client.clients_status}</td>
      <td>{clientInfo.flat_no}</td>
      <td>{clientInfo.road_no}</td>
      <td>{clientInfo.area}</td>
      <td>{clientInfo.remarks}</td>
      <td>
        <ConnectedComponent
          connected_component={clientInfo.connected_component}
        />
      </td>
      <td>
        <Button size='sm' variant='dark'>
          View Details
        </Button>
      </td>
    </tr>
  );
}

const ClientsDetail = ({ clients }) => {
  return (
    <Container fluid>
      <h4>Clients</h4>
      <hr className='m-0' />
      <Table striped bordered hover className='mt-2'>
        <thead>
          <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Username</th>
            <th>Password</th>
            <th>Phone Number</th>
            <th>Client Status</th>
            <th>Flat Number</th>
            <th>Road Number</th>
            <th>Area</th>
            <th>Remarks</th>
            <th>Connected Component</th>
          </tr>
        </thead>
        <tbody>
          {clients?.map((clientInfo) => (
            <ClientInfo key={clientInfo.id} clientInfo={clientInfo} />
          ))}
        </tbody>
      </Table>
    </Container>
  );
};

export default ClientsDetail;
