<?php

namespace App\Models\map;

use App\Models\map\Device;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cluster extends Model
{
    use HasFactory;

    protected $table = "cluster_map";

    protected $fillable = [
        "parent_id",
        "parent_type",
        "parent_cluster",
        "name",
        "coordinates",
        "remarks",
        "box"
    ];

    protected $morphClass = 'cluster';

    protected $casts = [
        "coordinates" => "array",
    ];

    public function devices()
    {
        return $this->hasMany(Device::class, "cluster_id");
    }

    public function splitters()
    {
        return $this->hasMany(Splitter::class, "cluster_id");
    }

    public function onus()
    {
        return $this->hasMany(Onu::class, "cluster_id");
    }

    public function upStream()
    {
        return $this->hasMany(Cable::class, "endNodeId")->where("endNodeType", "cluster");
    }
    public function downStream()
    {
        return $this->hasMany(Cable::class, "startNodeId")->where("startNodeType", "cluster");
    }
}
