<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateOltOnuInformationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('olt_onu_information', function (Blueprint $table) {
            $table->integer('laser')->change();
            $table->string('username', 255)->nullable()->after('laser');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('olt_onu_information', function (Blueprint $table) {
            // Revert 'laser' column to its previous state (string, assuming it was originally)
            $table->string('laser', 255)->change();

            // Drop the 'username' column
            $table->dropColumn('username');
        });
    }
}
