@extends('layout.app')


@section('content')


    <div class="card card-default">
        <div class="card-body">


            <form action="{{ route('settings.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="col-sm-6">
                    <div class="form-group">
                        <label for="name" class="block text-sm font-medium text-gray-700">
                            Company Name*
                        </label>
                        <input type="text" name="company_name" id="company_name" value="{{ old('company_name') }}" class="form-control"
                            placeholder="Company Name" autocomplete="off">
                        @error('company_name')<div class="alert alert-danger">{{ $message }}</div>@enderror
                    </div>

                    <div class="form-group">
                        <label for="Logo" class="block text-sm font-medium text-gray-700">
                            Company Logo*
                        </label>
                        <input class="filestyle form-control" type="file"
                        name="logo">
                        @error('reseller_type')<div class="alert alert-danger">{{ $message }}</div>@enderror
                    </div>

                    <div class="form-group">
                        <label for="Email" class="block text-sm font-medium text-gray-700">
                            Email
                        </label>

                        <input type="email" name="company_email" id="company_email" class="form-control" placeholder="Company Email"
                            value="{{ old('company_email') }}" autocomplete="off">

                        @error('company_email')<div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="contact" class="block text-sm font-medium text-gray-700">
                            Contact
                        </label>

                        <input type="text" name="company_contact" id="company_contact" class="form-control" placeholder="Contact"
                            value="{{ old('company_contact') }}" autocomplete="off">
                        @error('company_contact')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="Address" class="block text-sm font-medium text-gray-700">
                            Address
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <textarea  name="company_location" id="company_location" class="form-control" 
                                value="{{ old('company_location') }}" autocomplete="off">Enter address here....</textarea>
                        </div>
                        @error('company_location')
                            <div class="alert alert-dangers">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                   
                </div>

               
                <div class="col-sm-12">

                    
                    <div class="form-group float-right">
                        <a href="{{route('settings.index')}}"
                            class="btn btn-primary">Edit</a>
                        <button class="btn btn-primary" type="submit"><i class="fa fa-save"></i> Save</button>
                        <button class="btn btn-info" type="reset" id="reset">Reset</button>
                    </div>
                    
                </div>


            </form>


        </div>


    </div>






@endsection
