<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Token extends Model
{
    use HasFactory;
    protected $guarded = ['id'];


    public function Code()
    {
        return $this->belongsTo(TokenCode::class,'tokenCode','id');
    }

    public function category()
    {
        return $this->belongsTo(TokenCat::class,'tokenCategory','id');
    }

    public function clients()
    {
        return $this->belongsTo(Client::class, 'clientId', 'id');
    }
    public function employees()
    {
        return $this->belongsTo(Employee::class, 'assignToken', 'id');
    }
    public function creator()
    {
        return $this->belongsTo(User::class, 'createdBy', 'id');
    }
    public function closer()
    {
        return $this->belongsTo(User::class, 'closeUserId', 'id');
    }

    static function list()
    {
        $list = Token::with('category', 'Code', 'clients', 'creator', 'employees', 'clients.clientsinfo', 'clients.pops', 'clients.pops.reseller');

        return $list;
    }

    public function notes()
    {
        return $this->hasMany(TokenNote::class, 'token_id', 'id');
    }

}
