@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            
            <div class="float-right my-2">
                <a href="{{ route('sms-gateway.create') }}" class="btn btn-primary pull-right">Add SMS Gateway</a>
            </div>
            <div class="table-responsive">
                <table id="dataTable" class="display table table-sm">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col">
                                Name
                            </th>
                            <th scope="col">
                                API Key
                            </th>
                            <th scope="col">
                                Sender
                            </th>
                            <th scope="col">
                                Url
                            </th>
                            <th scope="col">
                                Balance Url
                            </th>
                            <th scope="col">
                                Status
                            </th>

                            <th scope="col">
                                Action
                            </th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($gateway as $item)
                            <tr>
                                <td>
                                    {{ $item->username }}
                                </td>
                                <td>
                                    {{ $item->apikey }}
                                </td>
                                <td>
                                    {{ $item->sender }}
                                </td>
                                <td>
                                    {{ $item->url }}
                                </td>
                                <td>
                                    {{ $item->balance_url }}
                                </td>
                                <td>
                                    {{ $item->status }}
                                </td>

                                <td>
                                    <a href="{{ route('sms-gateway.edit', $item->id) }}"
                                        class="btn btn-primary pull-right">Edit</a>
                                </td>
                            </tr>
                        @endforeach

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer">
            {{ $gateway->links() }}

        </div>
    </div>
@endsection
