<button class="btn btn-primary mb-2" onclick="export2csv()">Download csv</button>
<button class="btn btn-danger mb-2" onclick="export2pdf()">Download PDF</button>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://unpkg.com/jspdf-autotable@3.6.0/dist/jspdf.plugin.autotable.js"></script>
<div class="col-md-12">
    <div class=" float-right d-flex amount-container" style="text-align:center; gap:3px !important; ">
        <p class="p-1 " style="border:2px solid #fed7aa; ">Total Row <?php echo e($list->count() ?? 0); ?> </p>
        <p class="p-1 " style="border:2px solid #fed7aa; ">Total Amount <?php echo e($list->sum('paid_amount')); ?> TK</p>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('company_commission')): ?>

            <p class="p-1 " style="border:2px solid #fed7aa; ">Total Company Miscellaneous Expense <?php echo e($list->sum('paid_amount') - $list->sum('sub_manager_commission') - $list->sum('manager_commission')); ?> TK</p>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manager_commission')): ?>
            <p class="p-1 " style="border:2px solid #fed7aa; ">Total Manager Miscellaneous Expense <?php echo e($list->sum('manager_commission')); ?> TK</p>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sub_manager_commission')): ?>
            <p class="p-1 " style="border:2px solid #fed7aa; ">Total Sub Manager Miscellaneous Expense  <?php echo e($list->sum('sub_manager_commission')); ?> TK</p>
        <?php endif; ?>

        <p class="p-1 " style="border:2px solid #fed7aa; ">Total Discount: <?php echo e($list->sum('discount_amount')); ?></p>
    </div>
</div>
<div id="paymenthistory" class="mt-10">
    <div class="table-responsive">
        <table class="table table-bordered " id="tableDownload">
            <tr>
                <th>#id</th>
                <th>Date</th>
                <th>Type</th>
                <th>C Name</th>
                <th>username</th>
                <?php if(getBillingType() == 'day_to_day'): ?>
                    <th>Expire Date</th>
                <?php endif; ?>
                <th>Reseller</th>
                <th>POP</th>
                <th>Area</th>
                <th>MR ID</th>
                <th>Entry BY</th>
                <th>Col By</th>
                <th>Package</th>
                <th style="max-width: 150px">Description</th>
                <th>Amount</th>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('company_commission')): ?>

                    <th>Company Miscellaneous Expense</th>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manager_commission')): ?>

                    <th>Manager Miscellaneous Expense</th>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sub_manager_commission')): ?>

                    <th>Sub Manager Miscellaneous Expense</th>
                <?php endif; ?>


                <?php if($hideColumn == false): ?>
                    <th>Discount</th>
                    
                <?php elseif($hideColumn == true): ?>
                <?php endif; ?>
            </tr>

            <?php ($totalDue = 0 ); ?>
            <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($p->id); ?></td>
                        <td class="text-center"><?php echo e(date('d-M-Y h:i:s A', strtotime($p->created_at))); ?></td>
                        <td><?php echo e($p->income->head->name ?? ''); ?></td>
                        <td><?php echo e($p->clientsinfo->clients_name ?? ''); ?></td>
                        <td><?php echo e($p->clients->userid ?? ''); ?></td>
                        <?php if(getBillingType() == 'day_to_day'): ?>  <td> <?php echo e($p->clients->expire_date); ?></td> <?php endif; ?>
                        <td><?php echo e($p->clients->pop->reseller->name ?? ''); ?></td>
                        <td><?php echo e($p->clients->pop->popname ?? ''); ?></td>
                        <td><?php echo e($p->clients->clientsinfo->area ?? ''); ?></td>
                        <td><?php echo e($p->money_receipt_number); ?></td>
                        <td><?php echo e($p->user->name ?? ''); ?></td>
                        <td class="text-center"><?php echo e($p->employee->name ?? ''); ?></td>
                        <td> <?php echo e($p->clients->packages->package_name ?? ''); ?></td>
                        <td style="max-width: 150px"><?php echo e($p->description ?? ""); ?></td>
                        <td class="text-right"> <?php echo e($p->paid_amount); ?></td>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('company_commission')): ?>

                            <td class="text-right"> <?php echo e($p->paid_amount - $p->sub_manager_commission - $p->manager_commission); ?></td>

                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manager_commission')): ?>

                            <td class="text-right"> <?php echo e($p->manager_commission); ?></td>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sub_manager_commission')): ?>
                            <td class="text-right"> <?php echo e($p->sub_manager_commission); ?></td>
                        <?php endif; ?>



                        <?php if($hideColumn == false): ?>
                            <td class="text-right"> <?php echo e($p->discount_amount); ?></td>
                            
                        <?php elseif($hideColumn == true): ?>
                        <?php endif; ?>
                    </tr>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <tr class="hidden">
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <?php if(getBillingType() == 'day_to_day'): ?>  <td> </td> <?php endif; ?>
                <td></td>
                <td class="text-right"><b>Total:</b> </td>
                <td class="text-right"><b><?php echo e($list->sum('paid_amount')); ?> TK</b></td>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('company_commission')): ?>
                    <td class="text-right"><b><?php echo e($list->sum('paid_amount') - $list->sum('sub_manager_commission') - $list->sum('manager_commission')); ?> TK</b></td>

                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manager_commission')): ?>
                    <td class="text-right"><b><?php echo e($list->sum('manager_commission')); ?> TK</b></td>

                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sub_manager_commission')): ?>
                    <td class="text-right"><b><?php echo e($list->sum('sub_manager_commission')); ?> TK</b></td>
                <?php endif; ?>
                <?php if($hideColumn == false): ?>
                    <td class="text-right"><b><?php echo e($list->sum('discount_amount')); ?> TK</b></td>
                <?php elseif($hideColumn == true): ?>
                <?php endif; ?>
            </tr>
        </table>
    </div>
</div>

<script>

    function export2csv() {
      let data = "";
      const tableData = [];
      const rows = document.querySelectorAll("table#tableDownload tr");
      for (const row of rows) {
        const rowData = [];
        for (const [index, column] of row.querySelectorAll("th, td").entries()) {
          // To retain the commas in the "Description" column, we can enclose those fields in quotation marks.
          if ((index + 1) % 3 === 0) {
            rowData.push('"' + column.innerText + '"');
          } else {
            rowData.push(column.innerText);
          }
        }
        tableData.push(rowData.join(","));
      }
      data += tableData.join("\n");
      const a = document.createElement("a");
      a.href = URL.createObjectURL(new Blob([data], { type: "text/csv" }));
      a.setAttribute("download", "data.csv");
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
    }


    function export2pdf() {
        const { jsPDF } = window.jspdf;
        const doc = new jsPDF({
            orientation: 'landscape' // Optional: use landscape orientation
        });


        doc.text("Payment History", 14, 10);
        doc.autoTable({
            html: "#tableDownload",
            startY: 20,
            theme: "grid",
            headStyles: { fillColor: [22, 160, 133] },
            didParseCell: function(data) {
                if (data.column.index === 13) {
                    data.cell.styles.cellWidth = 'auto';
                }
            },
            styles: { fontSize: 7 },
            tableWidth: 'auto'
        });

        doc.save("data.pdf");
    }

    </script>

<style>
    .amount-container{
        flex-direction: column;
    }
    @media (min-width:640px){
        .amount-container{
            flex-direction: row;
        }
    }
</style>
<?php /**PATH /var/www/html/southbangla/radius-circle/resources/views/paymenthistory/result.blade.php ENDPATH**/ ?>