<?php

namespace App\Console\Commands;

use App\Http\Controllers\FixCommonIssueController;
use App\Http\Controllers\OnlinePaymentGetwayTokenController;
use App\Services\ExpireDateRoundService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class CommonCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fix:common';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'This command is for common fix';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Log::error(session()->get('reseller_id'));
        // (new FixCommonIssueController)->deletePreviousMonthBIllForDeActiveCustomer();


        (new FixCommonIssueController)->fixedThanIssue();
        (new FixCommonIssueController)->fixedDuplicateMoneyReceiptNumber();
        (new FixCommonIssueController)->addNewSmsToResellerSmsSetting();
        (new FixCommonIssueController)->addAllManagerAndPopAccount();
        (new FixCommonIssueController)->updateWelcomeAndBillpaySms();
        (new FixCommonIssueController)->addNewRoleForResellerBilling();
        if(!checkAPI() && globalPermission("RadiusExpiration")){

            (new FixCommonIssueController)->syncAllClientRadiusExpiration();
        }
        (new OnlinePaymentGetwayTokenController())->storeToken();

    }
}
