<?php

namespace App\Http\Controllers;

use App\Models\Reseller;
use App\Models\ResellerSmsLog;
use Carbon\Carbon;
use Illuminate\Http\Request;

class ResellerSmsLogController extends Controller
{
    public function resellersSmsLog()
    {
        $resellers = Reseller::list();
        $resellers_id = $resellers->pluck('id')->toArray();
        $types = ResellerSmsLog::groupBy('type')->pluck('type');


        $logs = ResellerSmsLog::with('reseller')->whereIn('reseller_id',$resellers_id)->orderBy('id', 'desc')->paginate(100);

        $data = [
            'resellers' => $resellers,
            'logs' => $logs,
            'types' => $types,
        ];

        return view('sms.resellerSmsLog', $data);
    }

    public function resellerSmsLogSearch(Request $request){


        if($request->reseller == "all"){
            $resellers = Reseller::list();
            $resellers_id = $resellers->pluck('id')->toArray();
            $logs = ResellerSmsLog::with('reseller')->whereIn('reseller_id', $resellers_id);
        }else{
            $logs = ResellerSmsLog::with('reseller')->where('reseller_id', $request->reseller);
        }

        if($request->from_date && $request->to_date){
            $start_date = Carbon::parse($request->from_date)->format('Y-m-d 00:00:00');
            $end_date = Carbon::parse($request->to_date)->format('Y-m-d 23:59:59');
            $logs = $logs->whereBetween('created_at', [$start_date, $end_date]);
        }


        if($request->type == "all"){
            $logs = $logs->orderBy('id', 'desc')->paginate(100);
        }else{
            $logs = $logs->where('type', $request->type)->orderBy('id', 'desc')->paginate(100);
        }

        $data = [
            'logs' => $logs,
        ];

        return view('sms.searchResellerSmsLog', $data);
    }
}
