<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddApproveStatusInItemReturn extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('crm_item_returns', function (Blueprint $table) {
            $table->enum('approve_status',['Approve','Not Approve'])->default('Not Approve');
            $table->foreignId('approve_by')->nullable();
            $table->dateTime('approve_time')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('crm_item_returns', function (Blueprint $table) {
            $table->dropColumn('approve_status');
            $table->dropColumn('approve_by');
            $table->dropColumn('approve_time');
        });
    }
}
