@extends('layout.app')

@section('content')
    <div class="row">
        <div id="" class="table-responsive" style="">

            <div class="card">
                <div class="card-body">
                    <h4>Total Deleted: {{ $list->count() }}</h4>
                    <table id="dataTable" class="table table-bordered">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col">Client Id </th>
                                <th scope="col">Customers Username </th>
                                <th scope="col">Deleted By </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach ($list as $r)
                                <tr>
                                    <td>
                                        {{ $r->customer_id }}
                                    </td>
                                    <td>
                                        {{ $r->username }}
                                    </td>
                                    <td>
                                        {{ $r->admin->name ?? '' }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>


        </div>
    </div>

    <style>
        div#processing {
            display: none;
        }

        div#processing div {
            background: rgba(0, 0, 0, .5);
            position: fixed;
            width: 100vw;
            height: 100vh;
            color: #fff;
            text-align: center;
            vertical-align: middle;
            display: flex;
            justify-content: center;
            align-items: center;
        }

    </style>
@endsection
