<script>
    $(document).ready(function() {

        function save_sms_template(sms_body_string, sms_type) {

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: sms_body_string,
                    sms_type: sms_type
                },
                success: function(data) {
                    console.log(data);
                    if (data == 1) {
                        toastr.success('SMS Template Update Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            })


        }

        $('#welcome_submit').click(function() {
            let sms_body = $('#smsbodywelcome').val();
            let sendSms = $("input[name='welcome_sms_send']:checked").val();

            let obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            let string = JSON.stringify(obj);
            save_sms_template(string, 'welcome');
        });

        $('#welcome_reset').click(function() {
            let sms_body ="প্রিয় {c_name}\nইউজার আইডি: {c_username}\nপাসওয়ার্ড: {c_password}\nআপনার আইডি সফলভাবে যুক্ত করা হয়েছে। ধন্যবাদ!\n{company_name}\n{company_cell}";
            let sendSms = "No";

            let obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;
            let string = JSON.stringify(obj);

            $('#smsbodywelcome').val(sms_body);
            $('#welcome_sms_send_no').prop('checked', true);
            save_sms_template(string, 'welcome');
        });

        $('#inactive_submit').click(function() {
            var sms_body = $('#smsbodyinactive').val();
            var min_inactive_amount = $('#inactive_minimum').val();
            if (min_inactive_amount) {
                min_inactive_amount = min_inactive_amount;
            } else {
                min_inactive_amount = 0;
            }
            var sendSms = $("input[name='auto_inactive_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.minimum = min_inactive_amount;
            obj.sendsms = sendSms;

            //convert object to json string
            var string = JSON.stringify(obj);

            //    console.log(string);
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'auto_inactive'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $('#inactive_reset').click(function() {
            var sms_body =
                "Dear {c_name}\nবিল পরিশোধ না করায় আপনার সংযোগটি বন্ধ হয়ে গেছে । {total_due} টাকা দ্রুত পরিশোধ করুন ।\n\n{company_name}\n{company_cell}";
            var min_inactive_amount = 50;
            var spantext = "When due amount larger than " + min_inactive_amount + "TK";

            var sendSms = "Yes";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.minimum = min_inactive_amount;
            obj.sendsms = sendSms;
            var string = JSON.stringify(obj);
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'auto_inactive'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                        $('#inactive_minimum').val(50);
                        $('#auto_inactive_span').text(spantext);
                        $('#smsbodyinactive').val(sms_body);
                        $('#auto_inactive_yes').prop('checked', true);
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $('#inactive_minimum').keyup(function() {

            var inactive_minimum = $('#inactive_minimum').val();
            var spantext = "When due amount larger than " + inactive_minimum + "TK";
            $('#auto_inactive_span').text(spantext);

        });

        $('#due_bill_submit').click(function() {
            var sms_body = $('#due_bill_sms_body').val();
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: sms_body,
                    sms_type: 'due_bill'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $('#due_bill_reset').click(function() {
            var sms_body =
                "Dear {c_name}\nসংযোগ বিচ্ছিন্নকরন এড়াতে\n{c_deadline}-{this_month} তারিখের পূর্বে বিল পরিশোধ করুন ।\nমোট বিলঃ {total_due} টাকা\n\nধ্যনবাদ\n{company_name}\n{company_cell}";

            $('#due_bill_sms_body').val(sms_body);
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: sms_body,
                    sms_type: 'due_bill'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Reset Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            })
        });

        $('#bill_payment_submit').click(function() {
            let sms_body = $('#bill_payment_sms_body').val();
            let sendSms = $("input[name='bill_payment_sms_send']:checked").val();

            let obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;
            let string = JSON.stringify(obj);
            save_sms_template(string, 'bill_payment');
        });

        $('#bill_payment_reset').click(function() {
            let sms_body = "প্রিয় গ্রাহক ({c_name}),\nআপনার বিল সঠিক ভাবে সংগৃহিত হয়েছে। সংগৃহিত টাকার পরিমান- TK {PaymentAmount} | যেকোনো তথ্যের জন্য যোগাযোগ {company_cell} | {company_name} এর সাথে থাকার জন্য ধন্যবাদ।";
            let sendSms = "No";
            let obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;
            let string = JSON.stringify(obj);

            $('#bill_payment_sms_body').val(sms_body);
            $('#bill_payment_sms_send_no').prop('checked', true);
            save_sms_template(string, 'bill_payment');
        });

        $('#others_collection_submit').click(function() {
            var sms_body_for_client = $('#sms_body_client').val();
            var sms_body_for_extra_income = $('#sms_body_extra_income').val();


            var obj = new Object();
            obj.sms_body_for_client = sms_body_for_client;
            obj.sms_body_for_extra_income = sms_body_for_extra_income;



            var string = JSON.stringify(obj);
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'other_collection'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $("#others_collection_reset").click(function() {
            var sms_body_for_client =
                "Dear {c_name}\nWe received {PaymentAmount} TK for {BillType}\n\nThanks\n{company_name}\n{company_cell}";
            var sms_body_for_extra_income =
                "Dear {Name}\nWe received {PaymentAmount} TK for {BillType}\n\nThanks for your payment\n{company_name}\n{company_cell}";

            $('#sms_body_client').val(sms_body_for_client);
            $('#sms_body_extra_income').val(sms_body_for_extra_income);

            var obj = new Object();
            obj.sms_body_for_client = sms_body_for_client;
            obj.sms_body_for_extra_income = sms_body_for_extra_income;



            var string = JSON.stringify(obj);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'other_collection'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Reset Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            })
        });

        $('#support_collection_submit').click(function() {
            var support_sms_body_for_client = $('#support_sms_body_for_client').val();
            var support_sms_body_for_employee = $('#support_sms_body_for_employee').val();

            var obj = new Object();
            obj.sms_body_for_client = support_sms_body_for_client;
            obj.sms_body_for_employee = support_sms_body_for_employee;

            var string = JSON.stringify(obj);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'support'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $('#support_collection_reset').click(function() {
            var support_sms_body_for_client =
                "Dear {c_name}\nTicketNo: {token_no} (open)\nTo: {department_to}\nSubject: {support_subject}\nWe will konck will soon\n\nThanks\n{company_name}\n{company_cell}";
            var support_sms_body_for_employee =
                "Dear {employee_name}\nClient Name:{c_name},{c_number}\nAddress: {c_address}\n{support_subject} (#{token_no})\n{support_massage}";

            $('#support_sms_body_for_client').val(support_sms_body_for_client);
            $('#support_sms_body_for_employee').val(support_sms_body_for_employee);

            var obj = new Object();
            obj.sms_body_for_client = support_sms_body_for_client;
            obj.sms_body_for_employee = support_sms_body_for_employee;

            var string = JSON.stringify(obj);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'support'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Reset Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            })
        });

        $('#reseller_collection_submit').click(function() {
            var sms_body = $('#reseler_sms_body').val();

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: sms_body,
                    sms_type: 'reseller_payment'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $('#reseller_collection_reset').click(function() {
            var sms_body =
                "{ResellerName}\nজমা: {PaymentAmount} টাকা\nডিস্কাউন্ট: {PaymentDiscount} টাকা\nমোট টাকা: {ColsingBalance} টাকা\n\nThanks\n{company_name}\n{company_cell}";

            $('#reseler_sms_body').val(sms_body);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: sms_body,
                    sms_type: 'reseller_payment'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Reset Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            })
        });

        $('#bill_generate_submit').click(function() {
            var sms_body = $('#bill_generate_sms_body').val();

            var sendSms = $("input[name='bill_generate_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'bill_generate'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $('#bill_generate_reset').click(function() {
            var sms_body =
                "Dear {c_name}\nMonthly Bill: {MonthBillAmount} TK\n\nPlease Pay Before: 05 {ThisMonth}\n\n{company_name}\n{company_cell}";
            var sendSms = "Yes";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#bill_generate_sms_body').val(sms_body);
            $('#bill_generate_yes').prop('checked', true);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'bill_generate'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Reset Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            })
        });

        $('#reminder_submit').click(function() {
            var first_reminder_sms_body = $('#first_reminder_sms_body').val();
            var second_reminder_sms_body = $('#second_reminder_sms_body').val();
            var first_reminder_day = $('#first_reminder_day').val();
            var second_reminder_day = $('#first_reminder_day').val();

            if (first_reminder_day) {
                first_reminder_day = first_reminder_day;
            } else {
                first_reminder_day = 0;
            }
            if (second_reminder_day) {
                second_reminder_day = second_reminder_day;
            } else {
                second_reminder_day = 0;
            }

            var first_reminder_sendsms = $("input[name='first_reminder_sendsms']:checked").val();
            var second_reminder_sendsms = $("input[name='second_reminder_sendsms']:checked").val();

            var obj = new Object();
            obj.frist_sms_body = first_reminder_sms_body;
            obj.second_sms_body = second_reminder_sms_body;
            obj.frist_sendsms = first_reminder_sendsms;
            obj.second_sendsms = second_reminder_sendsms;
            obj.first_reminder_day = first_reminder_day;
            obj.second_reminder_day = second_reminder_day;

            var string = JSON.stringify(obj);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'bill_reminder'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $('#reminder_reset').click(function() {
            var first_reminder_sms_body =
                "Dear {c_name}\nLast 2nd day Remaning to Play your internet due bill {TotalDue}Tk\nPlease Pay Your Bill as soon as possible\nThanks\n\n{company_name}\n{company_cell}";
            var second_reminder_sms_body =
                "Dear {c_name}\nLast 1 day Remaning to Play your internet due bill {TotalDue}Tk\nPlease Pay Your Bill as soon as possible\nThanks\n\n{company_name}\n{company_cell}";
            var first_reminder_day = 2;
            var second_reminder_day = 1;

            var first_reminder_sendsms = "Yes";
            var second_reminder_sendsms = "Yes";

            $('#first_reminder_sms_body').val(first_reminder_sms_body);
            $('#second_reminder_sms_body').val(second_reminder_sms_body);
            $('#first_reminder_day').val(first_reminder_day);
            $('#first_reminder_day').val(second_reminder_day);

            $('#first_reminder_yes').prop('checked', true);
            $('#second_reminder_yes').prop('checked', true);

            var obj = new Object();
            obj.frist_sms_body = first_reminder_sms_body;
            obj.second_sms_body = second_reminder_sms_body;
            obj.frist_sendsms = first_reminder_sendsms;
            obj.second_sendsms = second_reminder_sendsms;
            obj.first_reminder_day = first_reminder_day;
            obj.second_reminder_day = second_reminder_day;

            var string = JSON.stringify(obj);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'bill_reminder'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        })

        $('#temporary_extend_reset').click(function() {
            var sms_body =
                "Dear {c_name}\nyour billing date extended to {new_billing_date} please pay in time \nThanks \n{company_name}\n{company_cell}";
            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#temporary_extend_sms_body').val(sms_body);
            $('#temporary_extend_sendsms_no').prop('checked', true);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'temporary_extended'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Reset Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            })
        });

        $('#temporary_extend_submit').click(function() {
            var sms_body = $('#temporary_extend_sms_body').val();

            var sendSms = $("input[name='temporary_extend_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'temporary_extended'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $('#expire_reset').click(function() {
            var sms_body =
                "Dear {c_name}\nyour line is exipred please pay your due \nThanks \n{company_name}\n{company_cell}";
            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#expire_sms_body').val(sms_body);
            $('#expire_sendsms_no').prop('checked', true);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'expired'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Reset Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            })
        });

        $('#expire_submit').click(function() {
            var sms_body = $('#expire_sms_body').val();

            var sendSms = $("input[name='expire_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'expired'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $('#token_create_reset').click(function() {
            var sms_body =
                "প্রিয় গ্রাহক {c_username}\nআপনার সমস্যাটি আমরা অবগত হয়েছি, আপনার টোকেন আইডি {token_id}\nযে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন |";
            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#token_create_sms_body').val(sms_body);
            $('#token_create_sendsms_no').prop('checked', true);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'token_create'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Reset Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            })
        });

        $('#token_create_submit').click(function() {
            var sms_body = $('#token_create_sms_body').val();

            var sendSms = $("input[name='token_create_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'token_create'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $('#expire_exception_reset').click(function() {
            var sms_body =
                "প্রিয় গ্রাহক {c_name} \nবিল পরিশোধ না করার জন্য সাময়িক সময়ের জন্য আপনার সংযোগ টি বিছিন্ন করা হোল। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";
            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#expire_exception_sms_body').val(sms_body);
            $('#expire_exception_sendsms_no').prop('checked', true);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'pop_expair_exception_delete'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Reset Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            })
        });

        $('#expire_exception_submit').click(function() {
            var sms_body = $('#expire_exception_sms_body').val();
            var sendSms = $("input[name='expire_exception_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'pop_expair_exception_delete'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $('#reseller_recharge_reset').click(function() {
            var sms_body =
                "প্রিয় গ্রাহক ({c_name}),\nআপনার {month} মাসের বিল সঠিক ভাবে সংগৃহিত হয়েছে। {company_name} এর সাথে থাকার জন্য ধন্যবাদ।  যেকোনো তথ্যের জন্য যোগাযোগ {company_cell} এই নাম্বারে|";
            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#reseller_recharge_sms_body').val(sms_body);
            $('#reseller_recharge_sendsms_no').prop('checked', true);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'reseller_customer_recharge'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Reset Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            })
        });

        $('#reseller_recharge_submit').click(function() {
            var sms_body = $('#reseller_recharge_sms_body').val();
            var sendSms = $("input[name='reseller_recharge_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $.ajax({
                type: "POST",
                url: "<?php echo e(route('sms-tempalte-save')); ?>",
                data: {
                    sms_body: string,
                    sms_type: 'reseller_customer_recharge'
                },
                success: function(data) {
                    if (data == 1) {
                        toastr.success('SMS Template Saved Successfully');
                    } else {
                        toastr.error('SMS Template Not Saved');
                    }
                }
            });
        });

        $('#disable_customer_submit').click(function() {
            var sms_body = $('#disable_customer_sms_body').val();
            var sendSms = $("input[name='disable_customer_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);
            save_sms_template(string, 'disable_customer_sms');
        });

        $('#disable_customer_reset').click(function() {

            var sms_body =
                "প্রিয় গ্রাহক ({c_name}),\nইন্টারনেট বিলের টাকা দেওয়ার সময়সীমা শেষ হওয়ার কারনে সংযোগটি সাময়িক ভাবে বিচ্ছিন্ন হলো। অতিসত্বর বিল পরিশোধ করুন। হেল্পলাইন {company_cell}";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#disable_customer_sms_body').val(sms_body);
            $('#disable_customer_sendsms_no').prop('checked', true);
            save_sms_template(string, 'disable_customer_sms');
        });

        $('#different_message_of_otc_submit').click(function() {

            let sms_body = $('#different_message_of_otc_sms_body').val();
            let sendSms = $("input[name='different_message_of_otc']:checked").val();

            let obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;



            let string = JSON.stringify(obj);

            save_sms_template(string, 'otc_payment_sms');

        });

        $('#different_message_of_otc_reset').click(function() {

            var sms_body =
                "প্রিয় গ্রাহক ({c_name}),\n {PaymentAmount} টাকা সংগৃহিত হয়েছে OTC পেমেন্ট এর জন্য। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#different_message_of_otc_sms_body').val(sms_body);
            $('#different_message_of_otc_sendsms_no').prop('checked', true);
            save_sms_template(string, 'otc_payment_sms');
        });

        $('#different_message_of_billing_cycle_change_submit').click(function() {
            var sms_body = $('#different_message_of_billing_cycle_change_sms_body').val();
            var sendSms = $("input[name='different_message_of_billing_cycle_change_sendsms']:checked")
                .val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);
            save_sms_template(string, 'billing_cycle_change_payment_sms');
        });

        $('#different_message_of_billing_cycle_change_reset').click(function() {

            var sms_body =
                "প্রিয় গ্রাহক ({c_name}),\n {PaymentAmount} টাকা সংগৃহিত হয়েছে বিলিং সাইকেল চেঞ্জ পেমেন্ট এর জন্য। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#different_message_of_billing_cycle_change_sms_body').val(sms_body);
            $('#different_message_of_billing_cycle_change_sendsms_no').prop('checked', true);
            save_sms_template(string, 'billing_cycle_change_payment_sms');
        });

        $('#different_message_of_package_change_submit').click(function() {
            var sms_body = $('#different_message_of_package_change_sms_body').val();
            var sendSms = $("input[name='different_message_of_package_change_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);
            save_sms_template(string, 'package_change_payment_sms');
        });

        $('#different_message_of_package_change_reset').click(function() {

            var sms_body =
                "প্রিয় গ্রাহক ({c_name}),\n {PaymentAmount} টাকা সংগৃহিত হয়েছে পেকেজ চেঞ্জ এর জন্য। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#different_message_of_package_change_sms_body').val(sms_body);
            $('#different_message_of_package_change_sendsms_no').prop('checked', true);
            save_sms_template(string, 'package_change_payment_sms');
        });

        $('#new_customer_payment_submit').click(function() {
            var sms_body = $('#new_customer_payment_sms_body').val();
            var sendSms = $("input[name='new_customer_payment_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);
            save_sms_template(string, 'new_customer_payment_sms');
        });

        $('#new_customer_payment_reset').click(function() {

            var sms_body =
                "প্রিয় গ্রাহক ({c_name}),\n {PaymentAmount} টাকা সংগৃহিত হয়েছে নতুন কাস্টমার পেমেন্ট এর জন্য। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#new_customer_payment_sms_body').val(sms_body);
            $('#new_customer_payment_sendsms_no').prop('checked', true);
            save_sms_template(string, 'new_customer_payment_sms');
        });

        $('#advanced_payment_submit').click(function() {
            var sms_body = $('#advanced_payment_sms_body').val();
            var sendSms = $("input[name='advanced_payment_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);
            save_sms_template(string, 'advanced_payment_sms');
        });

        $('#advanced_payment_reset').click(function() {

            var sms_body =
                "প্রিয় গ্রাহক ({c_name}),\n {PaymentAmount} টাকা সংগৃহিত হয়েছে অগ্রিম পেমেন্ট এর জন্য। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#advanced_payment_sms_body').val(sms_body);
            $('#advanced_payment_sendsms_no').prop('checked', true);
            save_sms_template(string, 'advanced_payment_sms');
        });

        $('#token_on_create_customer_submit').click(function() {
            var sms_body = $('#token_on_create_customer_body').val();
            var sendSms = $("input[name='token_on_create_customer_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);
            save_sms_template(string, 'token_create_customer_sms');
        });

        $('#token_on_create_customer_reset').click(function() {

            var sms_body =
                "প্রিয় গ্রাহক, আপনার সমস্যাটি আমরা অবগত হয়েছি। আপনার টোকেন আইডি {token_no}| যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#token_on_create_customer_body').val(sms_body);
            $('#token_on_create_customer_sendsms_no').prop('checked', true);
            save_sms_template(string, 'token_create_customer_sms');
        });

        $('#token_assign_employee_submit').click(function() {
            var sms_body = $('#token_assign_employee_sms_body').val();
            var sendSms = $("input[name='token_assign_employee_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);
            save_sms_template(string, 'token_assign_employee_sms');
        });

        $('#token_assign_employee_reset').click(function() {

            var sms_body =
                "Token {token_no} ({token_code}) Contact: {reporter_contact_no} Solve Quickly";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#token_assign_employee_sms_body').val(sms_body);
            $('#token_assign_employee_sendsms_no').prop('checked', true);
            save_sms_template(string, 'token_assign_employee_sms');
        });

        $('#token_assign_customer_submit').click(function() {
            var sms_body = $('#token_assign_customer_sms_body').val();
            var sendSms = $("input[name='token_assign_customer_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);
            save_sms_template(string, 'token_assign_customer_sms');
        });

        $('#token_assign_customer_reset').click(function() {

            var sms_body =
                "প্রিয় গ্রাহক, আপনার সমস্যাটি আমরা অবগত হয়েছি। আপনার টোকেন আইডি {token_no}| আপনার সমস্যাটি {employee_name} ({employee_number})সমাধান করবে। যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#token_assign_customer_sms_body').val(sms_body);
            $('#token_assign_customer_sendsms_no').prop('checked', true);
            save_sms_template(string, 'token_assign_customer_sms');
        });

        $('#token_close_customer_submit').click(function() {
            var sms_body = $('#token_close_customer_sms_body').val();
            var sendSms = $("input[name='token_close_customer_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);
            save_sms_template(string, 'token_close_customer_sms');
        });

        $('#token_close_customer_reset').click(function() {

            var sms_body =
                "আপনার সমস্যাটি সমাধান হয়েছে। আমরা আপনার টোকেন আইডি {token_no} : {token_code} মুছে ফেলেছি। যদি এখনো সমস্যার সমাধান না হয় তাহলে {company_cell} এই নম্বর এ অভিযোগ করুন।আমাদের সাথে থাকার জন্য ধন্যবাদ।";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#token_close_customer_sms_body').val(sms_body);
            $('#token_close_customer_sendsms_no').prop('checked', true);
            save_sms_template(string, 'token_close_customer_sms');
        });

        $('#token_note_customer_sms_submit').click(function() {
            var sms_body = $('#token_note_customer_sms_body').val();
            var sendSms = $("input[name='token_note_customer_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);
            save_sms_template(string, 'token_note_customer_sms');
        });

        $('#token_note_customer_sms_reset').click(function() {

            var sms_body = "{note}| যে কোন প্রশ্নের জন্য {company_cell} নম্বরে যোগাযোগ করুন|";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#token_note_customer_sms_body').val(sms_body);
            $('#token_note_customer_sendsms_no').prop('checked', true);
            save_sms_template(string, 'token_note_customer_sms');
        });
        $('#token_re_assign_employee_sms_submit').click(function() {
            var sms_body = $('#token_re_assign_employee_sms_body').val();
            var sendSms = $("input[name='token_re_assign_employee_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);
            save_sms_template(string, 'token_reassign_employee_sms');
        });

        $('#token_re_assign_employee_sms_reset').click(function() {

            var sms_body =
                "Token {token_no} ({token_code}) Contact: {reporter_contact_no} Solve Quickly";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#token_re_assign_employee_sms_body').val(sms_body);
            $('#token_re_assign_employee_sendsms_no').prop('checked', true);
            save_sms_template(string, 'token_reassign_employee_sms');
        });

        $('#reseller_recharge_admin_submit').click(function() {
            var sms_body = $('#reseller_recharge_admin_sms_body').val();
            var sendSms = $("input[name='reseller_recharge_admin_sendsms']:checked").val();

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);
            save_sms_template(string, 'reseller_balance_recharge_sms');
        });

        $('#reseller_recharge_admin_reset').click(function() {

            var sms_body =
                "Dear {reseller_name}\nYour Balance Recharge {recharge_amount}Tk\nYour Current Balance {current_balance}Tk\n\n\nThanks\n{company_name}\n{company_cell}";

            var sendSms = "No";

            var obj = new Object();
            obj.sms_body = sms_body;
            obj.sendsms = sendSms;

            var string = JSON.stringify(obj);

            $('#reseller_recharge_admin_sms_body').val(sms_body);
            $('#reseller_recharge_admin_sendsms_no').prop('checked', true);
            save_sms_template(string, 'reseller_balance_recharge_sms');
        });

    });
</script>
<?php /**PATH /var/www/html/spacewalker/radius-circle/resources/views/smsSetting/JsFile/smsSetting.blade.php ENDPATH**/ ?>