<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <div class="row justify-content-center align-items-center">

                <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12">
                    <div class="form-group">
                        <label for="shortname" class="block text-lg font-medium  text-space">
                            Mikrotik Name <span style="color: #f59e0b;font-size:22px !important;">*</span>
                        </label>
                        <select class="form-control custom-select-lg text-space" name="mikrotik" id="mikrotik">
                            <option value="">Select mikrotik</option>
                            <?php $__empty_1 = true; $__currentLoopData = $mikrotiks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mikrotik): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <option value="<?php echo e($mikrotik->id); ?>" class="border "
                                    style="background-color: rgb(229 231 235 / 0.2);">
                                    <?php echo e($mikrotik->shortname); ?>

                                    <?php echo e($mikrotik->nasname); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>
                        </select>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <button class="btn  float-right ml-4" id="delete_all_id" style="background: #ef4444; color:#FFFFFF;">Delete
                    All</button>
                <button type="submit" class="btn btn-warning text-light float-right" id="sync">Sync</button>
            </div>

            <div class="table-responsive pt-2 " id="result">
                <table id="dataTable" class="display table table-bordered table-striped" style="width: 100% !important">
                    <thead style="background:#78716c;color:#FFFFFF;">
                        <tr class="text-center">
                            <th scope="col">#</th>
                            <th scope="col">Mikrotik Info</th>
                            <th scope="col">Package Name</th>
                            <th scope="col">Profile Name</th>
                            <th scope="col">Package Rate</th>
                            <th scope="col">Bandwidth Show in BTRC Report</th>
                            <th scope="col">Price Show in BTRC Report</th>
                            <th scope="col" style="width: 200px"> Action </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr id="row<?php echo e($item->id); ?>" class="text-center">
                                <td><?php echo e($item->id); ?></td>
                                <td class="comment"><?php echo e($item->mk_info ?? ''); ?></td>
                                <td>
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="package_name" id="package_name"
                                            value="<?php echo e($item->profile_name); ?>">
                                    </div>
                                </td>
                                <td class="mikrotik_current_profile">
                                    <?php echo e($item->profile_name); ?>

                                    <div class="form-group" style="display: none;">
                                        <input type="text" class="form-control" name="profile_name" id="profile_name"
                                            value="<?php echo e($item->profile_name); ?>">
                                    </div>
                                </td>
                                <td>
                                    <input type="number" class="form-control" name="package_rate" id="package_rate"
                                        value="0" min="0" step="0.01">
                                </td>
                                <td>
                                    <input type="number" class="form-control" name="package_bandwidth"
                                        id="package_bandwidth" value="0" min="0" step="0.01">
                                </td>
                                <td>
                                    <input type="number" class="form-control" name="btrc_package_price"
                                        id="btrc_package_price" value="0" min="0" step="0.01">
                                </td>
                                <td>
                                    <a href="#" class="btn-sm  pull-right savebtn"
                                        style="background:#0d9488; color:#FFFFFF;">Save</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('ajax'); ?>
    <script>
        $(document).ready(function() {

            $('#sync').click(function() {

                var mikrotik = $('#mikrotik').val();
                var mikrotik_connect_type = $('#connect_type').val();
                $("#sync").attr("disabled", true);
                $('body').prepend('<div id="loading">Loading.....</div>');

                if (mikrotik) {
                    $.ajax({
                        url: "<?php echo e(route('mikrotiks-sync-profile')); ?>",
                        type: "get",
                        data: {
                            mikrotik: mikrotik,
                            mikrotik_connect_type: mikrotik_connect_type
                        },
                        success: function(data) {
                            $('#loading').remove();
                            toastr.success("Profile Sync successfull");
                            $("#sync").attr("disabled", false);
                            $('#result').html(data);
                            location.reload();
                        },
                        error: function(request, error) {
                            toastr.error(request.responseText);
                            $('#loading').remove();
                        }
                    });
                } else {
                    toastr.error("Please select mikrotik");
                }
            });

            $(document).on('click', '#delete_all_id', function(e) {
                let confirmation = window.confirm("Are you sure to delete?");
                if (!confirmation) {
                    return false;
                };

                e.preventDefault();
                $('body').prepend('<div id="loading">Loading.....</div>');

                $.ajax({
                    url: "<?php echo e(route('deleteAllProfileFromSyncList')); ?>",
                    type: "post",

                    success: function(data) {
                        toastr.success("All Deleted from Sync successfull");
                        location.reload();
                        $('#loading').remove();
                    },
                    error: function(request, error) {
                        $('#loading').remove();
                        toastr.error(request.responseText);
                    }
                });
            });


            $(document).on("click", ".savebtn", function() {

                var package_name = $(this).parents("tr").find("#package_name").val();
                var profile_name = $(this).parents("tr").find("#profile_name").val();
                var package_rate = $(this).parents("tr").find("#package_rate").val();
                var package_bandwidth = $(this).parents("tr").find("#package_bandwidth").val();
                var btrc_package_price = $(this).parents("tr").find("#btrc_package_price").val();
                var thisvariable = $(this);

                if (package_name && profile_name && package_rate && package_bandwidth &&
                    btrc_package_price) {
                    $.ajax({
                        url: "<?php echo e(route('save-package-from-profil-sync')); ?>",
                        type: "post",
                        data: {
                            package_name: package_name,
                            profile_name: profile_name,
                            package_rate: package_rate,
                            package_bandwidth: package_bandwidth,
                            btrc_package_price: btrc_package_price,
                        },
                        success: function(data) {
                            toastr.success("প্যাকেজ সফলভাবে যোগ করা হয়েছে");
                            thisvariable.closest('tr').hide();
                        },
                        error: function(request, error) {
                            toastr.error(request.responseText);
                        }
                    });
                } else {
                    toastr.error("Please select all field");
                }
            });

        });
    </script>
<?php $__env->stopSection(); ?>


<style>
    .text-space {
        letter-spacing: 0.025em;
        line-height: 1.75rem;
        color: #78716c;
    }

    .dataTables_wrapper .dataTables_filter input:focus {
        outline-style: solid !important;
        outline-color: #fde047;
        outline-width: 2.5px;
    }

    #mikrotik {
        outline-style: solid !important;
        outline-color: #797359;
        outline-width: 0.75px;
    }

    .content-wrapper {
        background: inherit !important;
    }

    @media(max-width:1000px) {
        #delete-btn {
            line-height: 2.5 !important;
            background: blue !important;
        }
    }
</style>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/spacewalker/radius-circle/resources/views/mikrotik/profileSync.blade.php ENDPATH**/ ?>