
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `accounting_servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_servers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_enable` enum('1','0') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_servers` WRITE;
/*!40000 ALTER TABLE `accounting_servers` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_servers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `api_bandwidth_usages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `api_bandwidth_usages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mac_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `uploaded` decimal(20,2) NOT NULL DEFAULT '0.00',
  `downloaded` decimal(20,2) NOT NULL DEFAULT '0.00',
  `session_start_time` datetime NOT NULL,
  `session_end_time` datetime DEFAULT NULL,
  `last_disconnect_reason` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `api_bandwidth_usages` WRITE;
/*!40000 ALTER TABLE `api_bandwidth_usages` DISABLE KEYS */;
/*!40000 ALTER TABLE `api_bandwidth_usages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `areas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `areas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `areas_name_unique` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `areas` WRITE;
/*!40000 ALTER TABLE `areas` DISABLE KEYS */;
/*!40000 ALTER TABLE `areas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `balances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `balances` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('reseller','subreseller','pop') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_id` int NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `balances` WRITE;
/*!40000 ALTER TABLE `balances` DISABLE KEYS */;
INSERT INTO `balances` VALUES (1,'reseller',1,0.00,'2025-05-04 11:35:07','2025-05-04 11:35:07'),(2,'reseller',2,10000.00,'2025-05-04 11:35:39','2025-05-04 17:25:31'),(3,'pop',1,0.00,'2025-05-04 11:36:48','2025-05-04 11:36:48'),(4,'pop',2,0.00,'2025-05-04 11:37:32','2025-05-04 11:37:32'),(5,'reseller',3,0.00,'2025-05-04 16:01:55','2025-05-04 16:01:55'),(6,'pop',3,0.00,'2025-05-04 16:54:04','2025-05-04 16:54:04');
/*!40000 ALTER TABLE `balances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `band_buy_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `band_buy_payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_date` date NOT NULL,
  `received_by` bigint unsigned NOT NULL,
  `payment_method` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` double DEFAULT NULL,
  `discount` double DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `attachment` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `band_buy_payments` WRITE;
/*!40000 ALTER TABLE `band_buy_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `band_buy_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `band_providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `band_providers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_person` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `document` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `band_providers` WRITE;
/*!40000 ALTER TABLE `band_providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `band_providers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `band_purchase_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `band_purchase_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `bandPurchaseId` bigint unsigned DEFAULT NULL,
  `service_id` bigint unsigned DEFAULT NULL,
  `quantity` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `rate` double DEFAULT NULL,
  `vat` double DEFAULT NULL,
  `from_date` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `to_date` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line_total` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `band_purchase_items` WRITE;
/*!40000 ALTER TABLE `band_purchase_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `band_purchase_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `band_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `band_purchases` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `provider_id` bigint unsigned NOT NULL,
  `billing_date` date DEFAULT NULL,
  `status` enum('Active','Inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `total_price` decimal(10,2) DEFAULT NULL,
  `paid` decimal(10,2) DEFAULT NULL,
  `invoice_no` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `band_purchases` WRITE;
/*!40000 ALTER TABLE `band_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `band_purchases` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `band_sale_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `band_sale_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `sale_id` bigint unsigned DEFAULT NULL,
  `service_id` bigint unsigned DEFAULT NULL,
  `quantity` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `rate` double DEFAULT NULL,
  `vat` double DEFAULT NULL,
  `from_date` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `to_date` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('Active','Deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `line_total` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `band_sale_items` WRITE;
/*!40000 ALTER TABLE `band_sale_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `band_sale_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `band_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `band_sales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `invoice_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_date` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid` decimal(16,3) DEFAULT NULL,
  `discount` decimal(16,2) DEFAULT NULL,
  `total` decimal(16,2) DEFAULT NULL,
  `repeat_invoice` enum('Active','Deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `band_sales` WRITE;
/*!40000 ALTER TABLE `band_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `band_sales` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `band_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `band_services` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `band_services` WRITE;
/*!40000 ALTER TABLE `band_services` DISABLE KEYS */;
/*!40000 ALTER TABLE `band_services` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `band_stocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `band_stocks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `service_id` bigint unsigned NOT NULL,
  `quantity` decimal(16,3) DEFAULT NULL,
  `rate` decimal(16,2) DEFAULT NULL,
  `vat` decimal(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `band_stocks` WRITE;
/*!40000 ALTER TABLE `band_stocks` DISABLE KEYS */;
/*!40000 ALTER TABLE `band_stocks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bank_transfars`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bank_transfars` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int NOT NULL,
  `check_no` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `diposit_amount` int DEFAULT NULL,
  `withdraw_amount` int DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `by` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bank_transfars` WRITE;
/*!40000 ALTER TABLE `bank_transfars` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_transfars` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `banking_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `banking_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `banking_id` int NOT NULL,
  `user_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `banking_log` WRITE;
/*!40000 ALTER TABLE `banking_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `banking_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bankings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bankings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bank_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `branch_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` tinyint NOT NULL,
  `opening_balance` int NOT NULL,
  `action` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bankings` WRITE;
/*!40000 ALTER TABLE `bankings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bankings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bill_generates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bill_generates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bill_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `client_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `billing_type` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `due_date` datetime DEFAULT NULL,
  `due_amount` decimal(8,2) NOT NULL,
  `paid_amount` decimal(10,2) DEFAULT '0.00',
  `parmanent_discount` double(8,2) DEFAULT '0.00',
  `package_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `package_rate` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  `deleted_by` bigint unsigned DEFAULT NULL,
  `client_id_time` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `added_by` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bill_generates_client_id_time_unique` (`client_id_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bill_generates` WRITE;
/*!40000 ALTER TABLE `bill_generates` DISABLE KEYS */;
/*!40000 ALTER TABLE `bill_generates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bill_generates_archive`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bill_generates_archive` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `bill_generate_id` bigint unsigned NOT NULL,
  `client_id` bigint unsigned NOT NULL,
  `details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bill_generates_archive` WRITE;
/*!40000 ALTER TABLE `bill_generates_archive` DISABLE KEYS */;
/*!40000 ALTER TABLE `bill_generates_archive` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bill_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bill_payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `client_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `money_receipt_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `collected_by` bigint unsigned NOT NULL,
  `extend_month` int DEFAULT NULL,
  `reseller_balance_deduct` decimal(8,2) DEFAULT NULL,
  `pop_balance_deduct` decimal(8,2) DEFAULT NULL,
  `income_id` bigint unsigned DEFAULT NULL,
  `user_accountings_id` bigint unsigned DEFAULT NULL,
  `reseller_balance_log_report` bigint unsigned DEFAULT NULL,
  `sub_reseller_balance_log_report` bigint unsigned DEFAULT NULL,
  `expire_date_history` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customerMsisdn` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paymentCreateTime` datetime DEFAULT NULL,
  `trx_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_id_time` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_manager_commission` decimal(8,2) NOT NULL DEFAULT '0.00',
  `manager_commission` decimal(8,2) NOT NULL DEFAULT '0.00',
  `bill_ids` json DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bill_payments_client_id_time_unique` (`client_id_time`),
  UNIQUE KEY `bill_payments_money_receipt_number_unique` (`money_receipt_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bill_payments` WRITE;
/*!40000 ALTER TABLE `bill_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `bill_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bkash_payment_reseller_reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bkash_payment_reseller_reports` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `merchantInvoiceNumber` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `paymentID` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_id` int NOT NULL,
  `reseller_id` int NOT NULL,
  `pop_id` int NOT NULL,
  `amount` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transactionStatus` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bkash_payment_reseller_reports` WRITE;
/*!40000 ALTER TABLE `bkash_payment_reseller_reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `bkash_payment_reseller_reports` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bkash_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bkash_payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `statusCode` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paymentID` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payerReference` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customerMsisdn` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trxID` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transactionStatus` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `verificationStatus` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(16,2) DEFAULT NULL,
  `currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `intent` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `merchantInvoiceNumber` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paymentCreateTime` timestamp NULL DEFAULT NULL,
  `paymentExecuteTime` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `statusMessage` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bkash_payments` WRITE;
/*!40000 ALTER TABLE `bkash_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `bkash_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bkash_webhooks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bkash_webhooks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `trxid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bkash_webhooks` WRITE;
/*!40000 ALTER TABLE `bkash_webhooks` DISABLE KEYS */;
/*!40000 ALTER TABLE `bkash_webhooks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `manager_id` int NOT NULL,
  `pop_id` int NOT NULL,
  `box_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `boxes_box_name_unique` (`box_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `boxes` WRITE;
/*!40000 ALTER TABLE `boxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `boxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `branches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `branches` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bn_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` enum('Active','Inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `creator_user_id` bigint unsigned DEFAULT NULL,
  `updator_user_id` bigint unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `branches_creator_user_id_foreign` (`creator_user_id`),
  KEY `branches_updator_user_id_foreign` (`updator_user_id`),
  CONSTRAINT `branches_creator_user_id_foreign` FOREIGN KEY (`creator_user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `branches_updator_user_id_foreign` FOREIGN KEY (`updator_user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `branches` WRITE;
/*!40000 ALTER TABLE `branches` DISABLE KEYS */;
/*!40000 ALTER TABLE `branches` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bw_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bw_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_person` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_by` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` enum('active','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bw_customers_email_unique` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bw_customers` WRITE;
/*!40000 ALTER TABLE `bw_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `bw_customers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bwsales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `bwsales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `service_id` bigint unsigned NOT NULL,
  `bill_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_month` date NOT NULL,
  `payment_due_date` date NOT NULL,
  `quantity` decimal(8,2) NOT NULL,
  `rate` decimal(8,2) NOT NULL,
  `vat` decimal(8,2) DEFAULT NULL,
  `from_date` date NOT NULL,
  `to_date` date NOT NULL,
  `total_amount` decimal(8,2) NOT NULL,
  `status` enum('due','paid') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'due',
  `repeat_invoice` enum('active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bwsales` WRITE;
/*!40000 ALTER TABLE `bwsales` DISABLE KEYS */;
/*!40000 ALTER TABLE `bwsales` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `c_r_m_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `c_r_m_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `previous_crm_status` enum('Marketing','CRM','Support','Account','Fiber','Store') COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_crm_status` enum('Marketing','CRM','Support','Account','Fiber','Store') COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `crm_check_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `c_r_m_logs` WRITE;
/*!40000 ALTER TABLE `c_r_m_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_r_m_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cable_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cable_map` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `startNodeId` bigint unsigned DEFAULT NULL,
  `startNodeType` enum('cluster','tjBox') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `endNodeId` bigint unsigned DEFAULT NULL,
  `endNodeType` enum('cluster','tjBox') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `coordinates` json NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'cable',
  `cable_length` int NOT NULL,
  `cable_distance` int NOT NULL,
  `remarks` longtext COLLATE utf8mb4_unicode_ci,
  `fiber_count` int NOT NULL,
  `tube_count` int NOT NULL,
  `cable_type` enum('tight-buffered','loose-tube-buffered') COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cable_map` WRITE;
/*!40000 ALTER TABLE `cable_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `cable_map` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `check_expire`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `check_expire` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `check_expire` WRITE;
/*!40000 ALTER TABLE `check_expire` DISABLE KEYS */;
INSERT INTO `check_expire` VALUES (1,'[]',NULL,NULL),(2,'[]',NULL,NULL),(3,'[]',NULL,NULL),(4,'[]',NULL,NULL),(5,'[]',NULL,NULL),(6,'[]',NULL,NULL),(7,'[]',NULL,NULL),(8,'[]',NULL,NULL),(9,'[]',NULL,NULL),(10,'[]',NULL,NULL);
/*!40000 ALTER TABLE `check_expire` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_balance_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_balance_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_balance_logs` WRITE;
/*!40000 ALTER TABLE `client_balance_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_balance_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_edit_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_edit_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned DEFAULT NULL,
  `old_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `new_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `user_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_edit_logs` WRITE;
/*!40000 ALTER TABLE `client_edit_logs` DISABLE KEYS */;
INSERT INTO `client_edit_logs` VALUES (1,1,'{\"id\":1,\"pop_id\":2,\"billing_cycle\":15,\"package_id\":23,\"mac\":null,\"userid\":\"Si000\",\"password\":\"Si000\",\"ip_address\":null,\"expire_date\":\"2025-05-15 00:00:00\",\"required_cable\":\"0.00\",\"created_by\":4,\"client_approval\":\"pending\",\"created_at\":\"2025-05-04T16:27:32.000000Z\",\"updated_at\":\"2025-05-04T16:27:32.000000Z\",\"clients_status\":\"deactive\",\"crm_status\":\"Marketing\",\"marketed_by\":0,\"sub_package_id\":null,\"customer_id\":\"1\",\"deleted_at\":null,\"payment_dadeline\":0,\"payment_token\":null,\"app_key_type\":null,\"parmanent_discount\":\"0.00\",\"login_token\":null,\"ignoreMKCheck\":0,\"first_approval\":\"Pending\",\"first_approve_by\":null,\"closed_at\":null,\"bandwidth_limit\":null,\"up_bandwidth\":null,\"down_bandwidth\":null,\"apply_bandwidth_limit\":0,\"ethernet_port\":null,\"isStatic\":0,\"distribution_point\":\"pop\",\"connection_type\":\"shared\",\"box_id\":null,\"auto_deactive\":null,\"slug\":\"20250504222732037Xn4JZw\",\"customer_code\":null,\"customer_type\":\"Home\",\"crm_check_date\":null,\"is_free\":0,\"un_recharge_amount\":\"0.00\",\"client_payment_amount\":\"0.00\",\"billing_start_date\":null,\"experity_check\":\"Yes\",\"customer_account_balance_reseller\":\"0.00\",\"clientsinfo\":{\"id\":1,\"client_id\":1,\"clients_name\":\"Si000\",\"father_name\":null,\"mother_name\":null,\"flat_no\":null,\"building_name\":null,\"road_no\":\"\",\"block_sector\":\"\",\"area\":\"\",\"district\":\"8\",\"thana\":\"\",\"contact_no\":\"01861290540\",\"national_id\":null,\"email\":null,\"passport_no\":null,\"created_at\":\"2025-05-04T16:27:32.000000Z\",\"updated_at\":\"2025-05-04T16:27:32.000000Z\",\"owner_name\":null,\"owner_number\":null,\"olt_pon\":null,\"otc\":\"0.00\",\"building_no\":null,\"remarks\":null,\"dob\":\"05\\/04\\/2025\",\"cable_type\":null,\"road_name\":\"\",\"otc_due\":\"0.00\",\"profilePicture\":null,\"other_contact\":null,\"box\":null,\"joinDate\":\"2025-05-04 00:00:00\",\"client_latitude\":null,\"client_longitude\":null,\"picture\":null,\"client_door\":null,\"cat_type\":null,\"cat_length\":null,\"olt_no\":null,\"pon_port\":null,\"onu_serial\":null,\"customer_profile_picture\":null,\"from_cable\":null,\"to_cable\":null,\"customer_agrement\":null,\"cable_id\":null,\"customer_package_name\":null,\"btrc_package_bandwidth\":null,\"from_cable2\":null,\"to_cable2\":null,\"source_name\":null,\"connected_component_type\":null,\"connected_component_id\":null,\"type\":\"client\",\"division\":\"1\",\"map_box_id\":null,\"onu_router_info\":null,\"upazila\":0}}','{\"id\":1,\"pop_id\":2,\"billing_cycle\":15,\"package_id\":23,\"mac\":null,\"userid\":\"Si000\",\"password\":\"Si000\",\"ip_address\":null,\"expire_date\":\"2025-05-15 00:00:00\",\"required_cable\":\"0.00\",\"created_by\":4,\"client_approval\":\"pending\",\"created_at\":\"2025-05-04T16:27:32.000000Z\",\"updated_at\":\"2025-05-04T16:27:32.000000Z\",\"clients_status\":\"deactive\",\"crm_status\":\"Marketing\",\"marketed_by\":0,\"sub_package_id\":null,\"customer_id\":\"1\",\"deleted_at\":null,\"payment_dadeline\":0,\"payment_token\":null,\"app_key_type\":null,\"parmanent_discount\":\"0.00\",\"login_token\":null,\"ignoreMKCheck\":0,\"first_approval\":\"Approved\",\"first_approve_by\":null,\"closed_at\":null,\"bandwidth_limit\":null,\"up_bandwidth\":null,\"down_bandwidth\":null,\"apply_bandwidth_limit\":0,\"ethernet_port\":null,\"isStatic\":0,\"distribution_point\":\"pop\",\"connection_type\":\"shared\",\"box_id\":null,\"auto_deactive\":null,\"slug\":\"20250504222732037Xn4JZw\",\"customer_code\":null,\"customer_type\":\"Home\",\"crm_check_date\":null,\"is_free\":0,\"un_recharge_amount\":\"0.00\",\"client_payment_amount\":\"0.00\",\"billing_start_date\":null,\"experity_check\":\"Yes\",\"customer_account_balance_reseller\":\"0.00\",\"clientsinfo\":{\"id\":1,\"client_id\":1,\"clients_name\":\"Si000\",\"father_name\":null,\"mother_name\":null,\"flat_no\":null,\"building_name\":null,\"road_no\":\"\",\"block_sector\":\"\",\"area\":\"\",\"district\":\"8\",\"thana\":\"\",\"contact_no\":\"01861290540\",\"national_id\":null,\"email\":null,\"passport_no\":null,\"created_at\":\"2025-05-04T16:27:32.000000Z\",\"updated_at\":\"2025-05-04T16:27:32.000000Z\",\"owner_name\":null,\"owner_number\":null,\"olt_pon\":null,\"otc\":\"0.00\",\"building_no\":null,\"remarks\":null,\"dob\":\"05\\/04\\/2025\",\"cable_type\":null,\"road_name\":\"\",\"otc_due\":\"0.00\",\"profilePicture\":null,\"other_contact\":null,\"box\":null,\"joinDate\":\"2025-05-04 00:00:00\",\"client_latitude\":null,\"client_longitude\":null,\"picture\":null,\"client_door\":null,\"cat_type\":null,\"cat_length\":null,\"olt_no\":null,\"pon_port\":null,\"onu_serial\":null,\"customer_profile_picture\":null,\"from_cable\":null,\"to_cable\":null,\"customer_agrement\":null,\"cable_id\":null,\"customer_package_name\":null,\"btrc_package_bandwidth\":null,\"from_cable2\":null,\"to_cable2\":null,\"source_name\":null,\"connected_component_type\":null,\"connected_component_id\":null,\"type\":\"client\",\"division\":\"1\",\"map_box_id\":null,\"onu_router_info\":null,\"upazila\":0}}','4','2025-05-04 16:27:32','2025-05-04 16:27:32');
/*!40000 ALTER TABLE `client_edit_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_import_amount_reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_import_amount_reports` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` int NOT NULL,
  `pop_id` int NOT NULL,
  `client_id` int NOT NULL,
  `package_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `package_id` int NOT NULL,
  `sub_package_id` int DEFAULT NULL,
  `sub_package_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_days` int NOT NULL,
  `due_amount` int NOT NULL,
  `sub_due_amount` int DEFAULT NULL,
  `package_amount` int NOT NULL,
  `sub_package_amount` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_import_amount_reports` WRITE;
/*!40000 ALTER TABLE `client_import_amount_reports` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_import_amount_reports` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_references`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_references` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `firstname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lastname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isemployee` enum('no','yes') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `contact_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_references` WRITE;
/*!40000 ALTER TABLE `client_references` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_references` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_registers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `package` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connectivity` enum('Home','Corporate') COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('Pending','Approved','Rejected') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Pending',
  `message` text COLLATE utf8mb4_unicode_ci,
  `remarks` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_registers` WRITE;
/*!40000 ALTER TABLE `client_registers` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_sources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_sources` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_sources` WRITE;
/*!40000 ALTER TABLE `client_sources` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_sources` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_summaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_summaries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `month_year` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_clients` decimal(8,2) NOT NULL,
  `total_active_clients` decimal(8,2) NOT NULL,
  `total_expire_clients` decimal(8,2) NOT NULL,
  `total_disable_clients` decimal(8,2) NOT NULL,
  `total_de_active_clients` decimal(8,2) NOT NULL,
  `total_close_clients` decimal(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_summaries` WRITE;
/*!40000 ALTER TABLE `client_summaries` DISABLE KEYS */;
INSERT INTO `client_summaries` VALUES (1,'May-2025',94.00,1.00,0.00,0.00,93.00,0.00,'2025-05-04 17:58:04','2025-05-05 17:58:04');
/*!40000 ALTER TABLE `client_summaries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `clients` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pop_id` bigint unsigned NOT NULL,
  `billing_cycle` smallint NOT NULL,
  `package_id` bigint unsigned NOT NULL,
  `mac` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `userid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expire_date` datetime DEFAULT CURRENT_TIMESTAMP,
  `required_cable` decimal(8,2) DEFAULT NULL,
  `created_by` smallint NOT NULL,
  `client_approval` enum('pending','approved','canceled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `clients_status` enum('deactive','active','expired','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `crm_status` enum('Marketing','CRM','Support','Account','Fiber','Store') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Marketing',
  `marketed_by` bigint unsigned DEFAULT NULL,
  `sub_package_id` bigint unsigned DEFAULT NULL,
  `customer_id` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'id',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `payment_dadeline` int NOT NULL DEFAULT '0',
  `payment_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `app_key_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parmanent_discount` decimal(8,2) DEFAULT '0.00',
  `login_token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ignoreMKCheck` tinyint(1) NOT NULL,
  `first_approval` enum('Pending','Approved') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Pending',
  `first_approve_by` bigint unsigned DEFAULT NULL,
  `closed_at` datetime DEFAULT NULL,
  `bandwidth_limit` decimal(8,2) DEFAULT NULL,
  `up_bandwidth` decimal(8,2) DEFAULT NULL,
  `down_bandwidth` decimal(8,2) DEFAULT NULL,
  `apply_bandwidth_limit` tinyint NOT NULL DEFAULT '0',
  `ethernet_port` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `isStatic` tinyint NOT NULL DEFAULT '0',
  `distribution_point` enum('pop','noc') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `connection_type` enum('shared','dedicated') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `box_id` int DEFAULT NULL,
  `auto_deactive` datetime DEFAULT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Customer Code',
  `customer_type` enum('Home','Corporate') COLLATE utf8mb4_unicode_ci DEFAULT 'Home' COMMENT 'Customer Type',
  `crm_check_date` datetime DEFAULT NULL,
  `is_free` tinyint NOT NULL DEFAULT '0',
  `un_recharge_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `client_payment_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `billing_start_date` datetime DEFAULT NULL,
  `experity_check` enum('Yes','No') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Yes',
  `customer_account_balance_reseller` decimal(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `clients_userid_unique` (`userid`),
  UNIQUE KEY `clients_customer_code_unique` (`customer_code`),
  KEY `clients_status` (`clients_status`),
  KEY `expire_date` (`expire_date`),
  KEY `billing_cycle` (`billing_cycle`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `clients` WRITE;
/*!40000 ALTER TABLE `clients` DISABLE KEYS */;
INSERT INTO `clients` VALUES (1,2,15,23,NULL,'Si000','Si000',NULL,'2025-06-15 00:00:00',0.00,4,'approved','2025-05-04 16:27:32','2025-05-04 17:18:15','active','Marketing',0,NULL,'1',NULL,0,NULL,NULL,0.00,NULL,0,'Approved',NULL,NULL,NULL,NULL,NULL,0,NULL,0,'pop','shared',NULL,NULL,'20250504222732037Xn4JZw',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(2,2,15,23,NULL,'Si102','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'2',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(3,2,15,23,NULL,'Si103','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'3',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(4,2,15,23,NULL,'Si104','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'4',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(5,2,15,23,NULL,'Si105','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'5',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(6,2,15,23,NULL,'Si106','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'6',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(7,2,15,23,NULL,'Si107','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'7',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(8,2,15,24,NULL,'Si108','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'8',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(9,2,15,24,NULL,'Si109','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'9',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(10,2,15,23,NULL,'Si110','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'10',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(11,2,15,23,NULL,'Si111','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'11',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(12,2,15,24,NULL,'Si112','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'12',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(13,2,15,24,NULL,'Si113','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'13',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(14,2,15,23,NULL,'Si114','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'14',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(15,2,15,24,NULL,'Si115','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'15',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(16,2,15,24,NULL,'Si118','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'16',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(17,2,15,23,NULL,'Si119','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'17',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(18,2,15,23,NULL,'Si120','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'18',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(19,2,15,23,NULL,'Si121','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'19',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(20,2,15,23,NULL,'Si122','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'20',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(21,2,15,23,NULL,'Si123','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'21',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(22,2,15,23,NULL,'Si124','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'22',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(23,2,15,23,NULL,'Si125','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'23',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(24,2,15,24,NULL,'Si126','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'24',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(25,2,15,24,NULL,'Si127','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'25',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(26,2,15,23,NULL,'Si128','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'26',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(27,2,15,24,NULL,'Si129','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'27',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(28,2,15,23,NULL,'Si130','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'28',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(29,2,15,23,NULL,'Si131','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'29',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(30,2,15,24,NULL,'Si132','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'30',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(31,2,15,24,NULL,'Si133','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'31',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(32,2,15,24,NULL,'Si134','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'32',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(33,2,15,23,NULL,'Si135','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'33',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(34,2,15,23,NULL,'Si136','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'34',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(35,2,15,24,NULL,'Si138','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'35',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(36,2,15,24,NULL,'Si139','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'36',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(37,2,15,24,NULL,'Si140','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'37',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(38,2,15,24,NULL,'Si141','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'38',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(39,2,15,24,NULL,'Si142','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'39',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(40,2,15,24,NULL,'Si143','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'40',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(41,2,15,23,NULL,'Si144','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'41',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(42,2,15,23,NULL,'Si145','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'42',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(43,2,15,23,NULL,'Si146','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'43',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(44,2,15,23,NULL,'Si147','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'44',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(45,2,15,23,NULL,'Si148','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'45',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(46,2,15,23,NULL,'Si150','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'46',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(47,2,15,25,NULL,'Si151','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'47',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(48,2,15,24,NULL,'Si152','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'48',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(49,2,15,23,NULL,'Si153','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'49',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(50,2,15,26,NULL,'Si154','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'50',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(51,2,15,23,NULL,'Si155','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'51',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(52,2,15,23,NULL,'Si157','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:06','2025-05-04 18:23:06','deactive','Marketing',NULL,NULL,'52',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(53,2,15,24,NULL,'Si158','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'53',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(54,2,15,23,NULL,'Si159','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'54',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(55,2,15,24,NULL,'Si160','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'55',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(56,2,15,23,NULL,'Si161','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'56',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(57,2,15,23,NULL,'Si162','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'57',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(58,2,15,23,NULL,'Si163','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'58',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(59,2,15,23,NULL,'Si164','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'59',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(60,2,15,24,NULL,'Si165','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'60',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(61,2,15,24,NULL,'Si167','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'61',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(62,2,15,23,NULL,'Si166','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'62',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(63,2,15,23,NULL,'Si168','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'63',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(64,2,15,24,NULL,'Si170','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'64',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(65,2,15,23,NULL,'Si171','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'65',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(66,2,15,23,NULL,'Si172','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'66',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(67,2,15,24,NULL,'Si173','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'67',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(68,2,15,24,NULL,'Si174','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'68',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(69,2,15,24,NULL,'Si177','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'69',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(70,2,15,23,NULL,'Si178','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'70',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(71,2,15,24,NULL,'Si180','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'71',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(72,2,15,24,NULL,'Si181','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'72',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(73,2,15,23,NULL,'Si182','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'73',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(74,2,15,23,NULL,'Si183','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'74',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(75,2,15,25,NULL,'Si184','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'75',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(76,2,15,23,NULL,'Si185','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'76',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(77,2,15,23,NULL,'Si186','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'77',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(78,2,15,23,NULL,'Si187','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'78',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(79,2,15,23,NULL,'Si188','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'79',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(80,2,15,24,NULL,'Si189','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'80',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(81,2,15,24,NULL,'Si190.','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'81',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(82,2,15,24,NULL,'Si191.','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'82',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(83,2,15,23,NULL,'Si193','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'83',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(84,2,15,23,NULL,'Si194','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'84',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(85,2,15,23,NULL,'Si196','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'85',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(86,2,15,23,NULL,'Si197','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'86',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(87,2,15,26,NULL,'Si100','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'87',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(88,2,15,24,NULL,'Si1002','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'88',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(89,2,15,23,NULL,'Si1003','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'89',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(90,2,15,24,NULL,'Si1004','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'90',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(91,2,15,23,NULL,'Si1005','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'91',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(92,2,15,23,NULL,'Si1006','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'92',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(93,2,15,24,NULL,'Si1007','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'93',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00),(94,2,15,23,NULL,'Si1008','ksh412',NULL,'2025-05-15 00:00:00',0.00,3,'pending','2025-05-04 18:23:07','2025-05-04 18:23:07','deactive','Marketing',NULL,NULL,'94',NULL,0,NULL,NULL,0.00,NULL,0,'Pending',NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL,NULL,NULL,NULL,'',NULL,'Home',NULL,0,0.00,0.00,NULL,'Yes',0.00);
/*!40000 ALTER TABLE `clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `clientsinfo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `clientsinfo` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `clients_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `father_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mother_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flat_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `building_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `road_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `block_sector` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `area` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `district` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `thana` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `national_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `passport_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `owner_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `owner_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `olt_pon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `otc` decimal(8,2) NOT NULL,
  `building_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remarks` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `road_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `otc_due` decimal(8,2) DEFAULT NULL,
  `profilePicture` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `other_contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `box` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `joinDate` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_latitude` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_longitude` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `picture` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_door` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_length` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `olt_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pon_port` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `onu_serial` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_profile_picture` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_cable` int DEFAULT NULL,
  `to_cable` int DEFAULT NULL,
  `customer_agrement` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cable_id` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_package_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `btrc_package_bandwidth` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `from_cable2` int DEFAULT NULL,
  `to_cable2` int DEFAULT NULL,
  `source_name` bigint unsigned DEFAULT NULL,
  `connected_component_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `connected_component_id` bigint unsigned DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'client',
  `division` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `map_box_id` bigint unsigned DEFAULT NULL,
  `onu_router_info` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upazila` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `clientsinfo` WRITE;
/*!40000 ALTER TABLE `clientsinfo` DISABLE KEYS */;
INSERT INTO `clientsinfo` VALUES (1,1,'Si000',NULL,NULL,NULL,NULL,'','','','8','','01861290540',NULL,NULL,NULL,'2025-05-04 16:27:32','2025-05-04 16:27:32',NULL,NULL,NULL,0.00,NULL,NULL,'05/04/2025',NULL,'',0.00,NULL,NULL,NULL,'2025-05-04 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(2,2,'Ripon','','',NULL,NULL,NULL,NULL,'','8',NULL,'01857213470',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(3,3,'Cishty fzd bari','','',NULL,NULL,NULL,NULL,'','8',NULL,'01811222417',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(4,4,'Md Ashraf ali caca','','',NULL,NULL,NULL,NULL,'','8',NULL,'01312364955',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(5,5,'Azad amir shagor pr','','',NULL,NULL,NULL,NULL,'','8',NULL,'01857213470',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(6,6,'Abu naser','','',NULL,NULL,NULL,NULL,'','8',NULL,'01628478892',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(7,7,'Mohammad shamim','','',NULL,NULL,NULL,NULL,'','8',NULL,'01629055383',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(8,8,'Amzad hm','','',NULL,NULL,NULL,NULL,'','8',NULL,'01634902411',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(9,9,'Shahul Chowdhury','','',NULL,NULL,NULL,NULL,'','8',NULL,'01616860421',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(10,10,'Selim bhai modi','','',NULL,NULL,NULL,NULL,'','8',NULL,'01300050623',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(11,11,'Orni azom','','',NULL,NULL,NULL,NULL,'','8',NULL,'01747858762',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(12,12,'Arman czn','','',NULL,NULL,NULL,NULL,'','8',NULL,'01811222417',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(13,13,'Ibrahim hujur','','',NULL,NULL,NULL,NULL,'','8',NULL,'01845321243',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(14,14,'Priyom','','',NULL,NULL,NULL,NULL,'','8',NULL,'01844668992',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(15,15,'Md kabir','','',NULL,NULL,NULL,NULL,'','8',NULL,'01701278854',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(16,16,'Md Al-amin','','',NULL,NULL,NULL,NULL,'','8',NULL,'01842988486',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(17,17,'Md Babul','','',NULL,NULL,NULL,NULL,'','8',NULL,'01824839030',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(18,18,'Shabana nurch','','',NULL,NULL,NULL,NULL,'','8',NULL,'01611008107',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(19,19,'selim mia','','',NULL,NULL,NULL,NULL,'','8',NULL,'01738879888',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(20,20,'Mohiuddin mama','','',NULL,NULL,NULL,NULL,'','8',NULL,'01740002223',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(21,21,'Younos bhai','','',NULL,NULL,NULL,NULL,'','8',NULL,'01819829599',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(22,22,'Mizan bhai nurch','','',NULL,NULL,NULL,NULL,'','8',NULL,'01718024981',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(23,23,'Tisha nurse','','',NULL,NULL,NULL,NULL,'','8',NULL,'01824988852',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(24,24,'Shanta','','',NULL,NULL,NULL,NULL,'','8',NULL,'01832879359',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(25,25,'Bobita Aunty','','',NULL,NULL,NULL,NULL,'','8',NULL,'01732469247',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(26,26,'Babu bhai kj','','',NULL,NULL,NULL,NULL,'','8',NULL,'01690121693',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(27,27,'Younos bhai home','','',NULL,NULL,NULL,NULL,'','8',NULL,'01830178090',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(28,28,'Mahedi nursing','','',NULL,NULL,NULL,NULL,'','8',NULL,'01602755440',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(29,29,'Md sohel','','',NULL,NULL,NULL,NULL,'','8',NULL,'01630208059',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(30,30,'Borsha kfl v','','',NULL,NULL,NULL,NULL,'','8',NULL,'01878814365',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(31,31,'Md zahir','','',NULL,NULL,NULL,NULL,'','8',NULL,'01839240305',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(32,32,'Liton','','',NULL,NULL,NULL,NULL,'','8',NULL,'01974517934',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(33,33,'Shankar tv hptl','','',NULL,NULL,NULL,NULL,'','8',NULL,'01861209208',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(34,34,'Anuwar v','','',NULL,NULL,NULL,NULL,'','8',NULL,'01636266150',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(35,35,'Rifat kj','','',NULL,NULL,NULL,NULL,'','8',NULL,'01847943232',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(36,36,'Md Forhad','','',NULL,NULL,NULL,NULL,'','8',NULL,'01819366259',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(37,37,'Md nur hussain cng','','',NULL,NULL,NULL,NULL,'','8',NULL,'01825141829',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(38,38,'Nimour navi 6t b','','',NULL,NULL,NULL,NULL,'','8',NULL,'01793410220',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(39,39,'Bishojid nurch','','',NULL,NULL,NULL,NULL,'','8',NULL,'01851140115',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(40,40,'MD Alnasir s','','',NULL,NULL,NULL,NULL,'','8',NULL,'01819062378',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(41,41,'Tajia Taju br hm','','',NULL,NULL,NULL,NULL,'','8',NULL,'01810596624',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(42,42,'Jahangir showdager','','',NULL,NULL,NULL,NULL,'','8',NULL,'01671260307',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(43,43,'Md Taslim ank','','',NULL,NULL,NULL,NULL,'','8',NULL,'01324903409',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(44,44,'Taslim br jabed','','',NULL,NULL,NULL,NULL,'','8',NULL,'01842020917',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(45,45,'Md shumon nurse','','',NULL,NULL,NULL,NULL,'','8',NULL,'01815347212',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(46,46,'Jannatul fardous dakbari','','',NULL,NULL,NULL,NULL,'','8',NULL,'01845819252',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(47,47,'DC PARK OFFICE','','',NULL,NULL,NULL,NULL,'','8',NULL,'01304002660',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(48,48,'Mr Eliyas br bitid','','',NULL,NULL,NULL,NULL,'','8',NULL,'01738888302',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(49,49,'Md Tarek','','',NULL,NULL,NULL,NULL,'','8',NULL,'01841715904',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(50,50,'Dc park quater','','',NULL,NULL,NULL,NULL,'','8',NULL,'01516553257',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(51,51,'Md Emon nurseing','','',NULL,NULL,NULL,NULL,'','8',NULL,'01778933072',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(52,52,'Md Mostafa bhai nurse','','',NULL,NULL,NULL,NULL,'','8',NULL,'01788172259',NULL,'',NULL,'2025-05-04 18:23:06','2025-05-04 18:23:06',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(53,53,'Md Jahangir shagorpar','','',NULL,NULL,NULL,NULL,'','8',NULL,'01865113574',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(54,54,'Md Akram nurse','','',NULL,NULL,NULL,NULL,'','8',NULL,'01845370682',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(55,55,'Md Raihan ful Banu','','',NULL,NULL,NULL,NULL,'','8',NULL,'01812117924',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(56,56,'Md tarek','','',NULL,NULL,NULL,NULL,'','8',NULL,'01889866980',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(57,57,'Kanta kj bari','','',NULL,NULL,NULL,NULL,'','8',NULL,'01939837609',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(58,58,'Md Akbar bhai','','',NULL,NULL,NULL,NULL,'','8',NULL,'01820352187',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(59,59,'other','','',NULL,NULL,NULL,NULL,'','8',NULL,'01811222416',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(60,60,'Other Haji bld','','',NULL,NULL,NULL,NULL,'','8',NULL,'01779191622',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(61,61,'Mohammad Azam saleh dada','','',NULL,NULL,NULL,NULL,'','8',NULL,'01854492039',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(62,62,'Jarina nurse','','',NULL,NULL,NULL,NULL,'','8',NULL,'01867964861',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(63,63,'Md Salam','','',NULL,NULL,NULL,NULL,'','8',NULL,'01867964861',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(64,64,'Ms Salma nurse','','',NULL,NULL,NULL,NULL,'','8',NULL,'01857884683',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(65,65,'Md Mukbul','','',NULL,NULL,NULL,NULL,'','8',NULL,'01815624924',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(66,66,'Golapy nurse','','',NULL,NULL,NULL,NULL,'','8',NULL,'01764732697',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(67,67,'Dc p rst the hungrella','','',NULL,NULL,NULL,NULL,'','8',NULL,'01886769551',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(68,68,'Md Rashed','','',NULL,NULL,NULL,NULL,'','8',NULL,'01611673014',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(69,69,'Md shumon kj','','',NULL,NULL,NULL,NULL,'','8',NULL,'01837886045',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(70,70,'Ms Tania Nurse','','',NULL,NULL,NULL,NULL,'','8',NULL,'01632884112',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(71,71,'Md Rafikul islam','','',NULL,NULL,NULL,NULL,'','8',NULL,'01708959520',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(72,72,'Faruk br emon v','','',NULL,NULL,NULL,NULL,'','8',NULL,'01913303075',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(73,73,'Md rana','','',NULL,NULL,NULL,NULL,'','8',NULL,'01643094707',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(74,74,'Md Tuhin nurse','','',NULL,NULL,NULL,NULL,'','8',NULL,'01682573349',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(75,75,'Md muslim bk','','',NULL,NULL,NULL,NULL,'','8',NULL,'01818408714',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(76,76,'Mst Shomapti nurse','','',NULL,NULL,NULL,NULL,'','8',NULL,'01794874244',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(77,77,'Z.S Noyon sln','','',NULL,NULL,NULL,NULL,'','8',NULL,'01620544152',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(78,78,'ms Afrin','','',NULL,NULL,NULL,NULL,'','8',NULL,'01585753609',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(79,79,'Shumon Taskin','','',NULL,NULL,NULL,NULL,'','8',NULL,'01822527302',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(80,80,'Md sayeed iht main','','',NULL,NULL,NULL,NULL,'','8',NULL,'01741095690',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(81,81,'Md Jahidul nurse','','',NULL,NULL,NULL,NULL,'','8',NULL,'01304968806',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(82,82,'Md anuwar imran','','',NULL,NULL,NULL,NULL,'','8',NULL,'01861026654',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(83,83,'Ms Koli Shaiful','','',NULL,NULL,NULL,NULL,'','8',NULL,'01820034133',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(84,84,'Md Johir IHT','','',NULL,NULL,NULL,NULL,'','8',NULL,'01922241799',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(85,85,'Dc park Md sakib fz','','',NULL,NULL,NULL,NULL,'','8',NULL,'01307878566',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(86,86,'Arman kj','','',NULL,NULL,NULL,NULL,'','8',NULL,'01849397305',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(87,87,'Kakon nurse','','',NULL,NULL,NULL,NULL,'','8',NULL,'01824777656',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(88,88,'Jubayed jewel bld','','',NULL,NULL,NULL,NULL,'','8',NULL,'01645942877',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(89,89,'Md khaled nurseing','','',NULL,NULL,NULL,NULL,'','8',NULL,'01875616804',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(90,90,'Monir pona','','',NULL,NULL,NULL,NULL,'','8',NULL,'01960957553',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(91,91,'Sheli apa taslim','','',NULL,NULL,NULL,NULL,'','8',NULL,'01986814795',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(92,92,'Md Babaruddin dk bari','','',NULL,NULL,NULL,NULL,'','8',NULL,'01856941745',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(93,93,'Hasina sattar','','',NULL,NULL,NULL,NULL,'','8',NULL,'01813032169',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0),(94,94,'Shikti apu','','',NULL,NULL,NULL,NULL,'','8',NULL,'01817261024',NULL,'',NULL,'2025-05-04 18:23:07','2025-05-04 18:23:07',NULL,NULL,NULL,0.00,NULL,'ekram',NULL,'',NULL,NULL,NULL,NULL,NULL,'2025-01-05 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'client','1',NULL,NULL,0);
/*!40000 ALTER TABLE `clientsinfo` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cluster_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cluster_map` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint unsigned DEFAULT NULL,
  `parent_type` enum('cluster','cable') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'cluster',
  `parent_cluster` bigint unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `coordinates` json NOT NULL,
  `box` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remarks` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `isBox` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cluster_map` WRITE;
/*!40000 ALTER TABLE `cluster_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `cluster_map` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `company_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `company_information` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `img_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mobile` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `mikrotik_conection_type` enum('radius','api') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'radius',
  `telegram` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `telegram_for_support` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `same_for_support` enum('1','') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sync_time_in_secconds` int DEFAULT NULL,
  `max_extended_day` int DEFAULT NULL,
  `billing_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `technical_or_support_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notice` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `notice_yes_no` enum('Yes','No') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'No',
  `invoice_terms` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `bkash_img` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ssl_img` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nagod_img` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `qrcode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `online_offline_topbar` enum('Yes','No') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'No',
  `deactive_after` int NOT NULL DEFAULT '0',
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `stock_reminder_contact_numbers` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_button` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `expire_profile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `d2dactiveday` int NOT NULL DEFAULT '0',
  `day_to_day_after_10_days` enum('Yes','No') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'No',
  `bill_by_payment_start_time` timestamp NULL DEFAULT NULL,
  `min_recharge_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  CONSTRAINT `company_information_chk_1` CHECK (json_valid(`settings`))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `company_information` WRITE;
/*!40000 ALTER TABLE `company_information` DISABLE KEYS */;
INSERT INTO `company_information` VALUES (1,'Space Walker','sayadgmxr@gmail.com','1746358089.jpg','01633307601','<div>Halishahar Chittagong</div>',NULL,'2025-05-05 05:46:00','api','[{\"group_name\":null,\"api\":null,\"chat_id\":null}]','[{\"group_name\":null,\"api\":null,\"chat_id\":null}]','',300,30,NULL,NULL,NULL,'No',NULL,'','','',NULL,'{\"payment_url_enable\":null,\"payment_url\":null}','No',0,'[{\"type\":\"expire_time\",\"value\":\"0:0:00\"},{\"type\":\"deactive_after\",\"value\":null},{\"type\":\"billing_type\",\"value\":\"monthly\"},{\"type\":\"expire_sms_send_time\",\"value\":\"11:30\"},{\"type\":\"customer_panel_api\",\"value\":{\"customer_panel_url\":\"client-list.yetfix.com\",\"customer_panel_secret\":null}}]',NULL,'[]',NULL,NULL,0,'No',NULL,100.00);
/*!40000 ALTER TABLE `company_information` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_item_return_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_item_return_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `old_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_item_return_logs` WRITE;
/*!40000 ALTER TABLE `crm_item_return_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_item_return_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_item_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_item_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `crm_item_id` bigint unsigned NOT NULL,
  `status` enum('Damage','Lost','Good') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Good',
  `quantity` decimal(8,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `approve_status` enum('Approve','Not Approve') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Not Approve',
  `approve_by` bigint unsigned DEFAULT NULL,
  `approve_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_item_returns` WRITE;
/*!40000 ALTER TABLE `crm_item_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_item_returns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_item_units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_item_units` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bangla_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_item_units` WRITE;
/*!40000 ALTER TABLE `crm_item_units` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_item_units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `crm_item_unit_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bangla_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_items` WRITE;
/*!40000 ALTER TABLE `crm_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `current_update_time_difference`;
/*!50001 DROP VIEW IF EXISTS `current_update_time_difference`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `current_update_time_difference` AS SELECT 
 1 AS `username`,
 1 AS `acctinterval`,
 1 AS `acctstarttime`,
 1 AS `acctupdatetime`,
 1 AS `TIMESTAMPDIFF(MINUTE, acctupdatetime, now() )`*/;
SET character_set_client = @saved_cs_client;
DROP TABLE IF EXISTS `customer_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `totalPaid` decimal(8,2) NOT NULL,
  `dueAmount` decimal(8,2) NOT NULL,
  `totalDiscount` decimal(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `totalBillAmount` decimal(8,2) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `customer_accounts_client_id_unique` (`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_accounts` WRITE;
/*!40000 ALTER TABLE `customer_accounts` DISABLE KEYS */;
INSERT INTO `customer_accounts` VALUES (1,1,0.00,0.00,0.00,'2025-05-04 16:28:07','2025-05-04 16:28:07',0.00);
/*!40000 ALTER TABLE `customer_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_balance_adjustment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_balance_adjustment` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `client_id` bigint unsigned NOT NULL,
  `amount` decimal(8,2) NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_balance_adjustment` WRITE;
/*!40000 ALTER TABLE `customer_balance_adjustment` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_balance_adjustment` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_billing_cycle_infos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_billing_cycle_infos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `previous_billing_cycle` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `current_billing_cycle` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_billing_cycle_infos` WRITE;
/*!40000 ALTER TABLE `customer_billing_cycle_infos` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_billing_cycle_infos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_del_infos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_del_infos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` bigint unsigned NOT NULL,
  `deleted_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_del_infos` WRITE;
/*!40000 ALTER TABLE `customer_del_infos` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_del_infos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_package_change_infos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_package_change_infos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `previous_package_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `previous_package_price` decimal(10,2) NOT NULL,
  `new_package_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_package_price` decimal(10,2) NOT NULL,
  `previous_sub_package_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `previous_sub_package_price` decimal(10,2) DEFAULT NULL,
  `new_sub_package_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `new_sub_package_price` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_package_change_infos` WRITE;
/*!40000 ALTER TABLE `customer_package_change_infos` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_package_change_infos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `device_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `device_map` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `manufactures` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `serial_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remarks` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'device',
  `total_ports` int NOT NULL,
  `cluster_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `device_map` WRITE;
/*!40000 ALTER TABLE `device_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `device_map` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `device_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `device_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `device_types` WRITE;
/*!40000 ALTER TABLE `device_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `device_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `districts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `districts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `division_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bn_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `districts_division_id_foreign` (`division_id`),
  CONSTRAINT `districts_division_id_foreign` FOREIGN KEY (`division_id`) REFERENCES `divisions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `districts` WRITE;
/*!40000 ALTER TABLE `districts` DISABLE KEYS */;
INSERT INTO `districts` VALUES (1,1,'Comilla','কুমিল্লা','23.4682747','91.1788135','www.comilla.gov.bd',NULL,NULL),(2,1,'Feni','ফেনী','23.023231','91.3840844','www.feni.gov.bd',NULL,NULL),(3,1,'Brahmanbaria','ব্রাহ্মণবাড়িয়া','23.9570904','91.1119286','www.brahmanbaria.gov.bd',NULL,NULL),(4,1,'Rangamati','রাঙ্গামাটি',NULL,NULL,'www.rangamati.gov.bd',NULL,NULL),(5,1,'Noakhali','নোয়াখালী','22.869563','91.099398','www.noakhali.gov.bd',NULL,NULL),(6,1,'Chandpur','চাঁদপুর','23.2332585','90.6712912','www.chandpur.gov.bd',NULL,NULL),(7,1,'Lakshmipur','লক্ষ্মীপুর','22.942477','90.841184','www.lakshmipur.gov.bd',NULL,NULL),(8,1,'Chattogram','চট্টগ্রাম','22.335109','91.834073','www.chittagong.gov.bd',NULL,NULL),(9,1,'Coxsbazar','কক্সবাজার',NULL,NULL,'www.coxsbazar.gov.bd',NULL,NULL),(10,1,'Khagrachhari','খাগড়াছড়ি','23.119285','91.984663','www.khagrachhari.gov.bd',NULL,NULL),(11,1,'Bandarban','বান্দরবান','22.1953275','92.2183773','www.bandarban.gov.bd',NULL,NULL),(12,2,'Sirajganj','সিরাজগঞ্জ','24.4533978','89.7006815','www.sirajganj.gov.bd',NULL,NULL),(13,2,'Pabna','পাবনা','23.998524','89.233645','www.pabna.gov.bd',NULL,NULL),(14,2,'Bogura','বগুড়া','24.8465228','89.377755','www.bogra.gov.bd',NULL,NULL),(15,2,'Rajshahi','রাজশাহী',NULL,NULL,'www.rajshahi.gov.bd',NULL,NULL),(16,2,'Natore','নাটোর','24.420556','89.000282','www.natore.gov.bd',NULL,NULL),(17,2,'Joypurhat','জয়পুরহাট',NULL,NULL,'www.joypurhat.gov.bd',NULL,NULL),(18,2,'Chapainawabganj','চাঁপাইনবাবগঞ্জ','24.5965034','88.2775122','www.chapainawabganj.gov.bd',NULL,NULL),(19,2,'Naogaon','নওগাঁ',NULL,NULL,'www.naogaon.gov.bd',NULL,NULL),(20,3,'Jashore','যশোর','23.16643','89.2081126','www.jessore.gov.bd',NULL,NULL),(21,3,'Satkhira','সাতক্ষীরা',NULL,NULL,'www.satkhira.gov.bd',NULL,NULL),(22,3,'Meherpur','মেহেরপুর','23.762213','88.631821','www.meherpur.gov.bd',NULL,NULL),(23,3,'Narail','নড়াইল','23.172534','89.512672','www.narail.gov.bd',NULL,NULL),(24,3,'Chuadanga','চুয়াডাঙ্গা','23.6401961','88.841841','www.chuadanga.gov.bd',NULL,NULL),(25,3,'Kushtia','কুষ্টিয়া','23.901258','89.120482','www.kushtia.gov.bd',NULL,NULL),(26,3,'Magura','মাগুরা','23.487337','89.419956','www.magura.gov.bd',NULL,NULL),(27,3,'Khulna','খুলনা','22.815774','89.568679','www.khulna.gov.bd',NULL,NULL),(28,3,'Bagerhat','বাগেরহাট','22.651568','89.785938','www.bagerhat.gov.bd',NULL,NULL),(29,3,'Jhenaidah','ঝিনাইদহ','23.5448176','89.1539213','www.jhenaidah.gov.bd',NULL,NULL),(30,4,'Jhalakathi','ঝালকাঠি',NULL,NULL,'www.jhalakathi.gov.bd',NULL,NULL),(31,4,'Patuakhali','পটুয়াখালী','22.3596316','90.3298712','www.patuakhali.gov.bd',NULL,NULL),(32,4,'Pirojpur','পিরোজপুর',NULL,NULL,'www.pirojpur.gov.bd',NULL,NULL),(33,4,'Barisal','বরিশাল',NULL,NULL,'www.barisal.gov.bd',NULL,NULL),(34,4,'Bhola','ভোলা','22.685923','90.648179','www.bhola.gov.bd',NULL,NULL),(35,4,'Barguna','বরগুনা',NULL,NULL,'www.barguna.gov.bd',NULL,NULL),(36,5,'Sylhet','সিলেট','24.8897956','91.8697894','www.sylhet.gov.bd',NULL,NULL),(37,5,'Moulvibazar','মৌলভীবাজার','24.482934','91.777417','www.moulvibazar.gov.bd',NULL,NULL),(38,5,'Habiganj','হবিগঞ্জ','24.374945','91.41553','www.habiganj.gov.bd',NULL,NULL),(39,5,'Sunamganj','সুনামগঞ্জ','25.0658042','91.3950115','www.sunamganj.gov.bd',NULL,NULL),(40,6,'Narsingdi','নরসিংদী','23.932233','90.71541','www.narsingdi.gov.bd',NULL,NULL),(41,6,'Gazipur','গাজীপুর','24.0022858','90.4264283','www.gazipur.gov.bd',NULL,NULL),(42,6,'Shariatpur','শরীয়তপুর',NULL,NULL,'www.shariatpur.gov.bd',NULL,NULL),(43,6,'Narayanganj','নারায়ণগঞ্জ','23.63366','90.496482','www.narayanganj.gov.bd',NULL,NULL),(44,6,'Tangail','টাঙ্গাইল',NULL,NULL,'www.tangail.gov.bd',NULL,NULL),(45,6,'Kishoreganj','কিশোরগঞ্জ','24.444937','90.776575','www.kishoreganj.gov.bd',NULL,NULL),(46,6,'Manikganj','মানিকগঞ্জ',NULL,NULL,'www.manikganj.gov.bd',NULL,NULL),(47,6,'Dhaka','ঢাকা','23.7115253','90.4111451','www.dhaka.gov.bd',NULL,NULL),(48,6,'Munshiganj','মুন্সিগঞ্জ',NULL,NULL,'www.munshiganj.gov.bd',NULL,NULL),(49,6,'Rajbari','রাজবাড়ী','23.7574305','89.6444665','www.rajbari.gov.bd',NULL,NULL),(50,6,'Madaripur','মাদারীপুর','23.164102','90.1896805','www.madaripur.gov.bd',NULL,NULL),(51,6,'Gopalganj','গোপালগঞ্জ','23.0050857','89.8266059','www.gopalganj.gov.bd',NULL,NULL),(52,6,'Faridpur','ফরিদপুর','23.6070822','89.8429406','www.faridpur.gov.bd',NULL,NULL),(53,7,'Panchagarh','পঞ্চগড়','26.3411','88.5541606','www.panchagarh.gov.bd',NULL,NULL),(54,7,'Dinajpur','দিনাজপুর','25.6217061','88.6354504','www.dinajpur.gov.bd',NULL,NULL),(55,7,'Lalmonirhat','লালমনিরহাট',NULL,NULL,'www.lalmonirhat.gov.bd',NULL,NULL),(56,7,'Nilphamari','নীলফামারী','25.931794','88.856006','www.nilphamari.gov.bd',NULL,NULL),(57,7,'Gaibandha','গাইবান্ধা','25.328751','89.528088','www.gaibandha.gov.bd',NULL,NULL),(58,7,'Thakurgaon','ঠাকুরগাঁও','26.0336945','88.4616834','www.thakurgaon.gov.bd',NULL,NULL),(59,7,'Rangpur','রংপুর','25.7558096','89.244462','www.rangpur.gov.bd',NULL,NULL),(60,7,'Kurigram','কুড়িগ্রাম','25.805445','89.636174','www.kurigram.gov.bd',NULL,NULL),(61,8,'Sherpur','শেরপুর','25.0204933','90.0152966','www.sherpur.gov.bd',NULL,NULL),(62,8,'Mymensingh','ময়মনসিংহ',NULL,NULL,'www.mymensingh.gov.bd',NULL,NULL),(63,8,'Jamalpur','জামালপুর','24.937533','89.937775','www.jamalpur.gov.bd',NULL,NULL),(64,8,'Netrokona','নেত্রকোণা','24.870955','90.727887','www.netrokona.gov.bd',NULL,NULL),(65,6,'Dhaka Metro','ঢাকা মেট্রো','23.4682747','91.1788135','www.aa.gov.bd',NULL,NULL),(66,1,'Chittagang Metro','চট্রগ্রাম মেট্রো','23.4682747','91.1788135','www.aa.gov.bd',NULL,NULL),(67,2,'Rajshahi Metro','রাজশাহী মেট্রো','23.4682747','91.1788135','www.aa.gov.bd',NULL,NULL),(68,3,'Khulna Metro','খুলনা মেট্রো','23.4682747','91.1788135','www.aa.gov.bd',NULL,NULL),(69,4,'Barishal Metro','বরিশাল মেট্রো','23.4682747','91.1788135','www.aa.gov.bd',NULL,NULL),(70,5,'Sylhet Metro','সিলেট মেট্রো','23.4682747','91.1788135','www.aa.gov.bd',NULL,NULL),(71,7,'Rangpur Metro','রংপুর মেট্রো','23.4682747','91.1788135','www.aa.gov.bd',NULL,NULL),(72,6,'Gazipur Metro','গাজীপুর মেট্রো','23.4682747','91.1788135','www.aa.gov.bd',NULL,NULL);
/*!40000 ALTER TABLE `districts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `divisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `divisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bn_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `divisions` WRITE;
/*!40000 ALTER TABLE `divisions` DISABLE KEYS */;
INSERT INTO `divisions` VALUES (1,'Chattogram','চট্টগ্রাম','www.chittagongdiv.gov.bd',NULL,NULL),(2,'Rajshahi','রাজশাহী','www.rajshahidiv.gov.bd',NULL,NULL),(3,'Khulna','খুলনা','www.khulnadiv.gov.bd',NULL,NULL),(4,'Barisal','বরিশাল','www.barisaldiv.gov.bd',NULL,NULL),(5,'Sylhet','সিলেট','www.sylhetdiv.gov.bd',NULL,NULL),(6,'Dhaka','ঢাকা','www.dhakadiv.gov.bd',NULL,NULL),(7,'Rangpur','রংপুর','www.rangpurdiv.gov.bd',NULL,NULL),(8,'Mymensingh','ময়মনসিংহ','www.mymensinghdiv.gov.bd',NULL,NULL);
/*!40000 ALTER TABLE `divisions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `email_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tamplate_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `email_settings` WRITE;
/*!40000 ALTER TABLE `email_settings` DISABLE KEYS */;
INSERT INTO `email_settings` VALUES (1,'customer_payment_eamil','{\"sendemail\":\"No\",\"email_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09df \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 ({c_name}),\\n\\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u09ac\\u09bf\\u09b2 \\u09b8\\u09a0\\u09bf\\u0995 \\u09ad\\u09be\\u09ac\\u09c7 \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u09b9\\u09df\\u09c7\\u099b\\u09c7\\u0964 \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u099f\\u09be\\u0995\\u09be\\u09b0 \\u09aa\\u09b0\\u09bf\\u09ae\\u09be\\u09a8- TK {PaymentAmount} | \\u09af\\u09c7\\u0995\\u09cb\\u09a8\\u09cb \\u09a4\\u09a5\\u09cd\\u09af\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af \\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997 {company_cell} | {company_name} \\u098f\\u09b0 \\u09b8\\u09be\\u09a5\\u09c7 \\u09a5\\u09be\\u0995\\u09be\\u09b0 \\u099c\\u09a8\\u09cd\\u09af \\u09a7\\u09a8\\u09cd\\u09af\\u09ac\\u09be\\u09a6\\u0964\"}',NULL,NULL),(2,'bill_generate_eamil','{\"sendemail\":\"No\",\"email_body\":\"Dear {c_name}\\n {MonthBillAmount} TK Bill generate for {bill_type}\\n\\nPlease Pay Before: 05 {ThisMonth}\\n\\n{company_name}\\n{company_cell}\"}',NULL,NULL);
/*!40000 ALTER TABLE `email_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` bigint unsigned NOT NULL,
  `amount` int DEFAULT NULL,
  `remark` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_payments` WRITE;
/*!40000 ALTER TABLE `employee_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employees` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `join_date` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `manager_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hr_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_of_birth` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `joining_designation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_designation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `department` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `father` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mother` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `appointment_date` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `joining_salary` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_salary` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_promotion_increment_date` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `permanent_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_office` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_personal` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `family` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `employee_can_requisite` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` enum('pending','active','canceled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `admin_user_id` bigint unsigned DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `employee_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blode_group` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `house_allowance` int DEFAULT NULL,
  `transport_allowance` int DEFAULT NULL,
  `other_allowance` int DEFAULT NULL,
  `bonous` int DEFAULT NULL,
  `advance_salary` int DEFAULT NULL,
  `working_day` int DEFAULT NULL,
  `absent_day` int DEFAULT NULL,
  `salary_generate` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employees` WRITE;
/*!40000 ALTER TABLE `employees` DISABLE KEYS */;
INSERT INTO `employees` VALUES (1,'Gazi Saad','3','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01633307601',NULL,NULL,NULL,NULL,NULL,'2025-05-04 11:26:12','2025-05-04 11:26:12','active',3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),(2,'MD. IMTIAZ KHAN','4','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'01811222417',NULL,NULL,NULL,NULL,NULL,'2025-05-04 16:13:37','2025-05-04 16:13:37','active',4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
/*!40000 ALTER TABLE `employees` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_heads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `expense_heads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_heads` WRITE;
/*!40000 ALTER TABLE `expense_heads` DISABLE KEYS */;
INSERT INTO `expense_heads` VALUES (1,'Salary',NULL,NULL),(2,'House Rent',NULL,NULL),(3,'Office Expense',NULL,NULL),(4,'Electricity Bill',NULL,NULL),(5,'Bandwidth Bill',NULL,NULL),(6,'Reseller Commission',NULL,NULL),(7,'Employee Salary',NULL,NULL);
/*!40000 ALTER TABLE `expense_heads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_number` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `date` datetime NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `attach_document` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `expenseHead` bigint unsigned NOT NULL,
  `created_by` bigint unsigned DEFAULT NULL,
  `employee_id` bigint unsigned DEFAULT NULL,
  `fund_transfer_id` bigint unsigned DEFAULT NULL,
  `status` enum('pending','approved') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_accounting_id` bigint unsigned DEFAULT NULL,
  `band_with_buy_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses` WRITE;
/*!40000 ALTER TABLE `expenses` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `fiber_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fiber_map` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cable_id` bigint unsigned NOT NULL,
  `tube_id` bigint unsigned NOT NULL,
  `fiber_number` int NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fiber',
  `parent_fiber_id` bigint unsigned DEFAULT NULL,
  `child_fiber_id` bigint unsigned DEFAULT NULL,
  `parent_component_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_component_id` bigint unsigned DEFAULT NULL,
  `child_component_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `child_component_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `fiber_map` WRITE;
/*!40000 ALTER TABLE `fiber_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `fiber_map` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `fiber_ports_odf`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fiber_ports_odf` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `odf_id` bigint unsigned NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fiber_port',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` int NOT NULL,
  `column` int NOT NULL,
  `front_panel_component_id` bigint unsigned DEFAULT NULL,
  `front_panel_component_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `back_panel_component_id` bigint unsigned DEFAULT NULL,
  `back_panel_component_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `fiber_ports_odf` WRITE;
/*!40000 ALTER TABLE `fiber_ports_odf` DISABLE KEYS */;
/*!40000 ALTER TABLE `fiber_ports_odf` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `form_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `form_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'inactive',
  `group_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `form_settings` WRITE;
/*!40000 ALTER TABLE `form_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `form_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `fund_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `fund_transfers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fund_send_by` bigint unsigned NOT NULL,
  `fund_received_by` bigint unsigned NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `amount` decimal(16,2) NOT NULL,
  `transfer_by` bigint unsigned NOT NULL,
  `user_accountings_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `transfer_type` enum('none','fund_transfer','expense','income') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `fund_transfers` WRITE;
/*!40000 ALTER TABLE `fund_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `fund_transfers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `global_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=184 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `global_settings` WRITE;
/*!40000 ALTER TABLE `global_settings` DISABLE KEYS */;
INSERT INTO `global_settings` VALUES (1,'father-name-required','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(2,'mother-name-required','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(3,'hide-due-otc','enable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(4,'site-logo-show','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(5,'ssl-commerz-show','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(6,'ssl-commerz-live','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(7,'bkash-show','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(8,'new-user-create-sms','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(9,'otc-auto-due','enable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(10,'on-create-customer-auto-payment','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(11,'reseller-recharge-paid-option','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(12,'bill-payment-sms','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(13,'auto-payment-sms-send','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(14,'store','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(15,'token-create-sms','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(16,'token-close-sms','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(17,'area-dropdown','enable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(18,'customer-sync','enable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(19,'package-profile','enable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(20,'profilePicture','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(21,'help','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(22,'notification','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(23,'parmanent-discount','enable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(24,'telegram-notify','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(25,'blank-column','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(26,'show-traffice','enable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(27,'resseller-name-in-package','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(28,'national_id','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(29,'contact_no','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(30,'area','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(31,'mikrotik-connection-type-show','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(32,'package-commission','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(33,'sub-package-commission','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(34,'delete-radius-online-customer','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(35,'print-invoice','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(36,'bkash-tokenized','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(37,'bkash-checkout','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(38,'monthlyBillGenerate','enable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(39,'dob','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(40,'payment_month_show_in_remark','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(41,'cid_access_for_pending_customer','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(42,'close_token_after_customer_online','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(43,'email-setting','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(44,'singleInvoice','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(45,'reseller_bill_collection','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(46,'largeFontInBillsheet','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(47,'static-ip-address','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(48,'client-mac-binding','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(49,'ignore-mikrotik-check','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(50,'uddokta-pay-show','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(51,'cable-meter-required','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(52,'olt-pon','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(53,'package-name-show-in-customer-dashboard','enable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(54,'local-user-first-approve','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(55,'cable_meter_required','disable','2025-05-04 11:20:37','2025-05-04 11:20:37'),(56,'cable_cat5_cat6_required','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(57,'onu_serial_required','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(58,'olt_no_require','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(59,'olt_port_number_required','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(60,'pon_module_required','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(61,'dore_picture_required','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(62,'building_photo_required','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(63,'customer_profile_picture','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(64,'customer_agrement_required','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(65,'customer_package_name_show','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(66,'cable_id_required','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(67,'show-dshboard-graph','enable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(68,'new_customer_billing_report','enable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(69,'february_add_2_days','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(70,'expire_billing_change_today_from_billing_date','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(71,'auto_deactive_expire_customer','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(72,'dailyBillGenerate','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(73,'auto-payment-print','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(74,'upay-payment','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(75,'showClientUpDownInfo','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(76,'reseller-online-recharge','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(77,'upay-reseller-recharge','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(78,'bkash-reseller-recharge','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(79,'reseller-recharge-duplicate-protect','enable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(80,'static-ip-check','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(81,'pop-online-recharge','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(82,'upay-pop-recharge','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(83,'bkash-pop-recharge','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(84,'close-or-deactive-without-mikrotik','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(85,'auto-bill-generate-on-payment','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(86,'all-client-dataTable','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(87,'show-message-to-expire-customer','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(88,'source_name','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(89,'change-payment-date','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(90,'nagad-checkout-client-payment','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(91,'nagad-reseller-recharge','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(92,'online_payment_auto_recharge','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(93,'nagad-pop-recharge','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(94,'online-offline-using-api','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(95,'package-change-price-show','enable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(96,'account-history-userName-search','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(97,'customer-login-by-cid-mobileNumber','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(98,'radius-upload-download','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(99,'due-history-in-payment','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(100,'money_receipt_no_required','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(101,'Bandwidth-section','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(102,'radius_customer_bandwidth_limit','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(103,'only_local_bandwidth_check','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(104,'static_ip_manage','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(105,'disable_if_bandwidth_limit_over','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(106,'package_limite_quantity','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(107,'mobile_digit_change_on_btrc_export','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(108,'all_information_with_token_close','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(109,'box','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(110,'auto_deactive_check','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(111,'package_price_show_at_client_add','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(112,'otc_payment_with_generale_payment','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(113,'api_bandwidth_usage','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(114,'livespeed-client-portal','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(115,'Bank','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(116,'connect_second_data_base','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(117,'nagad_pgw_implement_sync','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(118,'payroll','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(119,'reseller-client-dynamic-recharge','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(120,'store_up_down_in_client_table','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(121,'surjo-pay-show','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(122,'deactive-custome-datatable','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(123,'Division','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(124,'District','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(125,'Upazila','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(126,'CRM','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(127,'package_rate_in_client_search_excel','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(128,'customer_code','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(129,'login_customer_code_and_password','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(130,'recharge_expire_customer_today','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(131,'check_manager_balance','enable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(132,'change_payment_amount_client_portal','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(133,'prepaid-bill-by-client-username','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(134,'prepaid-bill-by-client-code','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(135,'all_pay_bill_auto_recharge','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(136,'disable_limit_over_user','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(137,'schedule_package','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(138,'changeOrderInToken','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(139,'deactive_all_expire_customer','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(140,'ping_optical_info_required','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(141,'remote_autoreboot_info_required','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(142,'btrc_report_field_required','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(143,'d2d_recharge_for_reseller','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(144,'token_source','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(145,'only-last-invoice-print','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(146,'manage-map','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(147,'customerPortalReactive','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(148,'onu_router_info','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(149,'free_client','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(150,'d2d_extend_ExpireDate_By_Month','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(151,'Thana','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(152,'local_client_and_reseller_client_bill','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(153,'customResellerSmsGatewaySetup','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(154,'RadiusExpiration','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(155,'ResellerClientOnlineRecharge','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(156,'setClientPaymentAmountToClient','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(157,'setPackagePriceAsDueAmountForPayBill','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(158,'reseller-image','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(159,'disconnect-with-api','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(160,'reseller-can-recharge-from-commission','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(161,'client_import_amount_report','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(162,'countPaymentDateAsOneDayForExpireDate','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(163,'getResellerAreaOnSelectPop','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(164,'hidePopOnCreateArea','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(165,'onu_information_laser','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(166,'save_other_to_own_time_client','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(167,'client_name_in_online_list','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(168,'round_expire_date','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(169,'payment-bill-by-bill','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(170,'singlePageBillInvoice','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(171,'blockPaymentDeActiveNoDue','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(172,'pay-with-eps','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(173,'bulling_name','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(174,'cable_meter_from','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(175,'cable_meter_to','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(176,'extendFromToDayOwnCustomer','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(177,'testing','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(178,'expire_before_expire_date','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(179,'file_up_for_own_other','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(180,'reseller-client-billing','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(181,'import_excel_requred','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(182,'number_validate','disable','2025-05-04 11:20:38','2025-05-04 11:20:38'),(183,'show-dashboard-customer-summary','disable','2025-05-04 11:20:38','2025-05-04 11:20:38');
/*!40000 ALTER TABLE `global_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `income_heads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `income_heads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `income_heads` WRITE;
/*!40000 ALTER TABLE `income_heads` DISABLE KEYS */;
INSERT INTO `income_heads` VALUES (1,'New Customer',NULL,NULL),(2,'OTC',NULL,NULL),(3,'Billing Cycle Change',NULL,NULL),(4,'Package Change',NULL,NULL),(5,'Monthly Bill',NULL,NULL),(6,'Advanced Payment',NULL,NULL),(7,'House Rent',NULL,NULL),(8,'Router Sell',NULL,NULL),(9,'Old Item Sell',NULL,NULL),(10,'Reseller Recharge',NULL,NULL),(11,'Online Bill Payment',NULL,NULL);
/*!40000 ALTER TABLE `income_heads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `incomes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `incomes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `amount` decimal(16,2) DEFAULT NULL,
  `attach_document` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `incomeHead` bigint unsigned NOT NULL,
  `bandwidth_sale_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `incomes` WRITE;
/*!40000 ALTER TABLE `incomes` DISABLE KEYS */;
INSERT INTO `incomes` VALUES (1,'2025-05-04 12:12:27','2025-05-04 12:12:27','Reseller Recharge','','2025-05-04',10000.00,NULL,'Reseller Recharge Name: Ekram ID: 2',10,NULL),(2,'2025-05-04 17:25:31','2025-05-04 17:25:31','Reseller Recharge','','2025-05-04',336.00,NULL,'Reseller Recharge Name: Ekram ID: 2',10,NULL);
/*!40000 ALTER TABLE `incomes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `item_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `item_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bn_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` enum('Active','Inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `parent_id` bigint unsigned DEFAULT NULL,
  `creator_user_id` bigint unsigned DEFAULT NULL,
  `updator_user_id` bigint unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `item_categories_parent_id_foreign` (`parent_id`),
  KEY `item_categories_creator_user_id_foreign` (`creator_user_id`),
  KEY `item_categories_updator_user_id_foreign` (`updator_user_id`),
  CONSTRAINT `item_categories_creator_user_id_foreign` FOREIGN KEY (`creator_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_categories_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `item_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_categories_updator_user_id_foreign` FOREIGN KEY (`updator_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `item_categories` WRITE;
/*!40000 ALTER TABLE `item_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `item_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `item_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `item_return_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `item_retern_id` bigint unsigned NOT NULL,
  `item_id` bigint unsigned NOT NULL,
  `qty` decimal(16,2) NOT NULL,
  `serial_no` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `item_return_items` WRITE;
/*!40000 ALTER TABLE `item_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `item_return_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `item_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `item_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `employee_id` bigint unsigned NOT NULL,
  `branch_id` bigint unsigned NOT NULL,
  `recived_user_id` bigint unsigned NOT NULL,
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `serial_add_or_not` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `item_returns` WRITE;
/*!40000 ALTER TABLE `item_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `item_returns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `category_id` bigint unsigned NOT NULL,
  `unit_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bn_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barcode_path` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `alert_quantity` int DEFAULT NULL,
  `status` enum('Active','Inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `creator_user_id` bigint unsigned DEFAULT NULL,
  `updator_user_id` bigint unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `serial_number` enum('enable','disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_crm` enum('Yes','No') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'No',
  PRIMARY KEY (`id`),
  UNIQUE KEY `items_code_unique` (`code`),
  UNIQUE KEY `items_slug_unique` (`slug`),
  KEY `items_category_id_foreign` (`category_id`),
  KEY `items_unit_id_foreign` (`unit_id`),
  KEY `items_creator_user_id_foreign` (`creator_user_id`),
  KEY `items_updator_user_id_foreign` (`updator_user_id`),
  CONSTRAINT `items_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `item_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `items_creator_user_id_foreign` FOREIGN KEY (`creator_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `items_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE,
  CONSTRAINT `items_updator_user_id_foreign` FOREIGN KEY (`updator_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `items` WRITE;
/*!40000 ALTER TABLE `items` DISABLE KEYS */;
/*!40000 ALTER TABLE `items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB AUTO_INCREMENT=1454 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `license_check`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `license_check` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `license_check` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `license_check` WRITE;
/*!40000 ALTER TABLE `license_check` DISABLE KEYS */;
/*!40000 ALTER TABLE `license_check` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `line_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `line_shifts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_userid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pop_id` bigint unsigned NOT NULL,
  `old_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `new_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shifting_date` date NOT NULL,
  `contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('Done','Done and Cable Remove','Pending','Not Possible') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `flat_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `building_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `building_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `road_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `road_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `block_sector` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `area` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `box` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_latitude` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_longitude` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `line_shifts` WRITE;
/*!40000 ALTER TABLE `line_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `line_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `log_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `log_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_id` bigint unsigned DEFAULT NULL,
  `old_info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `new_info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `edit_by` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `log_histories` WRITE;
/*!40000 ALTER TABLE `log_histories` DISABLE KEYS */;
INSERT INTO `log_histories` VALUES (1,'Package',6,'{\"id\":6,\"package_name\":\"5Mbps\",\"package_rate\":\"240.00\",\"pool_name\":\"\",\"created_at\":\"2025-05-04T11:42:45.000000Z\",\"updated_at\":\"2025-05-04T11:42:45.000000Z\",\"commission\":null,\"profile_name\":\"5Mbps\",\"speed_up\":null,\"speed_down\":null,\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":6,\"package_name\":\"5_Mbps_E\",\"package_rate\":\"240.00\",\"pool_name\":\"5Mbps\",\"created_at\":\"2025-05-04T11:42:45.000000Z\",\"updated_at\":\"2025-05-04T11:56:31.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"5Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 11:56:31','2025-05-04 11:56:31'),(2,'POP',1,'{\"id\":1,\"popname\":\"Noyabazar\",\"reseller_id\":1,\"pop_location\":\"Noyabazar\",\"pop_contact\":\"1\",\"nas_id\":1,\"longitude\":\"YY\",\"latitude\":\"XX\",\"server_authentication\":\"yes\",\"billable\":\"yes\",\"subreseller\":\"no\",\"created_at\":\"2025-05-04T11:36:48.000000Z\",\"updated_at\":\"2025-05-04T11:36:48.000000Z\",\"bill_generate\":\"yes\",\"package_change_pricing\":\"full_month\",\"status\":\"Enable\",\"sms_send\":\"yes\",\"experity_check\":\"No\",\"sub_package_list\":null,\"pop_disable\":\"no\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"enable_online_recharge\":0,\"commission_percentage\":\"0.00\"}','{\"id\":1,\"popname\":\"Noyabazar\",\"reseller_id\":1,\"pop_location\":\"Noyabazar\",\"pop_contact\":\"1\",\"nas_id\":1,\"longitude\":\"YY\",\"latitude\":\"XX\",\"server_authentication\":\"yes\",\"billable\":\"yes\",\"subreseller\":\"no\",\"created_at\":\"2025-05-04T11:36:48.000000Z\",\"updated_at\":\"2025-05-04T12:11:00.000000Z\",\"bill_generate\":\"yes\",\"package_change_pricing\":\"full_month\",\"status\":\"Enable\",\"sms_send\":\"yes\",\"experity_check\":\"Yes\",\"sub_package_list\":null,\"pop_disable\":\"no\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"enable_online_recharge\":0,\"commission_percentage\":\"0.00\"}',3,'2025-05-04 12:11:00','2025-05-04 12:11:00'),(3,'POP',1,'{\"id\":1,\"popname\":\"Noyabazar\",\"reseller_id\":1,\"pop_location\":\"Noyabazar\",\"pop_contact\":\"1\",\"nas_id\":1,\"longitude\":\"YY\",\"latitude\":\"XX\",\"server_authentication\":\"yes\",\"billable\":\"yes\",\"subreseller\":\"no\",\"created_at\":\"2025-05-04T11:36:48.000000Z\",\"updated_at\":\"2025-05-04T12:11:00.000000Z\",\"bill_generate\":\"yes\",\"package_change_pricing\":\"full_month\",\"status\":\"Enable\",\"sms_send\":\"yes\",\"experity_check\":\"Yes\",\"sub_package_list\":null,\"pop_disable\":\"no\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"enable_online_recharge\":0,\"commission_percentage\":\"0.00\"}','{\"id\":1,\"popname\":\"Noyabazar\",\"reseller_id\":1,\"pop_location\":\"Noyabazar\",\"pop_contact\":\"1\",\"nas_id\":1,\"longitude\":\"YY\",\"latitude\":\"XX\",\"server_authentication\":\"yes\",\"billable\":\"yes\",\"subreseller\":\"no\",\"created_at\":\"2025-05-04T11:36:48.000000Z\",\"updated_at\":\"2025-05-04T12:11:04.000000Z\",\"bill_generate\":\"yes\",\"package_change_pricing\":\"full_month\",\"status\":\"Enable\",\"sms_send\":\"yes\",\"experity_check\":\"No\",\"sub_package_list\":null,\"pop_disable\":\"no\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"enable_online_recharge\":0,\"commission_percentage\":\"0.00\"}',3,'2025-05-04 12:11:04','2025-05-04 12:11:04'),(4,'Package',6,'{\"id\":6,\"package_name\":\"5_Mbps_E\",\"package_rate\":\"240.00\",\"pool_name\":\"5Mbps\",\"created_at\":\"2025-05-04T11:42:45.000000Z\",\"updated_at\":\"2025-05-04T11:56:31.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"5Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":6,\"package_name\":\"Mbps\",\"package_rate\":\"0.00\",\"pool_name\":\"5Mbps\",\"created_at\":\"2025-05-04T11:42:45.000000Z\",\"updated_at\":\"2025-05-04T12:14:27.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"5Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 12:14:27','2025-05-04 12:14:27'),(5,'Package',6,'{\"id\":6,\"package_name\":\"Mbps\",\"package_rate\":\"0.00\",\"pool_name\":\"5Mbps\",\"created_at\":\"2025-05-04T11:42:45.000000Z\",\"updated_at\":\"2025-05-04T12:14:27.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"5Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":6,\"package_name\":\"5Mbps\",\"package_rate\":\"0.00\",\"pool_name\":\"5Mbps\",\"created_at\":\"2025-05-04T11:42:45.000000Z\",\"updated_at\":\"2025-05-04T12:14:38.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"5Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 12:14:38','2025-05-04 12:14:38'),(6,'Package',9,'{\"id\":9,\"package_name\":\"20_Mbps_E\",\"package_rate\":\"380.00\",\"pool_name\":\"20Mbps\",\"created_at\":\"2025-05-04T11:45:15.000000Z\",\"updated_at\":\"2025-05-04T11:45:15.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"20Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":9,\"package_name\":\"20_Mbps\",\"package_rate\":\"0.00\",\"pool_name\":\"20Mbps\",\"created_at\":\"2025-05-04T11:45:15.000000Z\",\"updated_at\":\"2025-05-04T12:15:44.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"20Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 12:15:44','2025-05-04 12:15:44'),(7,'Package',10,'{\"id\":10,\"package_name\":\"30_Mbps_E\",\"package_rate\":\"480.00\",\"pool_name\":\"30Mbps\",\"created_at\":\"2025-05-04T11:46:00.000000Z\",\"updated_at\":\"2025-05-04T11:46:00.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"30Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":10,\"package_name\":\"30_Mbps\",\"package_rate\":\"480.00\",\"pool_name\":\"30Mbps\",\"created_at\":\"2025-05-04T11:46:00.000000Z\",\"updated_at\":\"2025-05-04T12:15:53.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"30Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 12:15:53','2025-05-04 12:15:53'),(8,'Package',10,'{\"id\":10,\"package_name\":\"30_Mbps\",\"package_rate\":\"480.00\",\"pool_name\":\"30Mbps\",\"created_at\":\"2025-05-04T11:46:00.000000Z\",\"updated_at\":\"2025-05-04T12:15:53.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"30Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":10,\"package_name\":\"30_Mbps\",\"package_rate\":\"480.00\",\"pool_name\":\"30Mbps\",\"created_at\":\"2025-05-04T11:46:00.000000Z\",\"updated_at\":\"2025-05-04T12:16:03.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"30Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 12:16:03','2025-05-04 12:16:03'),(9,'Package',7,'{\"id\":7,\"package_name\":\"10Mbps\",\"package_rate\":\"280.00\",\"pool_name\":\"\",\"created_at\":\"2025-05-04T11:42:50.000000Z\",\"updated_at\":\"2025-05-04T11:42:50.000000Z\",\"commission\":null,\"profile_name\":\"10Mbps\",\"speed_up\":null,\"speed_down\":null,\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":7,\"package_name\":\"10Mbps\",\"package_rate\":\"500.00\",\"pool_name\":\"10Mbps\",\"created_at\":\"2025-05-04T11:42:50.000000Z\",\"updated_at\":\"2025-05-04T12:17:16.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"10Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 12:17:16','2025-05-04 12:17:16'),(10,'Package',8,'{\"id\":8,\"package_name\":\"15Mbps\",\"package_rate\":\"340.00\",\"pool_name\":\"\",\"created_at\":\"2025-05-04T11:42:52.000000Z\",\"updated_at\":\"2025-05-04T11:42:52.000000Z\",\"commission\":null,\"profile_name\":\"15Mbps\",\"speed_up\":null,\"speed_down\":null,\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":8,\"package_name\":\"15Mbps\",\"package_rate\":\"550.00\",\"pool_name\":\"15Mbps\",\"created_at\":\"2025-05-04T11:42:52.000000Z\",\"updated_at\":\"2025-05-04T12:17:32.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"15Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 12:17:32','2025-05-04 12:17:32'),(11,'Package',7,'{\"id\":7,\"package_name\":\"10Mbps\",\"package_rate\":\"500.00\",\"pool_name\":\"10Mbps\",\"created_at\":\"2025-05-04T11:42:50.000000Z\",\"updated_at\":\"2025-05-04T12:17:16.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"10Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":7,\"package_name\":\"10Mbps\",\"package_rate\":\"400.00\",\"pool_name\":\"10Mbps\",\"created_at\":\"2025-05-04T11:42:50.000000Z\",\"updated_at\":\"2025-05-04T12:24:18.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"10Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 12:24:18','2025-05-04 12:24:18'),(12,'Manager',1,'{\"id\":1,\"name\":\"Saad\",\"address\":\".\",\"contact\":\"016333 07601\",\"remark\":null,\"billable\":\"yes\",\"last_login\":null,\"loign_ip\":null,\"created_at\":\"2025-05-04T11:35:07.000000Z\",\"updated_at\":\"2025-05-04T11:46:34.000000Z\",\"package_list\":\"1,2,3,4,5\",\"reseller_type\":\"own\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"img_url\":null,\"commission_percentage\":\"0.00\"}','{\"id\":1,\"name\":\"Saad\",\"address\":\".\",\"contact\":\"01633307601\",\"remark\":null,\"billable\":\"yes\",\"last_login\":null,\"loign_ip\":null,\"created_at\":\"2025-05-04T11:35:07.000000Z\",\"updated_at\":\"2025-05-04T12:35:27.000000Z\",\"package_list\":\"1,2,3,4,5\",\"reseller_type\":\"own\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"img_url\":null,\"commission_percentage\":\"0.00\"}',3,'2025-05-04 12:35:27','2025-05-04 12:35:27'),(13,'Manager',2,'{\"id\":2,\"name\":\"Ekram\",\"address\":\".\",\"contact\":\"11\",\"remark\":null,\"billable\":\"yes\",\"last_login\":null,\"loign_ip\":null,\"created_at\":\"2025-05-04T11:35:39.000000Z\",\"updated_at\":\"2025-05-04T12:16:47.000000Z\",\"package_list\":\"\",\"reseller_type\":\"other\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"img_url\":null,\"commission_percentage\":\"0.00\"}','{\"id\":2,\"name\":\"Ekram\",\"address\":\"Fozderhat\",\"contact\":\"11\",\"remark\":null,\"billable\":\"yes\",\"last_login\":null,\"loign_ip\":null,\"created_at\":\"2025-05-04T11:35:39.000000Z\",\"updated_at\":\"2025-05-04T15:39:31.000000Z\",\"package_list\":\"\",\"reseller_type\":\"other\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"img_url\":null,\"commission_percentage\":\"0.00\"}',3,'2025-05-04 15:39:31','2025-05-04 15:39:31'),(14,'Package',34,'{\"id\":34,\"package_name\":\"30Mbps_A\",\"package_rate\":\"220.00\",\"pool_name\":\"\",\"created_at\":\"2025-05-04T16:03:26.000000Z\",\"updated_at\":\"2025-05-04T16:03:26.000000Z\",\"commission\":null,\"profile_name\":\"30Mbps\",\"speed_up\":null,\"speed_down\":null,\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":34,\"package_name\":\"20Mbps_A\",\"package_rate\":\"220.00\",\"pool_name\":\"20Mbps\",\"created_at\":\"2025-05-04T16:03:26.000000Z\",\"updated_at\":\"2025-05-04T16:03:56.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"20Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 16:03:56','2025-05-04 16:03:56'),(15,'Package',34,'{\"id\":34,\"package_name\":\"20Mbps_A\",\"package_rate\":\"220.00\",\"pool_name\":\"20Mbps\",\"created_at\":\"2025-05-04T16:03:26.000000Z\",\"updated_at\":\"2025-05-04T16:03:56.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"20Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":34,\"package_name\":\"10Mbps_A\",\"package_rate\":\"220.00\",\"pool_name\":\"10Mbps\",\"created_at\":\"2025-05-04T16:03:26.000000Z\",\"updated_at\":\"2025-05-04T16:04:13.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"10Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 16:04:13','2025-05-04 16:04:13'),(16,'Package',36,'{\"id\":36,\"package_name\":\"20Mbps_A\",\"package_rate\":\"0.00\",\"pool_name\":\"\",\"created_at\":\"2025-05-04T16:04:27.000000Z\",\"updated_at\":\"2025-05-04T16:04:27.000000Z\",\"commission\":null,\"profile_name\":\"20Mbps\",\"speed_up\":null,\"speed_down\":null,\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":36,\"package_name\":\"20Mbps_A\",\"package_rate\":\"220.00\",\"pool_name\":\"20Mbps\",\"created_at\":\"2025-05-04T16:04:27.000000Z\",\"updated_at\":\"2025-05-04T16:04:58.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"20Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 16:04:58','2025-05-04 16:04:58'),(17,'Package',38,'{\"id\":38,\"package_name\":\"50Mbps_A\",\"package_rate\":\"220.00\",\"pool_name\":\"\",\"created_at\":\"2025-05-04T16:05:15.000000Z\",\"updated_at\":\"2025-05-04T16:05:15.000000Z\",\"commission\":null,\"profile_name\":\"50Mbps\",\"speed_up\":null,\"speed_down\":null,\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}','{\"id\":38,\"package_name\":\"30Mbps_A\",\"package_rate\":\"220.00\",\"pool_name\":\"30Mbps\",\"created_at\":\"2025-05-04T16:05:15.000000Z\",\"updated_at\":\"2025-05-04T16:05:25.000000Z\",\"commission\":\"0.00\",\"profile_name\":\"30Mbps\",\"speed_up\":\"0\",\"speed_down\":\"0\",\"limite_quantity\":null,\"package_bandwidth\":\"0\",\"btrc_package_price\":\"0.00\",\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 16:05:25','2025-05-04 16:05:25'),(18,'POP',2,'{\"id\":2,\"popname\":\"Foz derhat\",\"reseller_id\":2,\"pop_location\":\"Foz derhat\",\"pop_contact\":\"1\",\"nas_id\":1,\"longitude\":\"YY\",\"latitude\":\"XX\",\"server_authentication\":\"yes\",\"billable\":\"yes\",\"subreseller\":\"no\",\"created_at\":\"2025-05-04T11:37:32.000000Z\",\"updated_at\":\"2025-05-04T15:39:31.000000Z\",\"bill_generate\":\"no\",\"package_change_pricing\":\"full_month\",\"status\":\"Enable\",\"sms_send\":\"yes\",\"experity_check\":\"No\",\"sub_package_list\":null,\"pop_disable\":\"no\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"enable_online_recharge\":0,\"commission_percentage\":\"0.00\"}','{\"id\":2,\"popname\":\"Fozderhat\",\"reseller_id\":2,\"pop_location\":\"Foz derhat\",\"pop_contact\":\"1\",\"nas_id\":1,\"longitude\":\"YY\",\"latitude\":\"XX\",\"server_authentication\":\"yes\",\"billable\":\"yes\",\"subreseller\":\"no\",\"created_at\":\"2025-05-04T11:37:32.000000Z\",\"updated_at\":\"2025-05-04T16:19:08.000000Z\",\"bill_generate\":\"no\",\"package_change_pricing\":\"full_month\",\"status\":\"Enable\",\"sms_send\":\"no\",\"experity_check\":\"No\",\"sub_package_list\":null,\"pop_disable\":\"no\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"enable_online_recharge\":0,\"commission_percentage\":\"0.00\"}',3,'2025-05-04 16:19:08','2025-05-04 16:19:08'),(19,'POP',2,'{\"id\":2,\"popname\":\"Fozderhat\",\"reseller_id\":2,\"pop_location\":\"Foz derhat\",\"pop_contact\":\"1\",\"nas_id\":1,\"longitude\":\"YY\",\"latitude\":\"XX\",\"server_authentication\":\"yes\",\"billable\":\"yes\",\"subreseller\":\"no\",\"created_at\":\"2025-05-04T11:37:32.000000Z\",\"updated_at\":\"2025-05-04T16:19:08.000000Z\",\"bill_generate\":\"no\",\"package_change_pricing\":\"full_month\",\"status\":\"Enable\",\"sms_send\":\"no\",\"experity_check\":\"No\",\"sub_package_list\":null,\"pop_disable\":\"no\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"enable_online_recharge\":0,\"commission_percentage\":\"0.00\"}','{\"id\":2,\"popname\":\"Fozderhat\",\"reseller_id\":2,\"pop_location\":\"Foz derhat\",\"pop_contact\":\"1\",\"nas_id\":1,\"longitude\":\"YY\",\"latitude\":\"XX\",\"server_authentication\":\"yes\",\"billable\":\"yes\",\"subreseller\":\"no\",\"created_at\":\"2025-05-04T11:37:32.000000Z\",\"updated_at\":\"2025-05-04T16:19:17.000000Z\",\"bill_generate\":\"no\",\"package_change_pricing\":\"full_month\",\"status\":\"Enable\",\"sms_send\":\"no\",\"experity_check\":\"No\",\"sub_package_list\":null,\"pop_disable\":\"no\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"enable_online_recharge\":0,\"commission_percentage\":\"0.00\"}',3,'2025-05-04 16:19:17','2025-05-04 16:19:17'),(20,'POP',2,'{\"id\":2,\"popname\":\"Fozderhat\",\"reseller_id\":2,\"pop_location\":\"Foz derhat\",\"pop_contact\":\"1\",\"nas_id\":1,\"longitude\":\"YY\",\"latitude\":\"XX\",\"server_authentication\":\"yes\",\"billable\":\"yes\",\"subreseller\":\"no\",\"created_at\":\"2025-05-04T11:37:32.000000Z\",\"updated_at\":\"2025-05-04T16:19:17.000000Z\",\"bill_generate\":\"no\",\"package_change_pricing\":\"full_month\",\"status\":\"Enable\",\"sms_send\":\"no\",\"experity_check\":\"No\",\"sub_package_list\":null,\"pop_disable\":\"no\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"enable_online_recharge\":0,\"commission_percentage\":\"0.00\"}','{\"id\":2,\"popname\":\"Fozderhat\",\"reseller_id\":2,\"pop_location\":\"Fozderhat\",\"pop_contact\":\"1\",\"nas_id\":1,\"longitude\":\"YY\",\"latitude\":\"XX\",\"server_authentication\":\"yes\",\"billable\":\"yes\",\"subreseller\":\"no\",\"created_at\":\"2025-05-04T11:37:32.000000Z\",\"updated_at\":\"2025-05-04T16:23:38.000000Z\",\"bill_generate\":\"no\",\"package_change_pricing\":\"full_month\",\"status\":\"Enable\",\"sms_send\":\"no\",\"experity_check\":\"No\",\"sub_package_list\":null,\"pop_disable\":\"no\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"enable_online_recharge\":0,\"commission_percentage\":\"0.00\"}',3,'2025-05-04 16:23:38','2025-05-04 16:23:38'),(21,'Manager',3,'{\"id\":3,\"name\":\"Akash\",\"address\":\"Khanbari\",\"contact\":\"02\",\"remark\":\"Pon\\/1,2\",\"billable\":\"yes\",\"last_login\":null,\"loign_ip\":null,\"created_at\":\"2025-05-04T16:01:55.000000Z\",\"updated_at\":\"2025-05-04T16:01:55.000000Z\",\"package_list\":null,\"reseller_type\":\"other\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"img_url\":null,\"commission_percentage\":\"0.00\"}','{\"id\":3,\"name\":\"Akash\",\"address\":\"Khanbari\",\"contact\":\"01973464170\",\"remark\":\"Pon\\/1,2\",\"billable\":\"yes\",\"last_login\":null,\"loign_ip\":null,\"created_at\":\"2025-05-04T16:01:55.000000Z\",\"updated_at\":\"2025-05-04T16:52:49.000000Z\",\"package_list\":null,\"reseller_type\":\"other\",\"payment_charges\":\"{\\\"bkash_charges\\\":null,\\\"rocket_charges\\\":null,\\\"nagad_charges\\\":null,\\\"upay_charges\\\":null,\\\"ucash_charges\\\":null}\",\"img_url\":null,\"commission_percentage\":\"0.00\"}',3,'2025-05-04 16:52:49','2025-05-04 16:52:49'),(22,'Sub-Package',2,'{\"id\":2,\"reseller_id\":2,\"package_id\":23,\"name\":\"5Mbps_EE\",\"rate\":\"500\",\"created_at\":\"2025-05-04T18:29:56.000000Z\",\"updated_at\":\"2025-05-04T18:29:56.000000Z\",\"commission\":null,\"client_payment_amount\":\"0.00\"}','{\"id\":2,\"reseller_id\":2,\"package_id\":23,\"name\":\"5Mbps_EE\",\"rate\":\"500\",\"created_at\":\"2025-05-04T18:29:56.000000Z\",\"updated_at\":\"2025-05-04T18:29:56.000000Z\",\"commission\":null,\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 18:30:34','2025-05-04 18:30:34'),(23,'Sub-Package',2,'{\"id\":2,\"reseller_id\":2,\"package_id\":23,\"name\":\"5Mbps_EE\",\"rate\":\"500\",\"created_at\":\"2025-05-04T18:29:56.000000Z\",\"updated_at\":\"2025-05-04T18:29:56.000000Z\",\"commission\":null,\"client_payment_amount\":\"0.00\"}','{\"id\":2,\"reseller_id\":2,\"package_id\":23,\"name\":\"5Mbps_EE\",\"rate\":\"500\",\"created_at\":\"2025-05-04T18:29:56.000000Z\",\"updated_at\":\"2025-05-04T18:29:56.000000Z\",\"commission\":null,\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 18:30:48','2025-05-04 18:30:48'),(24,'Sub-Package',2,'{\"id\":2,\"reseller_id\":2,\"package_id\":23,\"name\":\"5Mbps_EE\",\"rate\":\"500\",\"created_at\":\"2025-05-04T18:29:56.000000Z\",\"updated_at\":\"2025-05-04T18:29:56.000000Z\",\"commission\":null,\"client_payment_amount\":\"0.00\"}','{\"id\":2,\"reseller_id\":3,\"package_id\":23,\"name\":\"5Mbps_EE\",\"rate\":\"500\",\"created_at\":\"2025-05-04T18:29:56.000000Z\",\"updated_at\":\"2025-05-04T18:33:35.000000Z\",\"commission\":null,\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 18:33:35','2025-05-04 18:33:35'),(25,'Sub-Package',3,'{\"id\":3,\"reseller_id\":2,\"package_id\":23,\"name\":\"5Mbps_EE\",\"rate\":\"500\",\"created_at\":\"2025-05-04T18:34:18.000000Z\",\"updated_at\":\"2025-05-04T18:34:18.000000Z\",\"commission\":null,\"client_payment_amount\":\"0.00\"}','{\"id\":3,\"reseller_id\":1,\"package_id\":23,\"name\":\"5Mbps_EE\",\"rate\":\"500\",\"created_at\":\"2025-05-04T18:34:18.000000Z\",\"updated_at\":\"2025-05-04T18:35:55.000000Z\",\"commission\":null,\"client_payment_amount\":\"0.00\"}',3,'2025-05-04 18:35:55','2025-05-04 18:35:55');
/*!40000 ALTER TABLE `log_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mail_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mail_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `clients_id` bigint unsigned NOT NULL,
  `subject` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delivery_log` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mail_logs` WRITE;
/*!40000 ALTER TABLE `mail_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `mail_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=397 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2019_08_19_000000_create_failed_jobs_table',1),(4,'2021_01_19_081656_create_resellers_table',1),(5,'2021_01_20_062739_create_pop_table',1),(6,'2021_01_24_082346_create_packages_table',1),(7,'2021_01_24_165530_create_clients_table',1),(8,'2021_01_25_025840_create_clients_info_table',1),(9,'2021_01_26_083704_add_package_list_to_resellers',1),(10,'2021_01_28_033432_add_client_status_to_clients',1),(11,'2021_02_11_140710_sub_resellers',1),(12,'2021_02_13_154309_user_details_table',1),(13,'2021_02_13_155334_user_log_details',1),(14,'2021_02_13_160321_create_reseller_recharge_reports_table',1),(15,'2021_02_13_160925_create_reselle_balance_log_reports_table',1),(16,'2021_02_14_131551_create_balances_table',1),(17,'2021_02_17_222517_create_permission_tables',1),(18,'2021_02_18_004245_create_client_balance_logs_table',1),(19,'2021_03_02_210953_change_clients_table_column_clients_status',1),(20,'2021_03_03_095517_create_incomes_table',1),(21,'2021_03_03_101318_create_expenses_table',1),(22,'2021_03_09_112848_create_user_has_reseller_table',1),(23,'2021_03_14_114836_create_bill_generates_table',1),(24,'2021_03_21_095613_create_settings_table',1),(25,'2021_03_21_123139_update_permissions_table',1),(26,'2021_03_22_114455_add_billing_type_to_bill_generates',1),(27,'2021_03_22_142449_add_collumn_clients_balance_logs',1),(28,'2021_03_24_110149_add_column_to_pops',1),(29,'2021_03_28_144245_create_client_references_table',1),(30,'2021_03_28_204636_add_column_to_clientsinfo',1),(31,'2021_03_29_105106_add_column_to_clients',1),(32,'2021_03_29_114912_add_column_on_client_references',1),(33,'2021_04_01_105556_add_coumn_clients_table',1),(34,'2021_04_17_125535_create_freeradius_table_if_not_exist',1),(35,'2021_04_18_120052_create_table_bill_generates_archive',1),(36,'2021_05_03_120438_add_column_on_clientsinfo_table',2),(37,'2021_05_04_015847_add_column_to_bill_payments',2),(38,'2021_05_05_194117_create_employees_table',3),(39,'2021_05_06_224324_add_status_to_pops_table',3),(40,'2021_05_07_002051_add_experity_check_to_pops_table',3),(41,'2021_05_07_012629_create_sub_packages_table',3),(42,'2021_05_07_114153_create_token_cats_table',3),(43,'2021_05_07_162014_create_token_codes_table',3),(44,'2021_05_08_104345_add_on_payment_extend_expirity_to_bill_payments',3),(45,'2021_05_08_121025_create_tokens_table',3),(46,'2021_05_08_132253_modify_clients_table',4),(47,'2021_05_08_141131_add_reseller_balance_pop_balance_to_billpayments',4),(48,'2021_05_09_004205_create_user_pop',4),(49,'2021_05_09_142149_create_sub_reseller_recharge_report',5),(50,'2021_05_09_142205_create_sub_reseller_balance_log_report',5),(51,'2021_05_10_103950_create_user_log_table',6),(52,'2021_05_11_113345_add_sub_package_list_to_pops_table',7),(53,'2021_05_11_134539_add_client_id_to_user_log',8),(55,'2021_05_16_111803_add_sub_reseller_id_to_sub_reseller_balance_log_report',9),(56,'2021_05_18_115648_add_sub_package_id_to_client',10),(57,'2021_05_19_100917_create_units_table',11),(58,'2021_05_19_101513_create_suppliers_table',11),(59,'2021_05_20_102424_create_item_categories_table',11),(60,'2021_05_20_103001_create_items_table',11),(61,'2021_05_21_104723_add_assign_token_to_tokens_table',12),(62,'2021_05_21_111140_add_status_to_tokens_table',12),(63,'2021_05_22_132103_add_client_id_to_tokens_table',13),(64,'2021_05_23_120855_add_assign_user_id_to_tokens_table',14),(65,'2021_05_23_145445_add_close_user_id_to_tokens_table',14),(66,'2021_05_24_164051_create_branches_table',14),(67,'2021_05_24_165051_create_purchases_table',14),(68,'2021_05_24_165536_create_purchase_items_table',14),(69,'2021_05_27_120537_add_token_code_to_tokens_table',14),(70,'2021_05_27_135836_create_payments_table',14),(71,'2021_05_27_202817_create_requisitions_table',14),(72,'2021_05_27_203242_create_requisition_items_table',14),(73,'2021_05_27_220325_create_stock_ins_table',14),(74,'2021_05_29_104121_create_requisition_approves_table',14),(75,'2021_05_29_104457_create_requisition_approve_items_table',14),(76,'2021_05_29_104920_create_stock_outs_table',14),(77,'2021_05_29_180150_add_created_by_to_tokens_table',14),(78,'2021_05_31_135937_add_branch_id_to_requisitions_table',14),(79,'2021_05_31_140017_add_branch_id_to_purchases_table',14),(80,'2021_06_08_113715_create_session_tracks_table',15),(81,'2021_06_13_134820_create_orders_table',15),(82,'2021_07_27_114048_change_employee_table',16),(83,'2021_08_29_114912_add_name_to_incomes_table',16),(84,'2021_08_29_131456_add_name_to_expenses_table',16),(85,'2021_09_01_135104_create_income_heads_table',16),(86,'2021_09_01_142619_create_expense_heads_table',16),(87,'2021_09_01_145740_add_income_head_to_incomes_table',16),(88,'2021_09_01_154641_add_expense_head_to_expenses_table',16),(89,'2021_09_22_125726_create_check_expire_table',16),(90,'2021_09_23_230016_create_client_view',16),(91,'2021_09_25_122743_update_clients_table',16),(92,'2021_10_16_122427_add_building_no_field_to_clientsinfo_table',17),(93,'2021_10_21_163006_create_user_accountings_table',18),(94,'2021_10_23_111406_add_field_to_users_table',18),(95,'2021_10_23_171843_add_login_fields_to_users_table',18),(96,'2021_10_24_152721_add_field_to_resellers_table',18),(97,'2021_10_25_152713_add_field_to_packages_table',18),(98,'2021_10_25_153014_add_field_to_sub_packages_table',18),(99,'2021_10_25_154255_create_reseller_commission_reference_table',18),(100,'2021_10_25_154307_create_sub_reseller_commission_reference_table',18),(101,'2021_10_25_172243_change_sub_reseller_commission_reference_table',18),(102,'2021_10_27_105300_add_field_to_sub_reseller_commission_reference_table',19),(103,'2021_10_27_105908_add_field_to_reseller_commission_reference_table',19),(104,'2021_10_27_140820_add_field_to_user_log_details_table',19),(105,'2021_10_27_151358_drop_os_from_user_log_details_table',19),(106,'2021_10_27_151722_add_device_info_to_user_log_details_table',19),(107,'2021_10_31_124730_add_field_users_table',20),(108,'2021_10_31_142500_create_user_balance_recharge_histories_table',20),(109,'2021_10_31_164714_create_user_balance_log_histories_table',20),(110,'2021_11_03_121237_add_field_to_user_accountings_table',20),(111,'2021_11_08_111357_add_type_to_user_accountings_table',20),(112,'2021_11_08_111635_change_user_accountings_table',20),(113,'2021_11_08_135213_create_fund_transfers_table',20),(114,'2021_11_09_155926_add_user_accounting_to_users_table',20),(115,'2021_11_11_101925_add_field_in_fund_transfer_table',20),(116,'2021_11_22_213617_add_field_in_clientsinfo_table',21),(117,'2021_11_24_144955_add_field_in_reseller_commission_reference_table',21),(118,'2021_11_27_144716_change_column_name_in_bill_generates_table',21),(119,'2021_11_27_171237_add_column_to_bill_payments_table',21),(120,'2021_11_28_140106_add_column_to_expenses_table',21),(121,'2021_11_28_141601_add_column_to_employees_table',21),(122,'2021_12_01_192048_add_column_to_reseller_recharge_report_table',22),(123,'2021_12_09_142152_add_column_to_clients_table',23),(124,'2021_12_10_231350_add_column_to_bill_payment_table',23),(125,'2021_12_11_143428_add_column_to_reseller_recharge_reports_table',24),(126,'2021_12_19_231247_create_global_settings_table',25),(127,'2021_12_19_231654_change_column_in_incomes_table',25),(128,'2021_12_20_234450_create_bkash_payments_table',25),(129,'2021_12_23_063021_add_soft_delete_column_to_clients_table',26),(130,'2021_12_23_072409_add_statusmessage_column_to__bkash_payments_table',26),(131,'2022_01_05_224722_add_unique_column_to_clients_table',27),(132,'2022_01_07_203300_create_areas_table',27),(133,'2022_01_08_171054_create_reseller_areas_table',28),(134,'2022_01_23_221506_create_customer_balance_adjustment_table',29),(135,'2022_02_14_105409_add_serial_no_to_items_table',30),(136,'2022_02_14_140045_create_serial_numbers_table',30),(137,'2022_02_20_111416_create_item_returns_table',30),(138,'2022_02_20_141701_create_item_return_items_table',30),(139,'2022_02_22_111322_add_purchase_approve_status_to_purchase_table',30),(140,'2022_02_22_161636_create_stock_adjustment_types_table',30),(141,'2022_02_22_162927_create_stock_adjustments_table',30),(142,'2022_02_22_163333_create_stock_adjustment_items_table',30),(143,'2022_03_24_111541_add_column_to_pops_table',31),(144,'2022_04_07_095427_create_sms_apis_table',32),(145,'2022_04_12_170133_create_company_information_table',33),(146,'2022_04_16_104521_create_sms_settings_table',34),(147,'2022_04_16_124020_add_pop_id_to_reseller_areas_table',34),(148,'2022_04_19_105247_add_payment_dade_line_to_clients_table',34),(149,'2022_04_23_105917_create_customer_del_infos_table',34),(150,'2022_04_23_114800_add_username_to_customer_del_infos_table',34),(151,'2022_04_23_163058_add_created_by_cliens_to_tokens_table',34),(152,'2022_04_25_153313_add_token_to_clients_table',34),(153,'2022_05_07_113505_add_app_key_type_to_clients_table',34),(154,'2022_05_08_102043_add_customer_msisdn_to_bill_payments_table',34),(155,'2022_04_18_120808_add_mikrotick_api_credential_to_nas_table',35),(156,'2022_04_25_151856_create_mikcrotik_client_lists_table',35),(157,'2022_05_11_110744_create_jobs_table',36),(158,'2022_05_21_154151_add_profile_picture_to_clientsinfo_table',37),(159,'2022_05_23_163350_add_is_active_to_users_table',38),(160,'2022_05_10_101327_add_profile_to_packages_table',39),(161,'2022_05_10_130652_add_mikrotik_connection_type_to_company_information_table',39),(162,'2022_05_10_161349_add_profile_name_to_mikcrotik_client_lists_table',39),(163,'2022_05_29_160936_add_due_amount_to_bill_generates',39),(164,'2022_05_30_103457_add_permanent_discount_to_clients_table',39),(165,'2022_05_30_110251_add_parmanent_discount_to_billgenerate_table',39),(166,'2022_05_30_152546_add_other_contact_to_clientsinfo_table',39),(167,'2022_06_06_095205_create_payment_methods_table',40),(168,'2022_06_06_114047_add_telegram_to_company_information_table',40),(169,'2022_06_15_141316_add_box_to_clientsinfos_table',41),(170,'2022_07_16_144409_create_sms_log_table',42),(171,'2022_07_16_145427_create_sms_payment_reminders_table',42),(172,'2022_07_28_000824_add_join_date_to_clientsinfo_table',43),(173,'2022_07_29_165543_change_column_type_to_sms_log_table',43),(174,'2022_07_30_122633_add_telegram_for_support_to_company_information_table',44),(175,'2022_08_08_144413_add_mobile_number_to_user_table',45),(176,'2022_08_14_125425_add_sync_time_to_company_information_table',46),(177,'2022_08_16_154528_add_max_extended_day_to_company_information_table',47),(178,'2022_08_17_122344_add_login_token_to_clients_table',48),(179,'2022_08_18_113323_create_band_providers_table',48),(180,'2022_08_18_113736_create_band_services_table',48),(181,'2022_08_18_113936_create_band_purchases_table',48),(182,'2022_08_18_130337_create_band_buy_payments_table',48),(183,'2022_08_20_115511_create_bw_customers_table',49),(184,'2022_08_21_151735_create_band_purchase_items_table',49),(185,'2022_08_21_160826_create_band_stocks_table',49),(186,'2022_08_22_160059_create_bwsales_table',49),(187,'2022_08_31_152435_create_band_sales_table',50),(188,'2022_08_31_153038_create_band_sale_items_table',50),(189,'2022_09_01_155104_add_edit_by_to_users_details_table',51),(190,'2022_09_14_153444_add_sms_column_to_pops_table',52),(191,'2022_09_19_110409_add_latitude_and_longitude_to_clients_info_table',53),(192,'2022_10_04_112913_add_comment_to_mikcrotik_client_lists',54),(193,'2022_10_06_105843_create_customer_package_change_infos_table',55),(194,'2022_10_06_155713_create_customer_billing_cycle_infos_table',55),(195,'2022_10_13_102938_modify_secret_to_nas_table',56),(196,'2022_10_19_155449_add_mikrotik_column_to_radpostauth_table',57),(197,'2022_10_19_102454_add_assign_time_close_time_to_token_table',58),(198,'2022_10_19_145534_create_token_notes_table',58),(199,'2022_10_20_140141_add_null_to_slug_and_code_to_items_table',58),(200,'2022_10_22_114224_add_billing_no_and_technical_or_support_no_to_company_information_table',59),(201,'2022_10_22_122513_create_email_settings_table',59),(202,'2022_10_23_140028_add_slider_not_to_company_information_table',59),(203,'2022_10_23_160330_add_column_to_bill_generates_table',59),(204,'2022_10_24_110626_add_invoice_terms_to_company_information_table',59),(205,'2022_10_27_135314_create_mail_logs_table',59),(206,'2022_11_08_120803_create_pay_buttons_table',60),(207,'2022_11_09_113057_change_package_list_string_to_text_in_reseller_table',60),(208,'2022_11_10_165034_add_image_to_company_information_table',61),(209,'2022_11_13_162808_add_mk_ignore_check_to_users_clients',62),(210,'2022_11_24_104800_add_padi_amount_to_bill_generate_table',63),(211,'2022_11_27_153716_add_qrcode_to_customer_information',63),(212,'2022_11_29_120926_create_line_shifts_table',63),(213,'2022_12_01_120654_create_client_edit_logs_table',64),(214,'2022_12_04_120018_add_field_to_line_shifts_table',65),(215,'2022_12_06_140132_add_ignore_mk_check_company_information',66),(216,'2022_12_13_172102_add_previous_data_to_token_table',67),(217,'2022_12_17_114100_add_different_payment_url_in_company_information_table',68),(218,'2022_12_17_135017_add_mac_check_to_company_information_table',69),(219,'2022_12_24_155511_add_static_ip_to_company_information',70),(220,'2023_01_02_172249_removing_column_from_company_information',70),(221,'2023_01_09_124003_add_admin_user_to_employees_table',71),(222,'2023_01_10_173217_add_oltchange_to_clientsinfo_table',72),(223,'2023_01_12_130539_add_cat_type_to_clientsinfo_table',73),(224,'2023_01_12_173148_add_mail_type_to_clientsinfo_table',73),(225,'2023_01_12_174259_create_uddokta_pay_logs_table',73),(226,'2023_01_14_201137_add_onu_serial_to_clients_info_table',74),(227,'2023_01_17_112745_add_customer_profile_picture_to_clientsinfo_table',75),(228,'2023_01_16_130707_add_first_approval_to_clients_table',76),(229,'2023_01_18_062735_add_user_agrement_to_clientsinfo_table',77),(230,'2023_01_21_102955_change_required_colum_in_clients_table',78),(231,'2023_01_23_104831_create_log_histories_table',79),(232,'2023_01_24_185929_change_due_date_column_to_bill_generates_table',80),(233,'2023_01_25_104109_add_user_accounting_id_to_expense_table',81),(234,'2023_01_26_113405_add_online_offline_field_to_company_information_table',81),(235,'2023_01_31_115955_add_other_settings_to_company_information_table',82),(236,'2023_01_31_183229_change_column_type_in_bill_generaes_table',82),(237,'2023_02_04_132800_add_from_cable2_to_clientsinfo_table',83),(238,'2023_02_04_135343_add_settings_to_company_information_table',84),(239,'2023_02_06_112402_add_deleted_at_to_bill_generates_table',85),(240,'2023_02_08_101423_add_client_id_time_column_to_bill_generates_table',86),(241,'2023_02_08_111711_add_client_id_time_to_bill_payments_table',86),(242,'2023_02_08_115211_create_device_types_table',87),(243,'2023_02_08_121147_add_stock_reminder_contact_number_company_info',87),(244,'2023_02_08_132514_create_store_returns_table',87),(245,'2023_02_09_104052_change_column_type_to_bill_generates_table',88),(246,'2023_02_04_123031_add_column_location_to_requisitions_table',89),(247,'2023_02_04_123303_add_column_purposes_to_requisitions_table',89),(248,'2023_02_09_123558_add_payment_btn_to_company_information',90),(249,'2023_02_15_141736_add_payment_coulmn_to_reseller_recharge_report_table',91),(250,'2023_02_18_150549_create_reseller_sms_getways_table',92),(251,'2023_02_19_161803_create_reseller_sms_logs_table',93),(252,'2023_02_23_122439_add_payment_percentage_to_resellers_table',94),(253,'2023_03_21_103507_add_payment_gateway_info_to_sub_reseller_recharge_report',95),(254,'2023_03_21_112820_add_online_pop_recharge_reduction_percentage_to_pop_table',95),(255,'2023_03_21_140010_add_static_ip_status_in_microtik_client_list_table',95),(256,'2023_04_05_100604_add_is_enable_online_recharge_to_pops_table',96),(257,'2023_04_09_154524_add_expire_profile_to_company_settings_table',97),(258,'2023_04_11_112516_add_source_to_clientsinfo_table',98),(259,'2023_04_11_124135_add_source_change_to_clientsinfo_table',99),(260,'2023_04_11_124535_create_client_sources_table',99),(261,'2023_05_09_120312_create_license_check_table',100),(262,'2023_03_06_153439_create_cluster_map',101),(263,'2023_03_06_160923_create_cable_map',101),(264,'2023_03_06_161413_create_tube_map',101),(265,'2023_03_06_161738_create_fiber_map',101),(266,'2023_03_12_132508_create_device_map_table',101),(267,'2023_03_12_135721_create_port_map_table',101),(268,'2023_05_14_145455_create_splitter_map_table',101),(269,'2023_05_14_152503_create_splitter_out_table',101),(270,'2023_06_17_132105_create_onu_map_table',101),(271,'2023_07_09_182044_add_map_component_to_clientsinfo_table',101),(272,'2023_07_23_133624_add_close_at_to_clients_table',101),(273,'2023_07_31_120003_add_bandwidth_limit_to_clients_table',101),(274,'2023_07_31_160949_add_bandwidth_used_to_clients_table',101),(275,'2023_08_02_153721_add_ip_block_to_nas_table',101),(276,'2023_08_06_100409_add_speed_to_package_table',101),(277,'2023_08_08_103757_add_limite_quantity_package_bandwidth_to_package_table',101),(278,'2023_08_08_125754_add_apply_bandwidth_limit_to_clients_table',101),(279,'2023_08_08_152640_create_divisions_table',101),(280,'2023_08_08_152732_create_districts_table',101),(281,'2023_08_08_152810_create_upazilas_table',101),(282,'2023_08_08_173845_add_division_to_clientsinfo_table',101),(283,'2023_08_09_163136_create_form_settings_table',101),(284,'2023_08_12_123846_add_ethernet_port_to_clients_table',101),(285,'2023_08_12_141015_add_distribution_point_to_clients_table',101),(286,'2023_08_23_095611_create_boxes_table',101),(287,'2023_08_28_105703_add_box_to_client_table',101),(288,'2023_08_29_111332_change_assign_token_type_into_forignid_to_token_table',101),(289,'2023_08_30_112517_add_auto_deactive_to_clients_table',101),(290,'2023_09_04_102316_add_slug_to_clients_table',101),(291,'2023_09_04_162212_create_pay_bill_logs_table',101),(292,'2023_09_12_104903_create_otc_payment_logs_table',101),(293,'2023_09_13_150002_create_tj_box_table',101),(294,'2023_09_23_144407_create_api_bandwidth_usages_table',101),(295,'2023_10_07_103044_add_ssl_commerz_softwoer_implemention_status_and_comment_to_order_table',101),(296,'2023_10_08_143645_add_val_id_order_table',101),(297,'2023_10_11_125730_add_ipn_data_to_order_table',101),(298,'2023_10_14_123200_create_bankings_table',101),(299,'2023_10_15_104617_create_banking_log',101),(300,'2023_10_16_114139_create_bank_transfars_table',101),(301,'2023_10_25_170720_create_radius_logs_table',101),(302,'2023_11_02_144937_create_pgw_response_logs_table',101),(303,'2023_11_06_103001_create_nagad_ipns_table',101),(304,'2023_11_07_121653_add_default_value_to_pgw_log_table_status_is_false',101),(305,'2023_11_11_120650_add_minimum_recharge_day_to_users_table',101),(306,'2023_11_19_113024_add_table_to_employee_table',101),(307,'2023_11_20_111152_create_payrolls_table',101),(308,'2023_12_05_170300_add_btrc_package_price_to_package_table',101),(309,'2023_12_31_122552_add_landing_image_to_company_information',101),(310,'2024_01_14_134645_add_crm_status_to_client_table',101),(311,'2024_01_14_145528_create_c_r_m_logs_table',101),(312,'2024_01_17_134334_create_crm_item_units_table',101),(313,'2024_01_17_134534_create_crm_items_table',101),(314,'2024_01_20_104041_create_crm_item_returns_table',101),(315,'2024_01_20_141332_add_customer_code_to_clients_table',101),(316,'2024_01_20_141351_create_crm_item_return_logs_table',101),(317,'2024_01_23_114304_create_bkash_webhooks_table',101),(318,'2024_02_04_123600_add_customer_type_to_clients_table',101),(319,'2024_02_08_122437_add_show_crm_column_to_item_table',101),(320,'2024_02_08_130340_add_approve_status_in_item_return',101),(321,'2024_02_11_133441_add_crm_check_date_in_client_table',101),(322,'2024_02_11_141123_add_crm_check_date_in_crm_log_table',101),(323,'2024_02_13_010838_change_default_value_permanent_discount_of_client_table',101),(324,'2024_02_27_104753_add_trxid_to_bkash_webhooks_table',101),(325,'2024_02_28_153544_add_payment_id_to_reseller_commission_reference_table',101),(326,'2024_03_19_112232_add_unique_index_to_customer_accounts_table',101),(327,'2024_03_19_115954_add_unique_index_to_money_receipt_number_to_bill_payments',101),(328,'2024_03_31_104451_change_length_payment_description_to_bill_payment',101),(329,'2024_04_20_114538_create_schedule_package_changes_table',101),(330,'2024_04_24_140720_add_ping_loss_to_tokens_table',101),(331,'2024_05_01_141621_add_remote_autoreboot_to_tokens_table',101),(332,'2024_05_19_102655_add_issue_type_to_tokens_table',101),(333,'2024_05_19_152951_add_client_feedback_to_tokens_table',101),(334,'2024_05_29_174139_add_d2dactiveday_to_information_table',101),(335,'2024_05_30_160222_add_token_source_to_tokens_table',101),(336,'2024_06_03_120507_create_token_sources_table',101),(337,'2024_06_04_113209_add_reseller_balance_to_reselle_balance_log_reports_table',101),(338,'2024_06_11_112218_modify_band_purchases_table_with_current_thoght',101),(339,'2024_06_11_134936_modify_band_purchase_items_for_normalization',101),(340,'2024_06_12_144837_add_bandwith_buy_id_to_expense_table',101),(341,'2024_06_26_162140_change_in_sale_table_for_new_requirement',101),(342,'2024_07_02_143539_add_after_before_balance_to_sub_reseller_balance_log_table',101),(343,'2024_07_02_145157_add_after_balance_to_reseller_balancee_log_report_table',101),(344,'2024_07_07_135746_add_bandwithbuysale_id_to_income_table',101),(345,'2024_07_08_141248_create_odf_table',101),(346,'2024_07_08_143323_create_fiber_ports_odf_table',101),(347,'2024_07_14_140343_add_bool_to_cluster_table',101),(348,'2024_07_14_142839_add_box_id_to_clientsinfo_table',101),(349,'2024_08_15_162726_add_onu_router_info_to_client_info_table',101),(350,'2024_08_17_134357_add_free_client_to_client_table',101),(351,'2024_08_25_130529_create_thanas_table',101),(352,'2024_08_25_140643_add_upazila_to_clientsinfo_table',101),(353,'2024_09_12_112017_add_unique_id_to_reseller_balance_log_table',101),(354,'2024_09_17_151430_create_accounting_servers_table',101),(355,'2024_10_03_110502_add_payment_url_to_reseller_sms_gateway_table',101),(356,'2024_10_20_090332_add_commission_to_bill_payment_table',101),(357,'2024_10_21_105506_add_pop_id_to_reseller_recharge_balance_log',101),(358,'2024_10_21_173316_add_reseller_cost_to_sub_reseller_balance_log_report_table',101),(359,'2024_10_24_120312_create_client_registers_table',101),(360,'2024_10_27_151902_add_un_recharge_in_client_table',101),(361,'2024_10_27_155707_create_reseller_client_bill_payments_table',101),(362,'2024_10_28_120733_add_client_payment_amount_in_sub_package_table',101),(363,'2024_10_28_122224_add_client_payment_amount_in_package_table',101),(364,'2024_10_29_172713_add_customer_payment_or_not_in_reseller_rechaage_report',101),(365,'2024_11_04_162733_add_img_to_resellers_table',101),(366,'2024_11_10_113649_create_client_import_amount_reports_table',101),(367,'2024_11_18_141857_add_commission_on_reseller_balance_log_table',101),(368,'2024_11_18_142648_add_commission_on_sub_reseller_balance_log_report_table',101),(369,'2024_11_23_131703_create_olt_onu_information_table',101),(370,'2024_11_26_141925_update_olt_onu_information_table',101),(371,'2024_12_04_123226_create_payment_getway_credentials_table',101),(372,'2024_12_05_072633_add_other_to_own_time_to_client_table',101),(373,'2025_01_08_155007_add_bill_generate_id_to_bill_payment_table',101),(374,'2025_01_08_172729_create_cache_table',101),(375,'2025_01_14_144836_create_nas_profiles_table',101),(376,'2025_01_15_120834_add_bill_by_payment_date_in_setting_table',101),(377,'2025_01_19_100037_create_bkash_payment_reseller_reports_table',101),(378,'2025_01_21_130847_add_experity_check_to_clients_table',101),(379,'2025_02_16_151705_add_primary_key_to_password_resets',101),(380,'2025_02_16_151731_add_primary_key_to_pop_user',101),(381,'2025_02_16_151752_add_primary_key_to_reseller_user',101),(382,'2025_03_03_132323_add_amount_limit_to_expenses_table',101),(383,'2025_03_12_104437_create_online_payment_getway_tokens_table',101),(384,'2025_03_15_121705_add_commission_percentage_to_reseller_balance_log',101),(385,'2025_03_15_122519_add_commission_percentage_to_reseller_table',101),(386,'2025_03_15_122631_add_commission_percentage_to_pop_table',101),(387,'2025_03_22_112443_create_olt_infos_table',101),(388,'2025_03_22_152856_add_min_amount_to_company_information_table',101),(389,'2025_03_25_124028_change_phone_no_to_band_providers_table',101),(390,'2025_04_15_122611_create_reseller_bill_generates_table',101),(391,'2025_04_15_125125_add_customer_account_balance_for_reseller_client_to_client_amount',101),(392,'2025_04_15_134009_create_reseller_bill_payments_table',101),(393,'2025_04_19_110902_have_salary_amount_to_payroll_table',101),(394,'2025_04_19_113955_create_employee_payments_table',101),(395,'2025_04_26_161433_added_by_add_to_billgenerate_table',101),(396,'2025_04_26_173522_create_client_summaries_table',101);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mikcrotik_client_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mikcrotik_client_lists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `username` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `profile_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mk_comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `disable_status` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `static_ip` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=382 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mikcrotik_client_lists` WRITE;
/*!40000 ALTER TABLE `mikcrotik_client_lists` DISABLE KEYS */;
INSERT INTO `mikcrotik_client_lists` VALUES (1,'babu_flb','babu_flb','2025-05-04 11:49:25','2025-05-04 11:49:25','20Mbps','','no',''),(2,'hafijur_engr','hafijur_engr','2025-05-04 11:49:25','2025-05-04 11:49:25','20Mbps','','no',''),(3,'rajin_gv.4','rajin_gv.4','2025-05-04 11:49:26','2025-05-04 11:49:26','50Mbps','','no',''),(4,'rana_mow','rana_mow','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(5,'tanhim_flb','tanhim_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(6,'proma_sb','proma_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(7,'ananda_ngb','ananda_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','50Mbps','','no',''),(8,'anik_mohz','anik_mohz','2025-05-04 11:49:26','2025-05-04 11:49:26','40Mbps','','no',''),(9,'rahul_mohz','rahul_mohz','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(10,'salauddin_yakubali','salauddin_yakubali','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(11,'montu_ngb','montu_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(12,'pinto_ngb','pinto_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(13,'shajib_engr','shajib_engr','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(14,'diponkor_mohz','diponkor_mohz','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(15,'liton_tf','liton_tf','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(16,'nasir_ngb','nasir_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(17,'tabassum_yakubali','tabassum_yakubali','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(18,'emran_flb','emran_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','40Mbps','','no',''),(19,'sazzad_tf','sazzad_tf','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(20,'sorowar_flb','sorowar_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(21,'haque_mdc','haque_mdc','2025-05-04 11:49:26','2025-05-04 11:49:26','50Mbps','','no',''),(22,'israt_ngb','israt_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(23,'abu_ngb','abu_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(24,'shadiqur_sb','shadiqur_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(25,'shojib_gv','shojib_gv','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(26,'rukhsana_ts','rukhsana_ts','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(27,'emon_flb','emon_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','40Mbps','','no',''),(28,'parvin_gv','parvin_gv','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(29,'mezbaul_chu','mezbaul_chu','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(30,'ashik_gv','ashik_gv','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(31,'afsar_ngb','afsar_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(32,'mahbub_barq','mahbub_barq','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(33,'nipu_ngb','nipu_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(34,'tahina_mow','tahina_mow','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(35,'kumar_sb','kumar_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(36,'shahid_ngb','shahid_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(37,'nusrat_sb','nusrat_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(38,'farid_mow','farid_mow','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(39,'shilpi_sb','shilpi_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','40Mbps','','no',''),(40,'jahirul_chnm','jahirul_chnm','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(41,'begum_flb','begum_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(42,'imtiaj_noy','imtiaj_noy','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(43,'ripon_yakubali','ripon_yakubali','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(44,'nazim_mow','nazim_mow','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(45,'yousuf_pan','yousuf_pan','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(46,'tohidul2_flb','tohidul2_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(47,'firoza_ngb','firoza_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(48,'alam_flb','alam_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(49,'enamul_chnm','enamul_chnm','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(50,'nandan_mohz','nandan_mohz','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(51,'rabby_noy','rabby_noy','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(52,'solaman_ts','solaman_ts','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(53,'islam_pat','islam_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(54,'kar_pat','kar_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(55,'joshim_nz','joshim_nz','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(56,'muzibur_gv','muzibur_gv','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(57,'rasel_nz','rasel_nz','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','yes',''),(58,'zayn_hm','zayn_hm','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(59,'yousufe_sb','yousufe_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(60,'salim_ts','salim_ts','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(61,'rashed','rashed','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(62,'alam_nz','alam_nz','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(63,'fatema_shy','fatema_shy','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(64,'jarna_nz','jarna_nz','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(65,'rahim_ts','rahim_ts','2025-05-04 11:49:26','2025-05-04 11:49:26','40Mbps','','no',''),(66,'rahman_fok','rahman_fok','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(67,'rahman_flb','rahman_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(68,'kashem_ngb','kashem_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(69,'ruma_gv','ruma_gv','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(70,'fatema_ngb','fatema_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(71,'montu2_ngb','montu2_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(72,'jahed_pc','jahed_pc','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(73,'muslim_ngb','muslim_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(74,'salman_dp','salman_dp','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(75,'bismillah_sb','bismillah_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','40Mbps','','no',''),(76,'mamun_noy','mamun_noy','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(77,'amit_noy','amit_noy','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(78,'rashid_sb','rashid_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(79,'nasir_bos','nasir_bos','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(80,'islam_ngb','islam_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(81,'asraf_and','asraf_and','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(82,'salauddin_pc','salauddin_pc','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(83,'kabir_ngb','kabir_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(84,'alam_noy','alam_noy','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(85,'abdul_ngb','abdul_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(86,'rupali_ngb','rupali_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(87,'shamim_pat','shamim_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(88,'rahman_sb','rahman_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(89,'yesmin_shy','yesmin_shy','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(90,'liakot_nz','liakot_nz','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(91,'afzal_flb','afzal_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(92,'arosh_chnm','arosh_chnm','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','yes',''),(93,'manik_l','manik_l','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(94,'monir_pat','monir_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(95,'lavly_chnm','lavly_chnm','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(96,'shahedul_bos','shahedul_bos','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(97,'sankor_mohz','sankor_mohz','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(98,'hosain_ts','hosain_ts','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(99,'sayed_shy','sayed_shy','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(100,'obaydul_and','obaydul_and','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','yes',''),(101,'kuddus_pat','kuddus_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(102,'alif_noy','alif_noy','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','yes',''),(103,'anower_pat','anower_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(104,'nasir_ts','nasir_ts','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(105,'sarker_chnm','sarker_chnm','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(106,'niaz_sb','niaz_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','50Mbps','','no',''),(107,'badal_bos','badal_bos','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(108,'morshed_ngb','morshed_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(109,'morshed_chnm','morshed_chnm','2025-05-04 11:49:26','2025-05-04 11:49:26','40Mbps','','no',''),(110,'morshed_fok','morshed_fok','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(111,'roni_ts','roni_ts','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(112,'saad','saad','2025-05-04 11:49:26','2025-05-04 11:49:26','5Mbps','','no',''),(113,'sumaiya_flb','sumaiya_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(114,'saiful_ngb','saiful_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(115,'jabed_nz','jabed_nz','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(116,'saiful_sb','saiful_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(117,'aziz_gv','aziz_gv','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(118,'madrasha_ngb','madrasha_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(119,'sakib_ts','sakib_ts','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(120,'rifat_pat','rifat_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','40Mbps','','no',''),(121,'azam_ngb','azam_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','40Mbps','','no',''),(122,'yousuf_gv','yousuf_gv','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(123,'elias_mow','elias_mow','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(124,'osman_pat','osman_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(125,'mithun_pat','mithun_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(126,'bhuiya_flb','bhuiya_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(127,'rahaman_and','rahaman_and','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(128,'shamima_chnm','shamima_chnm','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(129,'salim_mow','salim_mow','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(130,'faisal_mow','faisal_mow','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(131,'amina_noy','amina_noy','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(132,'sayadgmxr','sayadgmxr','2025-05-04 11:49:26','2025-05-04 11:49:26','Ovpn Real IP','','no',''),(133,'begum_engr','begum_engr','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(134,'hasan_pat','hasan_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(135,'hasan_l','hasan_l','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(136,'enamul_bow','enamul_bow','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(137,'debashis_pc','debashis_pc','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(138,'sakil_dp','sakil_dp','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(139,'rahela_bos','rahela_bos','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(140,'imran_shy','imran_shy','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(141,'pinto_mow','pinto_mow','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(142,'rani_sb','rani_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(143,'iqbal_gv','','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(144,'iqbal2_gv','','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(145,'saikat_pc','saikat_pc','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(146,'taslima_engr','taslima_engr','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(147,'kolirani_sb','kolirani_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(148,'azad','azad','2025-05-04 11:49:26','2025-05-04 11:49:26','50Mbps','','no',''),(149,'office test router 1','office test router 1','2025-05-04 11:49:26','2025-05-04 11:49:26','50Mbps','','no',''),(150,'office test router 2','office test router 2','2025-05-04 11:49:26','2025-05-04 11:49:26','50Mbps','','no',''),(151,'royalbengal_pc','royalbengal_pc','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(152,'bappi_ngb','bappi_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(153,'enamul_pc','enamul_pc','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','yes',''),(154,'enamul2_chnm','enamul2_chnm','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(155,'mizan_bos','mizan_bos','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(156,'alam_bos','alam_bos','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(157,'emdadullah_chnm','emdadullah_chnm','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(158,'abdul_chnm','abdul_chnm','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(159,'shahin_gvr9@','shahin_gvr9@','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','BCO','no',''),(160,'khokon_ngb','khokon_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(161,'murad_chnm','murad_chnm','2025-05-04 11:49:26','2025-05-04 11:49:26','50Mbps','','no',''),(162,'ibrahim_pat','ibrahim_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(163,'imam_nz','imam_nz','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(164,'nayan_mohz','nayan_mohz','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(165,'zahid_tmpl','zahid_tmpl','2025-05-04 11:49:26','2025-05-04 11:49:26','50Mbps','','no',''),(166,'azad_chnm','azad_chnm','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','azad_chnm |  | ','no',''),(167,'airin_pat','airin_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(168,'nasim_tmpl','nasim_tmpl','2025-05-04 11:49:26','2025-05-04 11:49:26','50Mbps','','no',''),(169,'sakib_tmpl','sakib_tmpl','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(170,'prashanta_chu','prashanta_chu','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','yes',''),(171,'mostopha_ngb','mostopha_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(172,'alam2_pc','alam2_pc','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(173,'shahed_tmpl','shahed_tmpl','2025-05-04 11:49:26','2025-05-04 11:49:26','50Mbps','','no',''),(174,'saiful_engr','saiful_engr','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(175,'joshim_ngb','joshim_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(176,'ali_pat','ali_pat','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(177,'didar_noy','didar_noy','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(178,'sujan_bos','sujan_bos','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(179,'tanvir_pat_sp3','tanvir_pat_sp3','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(180,'mazharul_nz','mazharul_nz','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(181,'riaz_sb','riaz_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(182,'alam2_nz','alam2_nz','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(183,'safikur_nz','safikur_nz','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(184,'polash_chnm_s4','polash_chnm_s4','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(185,'sabrina_bos_sp3','sabrina_bos_sp3','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(186,'alauddin_bos_s4','alauddin_bos_s4','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(187,'litan_gv','litan_gv','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','litan_gv','no',''),(188,'emon_gv','emon_gv','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(189,'fatema_yakubali','fatema_yakubali','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(190,'ehsan_flb','ehsan_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(191,'tarif_gv','tarif_gv','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(192,'manir_noy','manir_noy','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(193,'akash_ngb','akash_ngb','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(194,'manir2_noy','manir2_noy','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(195,'rezaul_flb','rezaul_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(196,'moyna_sb','moyna_sb','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(197,'office test router 3','office test router 3','2025-05-04 11:49:26','2025-05-04 11:49:26','50Mbps','','no',''),(198,'hossain_engr','hossain_engr','2025-05-04 11:49:26','2025-05-04 11:49:26','20Mbps','','no',''),(199,'Ttamimtraders','Ttamimtraders','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(200,'azad_flb','azad_flb','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(201,'hossen_chnm_sp5','hossen_chnm_sp5','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(202,'soneya_tmpl','soneya_tmpl','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(203,'sayem_engr','sayem_engr','2025-05-04 11:49:26','2025-05-04 11:49:26','40Mbps','','no',''),(204,'kamruzzaman_nz','kamruzzaman_nz','2025-05-04 11:49:26','2025-05-04 11:49:26','30Mbps','','no',''),(205,'sukanta_and','sukanta_and','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(206,'ahmed_and','ahmed_and','2025-05-04 11:49:26','2025-05-04 11:49:26','25Mbps','','no',''),(207,'echa','echa','2025-05-04 11:49:26','2025-05-04 11:49:26','10Mbps','','no',''),(208,'joynal_bos_sp1','joynal_bos_sp1','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','','yes',''),(209,'rahman_bos_sp1','rahman_bos_sp1','2025-05-04 11:49:27','2025-05-04 11:49:27','25Mbps','','yes',''),(210,'mdrakib_ov','mdrakib_ov','2025-05-04 11:49:27','2025-05-04 11:49:27','Ovpn Real IP','','no',''),(211,'iqbal_dp','iqbal_dp','2025-05-04 11:49:27','2025-05-04 11:49:27','25Mbps','','no',''),(212,'azad_yakubali','azad_yakubali','2025-05-04 11:49:27','2025-05-04 11:49:27','40Mbps','','no',''),(213,'amit_shy','amit_shy','2025-05-04 11:49:27','2025-05-04 11:49:27','40Mbps','','no',''),(214,'salauddin_ngb','salauddin_ngb','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','','no',''),(215,'ibrahim_flb','ibrahim_flb','2025-05-04 11:49:27','2025-05-04 11:49:27','40Mbps','','no',''),(216,'hossen_gv','hossen_gv','2025-05-04 11:49:27','2025-05-04 11:49:27','25Mbps','','no',''),(217,'arman_l','arman_l','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','','yes',''),(218,'bhuiya_ngb','bhuiya_ngb','2025-05-04 11:49:27','2025-05-04 11:49:27','50Mbps','','yes',''),(219,'jahirul_pan','jahirul_pan','2025-05-04 11:49:27','2025-05-04 11:49:27','25Mbps','','no',''),(220,'amit_ngb','amit_ngb','2025-05-04 11:49:27','2025-05-04 11:49:27','25Mbps','','no',''),(221,'fokrul_nz','fokrul_nz','2025-05-04 11:49:27','2025-05-04 11:49:27','25Mbps','','no',''),(222,'kamal_pc','kamal_pc','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','','no',''),(223,'moyna_tf','moyna_tf','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','','no',''),(224,'Timon','Timon','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','','no',''),(225,'rana_bos','rana_bos','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','','no',''),(226,'rubel_nz','rubel_nz','2025-05-04 11:49:27','2025-05-04 11:49:27','25Mbps','','yes',''),(227,'afsar_ts','afsar_ts','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','','no',''),(228,'munna_chnm','munna_chnm','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','','no',''),(229,'greencity_gv','greencity_gv','2025-05-04 11:49:27','2025-05-04 11:49:27','20Mbps','','no',''),(230,'Si102','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(231,'Si103','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(232,'Si104','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(233,'Si105','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(234,'Si106','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(235,'Si107','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(236,'Si110','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(237,'Si111','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(238,'Si114','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(239,'Si119','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(240,'Si120','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(241,'Si121','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(242,'Si122','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(243,'Si123','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(244,'Si124','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(245,'Si125','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(246,'Si128','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(247,'Si130','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(248,'Si131','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(249,'Si135','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(250,'Si136','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(251,'Si144','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(252,'Si145','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(253,'Si146','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(254,'Si147','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(255,'Si148','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(256,'Si150','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(257,'Si153','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(258,'Si155','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(259,'Si157','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(260,'Si159','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(261,'Si161','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(262,'Si162','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(263,'Si163','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(264,'Si164','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(265,'Si166','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(266,'Si168','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(267,'Si171','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(268,'Si172','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(269,'Si178','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(270,'Si182','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(271,'Si183','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(272,'Si185','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(273,'Si186','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(274,'Si187','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(275,'Si188','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(276,'Si193','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(277,'Si194','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(278,'Si196','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(279,'Si197','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(280,'Si1003','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(281,'Si1005','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(282,'Si1006','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(283,'Si1008','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(284,'Si154','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','20Mbps','ekram','no',''),(285,'Si100','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','20Mbps','ekram','no',''),(286,'Si151','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','15Mbps','ekram','no',''),(287,'Si184','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','15Mbps','ekram','no',''),(288,'Si108','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(289,'Si109','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(290,'Si112','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(291,'Si113','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(292,'Si115','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(293,'Si118','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(294,'Si126','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(295,'Si127','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(296,'Si129','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(297,'Si132','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(298,'Si133','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(299,'Si134','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(300,'Si138','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(301,'Si139','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(302,'Si140','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(303,'Si141','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(304,'Si142','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(305,'Si143','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(306,'Si152','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(307,'Si158','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(308,'Si160','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(309,'Si165','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(310,'Si167','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(311,'Si170','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(312,'Si173','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(313,'Si174','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(314,'Si177','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(315,'Si180','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(316,'Si181','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(317,'Si189','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','yes',''),(318,'Si1012','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(319,'Si191.','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(320,'Si1002','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(321,'Si1004','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(322,'Si1007','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(323,'hossan_engr','hossan_engr','2025-05-04 11:49:27','2025-05-04 11:49:27','40Mbps','','no',''),(324,'fardin_alonk','fardin_alonk','2025-05-04 11:49:27','2025-05-04 11:49:27','20Mbps','','no',''),(325,'foysal_chnm_sp1','foysal_chnm_sp1','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','','no',''),(326,'Si1010','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(327,'Si1011','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(328,'Si1009','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','no',''),(329,'Si190.','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(330,'Si192','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','ekram','no',''),(331,'Si149','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','ekram','yes',''),(332,'anowara_ngb','anowara_ngb','2025-05-04 11:49:27','2025-05-04 11:49:27','5Mbps','','no',''),(333,'ariful_clgr','ariful_clgr','2025-05-04 11:49:27','2025-05-04 11:49:27','20Mbps','','no',''),(334,'Si000','Si000','2025-05-04 11:49:27','2025-05-04 11:49:27','50Mbps','ekram','no',''),(335,'ASK101','ASK101','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(336,'ASK107','ASK107','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(337,'ASK108','ASK108','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(338,'ASK109','ASK109','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(339,'ASK110','ASK110','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(340,'ASK111','ASK111','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(341,'ASK112','ASK112','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(342,'ASK113','ASK113','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(343,'ASK114','ASK114','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(344,'ASK115','ASK115','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(345,'ASK116','ASK116','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(346,'ASK117','ASK117','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(347,'ASK118','ASK118','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(348,'ASK119','ASK119','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(349,'ASK120','ASK120','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(350,'ASK121','ASK121','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(351,'ASK122','ASK122','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(352,'ASK123','ASK123','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(353,'ASK124','ASK124','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(354,'ASK125','ASK125','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(355,'ASK126','ASK126','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(356,'ASK127','ASK127','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(357,'ASK128','ASK128','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(358,'ASK129','ASK129','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(359,'ASK130','ASK130','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(360,'ASK131','ASK131','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(361,'ASK132','ASK132','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(362,'ASK133','ASK133','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(363,'ASK134','ASK134','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(364,'ASK135','ASK135','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(365,'ASK136','ASK136','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(366,'ASK137','ASK137','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(367,'ASK138','ASK138','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(368,'ASK139','ASK139','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(369,'ASK140','ASK140','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(370,'ASK102','ASK102','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(371,'ASK103','ASK103','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(372,'ASK104','ASK104','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(373,'ASK105','ASK105','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(374,'ASK106','ASK106','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(375,'01897837696','837696','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(376,'01870676918','676918','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(377,'01871851182','851182','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','akash','no',''),(378,'Si101','ksh412','2025-05-04 11:49:27','2025-05-04 11:49:27','30Mbps','ekram','no',''),(379,'mala_chnm_sp5','mala_chnm_sp5','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','','no',''),(380,'redoy_gv','redoy_gv','2025-05-04 11:49:27','2025-05-04 11:49:27','25Mbps','','no',''),(381,'jalal__ngb_sp1','jalal__ngb_sp1','2025-05-04 11:49:27','2025-05-04 11:49:27','10Mbps','','no','');
/*!40000 ALTER TABLE `mikcrotik_client_lists` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_roles` (
  `role_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\Models\\User',1),(1,'App\\Models\\User',2),(1,'App\\Models\\User',3),(12,'App\\Models\\User',4);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `nagad_ipns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `nagad_ipns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `callback_response` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('Success','Failed') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `nagad_ipns` WRITE;
/*!40000 ALTER TABLE `nagad_ipns` DISABLE KEYS */;
/*!40000 ALTER TABLE `nagad_ipns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `nas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `nas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nasname` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shortname` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'other',
  `ports` int DEFAULT NULL,
  `secret` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'secret',
  `server` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `community` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'RADIUS Client',
  `mikrotick_user` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mikrotick_user_password` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mikrotick_port` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ip_block` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `nasname` (`nasname`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `nas` WRITE;
/*!40000 ALTER TABLE `nas` DISABLE KEYS */;
INSERT INTO `nas` VALUES (1,'103.20.243.49','Access 1','other',NULL,NULL,NULL,NULL,'1009','yetfix','Admin111222#','8728',NULL);
/*!40000 ALTER TABLE `nas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `nas_profiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `nas_profiles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `profile_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mk_info` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `nas_profiles` WRITE;
/*!40000 ALTER TABLE `nas_profiles` DISABLE KEYS */;
/*!40000 ALTER TABLE `nas_profiles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `odf`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `odf` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remarks` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cluster_id` bigint unsigned NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'odf',
  `odf_type` enum('wall_mount','rack_mount','floor_mount','pole_mount') COLLATE utf8mb4_unicode_ci NOT NULL,
  `rows` int NOT NULL,
  `columns` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `odf` WRITE;
/*!40000 ALTER TABLE `odf` DISABLE KEYS */;
/*!40000 ALTER TABLE `odf` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `olt_infos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `olt_infos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `olt_address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `community` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `olt_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vlan_mac` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `onu_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `onu_interface_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `onu_laser` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `port` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `olt_company` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `olt_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `olt_infos` WRITE;
/*!40000 ALTER TABLE `olt_infos` DISABLE KEYS */;
/*!40000 ALTER TABLE `olt_infos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `olt_onu_information`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `olt_onu_information` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `oltaddress` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `oltName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `onuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mac` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `Vlan` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `interface` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `laser` int DEFAULT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `olt_onu_information_mac_unique` (`mac`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `olt_onu_information` WRITE;
/*!40000 ALTER TABLE `olt_onu_information` DISABLE KEYS */;
/*!40000 ALTER TABLE `olt_onu_information` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `online_payment_getway_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `online_payment_getway_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_gateway` enum('bkash','nagad','rocket','upay') COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `online_payment_getway_tokens` WRITE;
/*!40000 ALTER TABLE `online_payment_getway_tokens` DISABLE KEYS */;
INSERT INTO `online_payment_getway_tokens` VALUES (1,'bkash','eyJraWQiOiJvTVJzNU9ZY0wrUnRXQ2o3ZEJtdlc5VDBEcytrckw5M1NzY0VqUzlERXVzPSIsImFsZyI6IlJTMjU2In0.eyJzdWIiOiJlODNlMDkwMC1jY2ZmLTQzYTctODhiNy0wNjE5NDJkMTVmOTYiLCJhdWQiOiI2cDdhcWVzZmljZTAxazltNWdxZTJhMGlhaCIsImV2ZW50X2lkIjoiNjA0YjVjMmMtNmE3Ny00YWVkLWE5NmUtNWU5ZTkwNjY2OTBjIiwidG9rZW5fdXNlIjoiaWQiLCJhdXRoX3RpbWUiOjE3NDY0ODQ4MDcsImlzcyI6Imh0dHBzOlwvXC9jb2duaXRvLWlkcC5hcC1zb3V0aGVhc3QtMS5hbWF6b25hd3MuY29tXC9hcC1zb3V0aGVhc3QtMV9yYTNuUFkzSlMiLCJjb2duaXRvOnVzZXJuYW1lIjoic2FuZGJveFRva2VuaXplZFVzZXIwMiIsImV4cCI6MTc0NjQ4ODQwNywiaWF0IjoxNzQ2NDg0ODA3fQ.p8v1OuUSuo7C--gPg5wfqPS8_gj0jzeJxBv3P6j_t-XhKegPsZbB31aOxv6KrzeqA444QN5FRaDevl6i5UgFNJ6WRuPHgp3IVWeaNs_nzUV-6rGEOPm2hZ40uwgplwbuke4eMbhAqFA5d0i9ix7-5rSoQSBzN2SGY03HDUiiQx2zTY-d1xCCCYJGdVqtOob1MpB9dEa_teD-nx2GrT2C2XamXuo5b-63eshGK9FURqHOTac4d9V_AczWS0Nchp67i_DKgJH_dEtJyvizzyKg0dR3UpOXsa3E32Tp45dgp70gpWhKznsFZ3F6NghWBmBryGyCP3DQKxDcyryFzlbMhg','2025-05-04 11:40:08','2025-05-05 22:40:07');
/*!40000 ALTER TABLE `online_payment_getway_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `onu_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `onu_map` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `serial_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mac_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manufactures` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `model` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remarks` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'onu',
  `cluster_id` bigint unsigned NOT NULL,
  `cable_id` bigint unsigned DEFAULT NULL,
  `fiber_id` bigint unsigned DEFAULT NULL,
  `optical_connected_component_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `optical_connected_component_id` bigint unsigned DEFAULT NULL,
  `lan_connected_component_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lan_connected_component_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `onu_map` WRITE;
/*!40000 ALTER TABLE `onu_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `onu_map` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(8,2) DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `software_integration_status` enum('pending','processing','completed','failed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `software_integration_comment` text COLLATE utf8mb4_unicode_ci,
  `software_integration_try` decimal(8,2) NOT NULL DEFAULT '0.00',
  `post_data` longtext COLLATE utf8mb4_unicode_ci,
  `val_id` text COLLATE utf8mb4_unicode_ci,
  `ipn_data` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `orders` WRITE;
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `otc_payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `otc_payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `bill_id` bigint unsigned NOT NULL,
  `payment_id` bigint unsigned NOT NULL,
  `otc_payment` decimal(10,2) NOT NULL DEFAULT '0.00',
  `otc_discount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `otc_payment_date` datetime DEFAULT NULL,
  `employee_id` bigint unsigned DEFAULT NULL,
  `admin_user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `otc_payment_logs` WRITE;
/*!40000 ALTER TABLE `otc_payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `otc_payment_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `package_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `package_rate` decimal(10,2) NOT NULL,
  `pool_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `commission` decimal(16,2) DEFAULT NULL,
  `profile_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `speed_up` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `speed_down` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `limite_quantity` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `package_bandwidth` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `btrc_package_price` decimal(10,2) DEFAULT '0.00',
  `client_payment_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` VALUES (11,'5Mbps',300.00,'','2025-05-04 15:48:20','2025-05-04 15:48:20',NULL,'5Mbps',NULL,NULL,NULL,'0',0.00,0.00),(12,'10Mbps',400.00,'','2025-05-04 15:48:23','2025-05-04 15:48:23',NULL,'10Mbps',NULL,NULL,NULL,'0',0.00,0.00),(13,'15Mbps',450.00,'','2025-05-04 15:48:25','2025-05-04 15:48:25',NULL,'15Mbps',NULL,NULL,NULL,'0',0.00,0.00),(14,'20Mbps',500.00,'','2025-05-04 15:48:27','2025-05-04 15:48:27',NULL,'20Mbps',NULL,NULL,NULL,'0',0.00,0.00),(15,'25Mbps',550.00,'','2025-05-04 15:48:29','2025-05-04 15:48:29',NULL,'25Mbps',NULL,NULL,NULL,'0',0.00,0.00),(16,'30Mbps',600.00,'','2025-05-04 15:48:32','2025-05-04 15:48:32',NULL,'30Mbps',NULL,NULL,NULL,'0',0.00,0.00),(17,'40Mbps',700.00,'','2025-05-04 15:48:33','2025-05-04 15:48:33',NULL,'40Mbps',NULL,NULL,NULL,'0',0.00,0.00),(18,'50Mbps',750.00,'','2025-05-04 15:48:35','2025-05-04 15:48:35',NULL,'50Mbps',NULL,NULL,NULL,'0',0.00,0.00),(19,'60Mbps',800.00,'','2025-05-04 15:48:37','2025-05-04 15:48:37',NULL,'60Mbps',NULL,NULL,NULL,'0',0.00,0.00),(20,'70Mbps',850.00,'','2025-05-04 15:48:39','2025-05-04 15:48:39',NULL,'70Mbps',NULL,NULL,NULL,'0',0.00,0.00),(21,'80Mbps',900.00,'','2025-05-04 15:48:41','2025-05-04 15:48:41',NULL,'80Mbps',NULL,NULL,NULL,'0',0.00,0.00),(22,'100Mbps',1000.00,'','2025-05-04 15:48:44','2025-05-04 15:48:44',NULL,'100Mbps',NULL,NULL,NULL,'0',0.00,0.00),(23,'5Mbps_E',240.00,'','2025-05-04 15:59:49','2025-05-04 15:59:49',NULL,'5Mbps',NULL,NULL,NULL,'0',0.00,0.00),(24,'10Mbps_E',280.00,'','2025-05-04 15:59:52','2025-05-04 15:59:52',NULL,'10Mbps',NULL,NULL,NULL,'0',0.00,0.00),(25,'15Mbps_E',340.00,'','2025-05-04 15:59:54','2025-05-04 15:59:54',NULL,'15Mbps',NULL,NULL,NULL,'0',0.00,0.00),(26,'20Mbps_E',380.00,'','2025-05-04 15:59:58','2025-05-04 15:59:58',NULL,'20Mbps',NULL,NULL,NULL,'0',0.00,0.00),(27,'30Mbps_E',480.00,'','2025-05-04 16:00:03','2025-05-04 16:00:03',NULL,'30Mbps',NULL,NULL,NULL,'0',0.00,0.00),(28,'40Mbps_E',540.00,'','2025-05-04 16:00:06','2025-05-04 16:00:06',NULL,'40Mbps',NULL,NULL,NULL,'0',0.00,0.00),(29,'50Mbps_E',0.00,'','2025-05-04 16:00:09','2025-05-04 16:00:09',NULL,'50Mbps',NULL,NULL,NULL,'0',0.00,0.00),(30,'60Mbps_E',580.00,'','2025-05-04 16:00:12','2025-05-04 16:00:12',NULL,'60Mbps',NULL,NULL,NULL,'0',0.00,0.00),(31,'70Mbps_E',600.00,'','2025-05-04 16:00:14','2025-05-04 16:00:14',NULL,'70Mbps',NULL,NULL,NULL,'0',0.00,0.00),(32,'80Mbps_E',700.00,'','2025-05-04 16:00:15','2025-05-04 16:00:15',NULL,'80Mbps',NULL,NULL,NULL,'0',0.00,0.00),(33,'100Mbps_E',900.00,'','2025-05-04 16:00:17','2025-05-04 16:00:17',NULL,'100Mbps',NULL,NULL,NULL,'0',0.00,0.00),(34,'10Mbps_A',220.00,'10Mbps','2025-05-04 16:03:26','2025-05-04 16:04:13',0.00,'10Mbps','0','0',NULL,'0',0.00,0.00),(35,'15Mbps_A',220.00,'','2025-05-04 16:04:19','2025-05-04 16:04:19',NULL,'15Mbps',NULL,NULL,NULL,'0',0.00,0.00),(36,'20Mbps_A',220.00,'20Mbps','2025-05-04 16:04:27','2025-05-04 16:04:58',0.00,'20Mbps','0','0',NULL,'0',0.00,0.00),(37,'25Mbps_A',220.00,'','2025-05-04 16:04:42','2025-05-04 16:04:42',NULL,'25Mbps',NULL,NULL,NULL,'0',0.00,0.00),(38,'30Mbps_A',220.00,'30Mbps','2025-05-04 16:05:15','2025-05-04 16:05:25',0.00,'30Mbps','0','0',NULL,'0',0.00,0.00);
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pay_bill_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pay_bill_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `trxn_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_id` bigint unsigned DEFAULT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `status` enum('Success','Failed') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error_message` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pay_bill_logs` WRITE;
/*!40000 ALTER TABLE `pay_bill_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pay_bill_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pay_buttons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pay_buttons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pay_buttons` WRITE;
/*!40000 ALTER TABLE `pay_buttons` DISABLE KEYS */;
/*!40000 ALTER TABLE `pay_buttons` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payment_getway_credentials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_getway_credentials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` int NOT NULL,
  `getway_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `appkey_publickey` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `secretkey_privatekey` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `username_merchantid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password_merchantnumber` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `callback_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `base_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payer_reference` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payment_getway_credentials` WRITE;
/*!40000 ALTER TABLE `payment_getway_credentials` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_getway_credentials` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payment_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_methods` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `api_key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('Active','Inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payment_methods` WRITE;
/*!40000 ALTER TABLE `payment_methods` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_methods` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `amount` double(15,2) DEFAULT NULL,
  `cheque_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `branch_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `purchase_id` bigint unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payments_purchase_id_foreign` (`purchase_id`),
  CONSTRAINT `payments_purchase_id_foreign` FOREIGN KEY (`purchase_id`) REFERENCES `purchases` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `payrolls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payrolls` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `employee_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `salary` int NOT NULL,
  `home_allowance` int NOT NULL,
  `transport_allowance` int NOT NULL,
  `other_allowance` int NOT NULL,
  `bonous` int NOT NULL,
  `deduction` int NOT NULL,
  `net_salary` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `salary_amount` int DEFAULT NULL,
  `remark` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `payrolls` WRITE;
/*!40000 ALTER TABLE `payrolls` DISABLE KEYS */;
/*!40000 ALTER TABLE `payrolls` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `status` enum('disable','enable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=541 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (2,'user-registration','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(3,'password-change','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(4,'user-logout','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(5,'assign-permission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(6,'assign-permission-role','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(7,'assign-role','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(8,'assign-user-role','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(9,'user_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(10,'permission_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(11,'permission_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(12,'permission_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(13,'permission_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(14,'permission_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(15,'permission_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(16,'role_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(17,'role_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(18,'role_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(19,'role_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(20,'role_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(21,'role_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(22,'pop_box','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(23,'box_switch','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(24,'pop_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(25,'pop_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(26,'pop_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(27,'pop_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(28,'box_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(29,'box_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(30,'box_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(31,'box_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(32,'box_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(33,'box_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(34,'switch_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(35,'switch_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(36,'switch_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(37,'connection-request','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(38,'connection-request-list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(39,'port-assignment','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(40,'customer-support','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(41,'close-token','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(42,'TokenByPOP','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(43,'assign-token','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(44,'customer-info','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(45,'customer-summary','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(46,'customer-contact-details','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(47,'customer-technical-details','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(48,'customer-token-details','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(49,'TokenById','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(50,'pop-name','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(51,'token-category','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(52,'token-code','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(53,'connection-history','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(54,'manage-connection','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(55,'customer-accounts','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(56,'customer-rating','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(57,'new-token','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(58,'update-token','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(59,'delete-token','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(60,'new_connection_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(61,'new_connection_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(62,'home','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(63,'admin-token-close','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(64,'support-token-close','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(65,'accounts-token-close','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(66,'package-id','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(67,'monthly-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(68,'token-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(69,'token-search','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(70,'employee_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(71,'employee_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(72,'employee_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(73,'employee_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(74,'employee_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(75,'employee_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(76,'nc-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(77,'requisition_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(78,'requisition_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(79,'money-receipt-entry','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(80,'money-receipt-entry-admin','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(81,'discount','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(82,'ip-bill','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(83,'get-customer-info','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(84,'payment-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(85,'billing-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(86,'bill-sheet','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(87,'print-bill','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(88,'bill-sheet-pdf','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(89,'generate-bill','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(90,'generate-other-bill','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(91,'single-discount','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(92,'inventory-transaction-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(93,'account-statement','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(94,'connection-search','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(95,'graph-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(96,'corporate-money-receipt-entry','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(97,'get-corporate-customer-info','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(98,'corporate-money-receipt-entry-admin','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(99,'generate-corporate-bill','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(100,'generate-corporate-other-bill','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(101,'corporate-account-statement','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(102,'corporate-print-bill','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(103,'corporate-customer-data_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(104,'corporate-customer-data_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(105,'corporate-customer-data_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(106,'corporate-customer-data_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(107,'corporate-customer-data_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(108,'corporate-customer-data_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(109,'corporate-close-customer','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(110,'reseller-recharge-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(111,'unit_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(112,'unit_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(113,'unit_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(114,'unit_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(115,'unit_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(116,'unit_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(117,'inventory-group_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(118,'inventory-group_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(119,'inventory-group_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(120,'inventory-group_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(121,'inventory-group_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(122,'inventory-group_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(123,'inventory_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(124,'inventory_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(125,'inventory_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(126,'inventory_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(127,'inventory_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(128,'inventory_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(129,'inventory-in_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(130,'inventory-in_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(131,'inventory-in_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(132,'inventory-in_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(133,'get-inventory-list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(134,'requisition_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(135,'requisition_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(136,'requisition_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(137,'requisition_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(138,'requisition_approve','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(139,'requisition_pending','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(140,'requisition_approved','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(141,'requisition_delivery','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(142,'requisition_show','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(143,'requisition_print','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(144,'supplier_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(145,'supplier_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(146,'supplier_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(147,'supplier_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(148,'supplier_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(149,'supplier_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(150,'package-permission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(151,'package_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(152,'package_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(153,'package_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(154,'package_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(155,'package_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(156,'package_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(157,'pop_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(158,'pop_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(159,'pop_exception','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(160,'reseller_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(161,'reseller_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(162,'reseller_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(163,'reseller_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(164,'reseller_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(165,'reseller_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(166,'reseller-recharge','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(167,'mikrotik_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(168,'mikrotik_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(169,'mikrotik_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(170,'mikrotik_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(171,'mikrotik_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(172,'mikrotik_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(173,'assign-package-permission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(174,'package-permission-form','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(175,'pop-exception_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(176,'company_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(177,'company_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(178,'company_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(179,'refresh','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(180,'refresh-admin','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(181,'refresh-super','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(182,'assign-user-reseller','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(183,'assign-reseller','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(184,'mac-customer_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(185,'mac-customer_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(186,'mac-customer_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(187,'mac-customer_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(188,'mac-customer_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(189,'mac-customer_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(190,'reseller-admin','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(191,'reseller-super','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(192,'get-username-availability','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(193,'get-expirity-n-cost','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(194,'customer_show','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(195,'login-attempts','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(196,'log-history','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(197,'get-expirity-n-cost-for-recharge','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(198,'changeBillCycle','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(199,'newBillCycle','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(200,'changePackage','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(201,'newPackage','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(202,'clientSummary','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(203,'onlineUser','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(204,'onlineUserDisconnection','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(205,'ledger_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(206,'ledger_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(207,'ledger_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(208,'ledger_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(209,'ledger_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(210,'ledger_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(211,'payment_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(212,'payment_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(213,'payment_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(214,'payment_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(215,'payment_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(216,'payment_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(217,'receive_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(218,'receive_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(219,'receive_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(220,'receive_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(221,'receive_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(222,'receive_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(223,'contra_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(224,'contra_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(225,'contra_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(226,'contra_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(227,'contra_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(228,'contra_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(229,'journal_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(230,'journal_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(231,'journal_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(232,'journal_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(233,'journal_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(234,'journal_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(235,'account-group_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(236,'account-group_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(237,'account-group_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(238,'account-group_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(239,'account-group_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(240,'account-group_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(241,'ledger_show','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(242,'ledger-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(243,'ledger-name','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(244,'profit_n_loss','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(245,'balance-sheet','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(246,'reseller-balance-log-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(247,'new-connection-search','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(248,'customer-search-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(249,'get-pop-list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(250,'assign-user-pop','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(251,'assign-pop','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(252,'pop-recharge','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(253,'sub-package-permission-form','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(254,'sub-package-permission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(255,'get-package-list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(256,'sub-package_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(257,'sub-package_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(258,'sub-package_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(259,'sub-package_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(260,'sub-package_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(261,'sub-package_destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(262,'reseller-sub-admin','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(263,'get-pop-package-list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(264,'money-receipt-destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(265,'corporate-money-receipt-destroy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(266,'dynamic-ip','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(267,'sub-reseller-recharge-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(268,'sub-reseller-balance-log-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(269,'mac-customer-ip','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(270,'support-manager','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(271,'accounts-manager','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(272,'customer-due','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(273,'customer-recharge','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(274,'money-receipt-search','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(275,'user_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(276,'user_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(277,'single-discount-corporate','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(278,'customer-recharge-batch','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(279,'mac-customer-close','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(280,'password-reset','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(281,'onlineUserSessionDisconnection','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(282,'admin-password-reset','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(283,'admin-password-reset-post','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(284,'get-pop-list-for-edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(285,'manual-sub-package-change','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(286,'mac-customer_show','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(287,'login-attempts-all','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(288,'export-customer-list-excel','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(289,'reseller-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(290,'corporate-connection-request','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(291,'corporate-connection-request-list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(292,'corporate-customer-support','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(293,'corporate-customer-info','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(294,'corporate-customer-summary','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(295,'corporate-customer-contact-details','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(296,'corporate-customer-technical-details','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(297,'corporate-customer-token-details','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(298,'corporate-new-token','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(299,'corporate-update-token','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(300,'corporate-delete-token','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(301,'corporate-token-category','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(302,'corporate-token-code','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(303,'corporate-manage-connection','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(304,'CorporateTokenById','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(305,'close-corporate-token','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(306,'manageCorporateConnection','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(307,'corporate-customer-accounts','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(308,'corporate-connection-history','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(309,'assign-corporate-token','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(310,'printCorporateToken','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(311,'downloadCorporateToken','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(312,'excel','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(313,'customer-list-for-BTRC','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(314,'last-month-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(315,'comment-token','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(316,'new_corporate_connection_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(317,'new_corporate_connection_update','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(318,'income-section','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(319,'expense-section','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(320,'bill-collection','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(321,'other-income','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(322,'account-head','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(323,'expense-entry','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(324,'reseller-menu-view','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(325,'customer-menu-view','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(326,'account-menu-view','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(327,'report-menu-view','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(328,'admin-menu-view','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(329,'new-customer-approve','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(330,'pending-customer','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(331,'customer-deactivated','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(332,'deactivated-customer_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(333,'newjoin','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(334,'oflineUser','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(335,'id-enable','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(336,'id-disable','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(337,'customer-delete','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(338,'customer-reactivate','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(339,'income-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(340,'expense-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(341,'extra','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(342,'income-head','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(343,'income-entry','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(344,'expense-head','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(345,'ip-pool','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(346,'show-dashboard','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(347,'show-reseller-admin','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(348,'sub-pack-commission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(349,'pack-commission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(350,'view-commission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(351,'sub-reseller-view-commission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(352,'expire-customer','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(353,'disable-customer','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(354,'active-customer','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(355,'user-balance-recharge','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(356,'fund-transfer','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(357,'show-mother-package','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(358,'show-motherpackage-rate','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(359,'cash-in-hand','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(360,'payment-discount','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(361,'show-sub-package','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(362,'show-sub-package-rate','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(363,'can-close','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(364,'reseller_area_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(365,'reseller_area_create','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(366,'customer-balance-adjust','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(367,'can-open','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(368,'paid-otc-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(369,'due-otc-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(370,'pop-disable','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(371,'search-by-package-name','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(372,'add-otc','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(373,'company-info','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(374,'sms_gateway_index','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(375,'sms_gateway_list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(376,'sms_balance','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(377,'bkash-recharge','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(378,'notification-setting','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(379,'extend-temporary-dedline','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(380,'deletedUser','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(381,'approve-local-customer','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(382,'parmanent-discount','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(383,'discount-online-all','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(384,'send-batch-sms','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(385,'sms-log','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(386,'reseller-show-in-package','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(387,'join-date-modify','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(388,'delete-generated-bill','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(389,'send-sms-from-header-search','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(390,'bulk-date-extended','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(391,'test-mikrotik','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(392,'bandwidth-buy','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(393,'bandwidth-sale','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(394,'customer-marketed-by','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(395,'otc-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(396,'customer-export','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(397,'payment-method','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(398,'commission-in-hand','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(399,'due-customer-list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(400,'token-dashboard','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(401,'bill-extended-customers','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(402,'pop-deactive','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(403,'pop-close','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(404,'edit-mother-package','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(405,'bill-generate-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(406,'dashboard-billing-info','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(407,'dashboard-counter','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(408,'sms-setting','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(409,'advanced-balance-list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(410,'client-username-edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(411,'email-setting','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(412,'view-client-password','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(413,'new-customer-billing-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(414,'line-shift','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(415,'token-note-delete','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(416,'show-package-rate','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(417,'show-pop-balance','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(418,'pop-wise-dashboard-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(419,'reseller_type','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(420,'edit_cable_meter','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(421,'change-employee-admin-user','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(422,'delete-generated-bill-full-permission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(423,'local-user-first-approve','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(424,'view-nas-log-history','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(425,'view-pop-log-history','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(426,'view-reseller-history','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(427,'change-collector','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(428,'all-expense-show','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(429,'expense-approve','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(430,'stock-alert-number','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(431,'view-customer-amount','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(432,'reseller-sms-getway','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(433,'deactive-all-expired-customer','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(434,'view-package-log-history','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(435,'add-marketer','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(436,'view-sub-package-log-history','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(437,'missing-bill-generate-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(438,'view-sms-log-history','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(439,'change-expire-date','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(440,'check-recharge-by','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(441,'pop-accounts-edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(442,'manager-accounts-edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(443,'change-payment-date','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(444,'day_by_day_payment','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(445,'client_search','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(446,'dashboard_info','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(447,'close_list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(448,'pending_list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(449,'report_menu','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(450,'support_home_hide','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(451,'add_other_bill','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(452,'portal-invoice','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(453,'payment-history','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(454,'package_change_without_cost','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(455,'specific_management_services','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(456,'radius_online_customer_reset','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(457,'deactive_all_expire_customer','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(458,'apply-bandwidth-limit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(459,'form-setting','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(460,'client-import','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(461,'bill_payment_report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(462,'change_auto_deactive_date','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(463,'static_manage','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(464,'delete-single-id-from-online','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(465,'change_marketed_by','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(466,'source_mrc_hide','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(467,'select_any_marketer','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(468,'change-billing-cycle-without-cost','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(469,'batch-package-change-without-cost','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(470,'leftclient','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(471,'pgw_response_log','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(472,'bank','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(473,'payroll','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(474,'dynamic-recharge','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(475,'dashboardLastPaymentReport','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(476,'client_auto_approve','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(477,'due-amount-check-by-month','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(478,'manager-balance-on-topbar','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(479,'show-reseller-cost','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(480,'duplicate-money-receipt','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(481,'delete_customer_edit','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(482,'token-summary-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(483,'up-down-report-package-wise','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(484,'permanent-discount-list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(485,'bkashWebhookReport','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(486,'expense-type-delete','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(487,'expense-type-history','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(488,'crm_marketing','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(489,'crm_crm','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(490,'crm_support','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(491,'crm_account','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(492,'crm_fiber','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(493,'crm_store','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(494,'change_item_crm_status','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(495,'schedule-package-change','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(496,'minimum_recharge_day','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(497,'default_source_crm','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(498,'print-invoice','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(499,'network-manage','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(500,'expire-but-online-customers','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(501,'package_change_without_cost_expire','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(502,'add-thana','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(503,'free-client','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(504,'running-due','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(505,'ignore-mikrotik-check','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(506,'requisition_delete','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(507,'company_commission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(508,'manager_commission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(509,'sub_manager_commission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(510,'reseller_balance_log_with_pop','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(511,'show_reseller_cost_in_pop','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(512,'manager_commission_top_ber','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(513,'reseller-image-upload','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(514,'client_register_list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(515,'show_commission_reseller_balance_log','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(516,'show_commission_sub_reseller_balance_log','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(517,'add-upazila','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(518,'can_recharge_from_manager_commission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(519,'area_hide_bill_sheet','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(520,'can-not-change-employee-in-expense','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(521,'client_import_amount_report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(522,'billing_start_time','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(523,'sub-manager-balance-on-topbar','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(524,'never_disconnect','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(525,'marketing-new-customer-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(526,'onu_information_laser','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(527,'router-remote-access','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(528,'set-manager-commission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(529,'set-pop-commission','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(530,'show_commission_percentage_reseller_balance_log','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(531,'client-payment-Invoice','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(532,'update_own_other_picture','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(533,'reseller-client-extra-bill-add','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(534,'reseller-client-payment-add','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(535,'view-client-account-balance','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(536,'reseller-customer-payment-report','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(537,'reseller-due-customer-list','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(538,'reseller-billing-info','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(539,'allClientDownloadExcel','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable'),(540,'dashboard-customer-summery','web','2025-05-04 11:20:36','2025-05-04 11:20:36','enable');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pgw_response_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pgw_response_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `response` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('Success','Failed') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_ref_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `error_massage` text COLLATE utf8mb4_unicode_ci,
  `payment_for` enum('Pop','Reseller','Client') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method` enum('Bkash','Nagad','Upay','Sslcommerz') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `source` enum('Payment_initiate','Call_back_url') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `added_by` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pgw_response_logs` WRITE;
/*!40000 ALTER TABLE `pgw_response_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pgw_response_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pop_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pop_user` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pop_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pop_user_pop_id_foreign` (`pop_id`),
  KEY `pop_user_user_id_foreign` (`user_id`),
  CONSTRAINT `pop_user_pop_id_foreign` FOREIGN KEY (`pop_id`) REFERENCES `pops` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pop_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pop_user` WRITE;
/*!40000 ALTER TABLE `pop_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `pop_user` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pops`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pops` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `popname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reseller_id` bigint unsigned NOT NULL,
  `pop_location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pop_contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nas_id` bigint unsigned NOT NULL,
  `longitude` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitude` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `server_authentication` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `billable` enum('no','yes') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subreseller` enum('no','yes') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `bill_generate` enum('no','yes') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `package_change_pricing` enum('full_month','day_by_day') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('Enable','Disable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Enable',
  `sms_send` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  `experity_check` enum('Yes','No') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'No',
  `sub_package_list` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `pop_disable` enum('no','yes') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `payment_charges` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `enable_online_recharge` tinyint NOT NULL DEFAULT '0',
  `commission_percentage` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pops` WRITE;
/*!40000 ALTER TABLE `pops` DISABLE KEYS */;
INSERT INTO `pops` VALUES (1,'Noyabazar',1,'Noyabazar','1',1,'YY','XX','yes','yes','no','2025-05-04 11:36:48','2025-05-04 12:35:27','yes','full_month','Enable','yes','No',NULL,'no','{\"bkash_charges\":null,\"rocket_charges\":null,\"nagad_charges\":null,\"upay_charges\":null,\"ucash_charges\":null}',0,0.00),(2,'Fozderhat',2,'Fozderhat','1',1,'YY','XX','yes','yes','no','2025-05-04 11:37:32','2025-05-04 16:23:38','no','full_month','Enable','no','No',NULL,'no','{\"bkash_charges\":null,\"rocket_charges\":null,\"nagad_charges\":null,\"upay_charges\":null,\"ucash_charges\":null}',0,0.00),(3,'Khanbari',3,'Khanbari','01973464170',1,'YY','XX','yes','yes','no','2025-05-04 16:54:04','2025-05-04 16:54:04','no','full_month','Enable','yes','No',NULL,'no','{\"bkash_charges\":null,\"rocket_charges\":null,\"nagad_charges\":null,\"upay_charges\":null,\"ucash_charges\":null}',0,0.00);
/*!40000 ALTER TABLE `pops` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `port_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `port_map` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port_number` int NOT NULL,
  `port_type` enum('1g','10g','40g','100g','pon','xpon','other') COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'port',
  `device_id` bigint unsigned NOT NULL,
  `port_stream` enum('incoming','outgoing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'outgoing',
  `fiber_id` bigint unsigned DEFAULT NULL,
  `cable_id` bigint unsigned DEFAULT NULL,
  `connected_component_id` bigint unsigned DEFAULT NULL,
  `connected_component_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pon_count` int NOT NULL DEFAULT '0',
  `pon_limit` enum('64','128') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `port_map` WRITE;
/*!40000 ALTER TABLE `port_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `port_map` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchase_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `item_id` bigint unsigned NOT NULL,
  `buying_price` double(15,2) NOT NULL,
  `quantity` int NOT NULL,
  `discount` double(8,2) DEFAULT NULL,
  `batch_number` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `manufactured_date` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `purchase_id` bigint unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_items_item_id_foreign` (`item_id`),
  KEY `purchase_items_purchase_id_foreign` (`purchase_id`),
  CONSTRAINT `purchase_items_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_items_purchase_id_foreign` FOREIGN KEY (`purchase_id`) REFERENCES `purchases` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_items` WRITE;
/*!40000 ALTER TABLE `purchase_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `purchase_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchases` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subtotal` double(15,2) NOT NULL,
  `paid` double(15,2) NOT NULL,
  `due` double(15,2) NOT NULL,
  `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `voucher_no` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supplier_id` bigint unsigned DEFAULT NULL,
  `creator_user_id` bigint unsigned DEFAULT NULL,
  `updator_user_id` bigint unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `branch_id` bigint unsigned DEFAULT NULL,
  `approve_status` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchases_supplier_id_foreign` (`supplier_id`),
  KEY `purchases_creator_user_id_foreign` (`creator_user_id`),
  KEY `purchases_updator_user_id_foreign` (`updator_user_id`),
  KEY `purchases_branch_id_foreign` (`branch_id`),
  CONSTRAINT `purchases_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`),
  CONSTRAINT `purchases_creator_user_id_foreign` FOREIGN KEY (`creator_user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `purchases_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `suppliers` (`id`),
  CONSTRAINT `purchases_updator_user_id_foreign` FOREIGN KEY (`updator_user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `radacct`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `radacct` (
  `radacctid` bigint NOT NULL AUTO_INCREMENT,
  `acctsessionid` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `acctuniqueid` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `username` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `groupname` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `realm` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `nasipaddress` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `nasportid` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nasporttype` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `acctstarttime` datetime DEFAULT NULL,
  `acctupdatetime` datetime DEFAULT NULL,
  `acctstoptime` datetime DEFAULT NULL,
  `acctinterval` int DEFAULT NULL,
  `acctsessiontime` int unsigned DEFAULT NULL,
  `acctauthentic` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `connectinfo_start` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `connectinfo_stop` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `acctinputoctets` bigint DEFAULT NULL,
  `acctoutputoctets` bigint DEFAULT NULL,
  `calledstationid` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `callingstationid` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `acctterminatecause` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `servicetype` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `framedprotocol` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `framedipaddress` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `framedipv6address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `framedipv6prefix` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `framedinterfaceid` varchar(44) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `delegatedipv6prefix` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`radacctid`),
  UNIQUE KEY `acctuniqueid` (`acctuniqueid`),
  KEY `username` (`username`),
  KEY `framedipaddress` (`framedipaddress`),
  KEY `framedipv6address` (`framedipv6address`),
  KEY `framedipv6prefix` (`framedipv6prefix`),
  KEY `framedinterfaceid` (`framedinterfaceid`),
  KEY `delegatedipv6prefix` (`delegatedipv6prefix`),
  KEY `acctsessionid` (`acctsessionid`),
  KEY `acctsessiontime` (`acctsessiontime`),
  KEY `acctstarttime` (`acctstarttime`),
  KEY `acctinterval` (`acctinterval`),
  KEY `acctstoptime` (`acctstoptime`),
  KEY `nasipaddress` (`nasipaddress`),
  KEY `bulk_close` (`acctstoptime`,`nasipaddress`,`acctstarttime`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `radacct` WRITE;
/*!40000 ALTER TABLE `radacct` DISABLE KEYS */;
/*!40000 ALTER TABLE `radacct` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `radcheck`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `radcheck` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(64) CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL DEFAULT '',
  `attribute` varchar(64) CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL DEFAULT '',
  `op` char(2) CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL DEFAULT '==',
  `value` varchar(253) CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `username` (`username`(32))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_general_cs;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `radcheck` WRITE;
/*!40000 ALTER TABLE `radcheck` DISABLE KEYS */;
/*!40000 ALTER TABLE `radcheck` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `radgroupcheck`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `radgroupcheck` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `groupname` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `attribute` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `op` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '==',
  `value` varchar(253) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `groupname` (`groupname`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `radgroupcheck` WRITE;
/*!40000 ALTER TABLE `radgroupcheck` DISABLE KEYS */;
/*!40000 ALTER TABLE `radgroupcheck` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `radgroupreply`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `radgroupreply` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `groupname` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `attribute` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `op` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '=',
  `value` varchar(253) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `groupname` (`groupname`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `radgroupreply` WRITE;
/*!40000 ALTER TABLE `radgroupreply` DISABLE KEYS */;
/*!40000 ALTER TABLE `radgroupreply` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `radpostauth`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `radpostauth` (
  `id` int NOT NULL AUTO_INCREMENT,
  `username` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pass` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `reply` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `authdate` timestamp(6) NOT NULL DEFAULT CURRENT_TIMESTAMP(6) ON UPDATE CURRENT_TIMESTAMP(6),
  `mikrotik` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mac` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `radpostauth` WRITE;
/*!40000 ALTER TABLE `radpostauth` DISABLE KEYS */;
/*!40000 ALTER TABLE `radpostauth` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `radreply`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `radreply` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `attribute` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `op` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '=',
  `value` varchar(253) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `username` (`username`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `radreply` WRITE;
/*!40000 ALTER TABLE `radreply` DISABLE KEYS */;
/*!40000 ALTER TABLE `radreply` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `radusergroup`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `radusergroup` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `groupname` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `priority` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `username` (`username`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `radusergroup` WRITE;
/*!40000 ALTER TABLE `radusergroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `radusergroup` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `requisition_approve_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `requisition_approve_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `item_id` bigint unsigned NOT NULL,
  `quantity` int NOT NULL,
  `requisition_approve_id` bigint unsigned NOT NULL,
  `requisition_id` bigint unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `requisition_approve_items_item_id_foreign` (`item_id`),
  KEY `requisition_approve_items_requisition_approve_id_foreign` (`requisition_approve_id`),
  KEY `requisition_approve_items_requisition_id_foreign` (`requisition_id`),
  CONSTRAINT `requisition_approve_items_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`) ON DELETE CASCADE,
  CONSTRAINT `requisition_approve_items_requisition_approve_id_foreign` FOREIGN KEY (`requisition_approve_id`) REFERENCES `requisition_approves` (`id`) ON DELETE CASCADE,
  CONSTRAINT `requisition_approve_items_requisition_id_foreign` FOREIGN KEY (`requisition_id`) REFERENCES `requisitions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `requisition_approve_items` WRITE;
/*!40000 ALTER TABLE `requisition_approve_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `requisition_approve_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `requisition_approves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `requisition_approves` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `requisition_approve_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `requisition_id` bigint unsigned NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Pending',
  `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `creator_user_id` bigint unsigned DEFAULT NULL,
  `updator_user_id` bigint unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `requisition_approves_requisition_id_foreign` (`requisition_id`),
  KEY `requisition_approves_creator_user_id_foreign` (`creator_user_id`),
  KEY `requisition_approves_updator_user_id_foreign` (`updator_user_id`),
  CONSTRAINT `requisition_approves_creator_user_id_foreign` FOREIGN KEY (`creator_user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `requisition_approves_requisition_id_foreign` FOREIGN KEY (`requisition_id`) REFERENCES `requisitions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `requisition_approves_updator_user_id_foreign` FOREIGN KEY (`updator_user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `requisition_approves` WRITE;
/*!40000 ALTER TABLE `requisition_approves` DISABLE KEYS */;
/*!40000 ALTER TABLE `requisition_approves` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `requisition_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `requisition_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `item_id` bigint unsigned NOT NULL,
  `quantity` int NOT NULL,
  `requisition_id` bigint unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `requisition_items_item_id_foreign` (`item_id`),
  KEY `requisition_items_requisition_id_foreign` (`requisition_id`),
  CONSTRAINT `requisition_items_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`) ON DELETE CASCADE,
  CONSTRAINT `requisition_items_requisition_id_foreign` FOREIGN KEY (`requisition_id`) REFERENCES `requisitions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `requisition_items` WRITE;
/*!40000 ALTER TABLE `requisition_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `requisition_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `requisitions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `requisitions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `requisition_number` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Pending',
  `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `employee_id` bigint unsigned DEFAULT NULL,
  `creator_user_id` bigint unsigned DEFAULT NULL,
  `updator_user_id` bigint unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `branch_id` bigint unsigned DEFAULT NULL,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `purposes` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `recommendation` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auth_file` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `requisitions_employee_id_foreign` (`employee_id`),
  KEY `requisitions_creator_user_id_foreign` (`creator_user_id`),
  KEY `requisitions_updator_user_id_foreign` (`updator_user_id`),
  KEY `requisitions_branch_id_foreign` (`branch_id`),
  CONSTRAINT `requisitions_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`),
  CONSTRAINT `requisitions_creator_user_id_foreign` FOREIGN KEY (`creator_user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `requisitions_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`),
  CONSTRAINT `requisitions_updator_user_id_foreign` FOREIGN KEY (`updator_user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `requisitions` WRITE;
/*!40000 ALTER TABLE `requisitions` DISABLE KEYS */;
/*!40000 ALTER TABLE `requisitions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reselle_balance_log_reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reselle_balance_log_reports` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` bigint unsigned NOT NULL,
  `client_id` bigint unsigned NOT NULL,
  `action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` int NOT NULL,
  `remarks` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `reseller_balance` decimal(8,2) DEFAULT NULL,
  `after_balance` decimal(8,2) DEFAULT NULL,
  `uniqueId` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pop_id` bigint unsigned DEFAULT NULL,
  `commission_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `reseller_commission_percentage` decimal(8,2) NOT NULL DEFAULT '0.00',
  `pop_commission_percentage` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reselle_balance_log_reports_uniqueid_unique` (`uniqueId`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reselle_balance_log_reports` WRITE;
/*!40000 ALTER TABLE `reselle_balance_log_reports` DISABLE KEYS */;
INSERT INTO `reselle_balance_log_reports` VALUES (1,2,1,'New MAC added. Package Name: 5Mbps_E Expire: 15-May-2025. For 12 days cost BDT 96',96,'Created BY Imtiazikramipho@gmail.com','2025-05-04 16:27:32','2025-05-04 16:27:32',NULL,NULL,'4ce9bbaf-4477-475a-939e-da74d1a7d103',2,0.00,0.00,0.00),(2,2,1,'Recharge For  1 Month. From 2025-05-15 00:00:00 To 2025-06-15 00:00:00 . For package 5Mbps_E cost BDT 240.00',240,'Created BY Imtiazikramipho@gmail.com','2025-05-04 17:18:15','2025-05-04 17:18:15',9904.00,9664.00,'f95c6419-e41c-4c0f-a1ce-e99dffdd53ad1',2,0.00,0.00,0.00);
/*!40000 ALTER TABLE `reselle_balance_log_reports` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reseller_areas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reseller_areas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` bigint unsigned NOT NULL,
  `area` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `pop_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reseller_areas` WRITE;
/*!40000 ALTER TABLE `reseller_areas` DISABLE KEYS */;
INSERT INTO `reseller_areas` VALUES (1,1,'Mosjid Goli','2025-05-04 17:55:51','2025-05-04 17:55:51',1);
/*!40000 ALTER TABLE `reseller_areas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reseller_bill_generates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reseller_bill_generates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` bigint unsigned NOT NULL,
  `client_id` bigint unsigned NOT NULL,
  `amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `paid_amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `due_amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reseller_bill_generates` WRITE;
/*!40000 ALTER TABLE `reseller_bill_generates` DISABLE KEYS */;
/*!40000 ALTER TABLE `reseller_bill_generates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reseller_bill_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reseller_bill_payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` bigint unsigned NOT NULL,
  `client_id` bigint unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `discount_amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `paid_amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `user_id` bigint unsigned NOT NULL,
  `money_receipt_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reseller_bill_payments_money_receipt_number_unique` (`money_receipt_number`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reseller_bill_payments` WRITE;
/*!40000 ALTER TABLE `reseller_bill_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `reseller_bill_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reseller_client_bill_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reseller_client_bill_payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `trx_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reseller_client_bill_payments_trx_id_unique` (`trx_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reseller_client_bill_payments` WRITE;
/*!40000 ALTER TABLE `reseller_client_bill_payments` DISABLE KEYS */;
/*!40000 ALTER TABLE `reseller_client_bill_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reseller_commission_reference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reseller_commission_reference` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `received_amount` decimal(16,2) DEFAULT NULL,
  `paid_amount` decimal(16,2) DEFAULT NULL,
  `actions` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reseller_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `comments` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `client_id` bigint unsigned NOT NULL,
  `fund_transfer_id` bigint unsigned DEFAULT NULL,
  `expense_id` bigint unsigned DEFAULT NULL,
  `bill_payment_id` bigint unsigned DEFAULT NULL,
  `bill_generate_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reseller_commission_reference` WRITE;
/*!40000 ALTER TABLE `reseller_commission_reference` DISABLE KEYS */;
/*!40000 ALTER TABLE `reseller_commission_reference` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reseller_recharge_reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reseller_recharge_reports` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` bigint unsigned NOT NULL,
  `amount` int NOT NULL,
  `after_recharge_balance` int NOT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `income_id` bigint unsigned DEFAULT NULL,
  `paid_amount` decimal(16,2) DEFAULT NULL,
  `payment_type` enum('cash','online') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'cash',
  `payment_gateway` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_gateway_transaction_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `txn_id` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_payment` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reseller_recharge_reports` WRITE;
/*!40000 ALTER TABLE `reseller_recharge_reports` DISABLE KEYS */;
INSERT INTO `reseller_recharge_reports` VALUES (1,2,10000,10000,'5*4',3,'2025-05-04 12:12:27','2025-05-04 12:12:27',1,10000.00,'cash',NULL,NULL,'202505041812',0),(2,2,336,10000,'.',3,'2025-05-04 17:25:31','2025-05-04 17:25:31',2,336.00,'cash',NULL,NULL,'202505042325',0);
/*!40000 ALTER TABLE `reseller_recharge_reports` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reseller_sms_getways`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reseller_sms_getways` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` bigint unsigned NOT NULL,
  `sms_gateway` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sms_formate` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `sms_balance_url` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reseller_sms_getways` WRITE;
/*!40000 ALTER TABLE `reseller_sms_getways` DISABLE KEYS */;
INSERT INTO `reseller_sms_getways` VALUES (1,2,'','[{\"sms_type\":\"other_reseller_customer_recharge\",\"send_sms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09df \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 ({c_name}), \\u0986\\u09aa\\u09a8\\u09be\\u09b0 {month} \\u09ae\\u09be\\u09b8 \\u09aa\\u09b0\\u09cd\\u09af\\u09a8\\u09cd\\u09a4 \\u09ac\\u09bf\\u09b2 \\u09b8\\u09a0\\u09bf\\u0995 \\u09ad\\u09be\\u09ac\\u09c7 \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u09b9\\u09df\\u09c7\\u099b\\u09c7\\u0964 {reseller_name} \\u098f\\u09b0 \\u09b8\\u09be\\u09a5\\u09c7 \\u09a5\\u09be\\u0995\\u09be\\u09b0 \\u099c\\u09a8\\u09cd\\u09af \\u09a7\\u09a8\\u09cd\\u09af\\u09ac\\u09be\\u09a6\\u0964  \\u09af\\u09c7\\u0995\\u09cb\\u09a8\\u09cb \\u09a4\\u09a5\\u09cd\\u09af\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af \\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997 {reseller_mobile} \\u098f\\u0987 \\u09a8\\u09be\\u09ae\\u09cd\\u09ac\\u09be\\u09b0\\u09c7|\"},{\"sms_type\":\"other_reseller_customer_reminder\",\"send_sms\":\"No\",\"sms_body\":\"\\u09b8\\u09ae\\u09cd\\u09ae\\u09be\\u09a8\\u09bf\\u09a4 \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995  \\u0986\\u09aa\\u09a8\\u09be\\u09b0 {c_name}\\u0964 \\u0987\\u09a8\\u09cd\\u099f\\u09be\\u09b0\\u09a8\\u09c7\\u099f \\u09ac\\u09bf\\u09b2 \\u09aa\\u09b0\\u09bf\\u09b6\\u09cb\\u09a7\\u09c7\\u09b0 \\u09b6\\u09c7\\u09b7 \\u09a4\\u09be\\u09b0\\u09bf\\u0996 {c_expire_date} \\u09a6\\u09af\\u09bc\\u09be \\u0995\\u09b0\\u09c7 \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u09ac\\u09bf\\u09b2\\u099f\\u09bf \\u09aa\\u09b0\\u09bf\\u09b6\\u09cb\\u09a7 \\u0995\\u09b0\\u09c1\\u09a8\\u0964 \",\"days_before\":\"2\"},{\"sms_type\":\"other_reseller_customer_expire\",\"send_sms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09df \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 {c_name} \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u0987\\u09a8\\u09cd\\u099f\\u09be\\u09b0\\u09a8\\u09c7\\u099f \\u09ac\\u09bf\\u09b2 \\u09aa\\u09b0\\u09bf\\u09b6\\u09cb\\u09a7 \\u0995\\u09b0\\u09be\\u09b0 \\u09b8\\u09ae\\u09df\\u09b8\\u09c0\\u09ae\\u09be \\u0985\\u09a4\\u09bf\\u0995\\u09cd\\u09b0\\u09ae \\u0995\\u09b0\\u09c7\\u099b\\u09c7\\u0964 \\u09a8\\u09bf\\u09b0\\u09ac\\u09bf\\u099a\\u09cd\\u099b\\u09bf\\u09a8\\u09cd\\u09a8 \\u09b8\\u0982\\u09af\\u09cb\\u0997 \\u09aa\\u09c7\\u09a4\\u09c7 \\u09ac\\u0995\\u09c7\\u09df\\u09be \\u099f\\u09be\\u0995\\u09be \\u09aa\\u09b0\\u09bf\\u09b6\\u09cb\\u09a7 \\u0995\\u09b0\\u09c1\\u09a8\\u0964\"},{\"sms_type\":\"other_reseller_customer_create\",\"send_sms\":\"No\",\"sms_body\":\"{reseller_name} \\u098f \\u0986\\u09aa\\u09a8\\u09be\\u0995\\u09c7 \\u09b8\\u09cd\\u09ac\\u09be\\u0997\\u09a4\\u09ae\\u0964 \\u0986\\u09aa\\u09a8\\u09be\\u09b0 User Id: {c_username} \\u0993 Password: {c_password} \\u09b8\\u0982\\u09b0\\u0995\\u09cd\\u09b7\\u09a8 \\u0995\\u09b0\\u09c7 \\u09b0\\u09be\\u0996\\u09cb\\u09a8\\u0964\"},{\"sms_type\":\"own_reseller_customer_create\",\"send_sms\":\"No\",\"sms_body\":\"{reseller_name} \\u098f \\u0986\\u09aa\\u09a8\\u09be\\u0995\\u09c7 \\u09b8\\u09cd\\u09ac\\u09be\\u0997\\u09a4\\u09ae\\u0964 \\u0986\\u09aa\\u09a8\\u09be\\u09b0 User Id: {c_username} \\u0993 Password: {c_password} \\u09b8\\u0982\\u09b0\\u0995\\u09cd\\u09b7\\u09a8 \\u0995\\u09b0\\u09c7 \\u09b0\\u09be\\u0996\\u09cb\\u09a8\\u0964\"},{\"sms_type\":\"own_reseller_customer_payment\",\"send_sms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09df \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 ({c_name}), CID-{c_id} \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u09ac\\u09bf\\u09b2 \\u09b8\\u09a0\\u09bf\\u0995 \\u09ad\\u09be\\u09ac\\u09c7 \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u09b9\\u09df\\u09c7\\u099b\\u09c7\\u0964 \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u099f\\u09be\\u0995\\u09be\\u09b0 \\u09aa\\u09b0\\u09bf\\u09ae\\u09be\\u09a8- TK {PaymentAmount} | \"},{\"sms_type\":\"own_reseller_customer_reminder\",\"send_sms\":\"No\",\"sms_body\":\"\\u09b8\\u09ae\\u09cd\\u09ae\\u09be\\u09a8\\u09bf\\u09a4 \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 \\u0986\\u0987\\u09a1\\u09bf - {c_id}. \\u0987\\u09a8\\u09cd\\u099f\\u09be\\u09b0\\u09a8\\u09c7\\u099f \\u09ac\\u09bf\\u09b2 {TotalDue} \\u09aa\\u09b0\\u09bf\\u09b6\\u09cb\\u09a7\\u09c7\\u09b0 \\u09b6\\u09c7\\u09b7 \\u09a4\\u09be\\u09b0\\u09bf\\u0996 {c_deadline} \\u09a6\\u09af\\u09bc\\u09be \\u0995\\u09b0\\u09c7 \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u09ac\\u09bf\\u09b2\\u099f\\u09bf \\u09aa\\u09b0\\u09bf\\u09b6\\u09cb\\u09a7 \\u0995\\u09b0\\u09c1\\u09a8\\u0964 \",\"days_before\":\"2\"}]','2025-05-04 16:21:20','2025-05-04 16:21:20',NULL);
/*!40000 ALTER TABLE `reseller_sms_getways` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reseller_sms_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reseller_sms_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` bigint unsigned NOT NULL,
  `contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'other',
  `delivery_message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'processing',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reseller_sms_logs` WRITE;
/*!40000 ALTER TABLE `reseller_sms_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `reseller_sms_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reseller_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reseller_user` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `reseller_user_reseller_id_foreign` (`reseller_id`),
  KEY `reseller_user_user_id_foreign` (`user_id`),
  CONSTRAINT `reseller_user_reseller_id_foreign` FOREIGN KEY (`reseller_id`) REFERENCES `resellers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reseller_user_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reseller_user` WRITE;
/*!40000 ALTER TABLE `reseller_user` DISABLE KEYS */;
INSERT INTO `reseller_user` VALUES (2,2,4);
/*!40000 ALTER TABLE `reseller_user` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `resellers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `resellers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billable` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_login` datetime DEFAULT NULL,
  `loign_ip` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `package_list` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `reseller_type` enum('other','own') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_charges` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `img_url` text COLLATE utf8mb4_unicode_ci,
  `commission_percentage` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `resellers` WRITE;
/*!40000 ALTER TABLE `resellers` DISABLE KEYS */;
INSERT INTO `resellers` VALUES (1,'Saad','.','01633307601',NULL,'yes',NULL,NULL,'2025-05-04 11:35:07','2025-05-04 17:58:03','11,12,13,14,15,16,17,18,19,20,21,22','own','{\"bkash_charges\":null,\"rocket_charges\":null,\"nagad_charges\":null,\"upay_charges\":null,\"ucash_charges\":null}',NULL,0.00),(2,'Ekram','Fozderhat','11',NULL,'yes',NULL,NULL,'2025-05-04 11:35:39','2025-05-04 16:01:09','23,24,25,26,27,28,29,30,31,32,33','other','{\"bkash_charges\":null,\"rocket_charges\":null,\"nagad_charges\":null,\"upay_charges\":null,\"ucash_charges\":null}',NULL,0.00),(3,'Akash','Khanbari','01973464170','Pon/1,2','yes',NULL,NULL,'2025-05-04 16:01:55','2025-05-04 16:52:49',NULL,'other','{\"bkash_charges\":null,\"rocket_charges\":null,\"nagad_charges\":null,\"upay_charges\":null,\"ucash_charges\":null}',NULL,0.00);
/*!40000 ALTER TABLE `resellers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES (2,1),(3,1),(4,1),(5,1),(6,1),(7,1),(8,1),(9,1),(10,1),(11,1),(12,1),(13,1),(14,1),(15,1),(16,1),(17,1),(18,1),(19,1),(20,1),(21,1),(22,1),(23,1),(24,1),(25,1),(26,1),(27,1),(28,1),(29,1),(30,1),(31,1),(32,1),(33,1),(34,1),(35,1),(36,1),(37,1),(38,1),(39,1),(40,1),(41,1),(42,1),(43,1),(44,1),(45,1),(46,1),(47,1),(48,1),(49,1),(50,1),(51,1),(52,1),(53,1),(54,1),(55,1),(56,1),(57,1),(58,1),(59,1),(60,1),(61,1),(62,1),(63,1),(64,1),(66,1),(67,1),(68,1),(69,1),(70,1),(71,1),(72,1),(73,1),(74,1),(75,1),(76,1),(77,1),(78,1),(79,1),(80,1),(81,1),(82,1),(83,1),(84,1),(85,1),(86,1),(87,1),(88,1),(89,1),(90,1),(91,1),(92,1),(93,1),(94,1),(96,1),(97,1),(98,1),(99,1),(100,1),(101,1),(102,1),(103,1),(104,1),(105,1),(106,1),(107,1),(108,1),(109,1),(110,1),(111,1),(112,1),(113,1),(114,1),(115,1),(116,1),(117,1),(118,1),(119,1),(120,1),(121,1),(122,1),(123,1),(124,1),(125,1),(126,1),(127,1),(128,1),(129,1),(130,1),(131,1),(132,1),(133,1),(134,1),(135,1),(136,1),(137,1),(138,1),(139,1),(140,1),(141,1),(142,1),(143,1),(144,1),(145,1),(146,1),(147,1),(148,1),(149,1),(150,1),(151,1),(152,1),(153,1),(154,1),(155,1),(156,1),(157,1),(158,1),(159,1),(160,1),(161,1),(162,1),(163,1),(164,1),(166,1),(167,1),(168,1),(169,1),(170,1),(171,1),(173,1),(174,1),(175,1),(176,1),(177,1),(178,1),(179,1),(181,1),(182,1),(183,1),(184,1),(185,1),(186,1),(187,1),(188,1),(189,1),(191,1),(192,1),(193,1),(194,1),(195,1),(196,1),(197,1),(198,1),(199,1),(200,1),(201,1),(202,1),(203,1),(204,1),(205,1),(206,1),(207,1),(208,1),(209,1),(210,1),(211,1),(212,1),(213,1),(214,1),(215,1),(216,1),(217,1),(218,1),(219,1),(220,1),(221,1),(222,1),(223,1),(224,1),(225,1),(226,1),(227,1),(228,1),(229,1),(230,1),(231,1),(232,1),(233,1),(234,1),(235,1),(236,1),(237,1),(238,1),(239,1),(240,1),(241,1),(242,1),(243,1),(244,1),(245,1),(246,1),(247,1),(248,1),(249,1),(250,1),(251,1),(252,1),(253,1),(254,1),(255,1),(256,1),(257,1),(258,1),(259,1),(260,1),(261,1),(263,1),(264,1),(265,1),(267,1),(268,1),(269,1),(272,1),(273,1),(274,1),(275,1),(276,1),(277,1),(278,1),(279,1),(280,1),(281,1),(282,1),(283,1),(284,1),(285,1),(286,1),(287,1),(288,1),(289,1),(290,1),(291,1),(292,1),(293,1),(294,1),(295,1),(296,1),(297,1),(298,1),(299,1),(300,1),(301,1),(302,1),(303,1),(304,1),(305,1),(306,1),(307,1),(308,1),(309,1),(310,1),(311,1),(312,1),(313,1),(314,1),(315,1),(316,1),(317,1),(318,1),(319,1),(320,1),(321,1),(322,1),(323,1),(324,1),(325,1),(326,1),(327,1),(328,1),(329,1),(330,1),(331,1),(332,1),(333,1),(334,1),(335,1),(336,1),(337,1),(338,1),(339,1),(340,1),(341,1),(342,1),(343,1),(344,1),(345,1),(346,1),(348,1),(350,1),(351,1),(352,1),(353,1),(354,1),(356,1),(357,1),(358,1),(359,1),(360,1),(361,1),(362,1),(363,1),(364,1),(365,1),(367,1),(368,1),(369,1),(370,1),(371,1),(372,1),(373,1),(374,1),(375,1),(376,1),(379,1),(381,1),(382,1),(384,1),(385,1),(386,1),(388,1),(390,1),(391,1),(395,1),(396,1),(397,1),(398,1),(399,1),(400,1),(401,1),(404,1),(405,1),(406,1),(407,1),(408,1),(409,1),(410,1),(412,1),(413,1),(416,1),(417,1),(419,1),(424,1),(425,1),(426,1),(427,1),(428,1),(429,1),(432,1),(433,1),(434,1),(435,1),(436,1),(437,1),(439,1),(453,1),(454,1),(460,1),(461,1),(462,1),(470,1),(471,1),(475,1),(502,1),(506,1),(517,1),(526,1),(3,2),(4,2),(22,2),(23,2),(24,2),(28,2),(29,2),(30,2),(37,2),(38,2),(40,2),(41,2),(42,2),(43,2),(44,2),(45,2),(46,2),(47,2),(48,2),(50,2),(51,2),(52,2),(53,2),(54,2),(55,2),(57,2),(60,2),(61,2),(62,2),(64,2),(66,2),(68,2),(77,2),(78,2),(87,2),(93,2),(184,2),(187,2),(188,2),(191,2),(195,2),(196,2),(203,2),(204,2),(248,2),(249,2),(270,2),(286,2),(287,2),(290,2),(291,2),(292,2),(293,2),(294,2),(295,2),(296,2),(297,2),(298,2),(299,2),(301,2),(303,2),(304,2),(305,2),(306,2),(307,2),(308,2),(309,2),(310,2),(311,2),(312,2),(313,2),(315,2),(400,2),(3,3),(4,3),(23,3),(24,3),(28,3),(29,3),(30,3),(31,3),(32,3),(34,3),(35,3),(36,3),(37,3),(38,3),(40,3),(41,3),(42,3),(43,3),(44,3),(45,3),(46,3),(47,3),(48,3),(49,3),(50,3),(51,3),(52,3),(53,3),(55,3),(57,3),(58,3),(60,3),(61,3),(62,3),(64,3),(66,3),(68,3),(69,3),(77,3),(78,3),(87,3),(93,3),(94,3),(184,3),(187,3),(188,3),(195,3),(196,3),(247,3),(248,3),(249,3),(270,3),(290,3),(291,3),(292,3),(293,3),(294,3),(295,3),(296,3),(297,3),(298,3),(299,3),(301,3),(302,3),(303,3),(304,3),(305,3),(306,3),(307,3),(308,3),(309,3),(310,3),(311,3),(312,3),(313,3),(315,3),(400,3),(3,4),(4,4),(22,4),(23,4),(24,4),(28,4),(36,4),(37,4),(38,4),(39,4),(40,4),(41,4),(42,4),(44,4),(45,4),(46,4),(47,4),(48,4),(49,4),(50,4),(51,4),(52,4),(53,4),(54,4),(55,4),(56,4),(57,4),(60,4),(61,4),(62,4),(65,4),(66,4),(67,4),(68,4),(69,4),(74,4),(76,4),(78,4),(79,4),(80,4),(81,4),(82,4),(83,4),(84,4),(85,4),(86,4),(87,4),(88,4),(89,4),(90,4),(91,4),(92,4),(93,4),(94,4),(96,4),(97,4),(98,4),(99,4),(100,4),(101,4),(102,4),(103,4),(104,4),(105,4),(106,4),(107,4),(109,4),(110,4),(113,4),(117,4),(127,4),(132,4),(133,4),(134,4),(139,4),(140,4),(143,4),(153,4),(160,4),(166,4),(169,4),(178,4),(179,4),(180,4),(184,4),(185,4),(186,4),(187,4),(188,4),(191,4),(192,4),(193,4),(194,4),(195,4),(196,4),(197,4),(198,4),(199,4),(200,4),(201,4),(205,4),(206,4),(207,4),(208,4),(210,4),(211,4),(212,4),(213,4),(214,4),(215,4),(217,4),(218,4),(223,4),(224,4),(229,4),(230,4),(235,4),(236,4),(237,4),(238,4),(239,4),(241,4),(242,4),(243,4),(244,4),(245,4),(246,4),(247,4),(248,4),(249,4),(252,4),(264,4),(267,4),(268,4),(269,4),(270,4),(271,4),(272,4),(273,4),(274,4),(275,4),(276,4),(277,4),(278,4),(279,4),(286,4),(287,4),(290,4),(291,4),(292,4),(293,4),(294,4),(295,4),(296,4),(297,4),(298,4),(301,4),(302,4),(303,4),(304,4),(305,4),(306,4),(307,4),(308,4),(311,4),(313,4),(315,4),(318,4),(319,4),(323,4),(341,4),(343,4),(368,4),(369,4),(395,4),(428,4),(3,5),(4,5),(22,5),(23,5),(24,5),(28,5),(36,5),(37,5),(40,5),(41,5),(42,5),(44,5),(45,5),(46,5),(47,5),(48,5),(49,5),(50,5),(51,5),(52,5),(53,5),(54,5),(55,5),(57,5),(60,5),(61,5),(65,5),(66,5),(67,5),(69,5),(76,5),(77,5),(78,5),(79,5),(83,5),(84,5),(85,5),(86,5),(87,5),(88,5),(90,5),(92,5),(93,5),(94,5),(96,5),(100,5),(101,5),(102,5),(103,5),(109,5),(110,5),(160,5),(166,5),(184,5),(187,5),(188,5),(247,5),(248,5),(249,5),(252,5),(267,5),(270,5),(272,5),(273,5),(274,5),(278,5),(315,5),(318,5),(319,5),(320,5),(323,5),(341,5),(343,5),(428,5),(3,6),(4,6),(22,6),(23,6),(24,6),(25,6),(26,6),(28,6),(29,6),(30,6),(31,6),(32,6),(34,6),(35,6),(36,6),(37,6),(38,6),(40,6),(41,6),(42,6),(43,6),(44,6),(45,6),(46,6),(47,6),(48,6),(49,6),(50,6),(51,6),(52,6),(53,6),(55,6),(57,6),(58,6),(60,6),(61,6),(62,6),(64,6),(66,6),(67,6),(68,6),(69,6),(76,6),(77,6),(78,6),(87,6),(93,6),(94,6),(101,6),(102,6),(103,6),(104,6),(105,6),(106,6),(107,6),(109,6),(184,6),(187,6),(188,6),(247,6),(248,6),(249,6),(270,6),(315,6),(3,7),(4,7),(77,7),(78,7),(92,7),(111,7),(112,7),(113,7),(114,7),(117,7),(118,7),(119,7),(120,7),(121,7),(123,7),(124,7),(125,7),(126,7),(127,7),(129,7),(130,7),(132,7),(133,7),(134,7),(135,7),(136,7),(137,7),(139,7),(140,7),(141,7),(142,7),(143,7),(144,7),(145,7),(146,7),(147,7),(148,7),(315,7),(3,8),(4,8),(24,8),(40,8),(44,8),(45,8),(46,8),(47,8),(62,8),(110,8),(153,8),(160,8),(179,8),(180,8),(184,8),(185,8),(186,8),(187,8),(188,8),(190,8),(192,8),(193,8),(194,8),(195,8),(196,8),(197,8),(198,8),(199,8),(200,8),(201,8),(202,8),(203,8),(204,8),(246,8),(247,8),(248,8),(249,8),(252,8),(253,8),(254,8),(255,8),(256,8),(257,8),(258,8),(259,8),(260,8),(263,8),(267,8),(268,8),(273,8),(275,8),(276,8),(278,8),(279,8),(284,8),(286,8),(287,8),(329,8),(332,8),(333,8),(334,8),(335,8),(336,8),(352,8),(354,8),(406,8),(407,8),(432,8),(478,8),(479,8),(166,9),(3,10),(4,10),(22,10),(23,10),(24,10),(28,10),(36,10),(37,10),(38,10),(40,10),(41,10),(42,10),(44,10),(45,10),(46,10),(47,10),(48,10),(49,10),(50,10),(51,10),(52,10),(53,10),(54,10),(55,10),(57,10),(60,10),(61,10),(62,10),(65,10),(66,10),(67,10),(69,10),(76,10),(77,10),(78,10),(79,10),(83,10),(84,10),(85,10),(86,10),(87,10),(88,10),(90,10),(92,10),(93,10),(94,10),(96,10),(97,10),(100,10),(101,10),(102,10),(103,10),(106,10),(107,10),(109,10),(110,10),(166,10),(184,10),(187,10),(188,10),(195,10),(196,10),(210,10),(213,10),(225,10),(229,10),(230,10),(234,10),(237,10),(241,10),(242,10),(243,10),(244,10),(245,10),(246,10),(247,10),(248,10),(249,10),(270,10),(271,10),(272,10),(274,10),(315,10),(3,11),(4,11),(24,11),(40,11),(44,11),(45,11),(46,11),(47,11),(62,11),(179,11),(184,11),(185,11),(186,11),(187,11),(188,11),(192,11),(193,11),(195,11),(196,11),(197,11),(198,11),(199,11),(200,11),(201,11),(202,11),(203,11),(204,11),(248,11),(249,11),(260,11),(262,11),(263,11),(267,11),(268,11),(273,11),(278,11),(281,11),(284,11),(286,11),(287,11),(329,11),(330,11),(332,11),(333,11),(335,11),(336,11),(352,11),(354,11),(361,11),(362,11),(3,12),(4,12),(24,12),(40,12),(44,12),(45,12),(46,12),(47,12),(62,12),(110,12),(153,12),(160,12),(179,12),(180,12),(184,12),(185,12),(186,12),(187,12),(188,12),(190,12),(192,12),(193,12),(194,12),(195,12),(196,12),(197,12),(198,12),(199,12),(200,12),(201,12),(202,12),(203,12),(204,12),(246,12),(247,12),(248,12),(249,12),(252,12),(254,12),(255,12),(256,12),(257,12),(258,12),(259,12),(260,12),(263,12),(267,12),(268,12),(269,12),(273,12),(275,12),(276,12),(278,12),(279,12),(284,12),(286,12),(287,12),(329,12),(332,12),(333,12),(334,12),(335,12),(336,12),(346,12),(352,12),(354,12),(406,12),(407,12),(432,12),(446,12),(478,12),(479,12),(3,13),(4,13),(79,13),(83,13),(84,13),(96,13),(97,13),(184,13),(185,13),(186,13),(187,13),(188,13),(203,13),(274,13),(320,13),(329,13),(334,13),(338,13),(381,13);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Admin','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(2,'Support Executive','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(3,'Support Manager','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(4,'Accounts Manager','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(5,'Accounts Executive','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(6,'Asst. Manager','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(7,'Store Manager','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(8,'Reseller Admin','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(9,'Account Manager X','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(10,'Accounts','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(11,'Sub Reseller','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(12,'Reseller','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(13,'Billing Man','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(14,'Marketing Manager','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(15,'Reseller user','web','2025-05-04 11:20:36','2025-05-04 11:20:36'),(16,'AAA','web','2025-05-04 12:33:13','2025-05-04 12:33:13');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `schedule_package_changes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `schedule_package_changes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint unsigned NOT NULL,
  `old_package_id` bigint unsigned NOT NULL,
  `old_sub_package_id` bigint unsigned DEFAULT NULL,
  `new_package_id` bigint unsigned NOT NULL,
  `new_sub_package_id` bigint unsigned DEFAULT NULL,
  `schedule_date` datetime NOT NULL,
  `schedule_by` bigint unsigned NOT NULL,
  `status` enum('Failed','Complete','Pending','Deleted') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Pending',
  `process_description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `schedule_package_changes` WRITE;
/*!40000 ALTER TABLE `schedule_package_changes` DISABLE KEYS */;
/*!40000 ALTER TABLE `schedule_package_changes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `serial_numbers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `serial_numbers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `purchase_id` bigint unsigned DEFAULT NULL,
  `item_return_id` bigint unsigned DEFAULT NULL,
  `item_id` bigint unsigned NOT NULL,
  `serial_no` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('used','notused') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remark` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `requisition_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `serial_numbers` WRITE;
/*!40000 ALTER TABLE `serial_numbers` DISABLE KEYS */;
/*!40000 ALTER TABLE `serial_numbers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `session_tracks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `session_tracks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `count` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `session_tracks` WRITE;
/*!40000 ALTER TABLE `session_tracks` DISABLE KEYS */;
/*!40000 ALTER TABLE `session_tracks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sms_apis`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sms_apis` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `apikey` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sender` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `balance_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `send_sms_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('disable','enable') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sms_apis` WRITE;
/*!40000 ALTER TABLE `sms_apis` DISABLE KEYS */;
/*!40000 ALTER TABLE `sms_apis` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sms_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sms_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'other',
  `delivery_message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` enum('processing','delivered','faild') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'processing',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sms_log` WRITE;
/*!40000 ALTER TABLE `sms_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `sms_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sms_payment_reminders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sms_payment_reminders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `step` enum('first','second') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'first',
  `expire_date` date DEFAULT NULL,
  `user_list` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `sms_payment_reminders_chk_1` CHECK (json_valid(`user_list`))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sms_payment_reminders` WRITE;
/*!40000 ALTER TABLE `sms_payment_reminders` DISABLE KEYS */;
/*!40000 ALTER TABLE `sms_payment_reminders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sms_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sms_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tamplate_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tamplate_body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sms_settings` WRITE;
/*!40000 ALTER TABLE `sms_settings` DISABLE KEYS */;
INSERT INTO `sms_settings` VALUES (1,'welcome','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09af\\u09bc {c_name}\\n\\u0987\\u0989\\u099c\\u09be\\u09b0 \\u0986\\u0987\\u09a1\\u09bf: {c_username}\\n\\u09aa\\u09be\\u09b8\\u0993\\u09af\\u09bc\\u09be\\u09b0\\u09cd\\u09a1: {c_password}\\n\\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u0986\\u0987\\u09a1\\u09bf \\u09b8\\u09ab\\u09b2\\u09ad\\u09be\\u09ac\\u09c7 \\u09af\\u09c1\\u0995\\u09cd\\u09a4 \\u0995\\u09b0\\u09be \\u09b9\\u09af\\u09bc\\u09c7\\u099b\\u09c7\\u0964 \\u09a7\\u09a8\\u09cd\\u09af\\u09ac\\u09be\\u09a6!\\n{company_name}\\n{company_cell}\"}',NULL,NULL),(2,'auto_inactive','{\"sms_body\":\"Dear {c_name}\\n\\u09ac\\u09bf\\u09b2 \\u09aa\\u09b0\\u09bf\\u09b6\\u09cb\\u09a7 \\u09a8\\u09be \\u0995\\u09b0\\u09be\\u09df \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u09b8\\u0982\\u09af\\u09cb\\u0997\\u099f\\u09bf \\u09ac\\u09a8\\u09cd\\u09a7 \\u09b9\\u09df\\u09c7 \\u0997\\u09c7\\u099b\\u09c7 \\u0964 {total_due} \\u099f\\u09be\\u0995\\u09be \\u09a6\\u09cd\\u09b0\\u09c1\\u09a4 \\u09aa\\u09b0\\u09bf\\u09b6\\u09cb\\u09a7 \\u0995\\u09b0\\u09c1\\u09a8 \\u0964\\n\\n{company_name}\\n{company_cell}\",\"minimum\":50,\"sendsms\":\"Yes\"}',NULL,NULL),(3,'due_bill','Dear {c_name}\nসংযোগ বিচ্ছিন্নকরন এড়াতে\n{c_deadline}-{this_month} তারিখের পূর্বে বিল পরিশোধ করুন ।\nমোট বিলঃ {total_due} টাকা\n\nধ্যনবাদ\n{company_name}\n{company_cell}',NULL,NULL),(4,'bill_payment','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09df \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 ({c_name}),\\n\\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u09ac\\u09bf\\u09b2 \\u09b8\\u09a0\\u09bf\\u0995 \\u09ad\\u09be\\u09ac\\u09c7 \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u09b9\\u09df\\u09c7\\u099b\\u09c7\\u0964 \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u099f\\u09be\\u0995\\u09be\\u09b0 \\u09aa\\u09b0\\u09bf\\u09ae\\u09be\\u09a8- TK {PaymentAmount} | \\u09af\\u09c7\\u0995\\u09cb\\u09a8\\u09cb \\u09a4\\u09a5\\u09cd\\u09af\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af \\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997 {company_cell} | {company_name} \\u098f\\u09b0 \\u09b8\\u09be\\u09a5\\u09c7 \\u09a5\\u09be\\u0995\\u09be\\u09b0 \\u099c\\u09a8\\u09cd\\u09af \\u09a7\\u09a8\\u09cd\\u09af\\u09ac\\u09be\\u09a6\\u0964\"}',NULL,NULL),(5,'other_collection','{\"sms_body_for_client\":\"Dear {c_name}\\nWe received {PaymentAmount} TK for {BillType}\\n\\nThanks\\n{company_name}\\n{company_cell}\",\"sms_body_for_extra_income\":\"Dear {Name}\\nWe received {PaymentAmount} TK for {BillType}\\n\\nThanks for your payment\\n{company_name}\\n{company_cell}\"}',NULL,NULL),(6,'support','{\"sms_body_for_client\":\"Dear {c_name}\\nTicket No: {token_no} (open)\\nTo: {department_to}\\nSubject: {support_subject}\\nWe will knock will soon\\n\\nThanks\\n{company_name}\\n{company_cell}\",\"sms_body_for_employee\":\"Dear {employee_name}\\nClient Name:{c_name},{c_number}\\nAddress: {c_address}\\n{support_subject} (#{token_no})\\n{support_massage}\"}',NULL,NULL),(7,'reseller_payment','{ResellerName}\nজমা: {PaymentAmount} টাকা\nডিস্কাউন্ট: {PaymentDiscount} টাকা\nমোট টাকা: {ColsingBalance} টাকা\n\nThanks\n{company_name}\n{company_cell}',NULL,NULL),(8,'bill_generate','{\"sendsms\":\"No\",\"sms_body\":\"Dear {c_name}\\n {MonthBillAmount} TK Bill generate for {bill_type}\\n\\nPlease Pay Before: 05 {ThisMonth}\\n\\n{company_name}\\n{company_cell}\"}',NULL,NULL),(9,'bill_reminder','{\"second_sendsms\":\"No\",\"frist_sendsms\":\"No\",\"frist_sms_body\":\"Dear {c_name}\\nLast 2nd day Remaning to Play your internet due bill {TotalDue}Tk\\nPlease Pay Your Bill as soon as possible\\nThanks\\n\\n{company_name}\\n{company_cell}\",\"second_sms_body\":\"Dear {c_name}\\nLast 1 day Remaning to Play your internet due bill {TotalDue}Tk\\nPlease Pay Your Bill as soon as possible\\nThanks\\n\\n{company_name}\\n{company_cell}\",\"first_reminder_day\":2,\"second_reminder_day\":1}',NULL,NULL),(10,'temporary_extended','{\"sendsms\":\"No\",\"sms_body\":\"Dear {c_name}\\nyour billing date extended to {new_billing_date} please pay in time \\nThanks \\n{company_name}\\n{company_cell}\"}',NULL,NULL),(11,'expired','{\"sendsms\":\"No\",\"sms_body\":\"Dear {c_name}\\nyour line is exipred please pay your due \\nThanks \\n{company_name}\\n{company_cell}\"}',NULL,NULL),(12,'token_create','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09af\\u09bc \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 {c_username}\\n\\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u09b8\\u09ae\\u09b8\\u09cd\\u09af\\u09be\\u099f\\u09bf \\u0986\\u09ae\\u09b0\\u09be \\u0985\\u09ac\\u0997\\u09a4 \\u09b9\\u09af\\u09bc\\u09c7\\u099b\\u09bf, \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u099f\\u09cb\\u0995\\u09c7\\u09a8 \\u0986\\u0987\\u09a1\\u09bf {token_id}\\n\\u09af\\u09c7 \\u0995\\u09cb\\u09a8 \\u09aa\\u09cd\\u09b0\\u09b6\\u09cd\\u09a8\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af {company_cell} \\u09a8\\u09ae\\u09cd\\u09ac\\u09b0\\u09c7 \\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997 \\u0995\\u09b0\\u09c1\\u09a8 |\"}',NULL,NULL),(13,'pop_expair_exception_delete','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09af\\u09bc \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 {c_name} \\n\\u09ac\\u09bf\\u09b2 \\u09aa\\u09b0\\u09bf\\u09b6\\u09cb\\u09a7 \\u09a8\\u09be \\u0995\\u09b0\\u09be\\u09b0 \\u099c\\u09a8\\u09cd\\u09af \\u09b8\\u09be\\u09ae\\u09df\\u09bf\\u0995 \\u09b8\\u09ae\\u09df\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u09b8\\u0982\\u09af\\u09cb\\u0997 \\u099f\\u09bf \\u09ac\\u09bf\\u099b\\u09bf\\u09a8\\u09cd\\u09a8 \\u0995\\u09b0\\u09be \\u09b9\\u09cb\\u09b2\\u0964 \\u09af\\u09c7 \\u0995\\u09cb\\u09a8 \\u09aa\\u09cd\\u09b0\\u09b6\\u09cd\\u09a8\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af {company_cell} \\u09a8\\u09ae\\u09cd\\u09ac\\u09b0\\u09c7 \\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997 \\u0995\\u09b0\\u09c1\\u09a8|\"}',NULL,NULL),(14,'reseller_customer_recharge','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09df \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 ({c_name}),\\n\\u0986\\u09aa\\u09a8\\u09be\\u09b0 {month} \\u09ae\\u09be\\u09b8 \\u09aa\\u09b0\\u09cd\\u09af\\u09a8\\u09cd\\u09a4 \\u09ac\\u09bf\\u09b2 \\u09b8\\u09a0\\u09bf\\u0995 \\u09ad\\u09be\\u09ac\\u09c7 \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u09b9\\u09df\\u09c7\\u099b\\u09c7\\u0964 {company_name} \\u098f\\u09b0 \\u09b8\\u09be\\u09a5\\u09c7 \\u09a5\\u09be\\u0995\\u09be\\u09b0 \\u099c\\u09a8\\u09cd\\u09af \\u09a7\\u09a8\\u09cd\\u09af\\u09ac\\u09be\\u09a6\\u0964  \\u09af\\u09c7\\u0995\\u09cb\\u09a8\\u09cb \\u09a4\\u09a5\\u09cd\\u09af\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af \\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997 {company_cell} \\u098f\\u0987 \\u09a8\\u09be\\u09ae\\u09cd\\u09ac\\u09be\\u09b0\\u09c7|\"}',NULL,NULL),(15,'disable_customer_sms','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09df \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 ({c_name}),\\n\\u0987\\u09a8\\u09cd\\u099f\\u09be\\u09b0\\u09a8\\u09c7\\u099f \\u09ac\\u09bf\\u09b2\\u09c7\\u09b0 \\u099f\\u09be\\u0995\\u09be \\u09a6\\u09c7\\u0993\\u09df\\u09be\\u09b0 \\u09b8\\u09ae\\u09df\\u09b8\\u09c0\\u09ae\\u09be \\u09b6\\u09c7\\u09b7 \\u09b9\\u0993\\u09df\\u09be\\u09b0 \\u0995\\u09be\\u09b0\\u09a8\\u09c7 \\u09b8\\u0982\\u09af\\u09cb\\u0997\\u099f\\u09bf \\u09b8\\u09be\\u09ae\\u09df\\u09bf\\u0995 \\u09ad\\u09be\\u09ac\\u09c7 \\u09ac\\u09bf\\u099a\\u09cd\\u099b\\u09bf\\u09a8\\u09cd\\u09a8 \\u09b9\\u09b2\\u09cb\\u0964 \\u0985\\u09a4\\u09bf\\u09b8\\u09a4\\u09cd\\u09ac\\u09b0 \\u09ac\\u09bf\\u09b2 \\u09aa\\u09b0\\u09bf\\u09b6\\u09cb\\u09a7 \\u0995\\u09b0\\u09c1\\u09a8\\u0964 \\u09b9\\u09c7\\u09b2\\u09cd\\u09aa\\u09b2\\u09be\\u0987\\u09a8 {company_cell}\"}',NULL,NULL),(16,'otc_payment_sms','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09df \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 ({c_name}),\\n {PaymentAmount} \\u099f\\u09be\\u0995\\u09be \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u09b9\\u09df\\u09c7\\u099b\\u09c7 OTC \\u09aa\\u09c7\\u09ae\\u09c7\\u09a8\\u09cd\\u099f \\u098f\\u09b0 \\u099c\\u09a8\\u09cd\\u09af\\u0964 \\u09af\\u09c7 \\u0995\\u09cb\\u09a8 \\u09aa\\u09cd\\u09b0\\u09b6\\u09cd\\u09a8\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af {company_cell} \\u09a8\\u09ae\\u09cd\\u09ac\\u09b0\\u09c7 \\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997 \\u0995\\u09b0\\u09c1\\u09a8|\"}',NULL,NULL),(17,'package_change_payment_sms','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09df \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 ({c_name}),\\n {PaymentAmount} \\u099f\\u09be\\u0995\\u09be \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u09b9\\u09df\\u09c7\\u099b\\u09c7 \\u09aa\\u09c7\\u0995\\u09c7\\u099c \\u099a\\u09c7\\u099e\\u09cd\\u099c \\u098f\\u09b0 \\u099c\\u09a8\\u09cd\\u09af\\u0964 \\u09af\\u09c7 \\u0995\\u09cb\\u09a8 \\u09aa\\u09cd\\u09b0\\u09b6\\u09cd\\u09a8\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af {company_cell} \\u09a8\\u09ae\\u09cd\\u09ac\\u09b0\\u09c7 \\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997 \\u0995\\u09b0\\u09c1\\u09a8|\"}',NULL,NULL),(18,'billing_cycle_change_payment_sms','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09df \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 ({c_name}),\\n {PaymentAmount} \\u099f\\u09be\\u0995\\u09be \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u09b9\\u09df\\u09c7\\u099b\\u09c7 \\u09ac\\u09bf\\u09b2\\u09bf\\u0982 \\u09b8\\u09be\\u0987\\u0995\\u09c7\\u09b2 \\u099a\\u09c7\\u099e\\u09cd\\u099c \\u098f\\u09b0 \\u099c\\u09a8\\u09cd\\u09af\\u0964 \\u09af\\u09c7 \\u0995\\u09cb\\u09a8 \\u09aa\\u09cd\\u09b0\\u09b6\\u09cd\\u09a8\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af {company_cell} \\u09a8\\u09ae\\u09cd\\u09ac\\u09b0\\u09c7 \\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997 \\u0995\\u09b0\\u09c1\\u09a8|\"}',NULL,NULL),(19,'new_customer_payment_sms','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09df \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 ({c_name}),\\n {PaymentAmount} \\u099f\\u09be\\u0995\\u09be \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u09b9\\u09df\\u09c7\\u099b\\u09c7 \\u09a8\\u09bf\\u0989 \\u0995\\u09be\\u09b8\\u09cd\\u099f\\u09ae\\u09be\\u09b0 \\u098f\\u09a8\\u09cd\\u099f\\u09cd\\u09b0\\u09bf \\u098f\\u09b0 \\u099c\\u09a8\\u09cd\\u09af\\u0964 \\u09af\\u09c7 \\u0995\\u09cb\\u09a8 \\u09aa\\u09cd\\u09b0\\u09b6\\u09cd\\u09a8\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af {company_cell} \\u09a8\\u09ae\\u09cd\\u09ac\\u09b0\\u09c7 \\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997 \\u0995\\u09b0\\u09c1\\u09a8|\"}',NULL,NULL),(20,'advanced_payment_sms','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09df \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995 ({c_name}),\\n {PaymentAmount} \\u099f\\u09be\\u0995\\u09be \\u09b8\\u0982\\u0997\\u09c3\\u09b9\\u09bf\\u09a4 \\u09b9\\u09df\\u09c7\\u099b\\u09c7 \\u0985\\u09cd\\u09af\\u09be\\u09a1\\u09ad\\u09be\\u09a8\\u09cd\\u09b8\\u09a1 \\u09aa\\u09c7\\u09ae\\u09c7\\u09a8\\u09cd\\u099f \\u098f\\u09b0 \\u099c\\u09a8\\u09cd\\u09af\\u0964 \\u09af\\u09c7 \\u0995\\u09cb\\u09a8 \\u09aa\\u09cd\\u09b0\\u09b6\\u09cd\\u09a8\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af {company_cell} \\u09a8\\u09ae\\u09cd\\u09ac\\u09b0\\u09c7 \\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997 \\u0995\\u09b0\\u09c1\\u09a8|\"}',NULL,NULL),(21,'token_create_customer_sms','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09af\\u09bc \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995, \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u09b8\\u09ae\\u09b8\\u09cd\\u09af\\u09be\\u099f\\u09bf \\u0986\\u09ae\\u09b0\\u09be \\u0985\\u09ac\\u0997\\u09a4 \\u09b9\\u09af\\u09bc\\u09c7\\u099b\\u09bf\\u0964 \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u099f\\u09cb\\u0995\\u09c7\\u09a8 \\u0986\\u0987\\u09a1\\u09bf {token_no}| \\u09af\\u09c7 \\u0995\\u09cb\\u09a8 \\u09aa\\u09cd\\u09b0\\u09b6\\u09cd\\u09a8\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af {company_cell} \\u09a8\\u09ae\\u09cd\\u09ac\\u09b0\\u09c7\\u00a0\\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997\\u00a0\\u0995\\u09b0\\u09c1\\u09a8\"}',NULL,NULL),(22,'token_assign_employee_sms','{\"sendsms\":\"No\",\"sms_body\":\"Token {token_no} ({token_code}) Contact: {reporter_contact_no} Solve Quickly\"}',NULL,NULL),(23,'token_assign_customer_sms','{\"sendsms\":\"No\",\"sms_body\":\"\\u09aa\\u09cd\\u09b0\\u09bf\\u09af\\u09bc \\u0997\\u09cd\\u09b0\\u09be\\u09b9\\u0995, \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u09b8\\u09ae\\u09b8\\u09cd\\u09af\\u09be\\u099f\\u09bf \\u0986\\u09ae\\u09b0\\u09be \\u0985\\u09ac\\u0997\\u09a4 \\u09b9\\u09af\\u09bc\\u09c7\\u099b\\u09bf\\u0964 \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u099f\\u09cb\\u0995\\u09c7\\u09a8 \\u0986\\u0987\\u09a1\\u09bf {token_no}| \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u09b8\\u09ae\\u09b8\\u09cd\\u09af\\u09be\\u099f\\u09bf {employee_name} ({employee_number})\\u09b8\\u09ae\\u09be\\u09a7\\u09be\\u09a8 \\u0995\\u09b0\\u09ac\\u09c7\\u0964 \\u09af\\u09c7 \\u0995\\u09cb\\u09a8 \\u09aa\\u09cd\\u09b0\\u09b6\\u09cd\\u09a8\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af {company_cell} \\u09a8\\u09ae\\u09cd\\u09ac\\u09b0\\u09c7\\u00a0\\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997\\u00a0\\u0995\\u09b0\\u09c1\\u09a8\"}',NULL,NULL),(24,'token_close_customer_sms','{\"sendsms\":\"No\",\"sms_body\":\"\\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u09b8\\u09ae\\u09b8\\u09cd\\u09af\\u09be\\u099f\\u09bf \\u09b8\\u09ae\\u09be\\u09a7\\u09be\\u09a8 \\u09b9\\u09af\\u09bc\\u09c7\\u099b\\u09c7\\u0964 \\u0986\\u09ae\\u09b0\\u09be \\u0986\\u09aa\\u09a8\\u09be\\u09b0 \\u099f\\u09cb\\u0995\\u09c7\\u09a8 \\u0986\\u0987\\u09a1\\u09bf {token_no} : {token_code} \\u09ae\\u09c1\\u099b\\u09c7 \\u09ab\\u09c7\\u09b2\\u09c7\\u099b\\u09bf\\u0964 \\u09af\\u09a6\\u09bf \\u098f\\u0996\\u09a8\\u09cb \\u09b8\\u09ae\\u09b8\\u09cd\\u09af\\u09be\\u09b0 \\u09b8\\u09ae\\u09be\\u09a7\\u09be\\u09a8 \\u09a8\\u09be \\u09b9\\u09af\\u09bc \\u09a4\\u09be\\u09b9\\u09b2\\u09c7 {company_cell} \\u098f\\u0987 \\u09a8\\u09ae\\u09cd\\u09ac\\u09b0 \\u098f \\u0985\\u09ad\\u09bf\\u09af\\u09cb\\u0997 \\u0995\\u09b0\\u09c1\\u09a8\\u0964\\u0986\\u09ae\\u09be\\u09a6\\u09c7\\u09b0 \\u09b8\\u09be\\u09a5\\u09c7 \\u09a5\\u09be\\u0995\\u09be\\u09b0\\u00a0\\u099c\\u09a8\\u09cd\\u09af\\u00a0\\u09a7\\u09a8\\u09cd\\u09af\\u09ac\\u09be\\u09a6\\u0964\"}',NULL,NULL),(25,'token_note_customer_sms','{\"sendsms\":\"No\",\"sms_body\":\"{note}| \\u09af\\u09c7 \\u0995\\u09cb\\u09a8 \\u09aa\\u09cd\\u09b0\\u09b6\\u09cd\\u09a8\\u09c7\\u09b0 \\u099c\\u09a8\\u09cd\\u09af {company_cell} \\u09a8\\u09ae\\u09cd\\u09ac\\u09b0\\u09c7 \\u09af\\u09cb\\u0997\\u09be\\u09af\\u09cb\\u0997 \\u0995\\u09b0\\u09c1\\u09a8|\"}',NULL,NULL),(26,'token_reassign_employee_sms','{\"sendsms\":\"No\",\"sms_body\":\"Token {token_no} ({token_code}) Contact: {reporter_contact_no} Solve Quickly\"}',NULL,NULL),(27,'reseller_balance_recharge_sms','{\"sendsms\":\"No\",\"sms_body\":\"Dear {reseller_name}\\nYour Balance Recharge {recharge_amount}Tk\\nYour Current Balance {current_balance}Tk\\n\\n\\nThanks\\n{company_name}\\n{company_cell}\"}',NULL,NULL);
/*!40000 ALTER TABLE `sms_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `splitter_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `splitter_map` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cluster_id` bigint unsigned NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'splitter',
  `cable_id` bigint unsigned DEFAULT NULL,
  `fiber_id` bigint unsigned DEFAULT NULL,
  `connected_component_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `connected_component_id` bigint unsigned DEFAULT NULL,
  `port_id` bigint unsigned DEFAULT NULL,
  `split_ratio` int NOT NULL,
  `used` int NOT NULL DEFAULT '0',
  `remarks` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `splitter_map` WRITE;
/*!40000 ALTER TABLE `splitter_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `splitter_map` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `splitter_out_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `splitter_out_map` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `splitter_id` bigint unsigned NOT NULL,
  `out_number` int NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'splitter_out',
  `fiber_id` bigint unsigned DEFAULT NULL,
  `cable_id` bigint unsigned DEFAULT NULL,
  `connected_component_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `connected_component_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `splitter_out_map` WRITE;
/*!40000 ALTER TABLE `splitter_out_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `splitter_out_map` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `stock_adjustment_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `stock_adjustment_id` bigint unsigned NOT NULL,
  `item_id` bigint unsigned NOT NULL,
  `quantity` decimal(16,2) NOT NULL,
  `serial_no` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_items` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustment_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `stock_adjustment_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `creator_user_id` bigint unsigned DEFAULT NULL,
  `updator_user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_types` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustment_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `stock_adjustments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `stock_adjustment_type_id` bigint unsigned NOT NULL,
  `creator_user_id` bigint unsigned NOT NULL,
  `approve_user_id` bigint unsigned DEFAULT NULL,
  `reason` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `status` enum('approved','not-approved') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments` WRITE;
/*!40000 ALTER TABLE `stock_adjustments` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_ins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `stock_ins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `item_id` bigint unsigned NOT NULL,
  `quantity` int NOT NULL,
  `purchase_id` bigint unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_ins_item_id_foreign` (`item_id`),
  KEY `stock_ins_purchase_id_foreign` (`purchase_id`),
  CONSTRAINT `stock_ins_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_ins_purchase_id_foreign` FOREIGN KEY (`purchase_id`) REFERENCES `purchases` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_ins` WRITE;
/*!40000 ALTER TABLE `stock_ins` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_ins` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_outs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `stock_outs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `item_id` bigint unsigned NOT NULL,
  `quantity` int NOT NULL,
  `requisition_id` bigint unsigned NOT NULL,
  `requisition_approve_id` bigint unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_outs_item_id_foreign` (`item_id`),
  KEY `stock_outs_requisition_id_foreign` (`requisition_id`),
  KEY `stock_outs_requisition_approve_id_foreign` (`requisition_approve_id`),
  CONSTRAINT `stock_outs_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_outs_requisition_approve_id_foreign` FOREIGN KEY (`requisition_approve_id`) REFERENCES `requisition_approves` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_outs_requisition_id_foreign` FOREIGN KEY (`requisition_id`) REFERENCES `requisitions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_outs` WRITE;
/*!40000 ALTER TABLE `stock_outs` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_outs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `store_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `store_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `clientId` bigint unsigned DEFAULT NULL,
  `device_id` bigint unsigned DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mack` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `serial` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `store_returns` WRITE;
/*!40000 ALTER TABLE `store_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `store_returns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sub_packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sub_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` bigint unsigned NOT NULL,
  `package_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `commission` decimal(16,2) DEFAULT NULL,
  `client_payment_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  KEY `sub_packages_reseller_id_foreign` (`reseller_id`),
  KEY `sub_packages_package_id_foreign` (`package_id`),
  CONSTRAINT `sub_packages_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE,
  CONSTRAINT `sub_packages_reseller_id_foreign` FOREIGN KEY (`reseller_id`) REFERENCES `resellers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sub_packages` WRITE;
/*!40000 ALTER TABLE `sub_packages` DISABLE KEYS */;
INSERT INTO `sub_packages` VALUES (3,1,23,'5Mbps_EE','500','2025-05-04 18:34:18','2025-05-04 18:35:55',NULL,0.00);
/*!40000 ALTER TABLE `sub_packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sub_reseller_balance_log_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sub_reseller_balance_log_report` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` bigint unsigned NOT NULL,
  `client_id` bigint unsigned NOT NULL,
  `action` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `amount` decimal(8,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `sub_reseller_id` bigint unsigned NOT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `before_balance` decimal(8,2) DEFAULT NULL,
  `after_balance` decimal(8,2) DEFAULT NULL,
  `reseller_cost` decimal(8,2) NOT NULL DEFAULT '0.00',
  `commission_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sub_reseller_balance_log_report` WRITE;
/*!40000 ALTER TABLE `sub_reseller_balance_log_report` DISABLE KEYS */;
/*!40000 ALTER TABLE `sub_reseller_balance_log_report` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sub_reseller_commission_reference`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sub_reseller_commission_reference` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `received_amount` decimal(16,2) DEFAULT NULL,
  `paid_amount` decimal(16,2) DEFAULT NULL,
  `actions` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pop_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `comments` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `client_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sub_reseller_commission_reference` WRITE;
/*!40000 ALTER TABLE `sub_reseller_commission_reference` DISABLE KEYS */;
/*!40000 ALTER TABLE `sub_reseller_commission_reference` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sub_reseller_package`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sub_reseller_package` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `sub_reseller_package_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reseller_id` bigint unsigned NOT NULL,
  `package_id` bigint unsigned NOT NULL,
  `sub_reseller_price` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sub_reseller_package` WRITE;
/*!40000 ALTER TABLE `sub_reseller_package` DISABLE KEYS */;
/*!40000 ALTER TABLE `sub_reseller_package` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sub_reseller_recharge_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sub_reseller_recharge_report` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pop_id` bigint unsigned NOT NULL,
  `amount` decimal(8,2) DEFAULT NULL,
  `after_recharge_balance` decimal(8,2) DEFAULT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payment_type` enum('cash','online') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_gateway` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_gateway_transaction_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `txn_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sub_reseller_recharge_report` WRITE;
/*!40000 ALTER TABLE `sub_reseller_recharge_report` DISABLE KEYS */;
/*!40000 ALTER TABLE `sub_reseller_recharge_report` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `suppliers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bn_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt_mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `division_id` bigint unsigned DEFAULT NULL,
  `district_id` bigint unsigned DEFAULT NULL,
  `upazila_id` bigint unsigned DEFAULT NULL,
  `area` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `contact_person_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_person_mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('Active','Inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Active',
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `creator_user_id` bigint unsigned DEFAULT NULL,
  `updator_user_id` bigint unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `suppliers_slug_unique` (`slug`),
  KEY `suppliers_creator_user_id_foreign` (`creator_user_id`),
  KEY `suppliers_updator_user_id_foreign` (`updator_user_id`),
  CONSTRAINT `suppliers_creator_user_id_foreign` FOREIGN KEY (`creator_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `suppliers_updator_user_id_foreign` FOREIGN KEY (`updator_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `suppliers` WRITE;
/*!40000 ALTER TABLE `suppliers` DISABLE KEYS */;
/*!40000 ALTER TABLE `suppliers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `thanas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `thanas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `upazila_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bn_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `thanas` WRITE;
/*!40000 ALTER TABLE `thanas` DISABLE KEYS */;
/*!40000 ALTER TABLE `thanas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tj_box_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tj_box_map` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `coordinates` json NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'tjBox',
  `remarks` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tj_box_map` WRITE;
/*!40000 ALTER TABLE `tj_box_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `tj_box_map` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `token_cats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `token_cats` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenCategory` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `token_cats` WRITE;
/*!40000 ALTER TABLE `token_cats` DISABLE KEYS */;
INSERT INTO `token_cats` VALUES (1,'Problem',NULL,NULL),(2,'Connection',NULL,NULL),(3,'Info',NULL,NULL);
/*!40000 ALTER TABLE `token_cats` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `token_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `token_codes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenCategory` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenCode` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `token_codes` WRITE;
/*!40000 ALTER TABLE `token_codes` DISABLE KEYS */;
INSERT INTO `token_codes` VALUES (1,'1','651/678 Local Problem',NULL,NULL),(2,'1','691/629 Username Pass Inv',NULL,NULL),(3,'1','738 LAN Card Disable',NULL,NULL),(4,'1','Bandwidth Problem',NULL,NULL),(5,'1','BDIX Down',NULL,NULL),(6,'1','Bill Collection',NULL,NULL),(7,'1','Browsing Problem',NULL,NULL),(8,'1','Cable Cut',NULL,NULL),(9,'1','Central Problem',NULL,NULL),(10,'1','Dialer Problem',NULL,NULL),(11,'1','DNS Problem',NULL,NULL),(12,'1','Electricity Problem',NULL,NULL),(13,'1','Facebook Browsing Problem',NULL,NULL),(14,'1','Fiber Cut',NULL,NULL),(15,'1','Fiber Signal Problem',NULL,NULL),(16,'1','FTP Problem',NULL,NULL),(17,'1','Getting (Error 691)',NULL,NULL),(18,'1','GGC Down',NULL,NULL),(19,'1','High Latency',NULL,NULL),(20,'1','ID Check Option',NULL,NULL),(21,'1','Internet Speed',NULL,NULL),(22,'1','IP Pool Issue',NULL,NULL),(23,'1','Line Disconnect Problem',NULL,NULL),(24,'1','Link Down',NULL,NULL),(25,'1','MC Problem',NULL,NULL),(26,'1','Mikrotik Problem',NULL,NULL),(27,'1','Others',NULL,NULL),(28,'1','Outlook Problem',NULL,NULL),(29,'1','Packet Loss',NULL,NULL),(30,'1','Physical Problem (651/678',NULL,NULL),(31,'1','Power Backup Problem',NULL,NULL),(32,'1','Real IP Speed Problem',NULL,NULL),(33,'1','Software Problem',NULL,NULL),(34,'1','Switch Down/Problem',NULL,NULL),(35,'1','TV Channel Problem',NULL,NULL),(36,'1','Underground Down',NULL,NULL),(37,'1','Upload Problem',NULL,NULL),(38,'1','Voice Chat Problem',NULL,NULL),(39,'1','Website access problem',NULL,NULL),(40,'1','Wifi Router Configuration',NULL,NULL),(41,'1','Wifi Router Problem',NULL,NULL),(42,'1','YouTube Buffering',NULL,NULL),(43,'1','YouTube Speed Problem',NULL,NULL),(44,'2','Close',NULL,NULL),(45,'2','Disable',NULL,NULL),(46,'2','Enable',NULL,NULL),(47,'2','Reopen',NULL,NULL),(48,'3','Contact Details Update',NULL,NULL),(49,'3','House Shift',NULL,NULL),(50,'3','Misc',NULL,NULL),(51,'3','New Package create of Res',NULL,NULL),(52,'3','New Package info of Resel',NULL,NULL),(53,'3','Package Upgrade',NULL,NULL),(54,'3','Package Downgrade',NULL,NULL),(55,'3','Request For MAC Change',NULL,NULL),(56,'3','Shifting Connectivity',NULL,NULL);
/*!40000 ALTER TABLE `token_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `token_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `token_notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `token_id` bigint unsigned NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `note_type` enum('employee','customer') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `client_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `token_notes` WRITE;
/*!40000 ALTER TABLE `token_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `token_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `token_sources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `token_sources` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `token_sources` WRITE;
/*!40000 ALTER TABLE `token_sources` DISABLE KEYS */;
/*!40000 ALTER TABLE `token_sources` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenCategory` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenCode` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reportedBy` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reporterContact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `assignToken` bigint unsigned DEFAULT NULL,
  `status` enum('Active','Inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `clientId` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assignUserId` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `closeUserId` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `createdBy` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `createByClient` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `assign_time` datetime DEFAULT NULL,
  `close_time` datetime DEFAULT NULL,
  `previous_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ping_loss` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `optical_power` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remote` tinyint DEFAULT NULL,
  `autoreboot` tinyint DEFAULT NULL,
  `issue_type` enum('Physical','Logical') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_feedback` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token_source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tokens` WRITE;
/*!40000 ALTER TABLE `tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tube_map`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tube_map` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cable_id` bigint unsigned NOT NULL,
  `tube_number` int NOT NULL,
  `fiber_count` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tube_map` WRITE;
/*!40000 ALTER TABLE `tube_map` DISABLE KEYS */;
/*!40000 ALTER TABLE `tube_map` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `uddokta_pay_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `uddokta_pay_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('pending','done') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `uddokta_pay_logs` WRITE;
/*!40000 ALTER TABLE `uddokta_pay_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `uddokta_pay_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `units` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `bn_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remarks` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `creator_user_id` bigint unsigned DEFAULT NULL,
  `updator_user_id` bigint unsigned DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `units_creator_user_id_foreign` (`creator_user_id`),
  KEY `units_updator_user_id_foreign` (`updator_user_id`),
  CONSTRAINT `units_creator_user_id_foreign` FOREIGN KEY (`creator_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `units_updator_user_id_foreign` FOREIGN KEY (`updator_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `upazilas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `upazilas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `district_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bn_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `upazilas_district_id_foreign` (`district_id`),
  CONSTRAINT `upazilas_district_id_foreign` FOREIGN KEY (`district_id`) REFERENCES `districts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `upazilas` WRITE;
/*!40000 ALTER TABLE `upazilas` DISABLE KEYS */;
/*!40000 ALTER TABLE `upazilas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `update_time_less_then_5_minutes`;
/*!50001 DROP VIEW IF EXISTS `update_time_less_then_5_minutes`*/;
SET @saved_cs_client     = @@character_set_client;
/*!50503 SET character_set_client = utf8mb4 */;
/*!50001 CREATE VIEW `update_time_less_then_5_minutes` AS SELECT 
 1 AS `username`,
 1 AS `acctstarttime`,
 1 AS `acctupdatetime`,
 1 AS `acctinterval`,
 1 AS `acctsessiontime`*/;
SET character_set_client = @saved_cs_client;
DROP TABLE IF EXISTS `user_accountings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_accountings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `received_amount` decimal(16,2) DEFAULT NULL,
  `paid_amount` decimal(16,2) DEFAULT NULL,
  `actions` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comments` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `client_id` bigint unsigned DEFAULT NULL,
  `accounting_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_accountings` WRITE;
/*!40000 ALTER TABLE `user_accountings` DISABLE KEYS */;
INSERT INTO `user_accountings` VALUES (1,10000.00,0.00,'Reseller payment received from Ekram 11',NULL,3,'2025-05-04 12:12:27','2025-05-04 12:12:27',NULL,'',''),(2,336.00,0.00,'Reseller payment received from Ekram 11',NULL,3,'2025-05-04 17:25:31','2025-05-04 17:25:31',NULL,'','');
/*!40000 ALTER TABLE `user_accountings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_balance_log_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_balance_log_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` int NOT NULL,
  `remarks` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_balance_log_histories` WRITE;
/*!40000 ALTER TABLE `user_balance_log_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_balance_log_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_balance_recharge_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_balance_recharge_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `amount` decimal(16,2) DEFAULT NULL,
  `after_recharge_balance` decimal(16,2) DEFAULT NULL,
  `remarks` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL,
  `recharge_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_balance_recharge_histories` WRITE;
/*!40000 ALTER TABLE `user_balance_recharge_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_balance_recharge_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_details` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `company` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `message` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token_admin` enum('no','yes') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_status` enum('pending','active','deactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `last_edit_by` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_details` WRITE;
/*!40000 ALTER TABLE `user_details` DISABLE KEYS */;
INSERT INTO `user_details` VALUES (1,1,NULL,NULL,'no','active','2025-05-04 11:20:36','2025-05-04 11:20:36',NULL),(2,2,NULL,NULL,'no','active','2025-05-04 11:20:36','2025-05-04 11:20:36',NULL),(3,3,'Space Walker',NULL,'no','active',NULL,NULL,1),(4,4,'Brother\'s Online',NULL,'no','active',NULL,NULL,4);
/*!40000 ALTER TABLE `user_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `client_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_log` WRITE;
/*!40000 ALTER TABLE `user_log` DISABLE KEYS */;
INSERT INTO `user_log` VALUES (1,'id_approved',4,'Client Created','2025-05-04 16:28:07','2025-05-04 16:28:07',1);
/*!40000 ALTER TABLE `user_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_log_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_log_details` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `last_ip` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `device_info` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_log_details` WRITE;
/*!40000 ALTER TABLE `user_log_details` DISABLE KEYS */;
INSERT INTO `user_log_details` VALUES (1,0,'202.136.89.110','2025-05-04 11:23:34',NULL,'rokibulhasan.356@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(2,0,'202.136.89.110','2025-05-04 11:27:40',NULL,'sayadgmxr@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(3,0,'202.136.89.110','2025-05-04 11:29:37',NULL,'rokibulhasan.356@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36 Edg/136.0.0.0'),(4,0,'103.20.243.51','2025-05-04 11:29:45',NULL,'sayadgmxr@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(5,0,'202.136.89.110','2025-05-04 11:46:24',NULL,'rokibulhasan.356@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(6,0,'103.20.243.51','2025-05-04 12:24:44',NULL,'sayadgmxr@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(7,0,'103.20.243.51','2025-05-04 12:29:33',NULL,'sayadgmxr@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(8,0,'202.136.89.110','2025-05-04 14:14:40',NULL,'rokibulhasan.356@gmail.com','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(9,0,'103.20.243.51','2025-05-04 16:17:46',NULL,'Imtiazikramipho@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(10,0,'103.20.243.51','2025-05-04 16:18:08',NULL,'Imtiazikramipho@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(11,0,'103.20.243.51','2025-05-04 16:18:47',NULL,'sayadgmxr@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(12,0,'103.20.243.51','2025-05-04 16:19:42',NULL,'Imtiazikramipho@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(13,0,'103.20.243.51','2025-05-04 16:22:41',NULL,'Imtiazikramipho@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(14,0,'103.20.243.51','2025-05-04 16:22:47',NULL,'sayadgmxr@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(15,0,'103.111.225.247','2025-05-04 17:25:17',NULL,'ImtiazImtiazikramipho@Gmail.com','Mozilla/5.0 (iPhone; CPU iPhone OS 15_8_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.6.6 Mobile/15E148 Safari/604.1'),(16,0,'103.111.225.247','2025-05-04 17:26:08',NULL,'Imtiazikramipho@Gmail','Mozilla/5.0 (iPhone; CPU iPhone OS 15_8_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.6.6 Mobile/15E148 Safari/604.1'),(17,0,'103.20.243.51','2025-05-04 17:29:25',NULL,'Imtiazikramipho@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(18,0,'103.20.243.51','2025-05-04 17:30:17',NULL,'sayadgmxr@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(19,0,'103.111.225.247','2025-05-04 17:31:42',NULL,'Imtiazikramipho@Gmail.com','Mozilla/5.0 (iPhone; CPU iPhone OS 15_8_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.6.6 Mobile/15E148 Safari/604.1'),(20,0,'103.20.243.51','2025-05-04 18:27:30',NULL,'Imtiazikramipho@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(21,0,'103.111.225.247','2025-05-04 20:56:48',NULL,'Imtiazikramipho@Gmail.com','Mozilla/5.0 (iPhone; CPU iPhone OS 15_8_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.6.6 Mobile/15E148 Safari/604.1'),(22,0,'103.170.204.190','2025-05-05 04:17:42',NULL,'rokibulhasan.356@gmail.com','Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Mobile Safari/537.36'),(23,0,'103.20.243.51','2025-05-05 05:40:09',NULL,'Imtiazikramipho@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(24,0,'202.136.89.110','2025-05-05 06:20:24',NULL,'rokibulhasan.356@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(25,0,'202.136.89.110','2025-05-05 06:26:47',NULL,'rokibulhasan.356@gmail.com','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36 Edg/136.0.0.0'),(26,0,'202.136.89.110','2025-05-05 10:32:27',NULL,'rokibulhasan.356@gmail.com','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36'),(27,0,'103.111.225.247','2025-05-05 12:18:39',NULL,'Imtiazikramipho@Gmail.com','Mozilla/5.0 (iPhone; CPU iPhone OS 15_8_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.6.6 Mobile/15E148 Safari/604.1');
/*!40000 ALTER TABLE `user_log_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_balance` decimal(16,2) DEFAULT NULL,
  `last_login_at` datetime DEFAULT NULL,
  `last_login_ip` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_balance_check` enum('no','yes') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_accounting_status` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `isActive` enum('yes','no') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile_number` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `minimum_recharge_day` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'system','rokibulhasan.356@gmail.com',NULL,'$2y$10$TVJcbSIJJgmYrSjgrk6VYOEJCk1XyNHaVRI/c4mLRctbGbu2bD/1m',NULL,'2025-05-04 11:20:36','2025-05-04 11:20:36',NULL,NULL,NULL,'no','yes','yes',NULL,NULL),(2,'Support','support@yetfix.com',NULL,'$2y$10$YQJ1LYxq9PAlMeRccThTb.iS5LNxKsRvrVlrshcBFqTEw0Kc5R4J2',NULL,'2025-05-04 11:20:36','2025-05-04 11:20:36',NULL,NULL,NULL,'no','yes','yes',NULL,NULL),(3,'Gazi Saad','sayadgmxr@gmail.com',NULL,'$2y$10$yBIVnXpV12P2S.gjBYtKL.ZpeLwCdrl.KElGLaOvfWK4mdZilbmpO','GuyIkzLLP2DtvuntV5ghcF4lSEPiFAxEyBJZxhgAUJF34lDIE1OwrRG6nqed','2025-05-04 11:26:12','2025-05-04 11:26:12',NULL,NULL,NULL,'no','yes','yes','01633307601',NULL),(4,'MD. IMTIAZ IKRAM','Imtiazikramipho@gmail.com',NULL,'$2y$10$gHV58DU/K9UyrKI4fyhazeqv8C0HK4UU3s.fK2IwwM2S9BeRw8mga','kJRKYPRLBbdDsu1CzqVsz4DKkmhPzDtzb0csD1SgpTNIqcH7bnlSq80NJwuu','2025-05-04 16:13:37','2025-05-04 21:03:24',NULL,NULL,NULL,'no','','yes','01811222417',NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!50001 DROP VIEW IF EXISTS `current_update_time_difference`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `current_update_time_difference` AS select 1 AS `username`,1 AS `acctinterval`,1 AS `acctstarttime`,1 AS `acctupdatetime`,1 AS `TIMESTAMPDIFF(MINUTE, acctupdatetime, now() )` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!50001 DROP VIEW IF EXISTS `update_time_less_then_5_minutes`*/;
/*!50001 SET @saved_cs_client          = @@character_set_client */;
/*!50001 SET @saved_cs_results         = @@character_set_results */;
/*!50001 SET @saved_col_connection     = @@collation_connection */;
/*!50001 SET character_set_client      = utf8mb4 */;
/*!50001 SET character_set_results     = utf8mb4 */;
/*!50001 SET collation_connection      = utf8mb4_general_ci */;
/*!50001 CREATE ALGORITHM=UNDEFINED */
/*!50013 DEFINER=`root`@`localhost` SQL SECURITY DEFINER */
/*!50001 VIEW `update_time_less_then_5_minutes` AS select 1 AS `username`,1 AS `acctstarttime`,1 AS `acctupdatetime`,1 AS `acctinterval`,1 AS `acctsessiontime` */;
/*!50001 SET character_set_client      = @saved_cs_client */;
/*!50001 SET character_set_results     = @saved_cs_results */;
/*!50001 SET collation_connection      = @saved_col_connection */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

