<?php
    use Carbon\Carbon;
?>
<?php $__env->startSection('content'); ?>
    
    <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="row">
            <div class="col-md-3">
                <div class="card ml-1">
                    <div class="card-body">
                        <?php if(checkSettings('profilePicture') == 'enable'): ?>
                            <div class="form-group col-sm-3">
                                <?php if($r->profilePicture != null): ?>
                                    <img width="150" height="150" style="border-radius: 50%"
                                        src="<?php echo e(asset('storage/customer_profile_picture/' . $r->customer_profile_picture)); ?>"
                                        alt="No Image">
                                <?php else: ?>
                                    <div
                                        style="background: #f0ede1;
                                    width: 200px;
                                    height: 200px;
                                    border-radius: 1%;">
                                    </div>
                                <?php endif; ?>
                            </div>
                            <label for="profilePicture" class="block pt-2">
                                Name : <?php echo e($r->clients_name); ?>

                            </label>
                        <?php endif; ?>

                        <div class="card-header p-0 pt-1">
                            <ul class="nav nav-tabs" id="custom-tabs-one-tab" role="tablist">

                                <li class="nav-item">
                                    <a class="nav-link active" id="custom-tabs-one-auto-wellcome-sms-tab" data-toggle="pill"
                                        href="#custom-tabs-one-auto-wellcome-sms" role="tab"
                                        aria-controls="custom-tabs-one-auto-wellcome-sms" aria-selected="true">Service</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="custom-tabs-one-bill-payment-tab" data-toggle="pill"
                                        href="#custom-tabs-one-bill-payment" role="tab"
                                        aria-controls="custom-tabs-one-bill-payment" aria-selected="false">Personal</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="custom-tabs-one-bill-address-tab" data-toggle="pill"
                                        href="#custom-tabs-one-bill-address" role="tab"
                                        aria-controls="custom-tabs-one-bill-address" aria-selected="false">Address</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="custom-tabs-one-bill-connection-tab" data-toggle="pill"
                                        href="#custom-tabs-one-bill-connection" role="tab"
                                        aria-controls="custom-tabs-one-bill-connection" aria-selected="false">Connection</a>
                                </li>
                            </ul>
                        </div>
                        <div class="row mt-2 ml-1">
                            <div class="mr-2 mt-1">
                                <a href="<?php echo e(route('clients.index')); ?>" class="btn btn-default"><i
                                        class="fa fa-arrow-left"></i> Back</a>
                            </div>
                            <div class="mr-2 mt-1">
                                <?php if(checkSettings('show-traffice') == 'enable' && $r->client_approval != 'pending'): ?>
                                    <a class="btn btn-primary" id="speedshow">Show Speed</a>
                                <?php endif; ?>
                            </div>
                            
                            <div class="mt-1">
                                <?php if($customer_account > 0): ?>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mac-customer_destroy')): ?>
                                        <form method="POST" action="<?php echo e(route('clients.destroy', $r->client_id)); ?>">
                                            <?php echo method_field('DELETE'); ?>
                                            <?php echo csrf_field(); ?>
                                            <button style=""
                                                onclick="return confirm('Are you sure you want to Perform the Action?');"
                                                type="submit"class="btn btn-danger ">Delete</button>
                                        </form>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-9">
                <div class="card ml-2">
                    <div class="card-body pl-2 ">
                        <div class="tab-content" id="custom-tabs-one-tabContent">

                            <div class="tab-pane fade show active" id="custom-tabs-one-auto-wellcome-sms" role="tabpanel"
                                aria-labelledby="custom-tabs-one-auto-wellcome-sms-tab">
                                <div class="container col-md-12">
                                    <div class="card-body">

                                        <div class="bg-primary">
                                            <h4 style="text-align: center;">Service Information</h4>
                                        </div>
                                        <div class="table-responsive">
                                            <table class="table table-borderd table-condensed">
                                                <tr>
                                                    <td>Pop Name</td>
                                                    <td><?php echo e($r->popname); ?></td>
                                                    <td>Billing Cycle</td>
                                                    <td><?php echo e($r->billing_cycle); ?></td>
                                                </tr>
                                                <tr>
                                                    <?php if(!$r->isStatic): ?>
                                                        <td>User Name</td>
                                                        <td><?php echo e($r->userid); ?></td>
                                                    <?php else: ?>
                                                        <td>
                                                            IP Address
                                                        </td>
                                                        <td>
                                                            <?php echo e($r->ip_address); ?>

                                                        </td>
                                                    <?php endif; ?>

                                                    <?php if(!$r->isStatic): ?>
                                                        <td>Password</td>
                                                        <td><?php echo e($r->password); ?></td>
                                                    <?php endif; ?>

                                                </tr>
                                                <tr>
                                                    <td>Package Name</td>
                                                    <?php if($r->sub_package_name != null && $r->subreseller == 'yes'): ?>
                                                        <td>
                                                            <?php echo e($r->sub_package_name); ?>

                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show-mother-package')): ?>
                                                                <br>
                                                                <?php echo e($r->package_name); ?>

                                                            <?php endif; ?>
                                                        </td>
                                                    <?php else: ?>
                                                        <td><?php echo e($r->package_name); ?></td>
                                                    <?php endif; ?>
                                                    <td>Expired Date</td>
                                                    <td> <?php echo e($r->expire_date ?? ''); ?></td>
                                                </tr>
                                                <tr>
                                                    <td> Enable MAC</td>
                                                    <td> <?php echo e($r->mac ?? ''); ?></td>
                                                    <td>Slug</td>
                                                    <td> <?php echo e($r->slug ?? ''); ?></td>
                                                </tr>

                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="custom-tabs-one-bill-payment" role="tabpanel"
                                aria-labelledby="custom-tabs-one-bill-payment-tab">
                                <div class="container col-md-12">
                                    <div class="card-body">
                                        <?php if(checkSettings('profilePicture') == 'enable'): ?>
                                            <label for="">Customer Agrement : </label>
                                            <img class="mb-3" width="150" height="150"
                                                src="<?php echo e(asset('storage/customer_agrement/' . $r->customer_agrement)); ?>"
                                                alt="No Image">
                                            <label for="">Circle Form : </label>
                                            <img class="mb-3" width="150" height="150"
                                                src="<?php echo e(asset('storage/profilePicture/' . $r->profilePicture)); ?>"
                                                alt="No Image">
                                        <?php endif; ?>
                                        <div class="bg-primary">
                                            <h4 style="text-align: center;">Personal Information</h4>
                                        </div>
                                        <div class="table-responsive">
                                            <table class="table table-borderd table-condensed">
                                                <tr>
                                                    <td> Client Name</td>
                                                    <td><?php echo e($r->clients_name); ?></td>
                                                    <td>Date Of Birth</td>
                                                    <td>
                                                        <?php if($r->dob): ?>
                                                            <?php echo e(date('d-M-Y', strtotime($r->dob))); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>Contact No</td>
                                                    <td><?php echo e($r->contact_no ?? ''); ?></td>
                                                    <td>Email</td>
                                                    <td> <?php echo e($r->email ?? ''); ?></td>
                                                </tr>
                                                <tr>
                                                    <td>Father Name</td>
                                                    <td><?php echo e($r->father_name ?? ''); ?></td>
                                                    <td>Mother Name</td>
                                                    <td> <?php echo e($r->mother_name ?? ''); ?></td>
                                                </tr>
                                                <tr>
                                                    <td>National ID</td>
                                                    <td><?php echo e($r->national_id ?? ''); ?></td>
                                                    <td> Passport No</td>
                                                    <td><?php echo e($r->passport_no ?? ''); ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="custom-tabs-one-bill-address" role="tabpanel"
                                aria-labelledby="custom-tabs-one-bill-address-tab">
                                <div class="container col-md-12">
                                    <div class="card-body">
                                        <?php if(checkSettings('profilePicture') == 'enable'): ?>
                                            <label for="">Building Photo : </label>
                                            <img class="mb-3" width="150" height="150"
                                                src="<?php echo e(asset('storage/picture/' . $r->picture)); ?>" alt="No Image">
                                            <label for="">Client Flat Door Picture : </label>
                                            <img class="mb-3" width="150" height="150"
                                                src="<?php echo e(asset('storage/client_door/' . $r->client_door)); ?>"
                                                alt="No Image">
                                        <?php endif; ?>
                                        <div class="bg-primary">
                                            <h4 style="text-align: center;">Address</h4>
                                        </div>
                                        <div class="table-responsive">
                                            <table class="table table-borderd table-condensed">
                                                <tr>
                                                    <td>Road No</td>
                                                    <td><?php echo e($r->road_no ?? ''); ?></td>
                                                    <td> Road Name</td>
                                                    <td><?php echo e($r->road_name ?? ''); ?></td>
                                                </tr>
                                                <tr>
                                                    <td> Flat/Level No</td>
                                                    <td><?php echo e($r->flat_no ?? ''); ?></td>
                                                    <td>Building No</td>
                                                    <td><?php echo e($r->building_no ?? ''); ?></td>
                                                </tr>
                                                <tr>
                                                    <td>Building Name</td>
                                                    <td><?php echo e($r->building_name ?? ''); ?></td>
                                                    <td>Block/Sector</td>
                                                    <td><?php echo e($r->block_sector ?? ''); ?></td>
                                                </tr>
                                                <tr>
                                                    <td>Latitude</td>
                                                    <td><?php echo e($r->client_latitude ?? ''); ?></td>
                                                    <td>Longitude</td>
                                                    <td><?php echo e($r->client_longitude ?? ''); ?></td>
                                                </tr>
                                                <tr>
                                                    <td> Area</td>
                                                    <td><?php echo e($r->area ?? ''); ?></td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="tab-pane fade" id="custom-tabs-one-bill-connection" role="tabpanel"
                                aria-labelledby="custom-tabs-one-bill-connection-tab">
                                <div class="container col-md-12">
                                    <div class="card-body">
                                        <div class="bg-primary">
                                            <h4 style="text-align: center;">Connection Info</h4>
                                        </div>
                                        <div class="table-responsive">
                                            <table class="table table-borderd table-condensed">
                                                <?php if($r->bill_generate == 'yes'): ?>
                                                    <tr>
                                                        <td>Cable type</td>
                                                        <td><?php echo e($r->cable_type ?? ''); ?></td>
                                                        <td>Cable Length(Meter)</td>
                                                        <td><?php echo e($r->required_cable ?? ''); ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Cable ID</td>
                                                        <td><?php echo e($r->cable_id ?? ''); ?></td>
                                                        <td>Cable Type(CAT5/CAT6)</td>
                                                        <td><?php echo e($r->cat_type ?? ''); ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td>Cable(CAT-5/CAT-6) Length(Meter)</td>
                                                        <td><?php echo e($r->cat_length ?? ''); ?></td>
                                                        <td>ONU MAC/Pon No/Serial No</td>
                                                        <td><?php echo e($r->onu_serial ?? ''); ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td>OLT No</td>
                                                        <td><?php echo e($r->olt_pon); ?></td>
                                                        <td>OLT Card Slot Number </td>
                                                        <td><?php echo e($r->olt_no); ?></td>
                                                    </tr>
                                                    <tr>
                                                        <td>PON Module Port No</td>
                                                        <td><?php echo e($r->pon_port); ?></td>
                                                        <td>Box</td>
                                                        <td><?php echo e($r->box); ?></td>
                                                    </tr>
                                                <?php endif; ?>
                                                <tr>
                                                    <td>Connection Date :</td>
                                                    <td>
                                                        <strong>CD:</strong>
                                                        <?php echo e(date('d-M-Y h:i:sa', strtotime($r->created_at))); ?><br>
                                                        <?php if($r->joinDate): ?>
                                                            <strong>JD:</strong>
                                                            <?php echo e(date('d-M-Y', strtotime($r->joinDate))); ?>

                                                        <?php endif; ?>
                                                    </td>

                                                    <?php if(auth()->user()->hasRole('Reseller Admin')): ?>
                                                    <?php elseif(auth()->user()->hasRole('Sub Reseller')): ?>
                                                    <?php else: ?>
                                                        <td>Marketed By</td>
                                                        <?php if($r->marketed_by == 0): ?>
                                                            <td>No Marketing</td>
                                                        <?php else: ?>
                                                            <?php
                                                                $m = App\Models\ClientReferer::where(
                                                                    'id',
                                                                    $r->marketed_by,
                                                                )->first();
                                                            ?>
                                                            <td><?php echo e($m->firstname ?? ''); ?> <?php echo e($m->lastname ?? ''); ?></td>
                                                            
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </tr>
                                                <tr>
                                                    <td>Remarks</td>
                                                    <td><?php echo e($r->remarks ?? ''); ?></td>

                                                    <td style="">
                                                        
                                                        <?php ($permissions = userPermissions()); ?>
                                                        <?php if(checkSettings('local-user-first-approve') == 'enable'): ?>
                                                            <?php if(in_array('local-user-first-approve', $permissions)): ?>
                                                                <?php if($r->first_approval == 'Pending'): ?>
                                                                    <form action="<?php echo e(route('firstApproveAllPending')); ?>"
                                                                        method="post" id="firstAllPendingApproveForm">
                                                                        <?php echo csrf_field(); ?>
                                                                        <?php echo method_field('post'); ?>
                                                                        <input type="hidden" name="first_client_ids[]"
                                                                            id="first_client_ids"
                                                                            value="<?php echo e($r->client_id); ?>">

                                                                        <button class="btn btn-primary"
                                                                            id="firstAllApprove"><i
                                                                                class="fa fa-check"></i>Final
                                                                            Approve</button>
                                                                    </form>
                                                                <?php endif; ?>
                                                            <?php elseif(in_array('new-customer-approve', $permissions)): ?>
                                                                <?php if($r->client_approval == 'pending'): ?>
                                                                    <form action="<?php echo e(route('approveAllPending')); ?>"
                                                                        method="post" id="allPendingApproveForm">
                                                                        <?php echo csrf_field(); ?>
                                                                        <?php echo method_field('post'); ?>
                                                                        <input type="hidden" name="client_ids[]"
                                                                            id="client_ids" value="<?php echo e($r->client_id); ?>">

                                                                        <button class="btn btn-success float-right"
                                                                            id="allApprove"><i class="fa fa-check"></i>
                                                                            Approve</button>
                                                                    </form>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            <?php if(in_array('new-customer-approve', $permissions)): ?>
                                                                <?php if($r->client_approval == 'pending'): ?>
                                                                    <form action="<?php echo e(route('approveAllPending')); ?>"
                                                                        method="post" id="allPendingApproveForm">
                                                                        <?php echo csrf_field(); ?>
                                                                        <?php echo method_field('post'); ?>
                                                                        <input type="hidden" name="client_ids[]"
                                                                            id="client_ids" value="<?php echo e($r->client_id); ?>">

                                                                        <button class="btn btn-success float-right"
                                                                            id="allApprove"><i class="fa fa-check"></i>
                                                                            Approve</button>
                                                                    </form>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-body">
                <?php if(checkSettings('show-traffice') == 'enable' && $r->client_approval != 'pending'): ?>
                    <input type="hidden" id="user_Id" name="user_id" value="<?php echo e($r->id); ?>">
                    <input type="hidden" id="admin_user_Id" name="admin_user_Id" value="<?php echo e($user_id); ?>">
                    <div class='row mb-2 mt-3'>
                        <div class="col-md-6 mb-2 mt-3" id="addcsnvaus">
                            <canvas id="myChart" style="max-height: 1000px;" class="mb-5"></canvas>
                        </div>
                        <div class="col-md-6">
                            <h4 class="font-weight-bold">Last session details</h4>
                            <hr class="my-0">
                            <div>
                                <h5 class="mb-2"><strong>Last Link Up Time</strong>:
                                    <?php echo e($bandwidthUsage ? parseDate($bandwidthUsage['last-link-up-time']) : '-1'); ?>

                                </h5>
                                <h5 class="mb-2"><strong>Last Logout Time</strong>:
                                    <?php echo e($lastLogoutTime ? parseDate($lastLogoutTime) : '-1'); ?>

                                </h5>

                                <div class="row my-3">
                                    <div class="col">
                                        <h5><strong>Download:
                                            </strong>
                                            <?php echo e(number_format(($bandwidthUsage ? $bandwidthUsage['tx-byte'] : 0) / 1073741824, 2, '.', '')); ?>

                                            GB
                                        </h5>
                                    </div>
                                    <div class="col">
                                        <h5><strong>Upload:
                                            </strong><?php echo e(number_format(($bandwidthUsage ? $bandwidthUsage['rx-byte'] : 0) / 1073741824, 2, '.', '')); ?>

                                            GB
                                        </h5>
                                    </div>
                                </div>
                                <canvas id="pieChart" style="max-height: 250px;" class="mb-5"></canvas>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php if(globalPermission('onu_information_laser')): ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('onu_information_laser')): ?>
                <div class="container-fluid mt-2">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card p-3">
                                <h5 class="text-center">ONU Information</h5>
                                <table class="table table-bordered table-sm">
                                    <tr>
                                        <td><strong>OLT:</strong></td>
                                        <td><?php echo e($onuInfo->oltaddress ?? '-'); ?> - <?php echo e($onuInfo->oltName ?? '-'); ?></td>
                                        <td><strong>ONU Id:</strong></td>
                                        <td><?php echo e($onuInfo->onuid ?? '-'); ?></td>

                                    </tr>
                                    <tr>
                                        <td><strong>Power(Laser):</strong></td>
                                        <td><span class="text-bold text-green"><?php echo e($onuInfo->laser ?? '-'); ?></span></td>
                                        <td><strong>Update:</strong></td>
                                        <td><?php echo e(isset($onuInfo->updated_at) ? Carbon::parse($onuInfo->updated_at)->format('d-m-Y h:i A') : '-'); ?>

                                        </td>

                                    </tr>
                                    <tr>
                                        <td><strong>PON ID, Vlan:</strong></td>
                                        <td><?php echo e($onuInfo->interface ?? '-'); ?>, <?php echo e($onuInfo->Vlan ?? '-'); ?></td>
                                        <td><strong>Device Mac:</strong></td>
                                        <td><?php echo e(strtoupper(implode(':', str_split($onuInfo->mac ?? null, 2))) ?? '-'); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('ajax'); ?>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
    <script>
        function create_UUID() {
            var dt = new Date().getTime();
            var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                var r = (dt + Math.random() * 16) % 16 | 0;
                dt = Math.floor(dt / 16);
                return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
            });
            return uuid;
        }


        const data = {
            labels: [],
            datasets: [{
                label: 'Downloads',
                backgroundColor: '#333C83',
                borderColor: '#333C83',
                data: [],
                tension: 0.3,


            }, {
                label: 'Uploads',
                backgroundColor: 'rgb(255, 99, 132)',
                borderColor: 'rgb(255, 99, 132)',
                data: [],
                tension: 0.3,


            }]
        };


        const config = {
            type: 'line',
            data: data,
            options: {
                scales: {
                    y: {
                        ticks: {
                            callback: function(value, index, ticks) {
                                return value > 1 ? value + 'Mb' : (value * 1024) + "Kb";
                            }
                        }
                    }
                },
                plugins: {
                    title: {
                        display: true,
                        text: 'Real-Time Speed',
                        padding: {
                            top: 10,
                            bottom: 10
                        },
                        font: {
                            size: 15,

                        }
                    },
                    legend: {
                        labels: {
                            // This more specific font property overrides the global property
                            font: {
                                size: 12
                            }
                        }
                    }
                }
            }
        };

        const myChart = new Chart(
            document.getElementById('myChart'),
            config
        );

        let usageData = [1, 1];
        if (!('<?php echo e($error); ?>'.length > 0)) {
            usageData = [
                (<?php echo e(($bandwidthUsage ? $bandwidthUsage['tx-byte'] : 1) / 1048576); ?>).toFixed(3),
                (<?php echo e(($bandwidthUsage ? $bandwidthUsage['rx-byte'] : 1) / 1048576); ?>).toFixed(3),
            ]
        }

        const pieChartData = {
            labels: [
                'Downloads',
                'Uploads',
            ],
            datasets: [{
                label: 'My First Dataset',
                data: usageData,
                backgroundColor: [
                    '#333C83',
                    'rgb(255, 99, 132)',
                ],
                hoverOffset: 4
            }]

        };

        const pieChartConfig = {
            type: 'doughnut',
            data: pieChartData,
        }

        const pieChart = new Chart(
            document.getElementById('pieChart'),
            pieChartConfig
        );

        $('#speedshow').click(function() {
            $('#speedshow').hide();
            const uuid = create_UUID();


            const currentTime = () => {
                const today = new Date();
                const time = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();
                return time;
            }

            const addData = (chart, download, upload) => {
                const time = currentTime();

                chart.data.datasets[0].label = download > 1 ? `Download ${download.toFixed(3)} Mbps` :
                    `Download ${(download *1024).toFixed(3)} Kbps`
                chart.data.datasets[1].label = upload > 1 ? `Upload ${upload.toFixed(3)} Mbps` :
                    `Upload ${(upload *1024).toFixed(3)} Kbps`

                chart.data.labels.push(time)
                chart.data.datasets[0].data.push(download);
                chart.data.datasets[1].data.push(upload)
                chart.update();

            }

            function removeData(chart) {
                chart.data.labels.shift();
                chart.data.datasets.forEach((dataset) => {
                    dataset.data.shift();
                });
                chart.update();
            }
            const pusher = new Pusher('<?php echo e(config('broadcasting.connections.pusher.key')); ?>', {
                cluster: '<?php echo e(config('broadcasting.connections.pusher.options.cluster')); ?>'
            });
            const user_id = $('#user_Id').val();
            const admin_user_id = $('#admin_user_Id').val();

            const channel = pusher.subscribe(uuid);

            channel.bind('my-event', function(data) {
                const speed = JSON.parse(JSON.parse(JSON.stringify(data)).message)[0];
                const upload = speed["rx-bits-per-second"] / 1048576;
                const download = speed["tx-bits-per-second"] / 1048576;

                if (myChart.data.datasets[0].data.length > 15) {
                    removeData(myChart);
                }
                addData(myChart, download, upload)

            });

            $(document).ready(function() {
                const user_id = $('#user_Id').val();
                const admin_user_id = $('#admin_user_Id').val();
                $.ajax({
                    type: 'GET',
                    url: '<?php echo e(route('getSpeed')); ?>',
                    data: {
                        id: user_id,
                        uuid: uuid,

                    },
                    success: function(data) {
                        $('#speedshow').show();

                    },
                    error: function(request, error) {
                        toastr.error(request.responseText);
                        $('#speedshow').show();
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/spacewalker/radius-circle/resources/views/clients/details.blade.php ENDPATH**/ ?>