<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <div class="row justify-content-center align-items-center">

                <div class="col-12 col-xl-6 col-lg-6 col-md-12 col-sm-12">
                    <div class="form-group">
                        <label for="shortname" class="block text-lg font-medium  text-space">
                            Mikrotik Name <span style="color: #f59e0b;font-size:22px !important;">*</span>
                        </label>
                        <select class="form-control custom-select-lg text-space" name="mikrotik" id="mikrotik">
                            <option value="">Select mikrotik</option>
                            <?php $__currentLoopData = $mikrotiks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mikrotik): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($mikrotik->id); ?>" class="border "
                                    style="background-color: rgb(229 231 235 / 0.2);">
                                    <?php echo e($mikrotik->shortname); ?>

                                    <?php echo e($mikrotik->nasname); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </select>
                    </div>


                </div>


            </div>

            <div class="form-group">
                <button class="btn  float-right ml-4" id="delete_all_id" style="background: #ef4444; color:#FFFFFF;">Delete
                    All</button>
                <button type="submit" class="btn btn-warning text-light float-right" id="sync">
                    Sync
                </button>
                <?php if(auth()->user()->id == 1): ?>
                    <a class="noprint btn btn-primary" href="<?php echo e(route('nasSyncListExport')); ?>?excel=yes"><i
                            class="fa fa-print"></i> Download CSV</a>
                <?php endif; ?>
            </div>

            <div class="table-responsive pt-2 " id="result">
                <table id="dataTable" class="display table table-bordered " style="width: 100% !important">
                    <thead style="background:#78716c;color:#FFFFFF;">
                        <tr class="text-center">
                            <th scope="col">Id</th>
                            <th scope="col"> User name </th>
                            <th scope="col"> Password </th>
                            <th scope="col"> Profile Name </th>
                            <th scope="col"> Comment </th>
                            <th scope="col"> Reseller Name </th>
                            <th scope="col" class="d-none"> Reseller Name d </th>
                            <th scope="col"> Pop Name </th>
                            <th scope="col"> Package Name </th>
                            <th scope="col"> Billing Cycle </th>
                            <th scope="col" style="width: 200px"> Action </th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $__currentLoopData = $client_lists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr id="row<?php echo e($item->id); ?>" class="text-center">
                                <td><?php echo e($item->id); ?></td>
                                <td class="username"><?php echo e($item->username); ?></td>
                                <td class="password"><?php echo e($item->password); ?></td>
                                <td class="mikrotik_current_profile"><?php echo e($item->profile_name); ?></td>
                                <td class="comment"><?php echo e($item->mk_comment ?? ''); ?></td>
                                <td class="packageprofilerow d-none">
                                    <input type="hidden" id="packageProfile" name="packageProfile">
                                </td>
                                <td>
                                    <div class="form-group do-float">

                                        <select name="reseller_name" id="reseller_name" class="form-control reseller">
                                            <option value="">Select Reseller</option>
                                            <?php $__currentLoopData = $resellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reseller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($reseller->id); ?>"><?php echo e($reseller->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </td>
                                <td>
                                    <div class="form-group do-float d-none popdiv">

                                        <select name="pop_name" id="pop_name" class="form-control pop">
                                            <option value="">Select Pop</option>

                                        </select>
                                    </div>
                                </td>
                                <td>
                                    <div class="form-group do-float  d-none packagediv">

                                        <select name="package_name" id="package_name" class="form-control package">
                                            <option value="">Select Package</option>

                                        </select>
                                    </div>
                                </td>
                                <td>
                                    <div class="form-group do-float  d-none billing_cyclediv">

                                        <select name="billing_cycle" id="billing_cycle" class="form-control billing_cycle">
                                            <option value="">Select Billing Cycle</option>
                                            <?php $__currentLoopData = explode(',', $billing_cycles); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($day); ?>"><?php echo e($day); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </td>

                                <td>
                                    <a href="#" class="btn-sm  pull-right savebtn"
                                        style="background:#0d9488; color:#FFFFFF;">Save</a>
                                    <a href="#" class="btn-sm  pull-right deletebtn"
                                        style="background:#9f2003; color:#FFFFFF; " id="delete-btn">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <!-- More items... -->
                    </tbody>
                </table>

            </div>


        </div>

    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('ajax'); ?>
    <script>
        $(document).ready(function() {
            $('#sync').click(function() {
                var mikrotik = $('#mikrotik').val();
                var mikrotik_connect_type = $('#connect_type').val();
                $("#sync").attr("disabled", true);
                $('body').prepend('<div id="loading">Loading.....</div>');

                if (mikrotik) {
                    $.ajax({
                        url: "<?php echo e(route('mikrotiks-sync-client')); ?>",
                        type: "get",
                        data: {
                            mikrotik: mikrotik,
                            mikrotik_connect_type: mikrotik_connect_type
                        },
                        success: function(data) {
                            // console.log(data);
                            $('#loading').remove();
                            toastr.success("Client Sync successfull");
                            $("#sync").attr("disabled", false);
                            $('#result').html(data);
                            location.reload();

                        },
                        error: function(request, error) {
                            toastr.error(request.responseText);
                            $('#loading').remove();
                        }
                    });
                } else {
                    toastr.error("Please select mikrotik");
                }

            });
            $(document).on("change", ".reseller", function() {

                var row = $(this).closest("tr");
                var rowId = row.attr("id");
                var reseller = $(this).val();
                var thisvariable = $(this);
                if (reseller) {
                    $.ajax({
                        url: "<?php echo e(route('reseller-pop')); ?>",
                        type: "get",
                        data: {
                            reseller: reseller
                        },
                        success: function(data) {

                            thisvariable.parents("tr").find(".pop").empty();
                            thisvariable.parents("tr").find(".package").empty();
                            thisvariable.parents("tr").find(".pop").append($(
                                "<option></option>").attr("value", "").text(
                                "Select Pop"));
                            thisvariable.parents("tr").find(".package").append($(
                                "<option></option>").attr("value", "").text(
                                "Select Package"));

                            thisvariable.parents("tr").find(".popdiv").removeClass('d-none');
                            thisvariable.parents("tr").find(".packagediv").removeClass(
                                'd-none');
                            thisvariable.parents("tr").find(".billing_cyclediv").removeClass(
                                'd-none');
                            data.popes.forEach(element => {
                                thisvariable.parents("tr").find(".pop").append($(
                                    "<option></option>").attr("value", element
                                    .id).text(element.popname));
                            });
                            data.packages.forEach(element => {
                                thisvariable.parents("tr").find(".package").append($(
                                    "<option></option>").attr("value", element
                                    .id).text(element.package_name));
                            });
                        }
                    });

                }
            });

            $(document).on("change", ".package", function() {
                var package = $(this).val();
                // console.log(package);
                if (package) {

                    $.ajax({
                        url: "<?php echo e(route('package-profile')); ?>",
                        type: "get",
                        data: {
                            package: package
                        },
                        success: function(data) {
                            if (data.profile_name) {
                                $(".packageprofilerow").find("input").val(data.profile_name);
                            } else {
                                $(".packageprofilerow").find("input").val("");
                            }
                        }
                    });
                }
            });


            $(document).on("click", ".savebtn", function() {

                var reseller = $(this).parents("tr").find(".reseller").val();
                var pop = $(this).parents("tr").find(".pop").val();
                var package = $(this).parents("tr").find(".package").val();
                var billing_cycle = $(this).parents("tr").find(".billing_cycle").val();
                var userName = $(this).parents("tr").find(".username").text();
                var password = $(this).parents("tr").find(".password").html();
                var comment = $(this).parents("tr").find(".comment").html();
                var mikrotik_curent_profile = $(this).parents("tr").find(".mikrotik_current_profile")
                    .text();

                var thisvariable = $(this);
                var row = $(this).closest("tr");
                var rowId = row.attr("id");
                let thisrowprofile = $(this).parents("tr").find(".packageprofilerow input").val();

                // mikrotik_curent_profile = mikrotik_curent_profile.replace(/ /g, '');
                // console.log(mikrotik_curent_profile);
                // console.log(userName);
                if (mikrotik_curent_profile == thisrowprofile) {
                    if (reseller && pop && package && billing_cycle) {
                        $.ajax({
                            url: "<?php echo e(route('save-from-sync-list')); ?>",
                            type: "post",
                            data: {
                                reseller: reseller,
                                pop: pop,
                                package: package,
                                billing_cycle: billing_cycle,
                                userName: userName,
                                password: password,
                                comment: comment,
                            },
                            success: function(data) {
                                toastr.success("Client Sync successfull");
                                thisvariable.closest('tr').hide();
                                console.log(thisvariable.closest('tr'));

                            },
                            error: function(request, error) {
                                toastr.error(request.responseText);

                            }
                        });
                    } else {
                        toastr.error("Please select all fields");
                    }
                } else {
                    console.log(userName);
                    console.log(mikrotik_curent_profile);
                    console.log(thisrowprofile);
                    toastr.error("Profile name is different from current profile");

                }



            });



            $(document).on("click", ".deletebtn", function() {

                var row = $(this).closest("tr");
                var userName = $(this).parents("tr").find(".username").html();
                var thisvariable = $(this);
                $.ajax({
                    url: "<?php echo e(route('delete-from-sync-list')); ?>",
                    type: "post",
                    data: {
                        userName: userName
                    },
                    success: function(data) {
                        // console.log(data);
                        toastr.success("Client Delete from Sync successfull");
                        thisvariable.closest('tr').hide();
                        // console.log(thisvariable.closest('tr'));

                    },
                    error: function(request, error) {
                        toastr.error(request.responseText);

                    }
                });
            });

            // $('#dataTable').DataTable({
            //     "searching": true,
            //     "pageLength": 25,
            //     "order": [
            //         [0, "asc"]
            //     ]
            // });

            $(document).on('click', '#delete_all_id', function(e) {
                let confirmation = window.confirm("Are you sure to delete?");
                if (!confirmation) {
                    return false;
                };


                e.preventDefault();
                $('body').prepend('<div id="loading">Loading.....</div>');

                $.ajax({
                    url: "<?php echo e(route('delete-all-from-sync-list')); ?>",
                    type: "post",

                    success: function(data) {

                        toastr.success("All Client Delete from Sync successfull");
                        location.reload();
                        $('#loading').remove();

                    },
                    error: function(request, error) {
                        $('#loading').remove();
                        toastr.error(request.responseText);
                    }
                });

            });

        });
    </script>
<?php $__env->stopSection(); ?>


<style>
    .text-space {
        letter-spacing: 0.025em;
        line-height: 1.75rem;
        color: #78716c;
    }

    .dataTables_wrapper .dataTables_filter input:focus {
        outline-style: solid !important;
        outline-color: #fde047;
        outline-width: 2.5px;
    }

    #mikrotik {
        outline-style: solid !important;
        outline-color: #797359;
        outline-width: 0.75px;
    }

    .content-wrapper {
        background: inherit !important;
    }



    @media(max-width:1000px) {
        #delete-btn {
            line-height: 2.5 !important;
            background: blue !important;
        }
    }
</style>

<?php echo $__env->make('layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/trustnet/radius-circle/resources/views/mikrotik/sync.blade.php ENDPATH**/ ?>