<?php

namespace App\Classes;

use ParagonIE\Sodium\Compat;
use App\Models\CompanyInformation;
use App\Models\LicenseCheckModel;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Http;

class LicenseCheck
{

  protected $customer_panel_api;

  function __construct()
  {

    $this->customer_panel_api = customer_panel_api();
  }


  public function check()
  {
    try {

      if (config('app.license_check') == false) {
        return false;
      }

      $url = $this->customer_panel_api->customer_panel_url . '/api/v1/client-details/' . $this->customer_panel_api->customer_panel_secret;
      $response = Http::get($url);
    } catch (\Throwable $th) {
      //throw $th;
    }

    // dd($response->body());

    if ($response->status() == 200) {
      $response = json_decode($response->body());
      if ($response->status == 'success') {
        if ($response->data) {

          $license = $response->data;

          LicenseCheckModel::create([
            'license_check' => json_encode($license)
          ]);

          return true;
        } else {

          return false;
        }
      } else {
        return false;
      }
    } else {
      return false;
    }
  }
}
